/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.interactionvisualizer.blocks;

import com.loohp.interactionvisualizer.InteractionVisualizer;
import com.loohp.interactionvisualizer.api.InteractionVisualizerAPI;
import com.loohp.interactionvisualizer.api.VisualizerInteractDisplay;
import com.loohp.interactionvisualizer.entityholders.ItemFrame;
import com.loohp.interactionvisualizer.managers.PacketManager;
import com.loohp.interactionvisualizer.objectholders.EntryKey;
import com.loohp.interactionvisualizer.utils.VanishUtils;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.bukkit.FluidCollisionMode;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.inventory.CartographyInventory;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class CartographyTableDisplay
extends VisualizerInteractDisplay
implements Listener {
    public static final EntryKey KEY = new EntryKey("cartography_table");
    public Map<Block, Map<String, Object>> openedCTable = new HashMap<Block, Map<String, Object>>();
    public Map<Player, Block> playermap = new HashMap<Player, Block>();

    @Override
    public EntryKey key() {
        return KEY;
    }

    @Override
    public int run() {
        return new BukkitRunnable(){

            public void run() {
                Iterator<Block> itr = CartographyTableDisplay.this.openedCTable.keySet().iterator();
                int count = 0;
                int maxper = (int)Math.ceil((double)CartographyTableDisplay.this.openedCTable.size() / 5.0);
                int delay = 1;
                while (itr.hasNext()) {
                    if (++count > maxper) {
                        count = 0;
                        ++delay;
                    }
                    final Block block = itr.next();
                    new BukkitRunnable(){

                        public void run() {
                            Player player;
                            if (!CartographyTableDisplay.this.openedCTable.containsKey(block)) {
                                return;
                            }
                            Map<String, Object> map = CartographyTableDisplay.this.openedCTable.get(block);
                            if (block.getType().equals((Object)Material.CARTOGRAPHY_TABLE) && !(player = (Player)map.get("Player")).getGameMode().equals((Object)GameMode.SPECTATOR) && player.getOpenInventory() != null && player.getOpenInventory().getTopInventory() != null && player.getOpenInventory().getTopInventory() instanceof CartographyInventory) {
                                return;
                            }
                            if (map.get("Item") instanceof ItemFrame) {
                                Entity entity = (Entity)map.get("Item");
                                PacketManager.removeItemFrame(InteractionVisualizerAPI.getPlayers(), (ItemFrame)entity);
                            }
                            CartographyTableDisplay.this.openedCTable.remove(block);
                        }
                    }.runTaskLater((Plugin)InteractionVisualizer.plugin, (long)delay);
                }
            }
        }.runTaskTimer((Plugin)InteractionVisualizer.plugin, 0L, 6L).getTaskId();
    }

    @Override
    public void process(Player player) {
        ItemStack output;
        Map<Object, Object> map;
        if (VanishUtils.isVanished(player)) {
            return;
        }
        if (!this.playermap.containsKey(player)) {
            if (player.getGameMode().equals((Object)GameMode.SPECTATOR)) {
                return;
            }
            if (!(player.getOpenInventory().getTopInventory() instanceof CartographyInventory)) {
                return;
            }
            Block block = player.getTargetBlockExact(7, FluidCollisionMode.NEVER);
            if (block == null || !block.getType().equals((Object)Material.CARTOGRAPHY_TABLE)) {
                return;
            }
            this.playermap.put(player, block);
        }
        InventoryView view = player.getOpenInventory();
        Block block = this.playermap.get(player);
        if (!this.openedCTable.containsKey(block)) {
            map = new HashMap<String, Player>();
            map.put("Player", player);
            map.put("Item", "N/A");
            this.openedCTable.put(block, map);
        }
        if (!(map = this.openedCTable.get(block)).get("Player").equals(player)) {
            return;
        }
        ItemStack input = view.getItem(0);
        if (input != null && input.getType().equals((Object)Material.AIR)) {
            input = null;
        }
        if ((output = view.getItem(2)) != null && output.getType().equals((Object)Material.AIR)) {
            output = null;
        }
        ItemStack itemstack = null;
        if (output == null) {
            if (input != null) {
                itemstack = input;
            }
        } else {
            itemstack = output;
        }
        ItemFrame item = null;
        if (!block.getRelative(BlockFace.UP).getType().isSolid()) {
            if (map.get("Item") instanceof String) {
                if (itemstack != null) {
                    item = new ItemFrame(block.getRelative(BlockFace.UP).getLocation());
                    item.setItem(itemstack);
                    item.setFacingDirection(BlockFace.UP);
                    item.setSilent(true);
                    map.put("Item", item);
                    PacketManager.sendItemFrameSpawn(InteractionVisualizerAPI.getPlayerModuleList(InteractionVisualizerAPI.Modules.ITEMSTAND, KEY), item);
                    PacketManager.updateItemFrame(item);
                } else {
                    map.put("Item", "N/A");
                }
            } else {
                item = (ItemFrame)map.get("Item");
                if (itemstack != null) {
                    if (!item.getItem().equals((Object)itemstack)) {
                        item.setItem(itemstack);
                        PacketManager.updateItemFrame(item);
                    }
                } else {
                    map.put("Item", "N/A");
                    PacketManager.removeItemFrame(InteractionVisualizerAPI.getPlayers(), item);
                }
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onUseCartographyTable(InventoryClickEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (!this.playermap.containsKey((Player)event.getWhoClicked())) {
            return;
        }
        if (event.getRawSlot() >= 0 && event.getRawSlot() <= 1) {
            PacketManager.sendHandMovement(InteractionVisualizerAPI.getPlayers(), (Player)event.getWhoClicked());
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onDragCartographyTable(InventoryDragEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (!this.playermap.containsKey((Player)event.getWhoClicked())) {
            return;
        }
        Iterator iterator = event.getRawSlots().iterator();
        while (iterator.hasNext()) {
            int slot = (Integer)iterator.next();
            if (slot < 0 || slot > 1) continue;
            PacketManager.sendHandMovement(InteractionVisualizerAPI.getPlayers(), (Player)event.getWhoClicked());
            break;
        }
    }

    @EventHandler
    public void onCloseCartographyTable(InventoryCloseEvent event) {
        if (!this.playermap.containsKey((Player)event.getPlayer())) {
            return;
        }
        Block block = this.playermap.get((Player)event.getPlayer());
        if (!this.openedCTable.containsKey(block)) {
            return;
        }
        Map<String, Object> map = this.openedCTable.get(block);
        if (!map.get("Player").equals(event.getPlayer())) {
            return;
        }
        if (map.get("Item") instanceof ItemFrame) {
            ItemFrame entity = (ItemFrame)map.get("Item");
            PacketManager.removeItemFrame(InteractionVisualizerAPI.getPlayers(), entity);
        }
        this.openedCTable.remove(block);
        this.playermap.remove((Player)event.getPlayer());
    }
}

