/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.interactionvisualizer.blocks;

import com.loohp.interactionvisualizer.InteractionVisualizer;
import com.loohp.interactionvisualizer.api.InteractionVisualizerAPI;
import com.loohp.interactionvisualizer.api.VisualizerRunnableDisplay;
import com.loohp.interactionvisualizer.api.events.InteractionVisualizerReloadEvent;
import com.loohp.interactionvisualizer.api.events.TileEntityRemovedEvent;
import com.loohp.interactionvisualizer.entityholders.ArmorStand;
import com.loohp.interactionvisualizer.libs.net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import com.loohp.interactionvisualizer.managers.PacketManager;
import com.loohp.interactionvisualizer.managers.PlayerLocationManager;
import com.loohp.interactionvisualizer.managers.TileEntityManager;
import com.loohp.interactionvisualizer.objectholders.EntryKey;
import com.loohp.interactionvisualizer.objectholders.TileEntity;
import com.loohp.interactionvisualizer.utils.ChatColorUtils;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.Campfire;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Directional;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.EulerAngle;
import org.bukkit.util.Vector;

public class CampfireDisplay
extends VisualizerRunnableDisplay
implements Listener {
    public static final EntryKey KEY = new EntryKey("campfire");
    public ConcurrentHashMap<Block, Map<String, Object>> campfireMap = new ConcurrentHashMap();
    private int checkingPeriod = 20;
    private int gcPeriod = 600;
    private String progressBarCharacter = "";
    private String emptyColor = "&7";
    private String filledColor = "&e";
    private int progressBarLength = 10;

    public CampfireDisplay() {
        this.onReload(new InteractionVisualizerReloadEvent());
    }

    @EventHandler
    public void onReload(InteractionVisualizerReloadEvent event) {
        this.checkingPeriod = InteractionVisualizer.plugin.getConfiguration().getInt("Blocks.Campfire.CheckingPeriod");
        this.gcPeriod = InteractionVisualizerAPI.getGCPeriod();
        this.progressBarCharacter = ChatColorUtils.translateAlternateColorCodes('&', InteractionVisualizer.plugin.getConfiguration().getString("Blocks.Campfire.Options.ProgressBarCharacter"));
        this.emptyColor = ChatColorUtils.translateAlternateColorCodes('&', InteractionVisualizer.plugin.getConfiguration().getString("Blocks.Campfire.Options.EmptyColor"));
        this.filledColor = ChatColorUtils.translateAlternateColorCodes('&', InteractionVisualizer.plugin.getConfiguration().getString("Blocks.Campfire.Options.FilledColor"));
        this.progressBarLength = InteractionVisualizer.plugin.getConfiguration().getInt("Blocks.Campfire.Options.ProgressBarLength");
    }

    @Override
    public EntryKey key() {
        return KEY;
    }

    @Override
    public int gc() {
        return Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)InteractionVisualizer.plugin, () -> {
            Iterator<Map.Entry<Block, Map<String, Object>>> itr = this.campfireMap.entrySet().iterator();
            int count = 0;
            int maxper = (int)Math.ceil((double)this.campfireMap.size() / (double)this.gcPeriod);
            int delay = 1;
            while (itr.hasNext()) {
                if (++count > maxper) {
                    count = 0;
                    ++delay;
                }
                Map.Entry<Block, Map<String, Object>> entry = itr.next();
                Bukkit.getScheduler().runTaskLater((Plugin)InteractionVisualizer.plugin, () -> {
                    Block block = (Block)entry.getKey();
                    if (!this.isActive(block.getLocation())) {
                        ArmorStand stand;
                        Map map = (Map)entry.getValue();
                        if (map.get("1") instanceof ArmorStand) {
                            stand = (ArmorStand)map.get("1");
                            PacketManager.removeArmorStand(InteractionVisualizerAPI.getPlayers(), stand);
                        }
                        if (map.get("2") instanceof ArmorStand) {
                            stand = (ArmorStand)map.get("2");
                            PacketManager.removeArmorStand(InteractionVisualizerAPI.getPlayers(), stand);
                        }
                        if (map.get("3") instanceof ArmorStand) {
                            stand = (ArmorStand)map.get("3");
                            PacketManager.removeArmorStand(InteractionVisualizerAPI.getPlayers(), stand);
                        }
                        if (map.get("4") instanceof ArmorStand) {
                            stand = (ArmorStand)map.get("4");
                            PacketManager.removeArmorStand(InteractionVisualizerAPI.getPlayers(), stand);
                        }
                        this.campfireMap.remove(block);
                        return;
                    }
                    if (!block.getType().equals((Object)Material.CAMPFIRE)) {
                        ArmorStand stand;
                        Map map = (Map)entry.getValue();
                        if (map.get("1") instanceof ArmorStand) {
                            stand = (ArmorStand)map.get("1");
                            PacketManager.removeArmorStand(InteractionVisualizerAPI.getPlayers(), stand);
                        }
                        if (map.get("2") instanceof ArmorStand) {
                            stand = (ArmorStand)map.get("2");
                            PacketManager.removeArmorStand(InteractionVisualizerAPI.getPlayers(), stand);
                        }
                        if (map.get("3") instanceof ArmorStand) {
                            stand = (ArmorStand)map.get("3");
                            PacketManager.removeArmorStand(InteractionVisualizerAPI.getPlayers(), stand);
                        }
                        if (map.get("4") instanceof ArmorStand) {
                            stand = (ArmorStand)map.get("4");
                            PacketManager.removeArmorStand(InteractionVisualizerAPI.getPlayers(), stand);
                        }
                        this.campfireMap.remove(block);
                        return;
                    }
                }, (long)delay);
            }
        }, 0L, (long)this.gcPeriod).getTaskId();
    }

    @Override
    public int run() {
        return Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)InteractionVisualizer.plugin, () -> {
            Bukkit.getScheduler().runTask((Plugin)InteractionVisualizer.plugin, () -> {
                Set<Block> list = this.nearbyCampfire();
                for (Block block : list) {
                    if (this.campfireMap.get(block) != null || !this.isActive(block.getLocation()) || !block.getType().equals((Object)Material.CAMPFIRE)) continue;
                    HashMap<String, ArmorStand> map = new HashMap<String, ArmorStand>();
                    map.putAll(this.spawnArmorStands(block));
                    this.campfireMap.put(block, map);
                }
            });
            Iterator<Map.Entry<Block, Map<String, Object>>> itr = this.campfireMap.entrySet().iterator();
            int count = 0;
            int maxper = (int)Math.ceil((double)this.campfireMap.size() / (double)this.checkingPeriod);
            int delay = 1;
            while (itr.hasNext()) {
                Map.Entry<Block, Map<String, Object>> entry = itr.next();
                if (++count > maxper) {
                    count = 0;
                    ++delay;
                }
                Bukkit.getScheduler().runTaskLater((Plugin)InteractionVisualizer.plugin, () -> {
                    Block block = (Block)entry.getKey();
                    if (!this.isActive(block.getLocation())) {
                        return;
                    }
                    if (!block.getType().equals((Object)Material.CAMPFIRE)) {
                        return;
                    }
                    Campfire campfire = (Campfire)block.getState();
                    boolean isLit = ((org.bukkit.block.data.type.Campfire)block.getBlockData()).isLit();
                    InteractionVisualizer.asyncExecutorManager.runTaskAsynchronously(() -> {
                        double i;
                        double percentagescaled;
                        String symbol;
                        int max;
                        int time;
                        ItemStack itemstack4;
                        ItemStack itemstack3;
                        ItemStack itemstack2;
                        ItemStack itemstack1 = campfire.getItem(0);
                        if (itemstack1 != null && itemstack1.getType().equals((Object)Material.AIR)) {
                            itemstack1 = null;
                        }
                        if ((itemstack2 = campfire.getItem(1)) != null && itemstack2.getType().equals((Object)Material.AIR)) {
                            itemstack2 = null;
                        }
                        if ((itemstack3 = campfire.getItem(2)) != null && itemstack3.getType().equals((Object)Material.AIR)) {
                            itemstack3 = null;
                        }
                        if ((itemstack4 = campfire.getItem(3)) != null && itemstack4.getType().equals((Object)Material.AIR)) {
                            itemstack4 = null;
                        }
                        ArmorStand stand1 = (ArmorStand)((Map)entry.getValue()).get("1");
                        ArmorStand stand2 = (ArmorStand)((Map)entry.getValue()).get("2");
                        ArmorStand stand3 = (ArmorStand)((Map)entry.getValue()).get("3");
                        ArmorStand stand4 = (ArmorStand)((Map)entry.getValue()).get("4");
                        if (isLit && itemstack1 != null) {
                            time = campfire.getCookTime(0);
                            max = campfire.getCookTimeTotal(0);
                            symbol = "";
                            percentagescaled = (double)time / (double)max * (double)this.progressBarLength;
                            i = 1.0;
                            for (i = 1.0; i < percentagescaled; i += 1.0) {
                                symbol = symbol + this.filledColor + this.progressBarCharacter;
                            }
                            if (percentagescaled - (i -= 1.0) > 0.0 && percentagescaled - i < 0.33) {
                                symbol = symbol + this.emptyColor + this.progressBarCharacter;
                            } else if (percentagescaled - i > 0.0 && percentagescaled - i < 0.67) {
                                symbol = symbol + this.emptyColor + this.progressBarCharacter;
                            } else if (percentagescaled - i > 0.0) {
                                symbol = symbol + this.filledColor + this.progressBarCharacter;
                            }
                            for (i = (double)(this.progressBarLength - 1); i >= percentagescaled; i -= 1.0) {
                                symbol = symbol + this.emptyColor + this.progressBarCharacter;
                            }
                            if (!PlainTextComponentSerializer.plainText().serialize(stand1.getCustomName()).equals(symbol) || !stand1.isCustomNameVisible()) {
                                stand1.setCustomNameVisible(true);
                                stand1.setCustomName(symbol);
                                PacketManager.updateArmorStandOnlyMeta(stand1);
                            }
                        } else if (!PlainTextComponentSerializer.plainText().serialize(stand1.getCustomName()).equals("") || stand1.isCustomNameVisible()) {
                            stand1.setCustomNameVisible(false);
                            stand1.setCustomName("");
                            PacketManager.updateArmorStandOnlyMeta(stand1);
                        }
                        if (isLit && itemstack2 != null) {
                            time = campfire.getCookTime(1);
                            max = campfire.getCookTimeTotal(1);
                            symbol = "";
                            percentagescaled = (double)time / (double)max * (double)this.progressBarLength;
                            i = 1.0;
                            for (i = 1.0; i < percentagescaled; i += 1.0) {
                                symbol = symbol + this.filledColor + this.progressBarCharacter;
                            }
                            if (percentagescaled - (i -= 1.0) > 0.0 && percentagescaled - i < 0.33) {
                                symbol = symbol + this.emptyColor + this.progressBarCharacter;
                            } else if (percentagescaled - i > 0.0 && percentagescaled - i < 0.67) {
                                symbol = symbol + this.emptyColor + this.progressBarCharacter;
                            } else if (percentagescaled - i > 0.0) {
                                symbol = symbol + this.filledColor + this.progressBarCharacter;
                            }
                            for (i = (double)(this.progressBarLength - 1); i >= percentagescaled; i -= 1.0) {
                                symbol = symbol + this.emptyColor + this.progressBarCharacter;
                            }
                            if (!PlainTextComponentSerializer.plainText().serialize(stand2.getCustomName()).equals(symbol) || !stand2.isCustomNameVisible()) {
                                stand2.setCustomNameVisible(true);
                                stand2.setCustomName(symbol);
                                PacketManager.updateArmorStandOnlyMeta(stand2);
                            }
                        } else if (!PlainTextComponentSerializer.plainText().serialize(stand2.getCustomName()).equals("") || stand2.isCustomNameVisible()) {
                            stand2.setCustomNameVisible(false);
                            stand2.setCustomName("");
                            PacketManager.updateArmorStandOnlyMeta(stand2);
                        }
                        if (isLit && itemstack3 != null) {
                            time = campfire.getCookTime(2);
                            max = campfire.getCookTimeTotal(2);
                            symbol = "";
                            percentagescaled = (double)time / (double)max * (double)this.progressBarLength;
                            i = 1.0;
                            for (i = 1.0; i < percentagescaled; i += 1.0) {
                                symbol = symbol + this.filledColor + this.progressBarCharacter;
                            }
                            if (percentagescaled - (i -= 1.0) > 0.0 && percentagescaled - i < 0.33) {
                                symbol = symbol + this.emptyColor + this.progressBarCharacter;
                            } else if (percentagescaled - i > 0.0 && percentagescaled - i < 0.67) {
                                symbol = symbol + this.emptyColor + this.progressBarCharacter;
                            } else if (percentagescaled - i > 0.0) {
                                symbol = symbol + this.filledColor + this.progressBarCharacter;
                            }
                            for (i = (double)(this.progressBarLength - 1); i >= percentagescaled; i -= 1.0) {
                                symbol = symbol + this.emptyColor + this.progressBarCharacter;
                            }
                            if (!PlainTextComponentSerializer.plainText().serialize(stand3.getCustomName()).equals(symbol) || !stand3.isCustomNameVisible()) {
                                stand3.setCustomNameVisible(true);
                                stand3.setCustomName(symbol);
                                PacketManager.updateArmorStandOnlyMeta(stand3);
                            }
                        } else if (!PlainTextComponentSerializer.plainText().serialize(stand3.getCustomName()).equals("") || stand3.isCustomNameVisible()) {
                            stand3.setCustomNameVisible(false);
                            stand3.setCustomName("");
                            PacketManager.updateArmorStandOnlyMeta(stand3);
                        }
                        if (isLit && itemstack4 != null) {
                            time = campfire.getCookTime(3);
                            max = campfire.getCookTimeTotal(3);
                            symbol = "";
                            percentagescaled = (double)time / (double)max * (double)this.progressBarLength;
                            i = 1.0;
                            for (i = 1.0; i < percentagescaled; i += 1.0) {
                                symbol = symbol + this.filledColor + this.progressBarCharacter;
                            }
                            if (percentagescaled - (i -= 1.0) > 0.0 && percentagescaled - i < 0.33) {
                                symbol = symbol + this.emptyColor + this.progressBarCharacter;
                            } else if (percentagescaled - i > 0.0 && percentagescaled - i < 0.67) {
                                symbol = symbol + this.emptyColor + this.progressBarCharacter;
                            } else if (percentagescaled - i > 0.0) {
                                symbol = symbol + this.filledColor + this.progressBarCharacter;
                            }
                            for (i = (double)(this.progressBarLength - 1); i >= percentagescaled; i -= 1.0) {
                                symbol = symbol + this.emptyColor + this.progressBarCharacter;
                            }
                            if (!PlainTextComponentSerializer.plainText().serialize(stand4.getCustomName()).equals(symbol) || !stand4.isCustomNameVisible()) {
                                stand4.setCustomNameVisible(true);
                                stand4.setCustomName(symbol);
                                PacketManager.updateArmorStandOnlyMeta(stand4);
                            }
                        } else if (!PlainTextComponentSerializer.plainText().serialize(stand4.getCustomName()).equals("") || stand4.isCustomNameVisible()) {
                            stand4.setCustomNameVisible(false);
                            stand4.setCustomName("");
                            PacketManager.updateArmorStandOnlyMeta(stand4);
                        }
                    });
                }, (long)delay);
            }
        }, 0L, (long)this.checkingPeriod).getTaskId();
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onBreakCampfire(TileEntityRemovedEvent event) {
        ArmorStand stand;
        Block block = event.getBlock();
        if (!this.campfireMap.containsKey(block)) {
            return;
        }
        Map<String, Object> map = this.campfireMap.get(block);
        if (map.get("1") instanceof ArmorStand) {
            stand = (ArmorStand)map.get("1");
            PacketManager.removeArmorStand(InteractionVisualizerAPI.getPlayers(), stand);
        }
        if (map.get("2") instanceof ArmorStand) {
            stand = (ArmorStand)map.get("2");
            PacketManager.removeArmorStand(InteractionVisualizerAPI.getPlayers(), stand);
        }
        if (map.get("3") instanceof ArmorStand) {
            stand = (ArmorStand)map.get("3");
            PacketManager.removeArmorStand(InteractionVisualizerAPI.getPlayers(), stand);
        }
        if (map.get("4") instanceof ArmorStand) {
            stand = (ArmorStand)map.get("4");
            PacketManager.removeArmorStand(InteractionVisualizerAPI.getPlayers(), stand);
        }
        this.campfireMap.remove(block);
    }

    public Set<Block> nearbyCampfire() {
        return TileEntityManager.getTileEntities(TileEntity.TileEntityType.CAMPFIRE);
    }

    public boolean isActive(Location loc) {
        return PlayerLocationManager.hasPlayerNearby(loc);
    }

    public Map<String, ArmorStand> spawnArmorStands(Block block) {
        HashMap<String, ArmorStand> map = new HashMap<String, ArmorStand>();
        Location origin = block.getLocation();
        BlockData blockData = block.getState().getBlockData();
        BlockFace facing = ((Directional)blockData).getFacing();
        Location target = block.getRelative(facing).getLocation();
        Vector direction = this.rotateVectorAroundY(target.toVector().subtract(origin.toVector()).multiply(0.44194173), 135.0);
        Location loc = origin.clone().add(0.5, 0.3, 0.5);
        ArmorStand slot1 = new ArmorStand(loc.clone().add(direction));
        this.setStand(slot1);
        ArmorStand slot2 = new ArmorStand(loc.clone().add(this.rotateVectorAroundY(direction.clone(), 90.0)));
        this.setStand(slot2);
        ArmorStand slot3 = new ArmorStand(loc.clone().add(this.rotateVectorAroundY(direction.clone(), 180.0)));
        this.setStand(slot3);
        ArmorStand slot4 = new ArmorStand(loc.clone().add(this.rotateVectorAroundY(direction.clone(), -90.0)));
        this.setStand(slot4);
        map.put("1", slot1);
        map.put("2", slot2);
        map.put("3", slot3);
        map.put("4", slot4);
        PacketManager.sendArmorStandSpawn(InteractionVisualizerAPI.getPlayerModuleList(InteractionVisualizerAPI.Modules.HOLOGRAM, KEY), slot1);
        PacketManager.sendArmorStandSpawn(InteractionVisualizerAPI.getPlayerModuleList(InteractionVisualizerAPI.Modules.HOLOGRAM, KEY), slot2);
        PacketManager.sendArmorStandSpawn(InteractionVisualizerAPI.getPlayerModuleList(InteractionVisualizerAPI.Modules.HOLOGRAM, KEY), slot3);
        PacketManager.sendArmorStandSpawn(InteractionVisualizerAPI.getPlayerModuleList(InteractionVisualizerAPI.Modules.HOLOGRAM, KEY), slot4);
        return map;
    }

    public void setStand(ArmorStand stand) {
        stand.setBasePlate(false);
        stand.setMarker(true);
        stand.setGravity(false);
        stand.setSmall(true);
        stand.setSilent(true);
        stand.setInvulnerable(true);
        stand.setVisible(false);
        stand.setCustomName("");
        stand.setRightArmPose(new EulerAngle(0.0, 0.0, 0.0));
    }

    public Vector rotateVectorAroundY(Vector vector, double degrees) {
        double rad = Math.toRadians(degrees);
        double currentX = vector.getX();
        double currentZ = vector.getZ();
        double cosine = Math.cos(rad);
        double sine = Math.sin(rad);
        return new Vector(cosine * currentX - sine * currentZ, vector.getY(), sine * currentX + cosine * currentZ);
    }
}

