/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.interactionvisualizer.blocks;

import com.loohp.interactionvisualizer.InteractionVisualizer;
import com.loohp.interactionvisualizer.api.InteractionVisualizerAPI;
import com.loohp.interactionvisualizer.api.VisualizerRunnableDisplay;
import com.loohp.interactionvisualizer.api.events.InteractionVisualizerReloadEvent;
import com.loohp.interactionvisualizer.api.events.TileEntityRemovedEvent;
import com.loohp.interactionvisualizer.entityholders.ArmorStand;
import com.loohp.interactionvisualizer.entityholders.Item;
import com.loohp.interactionvisualizer.libs.net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import com.loohp.interactionvisualizer.managers.PacketManager;
import com.loohp.interactionvisualizer.managers.PlayerLocationManager;
import com.loohp.interactionvisualizer.managers.TileEntityManager;
import com.loohp.interactionvisualizer.objectholders.EntryKey;
import com.loohp.interactionvisualizer.objectholders.TileEntity;
import com.loohp.interactionvisualizer.utils.ChatColorUtils;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BrewingStand;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.inventory.BrewerInventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.EulerAngle;
import org.bukkit.util.Vector;

public class BrewingStandDisplay
extends VisualizerRunnableDisplay
implements Listener {
    public static final EntryKey KEY = new EntryKey("brewing_stand");
    private final int max = 400;
    public ConcurrentHashMap<Block, Map<String, Object>> brewstand = new ConcurrentHashMap();
    private int checkingPeriod = 20;
    private int gcPeriod = 600;
    private String progressBarCharacter = "";
    private String emptyColor = "&7";
    private String filledColor = "&e";
    private String noFuelColor = "&c";
    private int progressBarLength = 10;

    public BrewingStandDisplay() {
        this.onReload(new InteractionVisualizerReloadEvent());
    }

    @EventHandler
    public void onReload(InteractionVisualizerReloadEvent event) {
        this.checkingPeriod = InteractionVisualizer.plugin.getConfiguration().getInt("Blocks.BrewingStand.CheckingPeriod");
        this.gcPeriod = InteractionVisualizerAPI.getGCPeriod();
        this.progressBarCharacter = ChatColorUtils.translateAlternateColorCodes('&', InteractionVisualizer.plugin.getConfiguration().getString("Blocks.BrewingStand.Options.ProgressBarCharacter"));
        this.emptyColor = ChatColorUtils.translateAlternateColorCodes('&', InteractionVisualizer.plugin.getConfiguration().getString("Blocks.BrewingStand.Options.EmptyColor"));
        this.filledColor = ChatColorUtils.translateAlternateColorCodes('&', InteractionVisualizer.plugin.getConfiguration().getString("Blocks.BrewingStand.Options.FilledColor"));
        this.noFuelColor = ChatColorUtils.translateAlternateColorCodes('&', InteractionVisualizer.plugin.getConfiguration().getString("Blocks.BrewingStand.Options.NoFuelColor"));
        this.progressBarLength = InteractionVisualizer.plugin.getConfiguration().getInt("Blocks.BrewingStand.Options.ProgressBarLength");
    }

    @Override
    public EntryKey key() {
        return KEY;
    }

    @Override
    public int gc() {
        return Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)InteractionVisualizer.plugin, () -> {
            Iterator<Map.Entry<Block, Map<String, Object>>> itr = this.brewstand.entrySet().iterator();
            int count = 0;
            int maxper = (int)Math.ceil((double)this.brewstand.size() / (double)this.gcPeriod);
            int delay = 1;
            while (itr.hasNext()) {
                if (++count > maxper) {
                    count = 0;
                    ++delay;
                }
                Map.Entry<Block, Map<String, Object>> entry = itr.next();
                Bukkit.getScheduler().runTaskLater((Plugin)InteractionVisualizer.plugin, () -> {
                    Block block = (Block)entry.getKey();
                    if (!this.isActive(block.getLocation())) {
                        Map map = (Map)entry.getValue();
                        if (map.get("Item") instanceof Item) {
                            Item item = (Item)map.get("Item");
                            PacketManager.removeItem(InteractionVisualizerAPI.getPlayers(), item);
                        }
                        if (map.get("Stand") instanceof ArmorStand) {
                            ArmorStand stand = (ArmorStand)map.get("Stand");
                            PacketManager.removeArmorStand(InteractionVisualizerAPI.getPlayers(), stand);
                        }
                        this.brewstand.remove(block);
                        return;
                    }
                    if (!block.getType().equals((Object)Material.BREWING_STAND)) {
                        Map map = (Map)entry.getValue();
                        if (map.get("Item") instanceof Item) {
                            Item item = (Item)map.get("Item");
                            PacketManager.removeItem(InteractionVisualizerAPI.getPlayers(), item);
                        }
                        if (map.get("Stand") instanceof ArmorStand) {
                            ArmorStand stand = (ArmorStand)map.get("Stand");
                            PacketManager.removeArmorStand(InteractionVisualizerAPI.getPlayers(), stand);
                        }
                        this.brewstand.remove(block);
                        return;
                    }
                }, (long)delay);
            }
        }, 0L, (long)this.gcPeriod).getTaskId();
    }

    @Override
    public int run() {
        return Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)InteractionVisualizer.plugin, () -> {
            Bukkit.getScheduler().runTask((Plugin)InteractionVisualizer.plugin, () -> {
                Set<Block> list = this.nearbyBrewingStand();
                for (Block block : list) {
                    if (this.brewstand.get(block) != null || !this.isActive(block.getLocation()) || !block.getType().equals((Object)Material.BREWING_STAND)) continue;
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    map.put("Item", "N/A");
                    map.putAll(this.spawnArmorStands(block));
                    this.brewstand.put(block, map);
                }
            });
            Iterator<Map.Entry<Block, Map<String, Object>>> itr = this.brewstand.entrySet().iterator();
            int count = 0;
            int maxper = (int)Math.ceil((double)this.brewstand.size() / (double)this.checkingPeriod);
            int delay = 1;
            while (itr.hasNext()) {
                Map.Entry<Block, Map<String, Object>> entry = itr.next();
                if (++count > maxper) {
                    count = 0;
                    ++delay;
                }
                Bukkit.getScheduler().runTaskLater((Plugin)InteractionVisualizer.plugin, () -> {
                    Block block = (Block)entry.getKey();
                    if (!this.isActive(block.getLocation())) {
                        return;
                    }
                    if (!block.getType().equals((Object)Material.BREWING_STAND)) {
                        return;
                    }
                    BrewingStand brewingstand = (BrewingStand)block.getState();
                    InteractionVisualizer.asyncExecutorManager.runTaskAsynchronously(() -> {
                        BrewerInventory inv = brewingstand.getInventory();
                        ItemStack itemstack = inv.getItem(3);
                        if (itemstack != null && inv.getItem(3).getType().equals((Object)Material.AIR)) {
                            itemstack = null;
                        }
                        Item item = null;
                        if (((Map)entry.getValue()).get("Item") instanceof String) {
                            if (itemstack != null) {
                                item = new Item(brewingstand.getLocation().clone().add(0.5, 1.0, 0.5));
                                item.setItemStack(itemstack);
                                item.setVelocity(new Vector(0, 0, 0));
                                item.setPickupDelay(Short.MAX_VALUE);
                                item.setGravity(false);
                                ((Map)entry.getValue()).put("Item", item);
                                PacketManager.sendItemSpawn(InteractionVisualizerAPI.getPlayerModuleList(InteractionVisualizerAPI.Modules.ITEMDROP, KEY), item);
                                PacketManager.updateItem(item);
                            } else {
                                ((Map)entry.getValue()).put("Item", "N/A");
                            }
                        } else {
                            item = (Item)((Map)entry.getValue()).get("Item");
                            if (itemstack != null) {
                                if (!item.getItemStack().equals((Object)itemstack)) {
                                    item.setItemStack(itemstack);
                                    PacketManager.updateItem(item);
                                }
                                item.setPickupDelay(Short.MAX_VALUE);
                                item.setGravity(false);
                            } else {
                                ((Map)entry.getValue()).put("Item", "N/A");
                                PacketManager.removeItem(InteractionVisualizerAPI.getPlayers(), item);
                            }
                        }
                        if (brewingstand.getFuelLevel() == 0) {
                            ArmorStand stand = (ArmorStand)((Map)entry.getValue()).get("Stand");
                            if (this.hasPotion(brewingstand)) {
                                stand.setCustomNameVisible(true);
                                String name = this.noFuelColor;
                                for (int i = 0; i < this.progressBarLength; ++i) {
                                    name = name + this.progressBarCharacter;
                                }
                                stand.setCustomName(name);
                                PacketManager.updateArmorStand(stand);
                            } else {
                                stand.setCustomNameVisible(false);
                                stand.setCustomName("");
                                PacketManager.updateArmorStand(stand);
                            }
                        } else {
                            ArmorStand stand = (ArmorStand)((Map)entry.getValue()).get("Stand");
                            if (this.hasPotion(brewingstand)) {
                                int time = brewingstand.getBrewingTime();
                                String symbol = "";
                                double percentagescaled = (double)(400 - time) / 400.0 * (double)this.progressBarLength;
                                double i = 1.0;
                                for (i = 1.0; i < percentagescaled; i += 1.0) {
                                    symbol = symbol + this.filledColor + this.progressBarCharacter;
                                }
                                if (percentagescaled - (i -= 1.0) > 0.0 && percentagescaled - i < 0.33) {
                                    symbol = symbol + this.emptyColor + this.progressBarCharacter;
                                } else if (percentagescaled - i > 0.0 && percentagescaled - i < 0.67) {
                                    symbol = symbol + this.emptyColor + this.progressBarCharacter;
                                } else if (percentagescaled - i > 0.0) {
                                    symbol = symbol + this.filledColor + this.progressBarCharacter;
                                }
                                for (i = (double)(this.progressBarLength - 1); i >= percentagescaled; i -= 1.0) {
                                    symbol = symbol + this.emptyColor + this.progressBarCharacter;
                                }
                                if (!PlainTextComponentSerializer.plainText().serialize(stand.getCustomName()).equals(symbol) || !stand.isCustomNameVisible()) {
                                    stand.setCustomNameVisible(true);
                                    stand.setCustomName(symbol);
                                    PacketManager.updateArmorStandOnlyMeta(stand);
                                }
                            } else if (!PlainTextComponentSerializer.plainText().serialize(stand.getCustomName()).equals("") || stand.isCustomNameVisible()) {
                                stand.setCustomNameVisible(false);
                                stand.setCustomName("");
                                PacketManager.updateArmorStandOnlyMeta(stand);
                            }
                        }
                    });
                }, (long)delay);
            }
        }, 0L, (long)this.checkingPeriod).getTaskId();
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onUseBrewingStand(InventoryClickEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (event.getWhoClicked().getGameMode().equals((Object)GameMode.SPECTATOR)) {
            return;
        }
        if (event.getView().getTopInventory() == null) {
            return;
        }
        try {
            if (event.getView().getTopInventory().getLocation() == null) {
                return;
            }
        }
        catch (AbstractMethodError | Exception e) {
            return;
        }
        if (event.getView().getTopInventory().getLocation().getBlock() == null) {
            return;
        }
        if (!event.getView().getTopInventory().getLocation().getBlock().getType().equals((Object)Material.BREWING_STAND)) {
            return;
        }
        if (event.getRawSlot() >= 0 && event.getRawSlot() <= 4) {
            PacketManager.sendHandMovement(InteractionVisualizerAPI.getPlayers(), (Player)event.getWhoClicked());
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onDragBrewingStand(InventoryDragEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (event.getWhoClicked().getGameMode().equals((Object)GameMode.SPECTATOR)) {
            return;
        }
        if (event.getView().getTopInventory() == null) {
            return;
        }
        try {
            if (event.getView().getTopInventory().getLocation() == null) {
                return;
            }
        }
        catch (AbstractMethodError | Exception e) {
            return;
        }
        if (event.getView().getTopInventory().getLocation().getBlock() == null) {
            return;
        }
        if (!event.getView().getTopInventory().getLocation().getBlock().getType().equals((Object)Material.BREWING_STAND)) {
            return;
        }
        Iterator iterator = event.getRawSlots().iterator();
        while (iterator.hasNext()) {
            int slot = (Integer)iterator.next();
            if (slot < 0 || slot > 4) continue;
            PacketManager.sendHandMovement(InteractionVisualizerAPI.getPlayers(), (Player)event.getWhoClicked());
            break;
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onBreakBrewingStand(TileEntityRemovedEvent event) {
        Block block = event.getBlock();
        if (!this.brewstand.containsKey(block)) {
            return;
        }
        Map<String, Object> map = this.brewstand.get(block);
        if (map.get("Item") instanceof Item) {
            Item item = (Item)map.get("Item");
            PacketManager.removeItem(InteractionVisualizerAPI.getPlayers(), item);
        }
        if (map.get("Stand") instanceof ArmorStand) {
            ArmorStand stand = (ArmorStand)map.get("Stand");
            PacketManager.removeArmorStand(InteractionVisualizerAPI.getPlayers(), stand);
        }
        this.brewstand.remove(block);
    }

    public boolean hasPotion(BrewingStand brewingstand) {
        BrewerInventory inv = brewingstand.getInventory();
        if (inv.getItem(0) != null && !inv.getItem(0).getType().equals((Object)Material.AIR)) {
            return true;
        }
        if (inv.getItem(1) != null && !inv.getItem(1).getType().equals((Object)Material.AIR)) {
            return true;
        }
        if (inv.getItem(2) != null) {
            return !inv.getItem(2).getType().equals((Object)Material.AIR);
        }
        return false;
    }

    public Set<Block> nearbyBrewingStand() {
        return TileEntityManager.getTileEntities(TileEntity.TileEntityType.BREWING_STAND);
    }

    public boolean isActive(Location loc) {
        return PlayerLocationManager.hasPlayerNearby(loc);
    }

    public Map<String, ArmorStand> spawnArmorStands(Block block) {
        HashMap<String, ArmorStand> map = new HashMap<String, ArmorStand>();
        Location loc = block.getLocation().clone().add(0.5, 0.700781, 0.5);
        ArmorStand slot1 = new ArmorStand(loc.clone());
        this.setStand(slot1);
        map.put("Stand", slot1);
        PacketManager.sendArmorStandSpawn(InteractionVisualizerAPI.getPlayerModuleList(InteractionVisualizerAPI.Modules.HOLOGRAM, KEY), slot1);
        return map;
    }

    public void setStand(ArmorStand stand) {
        stand.setBasePlate(false);
        stand.setMarker(true);
        stand.setGravity(false);
        stand.setSmall(true);
        stand.setInvulnerable(true);
        stand.setSilent(true);
        stand.setVisible(false);
        stand.setCustomName("");
        stand.setRightArmPose(new EulerAngle(0.0, 0.0, 0.0));
    }
}

