/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.interactionvisualizer.blocks;

import com.loohp.interactionvisualizer.InteractionVisualizer;
import com.loohp.interactionvisualizer.api.InteractionVisualizerAPI;
import com.loohp.interactionvisualizer.api.VisualizerRunnableDisplay;
import com.loohp.interactionvisualizer.api.events.InteractionVisualizerReloadEvent;
import com.loohp.interactionvisualizer.api.events.TileEntityRemovedEvent;
import com.loohp.interactionvisualizer.entityholders.ArmorStand;
import com.loohp.interactionvisualizer.libs.net.kyori.adventure.text.TextComponent;
import com.loohp.interactionvisualizer.libs.net.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import com.loohp.interactionvisualizer.libs.net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import com.loohp.interactionvisualizer.libs.net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import com.loohp.interactionvisualizer.managers.PacketManager;
import com.loohp.interactionvisualizer.managers.PlayerLocationManager;
import com.loohp.interactionvisualizer.managers.TileEntityManager;
import com.loohp.interactionvisualizer.nms.NMS;
import com.loohp.interactionvisualizer.objectholders.EntryKey;
import com.loohp.interactionvisualizer.objectholders.TileEntity;
import com.loohp.interactionvisualizer.utils.ChatColorUtils;
import com.loohp.interactionvisualizer.utils.JsonUtils;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.Rotatable;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.material.Banner;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.EulerAngle;
import org.bukkit.util.Vector;

public class BannerDisplay
extends VisualizerRunnableDisplay
implements Listener {
    public static final EntryKey KEY = new EntryKey("banner");
    public Map<Block, Map<String, Object>> bannerMap = new ConcurrentHashMap<Block, Map<String, Object>>();
    private int checkingPeriod = 20;
    private int gcPeriod = 600;
    private boolean stripColorBlacklist;
    private Predicate<String> blacklist;

    public BannerDisplay() {
        this.onReload(new InteractionVisualizerReloadEvent());
    }

    @EventHandler
    public void onReload(InteractionVisualizerReloadEvent event) {
        this.checkingPeriod = InteractionVisualizer.plugin.getConfiguration().getInt("Blocks.Banner.CheckingPeriod");
        this.gcPeriod = InteractionVisualizerAPI.getGCPeriod();
        this.stripColorBlacklist = InteractionVisualizer.plugin.getConfiguration().getBoolean("Entities.Item.Options.Blacklist.StripColorWhenMatching");
        this.blacklist = InteractionVisualizer.plugin.getConfiguration().getStringList("Blocks.Banner.Options.Blacklist.List").stream().map(each -> {
            Pattern pattern = Pattern.compile(each);
            return str -> pattern.matcher((CharSequence)str).matches();
        }).reduce(Predicate::or).orElse(s -> false);
    }

    @Override
    public EntryKey key() {
        return KEY;
    }

    @Override
    public int gc() {
        return Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)InteractionVisualizer.plugin, () -> {
            Iterator<Map.Entry<Block, Map<String, Object>>> itr = this.bannerMap.entrySet().iterator();
            int count = 0;
            int maxper = (int)Math.ceil((double)this.bannerMap.size() / (double)this.gcPeriod);
            int delay = 1;
            while (itr.hasNext()) {
                if (++count > maxper) {
                    count = 0;
                    ++delay;
                }
                Map.Entry<Block, Map<String, Object>> entry = itr.next();
                Bukkit.getScheduler().runTaskLater((Plugin)InteractionVisualizer.plugin, () -> {
                    Block block = (Block)entry.getKey();
                    if (!this.isActive(block.getLocation())) {
                        Map map = (Map)entry.getValue();
                        if (map.get("1") instanceof ArmorStand) {
                            ArmorStand stand = (ArmorStand)map.get("1");
                            PacketManager.removeArmorStand(InteractionVisualizerAPI.getPlayers(), stand);
                        }
                        this.bannerMap.remove(block);
                        return;
                    }
                    if (!this.isBanner(block.getType())) {
                        Map map = (Map)entry.getValue();
                        if (map.get("1") instanceof ArmorStand) {
                            ArmorStand stand = (ArmorStand)map.get("1");
                            PacketManager.removeArmorStand(InteractionVisualizerAPI.getPlayers(), stand);
                        }
                        this.bannerMap.remove(block);
                    }
                }, (long)delay);
            }
        }, 0L, (long)this.gcPeriod).getTaskId();
    }

    @Override
    public int run() {
        return Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)InteractionVisualizer.plugin, () -> {
            Bukkit.getScheduler().runTask((Plugin)InteractionVisualizer.plugin, () -> {
                Set<Block> list = this.nearbyBanner();
                for (Block block : list) {
                    if (this.bannerMap.get(block) != null || !this.isActive(block.getLocation()) || !this.isBanner(block.getType())) continue;
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    map.put("Item", "N/A");
                    map.putAll(this.spawnArmorStands(block));
                    this.bannerMap.put(block, map);
                }
            });
            Iterator<Map.Entry<Block, Map<String, Object>>> itr = this.bannerMap.entrySet().iterator();
            int count = 0;
            int maxper = (int)Math.ceil((double)this.bannerMap.size() / (double)this.checkingPeriod);
            int delay = 1;
            while (itr.hasNext()) {
                Map.Entry<Block, Map<String, Object>> entry = itr.next();
                if (++count > maxper) {
                    count = 0;
                    ++delay;
                }
                Bukkit.getScheduler().runTaskLater((Plugin)InteractionVisualizer.plugin, () -> {
                    Block block = (Block)entry.getKey();
                    if (!this.isActive(block.getLocation())) {
                        return;
                    }
                    if (!this.isBanner(block.getType())) {
                        return;
                    }
                    String name = NMS.getInstance().getBannerCustomName(block);
                    InteractionVisualizer.asyncExecutorManager.runTaskAsynchronously(() -> {
                        ArmorStand line1 = (ArmorStand)((Map)entry.getValue()).get("1");
                        if (name == null || name.equals("")) {
                            if (!PlainTextComponentSerializer.plainText().serialize(line1.getCustomName()).equals("") || line1.isCustomNameVisible()) {
                                line1.setCustomName("");
                                line1.setCustomNameVisible(false);
                                PacketManager.updateArmorStandOnlyMeta(line1);
                            }
                        } else {
                            TextComponent component;
                            if (JsonUtils.isValid(name)) {
                                try {
                                    component = GsonComponentSerializer.gson().deserialize(name);
                                }
                                catch (Throwable e) {
                                    component = LegacyComponentSerializer.legacySection().deserialize(name);
                                }
                            } else {
                                component = LegacyComponentSerializer.legacySection().deserialize(name);
                            }
                            String matchingName = LegacyComponentSerializer.legacySection().serialize(component);
                            if (this.stripColorBlacklist) {
                                matchingName = ChatColorUtils.stripColor(matchingName);
                            }
                            if (this.blacklist.test(matchingName)) {
                                if (!PlainTextComponentSerializer.plainText().serialize(line1.getCustomName()).equals("") || line1.isCustomNameVisible()) {
                                    line1.setCustomName("");
                                    line1.setCustomNameVisible(false);
                                    PacketManager.updateArmorStandOnlyMeta(line1);
                                }
                            } else if (!line1.getCustomName().equals(component) || !line1.isCustomNameVisible()) {
                                line1.setCustomName(component);
                                line1.setCustomNameVisible(true);
                                PacketManager.updateArmorStandOnlyMeta(line1);
                            }
                        }
                    });
                }, (long)delay);
            }
        }, 0L, (long)this.checkingPeriod).getTaskId();
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onBreakBanner(TileEntityRemovedEvent event) {
        Block block = event.getBlock();
        if (!this.bannerMap.containsKey(block)) {
            return;
        }
        Map<String, Object> map = this.bannerMap.get(block);
        if (map.get("1") instanceof ArmorStand) {
            ArmorStand stand = (ArmorStand)map.get("1");
            PacketManager.removeArmorStand(InteractionVisualizerAPI.getPlayers(), stand);
        }
        this.bannerMap.remove(block);
    }

    public Set<Block> nearbyBanner() {
        return TileEntityManager.getTileEntities(TileEntity.TileEntityType.BANNER);
    }

    public boolean isActive(Location loc) {
        return PlayerLocationManager.hasPlayerNearby(loc);
    }

    public boolean isBanner(Material material) {
        TileEntity.TileEntityType type = TileEntity.getTileEntityType(material);
        return type != null && type.equals((Object)TileEntity.TileEntityType.BANNER);
    }

    public boolean isWallBanner(Material material) {
        return material.name().contains("WALL");
    }

    public Map<String, ArmorStand> spawnArmorStands(Block block) {
        HashMap<String, ArmorStand> map = new HashMap<String, ArmorStand>();
        if (this.isWallBanner(block.getType())) {
            ArmorStand line1 = new ArmorStand(block.getLocation().add(0.5, 0.0, 0.5));
            this.setStand(line1);
            map.put("1", line1);
            PacketManager.sendArmorStandSpawn(InteractionVisualizerAPI.getPlayerModuleList(InteractionVisualizerAPI.Modules.HOLOGRAM, KEY), line1);
        } else {
            Vector vector;
            Location origin = block.getLocation().add(0.5, 1.0, 0.5);
            if (InteractionVisualizer.version.isLegacy()) {
                Banner banner = (Banner)block.getState().getData();
                vector = this.getDirection(banner.getFacing()).multiply(0.3125);
            } else {
                Rotatable rotate = (Rotatable)block.getBlockData();
                vector = this.getDirection(rotate.getRotation()).multiply(0.3125);
            }
            ArmorStand line1 = new ArmorStand(origin.clone().add(vector));
            this.setStand(line1);
            map.put("1", line1);
            PacketManager.sendArmorStandSpawn(InteractionVisualizerAPI.getPlayerModuleList(InteractionVisualizerAPI.Modules.HOLOGRAM, KEY), line1);
        }
        return map;
    }

    public Vector getDirection(BlockFace face) {
        Vector direction = new Vector(face.getModX(), face.getModY(), face.getModZ());
        if (face.getModX() != 0 || face.getModY() != 0 || face.getModZ() != 0) {
            direction.normalize();
        }
        return direction;
    }

    public void setStand(ArmorStand stand) {
        stand.setBasePlate(false);
        stand.setMarker(true);
        stand.setGravity(false);
        stand.setSmall(true);
        stand.setSilent(true);
        stand.setInvulnerable(true);
        stand.setVisible(false);
        stand.setCustomName("");
        stand.setRightArmPose(new EulerAngle(0.0, 0.0, 0.0));
    }
}

