/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.interactionvisualizer.api;

import com.loohp.interactionvisualizer.api.InteractionVisualizerAPI;
import com.loohp.interactionvisualizer.api.VisualizerDisplay;
import com.loohp.interactionvisualizer.managers.TaskManager;
import com.loohp.interactionvisualizer.objectholders.EntryKey;
import java.util.HashSet;
import java.util.Set;
import org.bukkit.Bukkit;

public abstract class VisualizerRunnableDisplay
implements VisualizerDisplay {
    private Set<Integer> tasks;

    public abstract int gc();

    public abstract int run();

    @Override
    public final void register() {
        int run;
        if (this.key().isNative()) {
            throw new IllegalStateException("EntryKey must not have the default interactionvisualizer namespace");
        }
        InteractionVisualizerAPI.getPreferenceManager().registerEntry(this.key(), new EntryKey[0]);
        TaskManager.runnables.add(this);
        this.tasks = new HashSet<Integer>();
        int gc = this.gc();
        if (gc >= 0) {
            this.tasks.add(gc);
        }
        if ((run = this.run()) >= 0) {
            this.tasks.add(run);
        }
    }

    @Override
    @Deprecated
    public final EntryKey registerNative() {
        int run;
        TaskManager.runnables.add(this);
        this.tasks = new HashSet<Integer>();
        int gc = this.gc();
        if (gc >= 0) {
            this.tasks.add(gc);
        }
        if ((run = this.run()) >= 0) {
            this.tasks.add(run);
        }
        return this.key();
    }

    @Deprecated
    public final void unregister() {
        TaskManager.runnables.remove(this);
        this.tasks.forEach(each -> Bukkit.getScheduler().cancelTask(each.intValue()));
    }
}

