/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.interactionvisualizer.api;

import com.loohp.interactionvisualizer.InteractionVisualizer;
import com.loohp.interactionvisualizer.config.Config;
import com.loohp.interactionvisualizer.entityholders.ArmorStand;
import com.loohp.interactionvisualizer.entityholders.Item;
import com.loohp.interactionvisualizer.libs.net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import com.loohp.interactionvisualizer.managers.PacketManager;
import com.loohp.interactionvisualizer.managers.PreferenceManager;
import com.loohp.interactionvisualizer.managers.SoundManager;
import com.loohp.interactionvisualizer.managers.TileEntityManager;
import com.loohp.interactionvisualizer.objectholders.EntryKey;
import com.loohp.interactionvisualizer.objectholders.SynchronizedFilteredCollection;
import com.loohp.interactionvisualizer.objectholders.TileEntity;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.EulerAngle;
import org.bukkit.util.Vector;

public class InteractionVisualizerAPI {
    public static String getUserFriendlyName(Modules module) {
        return Config.getConfig("config").getConfiguration().getString("Messages.ModuleName." + module.toString().toLowerCase(), module.toString().toLowerCase());
    }

    public static String getUserFriendlyName(EntryKey entry) {
        return Config.getConfig("config").getConfiguration().getString("Messages.EntryName." + entry.toString().toLowerCase(), entry.toString().toLowerCase());
    }

    public static int getGCPeriod() {
        return InteractionVisualizer.plugin.getConfiguration().getInt("GarbageCollector.Period");
    }

    public static Collection<Block> getActiveTileEntityBlocks(TileEntity.TileEntityType type) {
        return TileEntityManager.getTileEntities(type);
    }

    public static Collection<Player> getPlayerModuleList(Modules module, EntryKey entry) {
        return InteractionVisualizerAPI.getPlayerModuleList(module, entry, true, new Player[0]);
    }

    public static Collection<Player> getPlayerModuleList(Modules module, EntryKey entry, Player ... excludes) {
        return InteractionVisualizerAPI.getPlayerModuleList(module, entry, true, excludes);
    }

    public static Collection<Player> getPlayerModuleList(Modules module, EntryKey entry, boolean excludeDisabledWorlds, Player ... excludes) {
        Collection<Player> players = InteractionVisualizer.preferenceManager.getPlayerList(module, entry);
        Set excludedPlayers = Stream.of(excludes).collect(Collectors.toSet());
        if (excludeDisabledWorlds) {
            Set<String> disabledWorlds = InteractionVisualizerAPI.getDisabledWorlds();
            players = SynchronizedFilteredCollection.filterSynchronized(players, each -> !excludedPlayers.contains(each) && !disabledWorlds.contains(each.getWorld().getName()));
        } else {
            players = SynchronizedFilteredCollection.filterSynchronized(players, each -> !excludedPlayers.contains(each));
        }
        return Collections.unmodifiableCollection(players);
    }

    public static Collection<Player> getPlayers() {
        return InteractionVisualizerAPI.getPlayers(false);
    }

    public static Collection<Player> getPlayers(boolean excludeDisabledWorlds) {
        if (excludeDisabledWorlds) {
            Set<String> disabledWorlds = InteractionVisualizerAPI.getDisabledWorlds();
            return Bukkit.getWorlds().stream().filter(each -> disabledWorlds.contains(each.getName())).flatMap(each -> each.getPlayers().stream()).collect(Collectors.toSet());
        }
        return new HashSet<Player>(Bukkit.getOnlinePlayers());
    }

    public static boolean hasPlayerEnabledModule(Player player, Modules module, EntryKey entry) {
        return InteractionVisualizerAPI.getPlayerModuleList(module, entry).contains(player);
    }

    public static boolean hasPlayerEnabledModule(UUID uuid, Modules module, EntryKey entry) {
        Player player = Bukkit.getPlayer((UUID)uuid);
        if (player != null) {
            return InteractionVisualizerAPI.hasPlayerEnabledModule(player, module, entry);
        }
        InteractionVisualizer.preferenceManager.loadPlayer(uuid, "", false);
        boolean value = InteractionVisualizerAPI.hasPlayerEnabledModule(player, module, entry);
        InteractionVisualizer.preferenceManager.unloadPlayerWithoutSaving(uuid);
        return value;
    }

    public static boolean hasAnyPreferenceDisabled(UUID uuid, Modules module) {
        Player player = Bukkit.getPlayer((UUID)uuid);
        if (player != null) {
            return InteractionVisualizerAPI.getPreferenceManager().hasAnyPreferenceDisabled(uuid, module);
        }
        InteractionVisualizer.preferenceManager.loadPlayer(uuid, "", false);
        boolean value = InteractionVisualizerAPI.getPreferenceManager().hasAnyPreferenceDisabled(uuid, module);
        InteractionVisualizer.preferenceManager.unloadPlayerWithoutSaving(uuid);
        return value;
    }

    public static boolean hasAnyPreferenceDisabled(UUID uuid, EntryKey entry) {
        Player player = Bukkit.getPlayer((UUID)uuid);
        if (player != null) {
            return InteractionVisualizerAPI.getPreferenceManager().hasAnyPreferenceDisabled(uuid, entry);
        }
        InteractionVisualizer.preferenceManager.loadPlayer(uuid, "", false);
        boolean value = InteractionVisualizerAPI.getPreferenceManager().hasAnyPreferenceDisabled(uuid, entry);
        InteractionVisualizer.preferenceManager.unloadPlayerWithoutSaving(uuid);
        return value;
    }

    public static boolean hasAnyPreferenceDisabled(UUID uuid) {
        Player player = Bukkit.getPlayer((UUID)uuid);
        if (player != null) {
            return InteractionVisualizerAPI.getPreferenceManager().hasAnyPreferenceDisabled(uuid);
        }
        InteractionVisualizer.preferenceManager.loadPlayer(uuid, "", false);
        boolean value = InteractionVisualizerAPI.getPreferenceManager().hasAnyPreferenceDisabled(uuid);
        InteractionVisualizer.preferenceManager.unloadPlayerWithoutSaving(uuid);
        return value;
    }

    public static boolean hasAnyPreferenceEnabled(UUID uuid, Modules module) {
        Player player = Bukkit.getPlayer((UUID)uuid);
        if (player != null) {
            return InteractionVisualizerAPI.getPreferenceManager().hasAnyPreferenceEnabled(uuid, module);
        }
        InteractionVisualizer.preferenceManager.loadPlayer(uuid, "", false);
        boolean value = InteractionVisualizerAPI.getPreferenceManager().hasAnyPreferenceEnabled(uuid, module);
        InteractionVisualizer.preferenceManager.unloadPlayerWithoutSaving(uuid);
        return value;
    }

    public static boolean hasAnyPreferenceEnabled(UUID uuid, EntryKey entry) {
        Player player = Bukkit.getPlayer((UUID)uuid);
        if (player != null) {
            return InteractionVisualizerAPI.getPreferenceManager().hasAnyPreferenceEnabled(uuid, entry);
        }
        InteractionVisualizer.preferenceManager.loadPlayer(uuid, "", false);
        boolean value = InteractionVisualizerAPI.getPreferenceManager().hasAnyPreferenceEnabled(uuid, entry);
        InteractionVisualizer.preferenceManager.unloadPlayerWithoutSaving(uuid);
        return value;
    }

    public static boolean hasAnyPreferenceEnabled(UUID uuid) {
        Player player = Bukkit.getPlayer((UUID)uuid);
        if (player != null) {
            return InteractionVisualizerAPI.getPreferenceManager().hasAnyPreferenceEnabled(uuid);
        }
        InteractionVisualizer.preferenceManager.loadPlayer(uuid, "", false);
        boolean value = InteractionVisualizerAPI.getPreferenceManager().hasAnyPreferenceEnabled(uuid);
        InteractionVisualizer.preferenceManager.unloadPlayerWithoutSaving(uuid);
        return value;
    }

    public static boolean hasAllPreferenceEnabled(UUID uuid, Modules module) {
        Player player = Bukkit.getPlayer((UUID)uuid);
        if (player != null) {
            return InteractionVisualizerAPI.getPreferenceManager().hasAllPreferenceEnabled(uuid, module);
        }
        InteractionVisualizer.preferenceManager.loadPlayer(uuid, "", false);
        boolean value = InteractionVisualizerAPI.getPreferenceManager().hasAllPreferenceEnabled(uuid, module);
        InteractionVisualizer.preferenceManager.unloadPlayerWithoutSaving(uuid);
        return value;
    }

    public static boolean hasAllPreferenceEnabled(UUID uuid, EntryKey entry) {
        Player player = Bukkit.getPlayer((UUID)uuid);
        if (player != null) {
            return InteractionVisualizerAPI.getPreferenceManager().hasAllPreferenceEnabled(uuid, entry);
        }
        InteractionVisualizer.preferenceManager.loadPlayer(uuid, "", false);
        boolean value = InteractionVisualizerAPI.getPreferenceManager().hasAllPreferenceEnabled(uuid, entry);
        InteractionVisualizer.preferenceManager.unloadPlayerWithoutSaving(uuid);
        return value;
    }

    public static boolean hasAllPreferenceEnabled(UUID uuid) {
        Player player = Bukkit.getPlayer((UUID)uuid);
        if (player != null) {
            return InteractionVisualizerAPI.getPreferenceManager().hasAllPreferenceEnabled(uuid);
        }
        InteractionVisualizer.preferenceManager.loadPlayer(uuid, "", false);
        boolean value = InteractionVisualizerAPI.getPreferenceManager().hasAllPreferenceEnabled(uuid);
        InteractionVisualizer.preferenceManager.unloadPlayerWithoutSaving(uuid);
        return value;
    }

    public static boolean isRegisteredEntry(EntryKey entry) {
        return InteractionVisualizer.preferenceManager.isRegisteredEntry(entry);
    }

    public static List<EntryKey> getRegisteredEntries() {
        return InteractionVisualizer.preferenceManager.getRegisteredEntries();
    }

    public static Set<String> getDisabledWorlds() {
        return Collections.unmodifiableSet(InteractionVisualizer.disabledWorlds);
    }

    public static Set<EntryKey> getOverridingDisabledEntries(Modules module) {
        switch (module) {
            case ITEMSTAND: {
                return Collections.unmodifiableSet(InteractionVisualizer.itemStandDisabled);
            }
            case ITEMDROP: {
                return Collections.unmodifiableSet(InteractionVisualizer.itemDropDisabled);
            }
            case HOLOGRAM: {
                return Collections.unmodifiableSet(InteractionVisualizer.hologramsDisabled);
            }
        }
        return Collections.emptySet();
    }

    public static PreferenceManager getPreferenceManager() {
        return InteractionVisualizer.preferenceManager;
    }

    public static void playFakeItemThrowAnimation(EntryKey entry, Location from, Location to, ItemStack itemstack, boolean pickupSound) {
        Item item = new Item(from.clone());
        item.setItemStack(itemstack);
        item.setLocked(true);
        item.setGravity(true);
        Vector lift = new Vector(0.0, 0.15, 0.0);
        Vector pickup = to.clone().toVector().subtract(from.clone().toVector()).multiply(0.15).add(lift);
        item.setVelocity(pickup);
        item.setPickupDelay(Short.MAX_VALUE);
        PacketManager.sendItemSpawn(InteractionVisualizerAPI.getPlayerModuleList(Modules.ITEMDROP, entry), item);
        PacketManager.updateItem(item);
        Bukkit.getScheduler().runTaskLater((Plugin)InteractionVisualizer.plugin, () -> {
            if (pickupSound) {
                SoundManager.playItemPickup(item.getLocation(), InteractionVisualizerAPI.getPlayerModuleList(Modules.ITEMDROP, entry));
            }
            PacketManager.removeItem(InteractionVisualizerAPI.getPlayers(), item);
        }, 8L);
    }

    public static ArmorStand createArmorStandObject(Location location) {
        return new ArmorStand(location.clone());
    }

    public static ArmorStand createArmorStandItemHoldingObject(Location location) {
        Vector vector = InteractionVisualizerAPI.rotateVectorAroundY(location.clone().getDirection().normalize().multiply(0.19), -100.0).add(location.clone().getDirection().normalize().multiply(-0.11));
        ArmorStand stand = new ArmorStand(location.add(vector));
        InteractionVisualizerAPI.setStand(stand, location.getYaw());
        return stand;
    }

    public static ArmorStandHoldingMode getArmorStandItemHoldingObjectMode(ArmorStand stand, ArmorStandHoldingMode mode) {
        switch (InteractionVisualizerAPI.getStandModeRaw(stand).toLowerCase()) {
            case "Item": {
                return ArmorStandHoldingMode.ITEM;
            }
            case "LowBlock": {
                return ArmorStandHoldingMode.LOWBLOCK;
            }
            case "Tool": {
                return ArmorStandHoldingMode.TOOL;
            }
            case "Standing": {
                return ArmorStandHoldingMode.STANDING;
            }
        }
        return null;
    }

    public static ArmorStand rotateArmorStandItemHoldingObject(ArmorStand stand, ArmorStandHoldingMode mode) {
        InteractionVisualizerAPI.toggleStandMode(stand, mode.toString());
        return stand;
    }

    private static Vector rotateVectorAroundY(Vector vector, double degrees) {
        double rad = Math.toRadians(degrees);
        double currentX = vector.getX();
        double currentZ = vector.getZ();
        double cosine = Math.cos(rad);
        double sine = Math.sin(rad);
        return new Vector(cosine * currentX - sine * currentZ, vector.getY(), sine * currentX + cosine * currentZ);
    }

    private static void setStand(ArmorStand stand, float yaw) {
        stand.setArms(true);
        stand.setBasePlate(false);
        stand.setMarker(true);
        stand.setGravity(false);
        stand.setSmall(true);
        stand.setInvulnerable(true);
        stand.setVisible(false);
        stand.setSilent(true);
        stand.setRightArmPose(new EulerAngle(0.0, 0.0, 0.0));
        stand.setCustomName("IV.Custom.Item");
        stand.setRotation(yaw, stand.getLocation().getPitch());
    }

    @Deprecated
    public static String getStandModeRaw(ArmorStand stand) {
        String plain = PlainTextComponentSerializer.plainText().serialize(stand.getCustomName());
        if (plain.startsWith("IV.Custom.")) {
            return plain.substring(plain.lastIndexOf(".") + 1);
        }
        return null;
    }

    public static ArmorStandHoldingMode getStandMode(ArmorStand stand) {
        String plain = PlainTextComponentSerializer.plainText().serialize(stand.getCustomName());
        if (plain.startsWith("IV.Custom.")) {
            return ArmorStandHoldingMode.fromName(plain.substring(plain.lastIndexOf(".") + 1));
        }
        return null;
    }

    private static void toggleStandMode(ArmorStand stand, String mode) {
        String plain = PlainTextComponentSerializer.plainText().serialize(stand.getCustomName());
        if (!plain.equals("IV.Custom.Item")) {
            if (plain.equals("IV.Custom.Block")) {
                stand.setCustomName("IV.Custom.Item");
                stand.setRotation(stand.getLocation().getYaw() - 45.0f, stand.getLocation().getPitch());
                stand.setRightArmPose(new EulerAngle(0.0, 0.0, 0.0));
                stand.teleport(stand.getLocation().add(0.0, -0.084, 0.0));
                stand.teleport(stand.getLocation().add(InteractionVisualizerAPI.rotateVectorAroundY(stand.getLocation().clone().getDirection().normalize().multiply(-0.102), -90.0)));
                stand.teleport(stand.getLocation().add(stand.getLocation().clone().getDirection().normalize().multiply(-0.14)));
            }
            if (plain.equals("IV.Custom.LowBlock")) {
                stand.setCustomName("IV.Custom.Item");
                stand.setRotation(stand.getLocation().getYaw() - 45.0f, stand.getLocation().getPitch());
                stand.setRightArmPose(new EulerAngle(0.0, 0.0, 0.0));
                stand.teleport(stand.getLocation().add(0.0, -0.02, 0.0));
                stand.teleport(stand.getLocation().add(InteractionVisualizerAPI.rotateVectorAroundY(stand.getLocation().clone().getDirection().normalize().multiply(-0.09), -90.0)));
                stand.teleport(stand.getLocation().add(stand.getLocation().clone().getDirection().normalize().multiply(-0.15)));
            }
            if (plain.equals("IV.Custom.Tool")) {
                stand.setCustomName("IV.Custom.Item");
                stand.teleport(stand.getLocation().add(InteractionVisualizerAPI.rotateVectorAroundY(stand.getLocation().clone().getDirection().normalize().multiply(0.3), -90.0)));
                stand.teleport(stand.getLocation().add(stand.getLocation().clone().getDirection().normalize().multiply(0.1)));
                stand.teleport(stand.getLocation().add(0.0, 0.26, 0.0));
                stand.setRightArmPose(new EulerAngle(0.0, 0.0, 0.0));
            }
            if (plain.equals("IV.Custom.Standing")) {
                stand.setCustomName("IV.Custom.Item");
                stand.teleport(stand.getLocation().add(InteractionVisualizerAPI.rotateVectorAroundY(stand.getLocation().getDirection().normalize().multiply(0.323), -90.0)));
                stand.teleport(stand.getLocation().add(stand.getLocation().getDirection().normalize().multiply(-0.115)));
                stand.teleport(stand.getLocation().add(0.0, 0.32, 0.0));
                stand.setRightArmPose(new EulerAngle(0.0, 0.0, 0.0));
            }
        }
        if (mode.equals("Block")) {
            stand.setCustomName("IV.Custom.Block");
            stand.teleport(stand.getLocation().add(stand.getLocation().clone().getDirection().normalize().multiply(0.14)));
            stand.teleport(stand.getLocation().add(InteractionVisualizerAPI.rotateVectorAroundY(stand.getLocation().clone().getDirection().normalize().multiply(0.102), -90.0)));
            stand.teleport(stand.getLocation().add(0.0, 0.084, 0.0));
            stand.setRightArmPose(new EulerAngle(357.9, 0.0, 0.0));
            stand.setRotation(stand.getLocation().getYaw() + 45.0f, stand.getLocation().getPitch());
        }
        if (mode.equals("LowBlock")) {
            stand.setCustomName("IV.Custom.LowBlock");
            stand.teleport(stand.getLocation().add(stand.getLocation().clone().getDirection().normalize().multiply(0.15)));
            stand.teleport(stand.getLocation().add(InteractionVisualizerAPI.rotateVectorAroundY(stand.getLocation().clone().getDirection().normalize().multiply(0.09), -90.0)));
            stand.teleport(stand.getLocation().add(0.0, 0.02, 0.0));
            stand.setRightArmPose(new EulerAngle(357.9, 0.0, 0.0));
            stand.setRotation(stand.getLocation().getYaw() + 45.0f, stand.getLocation().getPitch());
        }
        if (mode.equals("Tool")) {
            stand.setCustomName("IV.Custom.Tool");
            stand.setRightArmPose(new EulerAngle(357.99, 0.0, 300.0));
            stand.teleport(stand.getLocation().add(0.0, -0.26, 0.0));
            stand.teleport(stand.getLocation().add(stand.getLocation().clone().getDirection().normalize().multiply(-0.1)));
            stand.teleport(stand.getLocation().add(InteractionVisualizerAPI.rotateVectorAroundY(stand.getLocation().clone().getDirection().normalize().multiply(-0.3), -90.0)));
        }
        if (mode.equals("Standing")) {
            stand.setCustomName("IV.Custom.Standing");
            stand.setRightArmPose(new EulerAngle(0.0, 4.7, 4.7));
            stand.teleport(stand.getLocation().add(0.0, -0.32, 0.0));
            stand.teleport(stand.getLocation().add(stand.getLocation().getDirection().normalize().multiply(0.115)));
            stand.teleport(stand.getLocation().add(InteractionVisualizerAPI.rotateVectorAroundY(stand.getLocation().getDirection().normalize().multiply(-0.323), -90.0)));
        }
    }

    public static ArmorStand spawnFakeArmorStand(ArmorStand stand, EntryKey entry) {
        PacketManager.sendArmorStandSpawn(InteractionVisualizerAPI.getPlayerModuleList(Modules.HOLOGRAM, entry), stand);
        return stand;
    }

    public static ArmorStand updateFakeArmorStand(ArmorStand stand, EntryKey entry) {
        PacketManager.updateArmorStand(InteractionVisualizerAPI.getPlayerModuleList(Modules.HOLOGRAM, entry), stand);
        return stand;
    }

    public static ArmorStand removeFakeArmorStand(ArmorStand stand, EntryKey entry) {
        PacketManager.removeArmorStand(InteractionVisualizerAPI.getPlayerModuleList(Modules.HOLOGRAM, entry), stand);
        return stand;
    }

    public static Item createItemObject(Location location) {
        return new Item(location.clone());
    }

    public static Item spawnFakeItem(Item item, EntryKey entry) {
        PacketManager.sendItemSpawn(InteractionVisualizerAPI.getPlayerModuleList(Modules.ITEMDROP, entry), item);
        return item;
    }

    public static Item updateItem(Item item, EntryKey entry) {
        PacketManager.updateItem(InteractionVisualizerAPI.getPlayerModuleList(Modules.ITEMDROP, entry), item);
        return item;
    }

    public static Item removeItem(Item item, EntryKey entry) {
        PacketManager.removeItem(InteractionVisualizerAPI.getPlayerModuleList(Modules.ITEMDROP, entry), item);
        return item;
    }

    public static enum Modules {
        ITEMSTAND,
        ITEMDROP,
        HOLOGRAM;

    }

    public static enum ArmorStandHoldingMode {
        ITEM("Item"),
        LOWBLOCK("LowBlock"),
        TOOL("Tool"),
        STANDING("Standing");

        private final String mode;

        public static ArmorStandHoldingMode fromName(String name) {
            for (ArmorStandHoldingMode mode : ArmorStandHoldingMode.values()) {
                if (!mode.toString().equalsIgnoreCase(name)) continue;
                return mode;
            }
            return null;
        }

        private ArmorStandHoldingMode(String mode) {
            this.mode = mode;
        }

        public String toString() {
            return this.mode;
        }
    }

    public static enum ConfiguationType {
        MAIN("config.yml"),
        MATERIAL("material.yml"),
        EFFECTS("effect.yml"),
        ENCHANTMENT("enchantment.yml"),
        MUSIC("music.yml");

        String fileName;

        public static ConfiguationType fromConfigFileName(String filename) {
            for (ConfiguationType cfgtype : ConfiguationType.values()) {
                if (!cfgtype.getConfigFileName().equalsIgnoreCase(filename)) continue;
                return cfgtype;
            }
            return null;
        }

        private ConfiguationType(String fileName) {
            this.fileName = fileName;
        }

        public String getConfigFileName() {
            return this.fileName;
        }
    }
}

