/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.interactionvisualizer;

import com.loohp.interactionvisualizer.InteractionVisualizer;
import com.loohp.interactionvisualizer.Toggle;
import com.loohp.interactionvisualizer.api.InteractionVisualizerAPI;
import com.loohp.interactionvisualizer.libs.net.kyori.adventure.text.Component;
import com.loohp.interactionvisualizer.libs.net.kyori.adventure.text.TextComponent;
import com.loohp.interactionvisualizer.libs.net.kyori.adventure.text.event.ClickEvent;
import com.loohp.interactionvisualizer.libs.net.kyori.adventure.text.event.HoverEvent;
import com.loohp.interactionvisualizer.libs.net.kyori.adventure.text.format.NamedTextColor;
import com.loohp.interactionvisualizer.libs.net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import com.loohp.interactionvisualizer.managers.MaterialManager;
import com.loohp.interactionvisualizer.managers.MusicManager;
import com.loohp.interactionvisualizer.managers.PacketManager;
import com.loohp.interactionvisualizer.objectholders.EntryKey;
import com.loohp.interactionvisualizer.updater.Updater;
import com.loohp.interactionvisualizer.utils.ChatColorUtils;
import java.util.LinkedList;
import java.util.List;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class Commands
implements CommandExecutor,
TabCompleter {
    private static final InteractionVisualizer plugin = InteractionVisualizer.plugin;

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (!label.equalsIgnoreCase("interactionvisualizer") && !label.equalsIgnoreCase("iv")) {
            return true;
        }
        if (args.length == 0) {
            sender.sendMessage(ChatColor.AQUA + "[InteractionVisualizer] InteractionVisualizer written by LOOHP!");
            sender.sendMessage(ChatColor.GOLD + "[InteractionVisualizer] Running InteractionVisualizer version: " + plugin.getDescription().getVersion());
            return true;
        }
        if (args[0].equalsIgnoreCase("reload")) {
            if (sender.hasPermission("interactionvisualizer.reload")) {
                plugin.loadConfig();
                MusicManager.reloadConfig();
                MaterialManager.reloadConfig();
                sender.sendMessage(ChatColorUtils.translateAlternateColorCodes('&', plugin.getConfiguration().getString("Messages.Reload")));
            } else {
                sender.sendMessage(ChatColorUtils.translateAlternateColorCodes('&', plugin.getConfiguration().getString("Messages.NoPermission")));
            }
            return true;
        }
        if (args[0].equalsIgnoreCase("refresh")) {
            if (sender instanceof Player) {
                Player player = (Player)sender;
                if (player.hasPermission("interactionvisualizer.refresh")) {
                    Bukkit.getScheduler().runTask((Plugin)InteractionVisualizer.plugin, () -> PacketManager.reset(player));
                } else {
                    sender.sendMessage(ChatColorUtils.translateAlternateColorCodes('&', plugin.getConfiguration().getString("Messages.NoPermission")));
                }
            } else {
                sender.sendMessage(ChatColorUtils.translateAlternateColorCodes('&', plugin.getConfiguration().getString("Messages.Toggle.Console")));
            }
            return true;
        }
        if (args[0].equalsIgnoreCase("update")) {
            if (sender.hasPermission("interactionvisualizer.update")) {
                sender.sendMessage(ChatColor.AQUA + "[InteractionVisualizer] InteractionVisualizer written by LOOHP!");
                sender.sendMessage(ChatColor.GOLD + "[InteractionVisualizer] You are running InteractionVisualizer version: " + plugin.getDescription().getVersion());
                InteractionVisualizer.asyncExecutorManager.runTaskAsynchronously(() -> {
                    Updater.UpdaterResponse version = Updater.checkUpdate();
                    if (version.getResult().equals("latest")) {
                        if (version.isDevBuildLatest()) {
                            sender.sendMessage(ChatColor.GREEN + "[InteractionVisualizer] You are running the latest version!");
                        } else {
                            Updater.sendUpdateMessage(sender, version.getResult(), version.getSpigotPluginId(), true);
                        }
                    } else {
                        Updater.sendUpdateMessage(sender, version.getResult(), version.getSpigotPluginId());
                    }
                });
            } else {
                sender.sendMessage(ChatColorUtils.translateAlternateColorCodes('&', plugin.getConfiguration().getString("Messages.NoPermission")));
            }
            return true;
        }
        if (args[0].equalsIgnoreCase("toggle")) {
            if (sender.hasPermission("interactionvisualizer.toggle")) {
                if (args.length == 4 && (args[3].equalsIgnoreCase("true") || args[3].equalsIgnoreCase("false")) || args.length == 3) {
                    if (!(sender instanceof Player)) {
                        sender.sendMessage(ChatColorUtils.translateAlternateColorCodes('&', plugin.getConfiguration().getString("Messages.Toggle.Console")));
                        return true;
                    }
                    Player player = (Player)sender;
                    InteractionVisualizer.asyncExecutorManager.runTaskAsynchronously(() -> {
                        block29: {
                            EntryKey[] entries;
                            String verboseEntry;
                            block28: {
                                verboseEntry = null;
                                if (args[2].equalsIgnoreCase("all")) {
                                    entries = InteractionVisualizer.preferenceManager.getRegisteredEntries().toArray(new EntryKey[0]);
                                    verboseEntry = ChatColorUtils.translateAlternateColorCodes('&', plugin.getConfiguration().getString("Messages.Toggle.All"));
                                } else {
                                    entries = new EntryKey[]{new EntryKey(args[2])};
                                }
                                if (args.length != 4) break block28;
                                boolean value = args[3].equalsIgnoreCase("true");
                                switch (args[1].toLowerCase()) {
                                    case "itemstand": {
                                        Toggle.toggle(sender, player, InteractionVisualizerAPI.Modules.ITEMSTAND, value, true, verboseEntry, entries);
                                        break;
                                    }
                                    case "itemdrop": {
                                        Toggle.toggle(sender, player, InteractionVisualizerAPI.Modules.ITEMDROP, value, true, verboseEntry, entries);
                                        break;
                                    }
                                    case "hologram": {
                                        Toggle.toggle(sender, player, InteractionVisualizerAPI.Modules.HOLOGRAM, value, true, verboseEntry, entries);
                                        break;
                                    }
                                    case "all": {
                                        for (InteractionVisualizerAPI.Modules modules : InteractionVisualizerAPI.Modules.values()) {
                                            Toggle.toggle(sender, player, modules, value, true, verboseEntry, entries);
                                        }
                                        break block29;
                                    }
                                    default: {
                                        sender.sendMessage(ChatColorUtils.translateAlternateColorCodes('&', plugin.getConfiguration().getString("Messages.Toggle.Modes")));
                                    }
                                }
                                break block29;
                            }
                            switch (args[1].toLowerCase()) {
                                case "itemstand": {
                                    Toggle.toggle(sender, player, InteractionVisualizerAPI.Modules.ITEMSTAND, true, verboseEntry, entries);
                                    break;
                                }
                                case "itemdrop": {
                                    Toggle.toggle(sender, player, InteractionVisualizerAPI.Modules.ITEMDROP, true, verboseEntry, entries);
                                    break;
                                }
                                case "hologram": {
                                    Toggle.toggle(sender, player, InteractionVisualizerAPI.Modules.HOLOGRAM, true, verboseEntry, entries);
                                    break;
                                }
                                case "all": {
                                    for (InteractionVisualizerAPI.Modules modules : InteractionVisualizerAPI.Modules.values()) {
                                        Toggle.toggle(sender, player, modules, true, verboseEntry, entries);
                                    }
                                    break;
                                }
                                default: {
                                    sender.sendMessage(ChatColorUtils.translateAlternateColorCodes('&', plugin.getConfiguration().getString("Messages.Toggle.Modes")));
                                }
                            }
                        }
                    });
                    return true;
                }
                if (args.length == 5 || args.length == 4) {
                    Player player = Bukkit.getPlayer((String)args[args.length == 4 ? 3 : 4]);
                    if (sender instanceof Player && player != null && !player.equals(sender) && !sender.hasPermission("interactionvisualizer.toggle.others")) {
                        sender.sendMessage(ChatColorUtils.translateAlternateColorCodes('&', plugin.getConfiguration().getString("Messages.NoPermission")));
                        return true;
                    }
                    if (player == null) {
                        sender.sendMessage(ChatColorUtils.translateAlternateColorCodes('&', plugin.getConfiguration().getString("Messages.Toggle.PlayerNotFound")));
                        return true;
                    }
                    InteractionVisualizer.asyncExecutorManager.runTaskAsynchronously(() -> {
                        block29: {
                            EntryKey[] entries;
                            String verboseEntry;
                            block28: {
                                verboseEntry = null;
                                if (args[2].equalsIgnoreCase("all")) {
                                    entries = InteractionVisualizer.preferenceManager.getRegisteredEntries().toArray(new EntryKey[0]);
                                    verboseEntry = ChatColorUtils.translateAlternateColorCodes('&', plugin.getConfiguration().getString("Messages.Toggle.All"));
                                } else {
                                    entries = new EntryKey[]{new EntryKey(args[2])};
                                }
                                if (args.length != 5) break block28;
                                boolean value = args[3].equalsIgnoreCase("true");
                                switch (args[1].toLowerCase()) {
                                    case "itemstand": {
                                        Toggle.toggle(sender, player, InteractionVisualizerAPI.Modules.ITEMSTAND, value, true, verboseEntry, entries);
                                        break;
                                    }
                                    case "itemdrop": {
                                        Toggle.toggle(sender, player, InteractionVisualizerAPI.Modules.ITEMDROP, value, true, verboseEntry, entries);
                                        break;
                                    }
                                    case "hologram": {
                                        Toggle.toggle(sender, player, InteractionVisualizerAPI.Modules.HOLOGRAM, value, true, verboseEntry, entries);
                                        break;
                                    }
                                    case "all": {
                                        for (InteractionVisualizerAPI.Modules modules : InteractionVisualizerAPI.Modules.values()) {
                                            Toggle.toggle(sender, player, modules, value, true, verboseEntry, entries);
                                        }
                                        break block29;
                                    }
                                    default: {
                                        sender.sendMessage(ChatColorUtils.translateAlternateColorCodes('&', plugin.getConfiguration().getString("Messages.Toggle.Modes")));
                                    }
                                }
                                break block29;
                            }
                            switch (args[1].toLowerCase()) {
                                case "itemstand": {
                                    Toggle.toggle(sender, player, InteractionVisualizerAPI.Modules.ITEMSTAND, true, verboseEntry, entries);
                                    break;
                                }
                                case "itemdrop": {
                                    Toggle.toggle(sender, player, InteractionVisualizerAPI.Modules.ITEMDROP, true, verboseEntry, entries);
                                    break;
                                }
                                case "hologram": {
                                    Toggle.toggle(sender, player, InteractionVisualizerAPI.Modules.HOLOGRAM, true, verboseEntry, entries);
                                    break;
                                }
                                case "all": {
                                    for (InteractionVisualizerAPI.Modules modules : InteractionVisualizerAPI.Modules.values()) {
                                        Toggle.toggle(sender, player, modules, true, verboseEntry, entries);
                                    }
                                    break;
                                }
                                default: {
                                    sender.sendMessage(ChatColorUtils.translateAlternateColorCodes('&', plugin.getConfiguration().getString("Messages.Toggle.Modes")));
                                }
                            }
                        }
                    });
                    return true;
                }
                sender.sendMessage(ChatColorUtils.translateAlternateColorCodes('&', plugin.getConfiguration().getString("Messages.Toggle.Usage")));
                return true;
            }
            sender.sendMessage(ChatColorUtils.translateAlternateColorCodes('&', plugin.getConfiguration().getString("Messages.NoPermission")));
            return true;
        }
        if (args[0].equalsIgnoreCase("ethereal")) {
            Component text = Component.text("She is Imaginary~~");
            text = text.color(NamedTextColor.YELLOW);
            TextComponent bone = LegacyComponentSerializer.legacySection().deserialize("\u00a7eNana's Bone\n\u00a77Lost \u00a76In-\u00a7dMaginary~~");
            text = text.hoverEvent(HoverEvent.showText(bone)).clickEvent(ClickEvent.openUrl("https://www.instagram.com/narliar/"));
            InteractionVisualizer.sendMessage(sender, text);
            return true;
        }
        sender.sendMessage(ChatColorUtils.translateAlternateColorCodes('&', Bukkit.spigot().getConfig().getString("messages.unknown-command")));
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command cmd, String label, String[] args) {
        LinkedList<String> tab = new LinkedList<String>();
        if (!label.equalsIgnoreCase("interactionvisualizer") && !label.equalsIgnoreCase("iv")) {
            return tab;
        }
        switch (args.length) {
            case 0: {
                if (sender.hasPermission("interactionvisualizer.reload")) {
                    tab.add("reload");
                }
                if (sender.hasPermission("interactionvisualizer.update")) {
                    tab.add("update");
                }
                if (sender.hasPermission("interactionvisualizer.toggle")) {
                    tab.add("toggle");
                }
                if (sender.hasPermission("interactionvisualizer.refresh")) {
                    tab.add("refresh");
                }
                return tab;
            }
            case 1: {
                if (sender.hasPermission("interactionvisualizer.reload") && "reload".startsWith(args[0].toLowerCase())) {
                    tab.add("reload");
                }
                if (sender.hasPermission("interactionvisualizer.update") && "update".startsWith(args[0].toLowerCase())) {
                    tab.add("update");
                }
                if (sender.hasPermission("interactionvisualizer.toggle") && "toggle".startsWith(args[0].toLowerCase())) {
                    tab.add("toggle");
                }
                if (sender.hasPermission("interactionvisualizer.refresh") && "refresh".startsWith(args[0].toLowerCase())) {
                    tab.add("refresh");
                }
                return tab;
            }
            case 2: {
                if (args[0].equalsIgnoreCase("toggle") && sender.hasPermission("interactionvisualizer.toggle")) {
                    if ("itemstand".startsWith(args[1].toLowerCase())) {
                        tab.add("itemstand");
                    }
                    if ("itemdrop".startsWith(args[1].toLowerCase())) {
                        tab.add("itemdrop");
                    }
                    if ("hologram".startsWith(args[1].toLowerCase())) {
                        tab.add("hologram");
                    }
                    if ("all".startsWith(args[1].toLowerCase())) {
                        tab.add("all");
                    }
                }
                return tab;
            }
            case 3: {
                if (args[0].equalsIgnoreCase("toggle") && sender.hasPermission("interactionvisualizer.toggle") && (args[1].equalsIgnoreCase("itemstand") || args[1].equalsIgnoreCase("itemdrop") || args[1].equalsIgnoreCase("hologram") || args[1].equalsIgnoreCase("all"))) {
                    for (EntryKey each : InteractionVisualizer.preferenceManager.getRegisteredEntries()) {
                        if (!each.toSimpleString().toLowerCase().startsWith(args[2].toLowerCase())) continue;
                        tab.add(each.toSimpleString());
                    }
                    if ("all".startsWith(args[2].toLowerCase())) {
                        tab.add("all");
                    }
                }
                return tab;
            }
            case 4: {
                if (args[0].equalsIgnoreCase("toggle") && sender.hasPermission("interactionvisualizer.toggle") && (args[1].equalsIgnoreCase("itemstand") || args[1].equalsIgnoreCase("itemdrop") || args[1].equalsIgnoreCase("hologram") || args[1].equalsIgnoreCase("all"))) {
                    if (Boolean.TRUE.toString().toLowerCase().startsWith(args[3].toLowerCase())) {
                        tab.add(Boolean.TRUE.toString());
                    }
                    if (Boolean.FALSE.toString().toLowerCase().startsWith(args[3].toLowerCase())) {
                        tab.add(Boolean.FALSE.toString());
                    }
                }
                return tab;
            }
            case 5: {
                if (args[0].equalsIgnoreCase("toggle") && sender.hasPermission("interactionvisualizer.toggle") && (args[1].equalsIgnoreCase("itemstand") || args[1].equalsIgnoreCase("itemdrop") || args[1].equalsIgnoreCase("hologram")) && sender.hasPermission("interactionvisualizer.toggle.others")) {
                    for (Player each : Bukkit.getOnlinePlayers()) {
                        if (!each.getName().toLowerCase().startsWith(args[4].toLowerCase())) continue;
                        tab.add(each.getName());
                    }
                }
                return tab;
            }
        }
        return tab;
    }
}

