/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.interactionvisualizer.utils;

import com.loohp.interactionvisualizer.InteractionVisualizer;
import com.loohp.interactionvisualizer.utils.MCVersion;
import com.loohp.interactionvisualizer.utils.NMSUtils;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.potion.PotionEffectType;

public class TranslationUtils {
    private static Method bukkitEnchantmentGetIdMethod;
    private static Class<?> nmsEnchantmentClass;
    private static Method getEnchantmentByIdMethod;
    private static Method getEnchantmentKeyMethod;
    private static Class<?> nmsMobEffectListClass;
    private static Field nmsMobEffectByIdField;
    private static Method getEffectFromIdMethod;
    private static Method getEffectKeyMethod;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getEffect(PotionEffectType type) {
        if (!InteractionVisualizer.version.isLegacy()) {
            try {
                int id = type.getId();
                Object nmsMobEffectListObject = getEffectFromIdMethod.invoke(null, id);
                if (nmsMobEffectListObject == null) return "";
                return getEffectKeyMethod.invoke(nmsMobEffectListObject, new Object[0]).toString();
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                e.printStackTrace();
                return "";
            }
        }
        try {
            Object nmsMobEffectListObject;
            int id = type.getId();
            if (InteractionVisualizer.version.isOlderOrEqualTo(MCVersion.V1_8_4)) {
                Object nmsMobEffectListArray = nmsMobEffectByIdField.get(null);
                if (Array.getLength(nmsMobEffectListArray) <= id) return "";
                nmsMobEffectListObject = Array.get(nmsMobEffectListArray, id);
            } else {
                nmsMobEffectListObject = getEffectFromIdMethod.invoke(null, id);
            }
            if (nmsMobEffectListObject == null) return "";
            String str = getEffectKeyMethod.invoke(nmsMobEffectListObject, new Object[0]).toString();
            return "effect." + str.substring(str.indexOf(".") + 1);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            e.printStackTrace();
            return "";
        }
    }

    public static String getEnchantment(Enchantment enchantment) {
        if (!InteractionVisualizer.version.isLegacy()) {
            return "enchantment." + enchantment.getKey().getNamespace() + "." + enchantment.getKey().getKey();
        }
        try {
            Object nmsEnchantmentObject = getEnchantmentByIdMethod.invoke(null, bukkitEnchantmentGetIdMethod.invoke((Object)enchantment, new Object[0]));
            if (nmsEnchantmentObject != null) {
                return getEnchantmentKeyMethod.invoke(nmsEnchantmentObject, new Object[0]).toString();
            }
            return "";
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            e.printStackTrace();
            return "";
        }
    }

    public static String getLevel(int level) {
        if (level == 1) {
            return "container.enchant.level.one";
        }
        return "container.enchant.level.many";
    }

    public static String getRecord(String type) {
        if (!type.contains("MUSIC_DISC_")) {
            return null;
        }
        if (!InteractionVisualizer.version.isLegacy()) {
            return "item.minecraft." + type.toLowerCase() + ".desc";
        }
        return "item.record." + type.substring(type.indexOf("MUSIC_DISC_") + 11).toLowerCase() + ".desc";
    }

    static {
        if (InteractionVisualizer.version.isLegacy()) {
            try {
                bukkitEnchantmentGetIdMethod = Enchantment.class.getMethod("getId", new Class[0]);
                nmsEnchantmentClass = NMSUtils.getNMSClass("net.minecraft.server.%s.Enchantment", "net.minecraft.world.item.enchantment.Enchantment");
                getEnchantmentByIdMethod = nmsEnchantmentClass.getMethod("c", Integer.TYPE);
                getEnchantmentKeyMethod = nmsEnchantmentClass.getMethod("a", new Class[0]);
                nmsMobEffectListClass = NMSUtils.getNMSClass("net.minecraft.server.%s.MobEffectList", "net.minecraft.world.effect.MobEffectList");
                if (InteractionVisualizer.version.isOlderOrEqualTo(MCVersion.V1_8_4)) {
                    nmsMobEffectByIdField = nmsMobEffectListClass.getField("byId");
                } else {
                    getEffectFromIdMethod = nmsMobEffectListClass.getMethod("fromId", Integer.TYPE);
                }
                getEffectKeyMethod = nmsMobEffectListClass.getMethod("a", new Class[0]);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            try {
                nmsMobEffectListClass = NMSUtils.getNMSClass("net.minecraft.server.%s.MobEffectList", "net.minecraft.world.effect.MobEffectList");
                getEffectFromIdMethod = NMSUtils.reflectiveLookup(Method.class, () -> nmsMobEffectListClass.getMethod("fromId", Integer.TYPE), () -> nmsMobEffectListClass.getMethod("byId", Integer.TYPE), () -> nmsMobEffectListClass.getMethod("a", Integer.TYPE));
                getEffectKeyMethod = InteractionVisualizer.version.isNewerOrEqualTo(MCVersion.V1_19) ? nmsMobEffectListClass.getMethod("d", new Class[0]) : nmsMobEffectListClass.getMethod("c", new Class[0]);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

