/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.interactionvisualizer.utils;

import com.loohp.interactionvisualizer.InteractionVisualizer;
import com.loohp.interactionvisualizer.utils.NMSUtils;
import java.lang.reflect.Field;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;

public class EntityUtils {
    private static Field entityCountField;

    public static Future<Integer> getNextEntityId() {
        block6: {
            try {
                entityCountField.setAccessible(true);
                Object entityCountObject = entityCountField.get(null);
                if (entityCountObject instanceof AtomicInteger) {
                    return CompletableFuture.completedFuture(((AtomicInteger)entityCountObject).incrementAndGet());
                }
                if (!(entityCountObject instanceof Integer)) break block6;
                if (Bukkit.isPrimaryThread()) {
                    int value = (Integer)entityCountObject;
                    try {
                        entityCountField.set(null, value + 1);
                    }
                    catch (IllegalAccessException | IllegalArgumentException e) {
                        e.printStackTrace();
                    }
                    return CompletableFuture.completedFuture(value);
                }
                return Bukkit.getScheduler().callSyncMethod((Plugin)InteractionVisualizer.plugin, () -> EntityUtils.getNextEntityId().get());
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                e.printStackTrace();
            }
        }
        return CompletableFuture.completedFuture(-1);
    }

    static {
        try {
            Class<?> nmsEntityClass = NMSUtils.getNMSClass("net.minecraft.server.%s.Entity", "net.minecraft.world.entity.Entity");
            try {
                entityCountField = nmsEntityClass.getDeclaredField("entityCount");
            }
            catch (NoSuchFieldException | SecurityException e) {
                entityCountField = Stream.of(nmsEntityClass.getDeclaredFields()).filter(each -> each.getType().equals(AtomicInteger.class)).findFirst().get();
            }
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
    }
}

