/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.interactionvisualizer.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;

public class CustomMapUtils {
    public static <K, V extends Comparable<? super V>> List<Map.Entry<K, V>> entriesSortedByValues(Map<K, V> map) {
        ArrayList<Map.Entry<K, V>> sortedEntries = new ArrayList<Map.Entry<K, V>>(map.entrySet());
        Collections.sort(sortedEntries, new Comparator<Map.Entry<K, V>>(){

            @Override
            public int compare(Map.Entry<K, V> e1, Map.Entry<K, V> e2) {
                return ((Comparable)e2.getValue()).compareTo(e1.getValue());
            }
        });
        return sortedEntries;
    }

    public static <K, V extends Comparable<? super V>> LinkedHashMap<K, V> sortMapByValue(Map<K, V> map) {
        LinkedHashMap linkedmap = new LinkedHashMap();
        CustomMapUtils.entriesSortedByValues(map).stream().forEach(entry -> linkedmap.put(entry.getKey(), (Comparable)entry.getValue()));
        return linkedmap;
    }

    public static <K, V extends Comparable<? super V>> LinkedHashMap<K, V> sortMapByValueReverse(Map<K, V> map) {
        LinkedHashMap linkedmap = new LinkedHashMap();
        ArrayList<Map.Entry<K, V>> list = new ArrayList<Map.Entry<K, V>>(CustomMapUtils.sortMapByValue(map).entrySet());
        ListIterator itr = list.listIterator(list.size());
        while (itr.hasPrevious()) {
            Map.Entry entry = (Map.Entry)itr.previous();
            linkedmap.put(entry.getKey(), (Comparable)entry.getValue());
        }
        return linkedmap;
    }
}

