/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.interactionvisualizer.utils;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.loohp.interactionvisualizer.libs.net.kyori.adventure.text.format.NamedTextColor;
import com.loohp.interactionvisualizer.libs.net.kyori.adventure.text.format.TextColor;
import com.loohp.interactionvisualizer.utils.ChatColorUtils;
import java.awt.Color;
import java.util.stream.Stream;
import net.md_5.bungee.api.ChatColor;

public class ColorUtils {
    private static final BiMap<ChatColor, Color> COLORS = HashBiMap.create();
    private static final boolean CHAT_COLOR_HAS_GET_COLOR;

    public static ChatColor toChatColor(String str) {
        try {
            if (str.length() < 2) {
                return null;
            }
            if (str.charAt(1) == 'x' && str.length() > 13) {
                return ChatColor.of((String)("#" + str.charAt(3) + str.charAt(5) + str.charAt(7) + str.charAt(9) + str.charAt(11) + str.charAt(13)));
            }
            return ChatColor.getByChar((char)str.charAt(1));
        }
        catch (Throwable e) {
            return null;
        }
    }

    public static Color getColor(ChatColor chatcolor) {
        if (CHAT_COLOR_HAS_GET_COLOR) {
            return chatcolor.getColor();
        }
        Color color = (Color)COLORS.get((Object)chatcolor);
        return color == null ? Color.white : color;
    }

    public static ChatColor getLegacyChatColor(Color color) {
        ChatColor chatcolor = (ChatColor)COLORS.inverse().get((Object)color);
        return chatcolor == null ? ChatColor.WHITE : chatcolor;
    }

    public static Color hex2Rgb(String colorStr) {
        return new Color(Integer.valueOf(colorStr.substring(1, 3), 16), Integer.valueOf(colorStr.substring(3, 5), 16), Integer.valueOf(colorStr.substring(5, 7), 16));
    }

    public static String rgb2Hex(Color color) {
        return String.format("#%02x%02x%02x", color.getRed(), color.getGreen(), color.getBlue());
    }

    public static Color getFirstColor(String str) {
        ChatColor chatColor;
        String colorStr = ChatColorUtils.getFirstColors(str);
        if (colorStr.length() > 1 && (chatColor = ColorUtils.toChatColor(colorStr)) != null && ChatColorUtils.isColor(chatColor)) {
            return CHAT_COLOR_HAS_GET_COLOR ? chatColor.getColor() : ColorUtils.getColor(chatColor);
        }
        return null;
    }

    public static NamedTextColor toNamedTextColor(ChatColor color) {
        Color awtColor = ColorUtils.getColor(color);
        return NamedTextColor.nearestTo(TextColor.color(awtColor.getRed(), awtColor.getGreen(), awtColor.getBlue()));
    }

    public static TextColor toTextColor(ChatColor color) {
        Color awtColor = ColorUtils.getColor(color);
        return TextColor.color(awtColor.getRed(), awtColor.getGreen(), awtColor.getBlue());
    }

    public static ChatColor toChatColor(NamedTextColor color) {
        return ColorUtils.getLegacyChatColor(new Color(color.value()));
    }

    static {
        COLORS.put((Object)ChatColor.BLACK, (Object)new Color(0));
        COLORS.put((Object)ChatColor.DARK_BLUE, (Object)new Color(170));
        COLORS.put((Object)ChatColor.DARK_GREEN, (Object)new Color(43520));
        COLORS.put((Object)ChatColor.DARK_AQUA, (Object)new Color(43690));
        COLORS.put((Object)ChatColor.DARK_RED, (Object)new Color(0xAA0000));
        COLORS.put((Object)ChatColor.DARK_PURPLE, (Object)new Color(0xAA00AA));
        COLORS.put((Object)ChatColor.GOLD, (Object)new Color(0xFFAA00));
        COLORS.put((Object)ChatColor.GRAY, (Object)new Color(0xAAAAAA));
        COLORS.put((Object)ChatColor.DARK_GRAY, (Object)new Color(0x555555));
        COLORS.put((Object)ChatColor.BLUE, (Object)new Color(0x5555FF));
        COLORS.put((Object)ChatColor.GREEN, (Object)new Color(0x55FF55));
        COLORS.put((Object)ChatColor.AQUA, (Object)new Color(0x55FFFF));
        COLORS.put((Object)ChatColor.RED, (Object)new Color(0xFF5555));
        COLORS.put((Object)ChatColor.LIGHT_PURPLE, (Object)new Color(0xFF55FF));
        COLORS.put((Object)ChatColor.YELLOW, (Object)new Color(0xFFFF55));
        COLORS.put((Object)ChatColor.WHITE, (Object)new Color(0xFFFFFF));
        CHAT_COLOR_HAS_GET_COLOR = Stream.of(ChatColor.class.getMethods()).anyMatch(each -> each.getName().equalsIgnoreCase("getColor") && each.getReturnType().equals(Color.class));
    }
}

