/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.interactionvisualizer.protocol;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.ProtocolManager;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.wrappers.WrappedDataWatcher;
import com.loohp.interactionvisualizer.InteractionVisualizer;
import com.loohp.interactionvisualizer.entityholders.ArmorStand;
import com.loohp.interactionvisualizer.entityholders.Item;
import com.loohp.interactionvisualizer.entityholders.ItemFrame;
import com.loohp.interactionvisualizer.nms.NMS;
import com.loohp.interactionvisualizer.objectholders.ValuePairs;
import com.loohp.interactionvisualizer.utils.MCVersion;
import java.util.ArrayList;
import java.util.Collection;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class ServerPacketSender {
    private static final Plugin plugin = InteractionVisualizer.plugin;
    private static final MCVersion version = InteractionVisualizer.version;
    private static final ProtocolManager protocolManager = InteractionVisualizer.protocolManager;
    private static final NMS nms = NMS.getInstance();

    public static void sendHandMovement(Collection<Player> players, Player entity) {
        if (!InteractionVisualizer.handMovementEnabled.booleanValue()) {
            return;
        }
        PacketContainer packet1 = protocolManager.createPacket(PacketType.Play.Server.ANIMATION);
        packet1.getIntegers().write(0, (Object)entity.getEntityId());
        packet1.getIntegers().write(1, (Object)0);
        if (!plugin.isEnabled()) {
            return;
        }
        Bukkit.getScheduler().runTask(plugin, () -> protocolManager.sendServerPacket(entity, packet1));
    }

    public static void teleportEntity(Player player, int entityId, Location location) {
        PacketContainer packet1 = protocolManager.createPacket(PacketType.Play.Server.ENTITY_TELEPORT);
        packet1.getIntegers().write(0, (Object)entityId);
        packet1.getDoubles().write(0, (Object)location.getX());
        packet1.getDoubles().write(1, (Object)location.getY());
        packet1.getDoubles().write(2, (Object)location.getZ());
        packet1.getBytes().write(0, (Object)((byte)(location.getYaw() * 256.0f / 360.0f)));
        packet1.getBytes().write(1, (Object)((byte)(location.getPitch() * 256.0f / 360.0f)));
        if (!plugin.isEnabled()) {
            return;
        }
        Bukkit.getScheduler().runTask(plugin, () -> protocolManager.sendServerPacket(player, packet1));
    }

    public static void spawnArmorStand(Collection<Player> players, ArmorStand entity) {
        PacketContainer packet1 = protocolManager.createPacket(version.isNewerOrEqualTo(MCVersion.V1_19) ? PacketType.Play.Server.SPAWN_ENTITY : PacketType.Play.Server.SPAWN_ENTITY_LIVING);
        packet1.getIntegers().write(0, (Object)entity.getEntityId());
        if (packet1.getUUIDs().size() > 0) {
            packet1.getUUIDs().write(0, (Object)entity.getUniqueId());
        }
        int i = 1;
        if (version.isOlderThan(MCVersion.V1_19)) {
            packet1.getIntegers().write(i++, (Object)(version.isLegacy() ? 30 : 1));
        } else {
            packet1.getEntityTypeModifier().write(0, (Object)entity.getType());
        }
        packet1.getIntegers().write(i++, (Object)((int)(entity.getVelocity().getX() * 8000.0)));
        packet1.getIntegers().write(i++, (Object)((int)(entity.getVelocity().getY() * 8000.0)));
        packet1.getIntegers().write(i++, (Object)((int)(entity.getVelocity().getZ() * 8000.0)));
        packet1.getDoubles().write(0, (Object)entity.getLocation().getX());
        packet1.getDoubles().write(1, (Object)entity.getLocation().getY());
        packet1.getDoubles().write(2, (Object)entity.getLocation().getZ());
        packet1.getBytes().write(0, (Object)((byte)(entity.getLocation().getYaw() * 256.0f / 360.0f)));
        packet1.getBytes().write(1, (Object)((byte)(entity.getLocation().getPitch() * 256.0f / 360.0f)));
        packet1.getBytes().write(2, (Object)((byte)(entity.getLocation().getYaw() * 256.0f / 360.0f)));
        if (packet1.getIntegers().size() > i) {
            packet1.getIntegers().write(i, (Object)0);
        }
        PacketContainer packet2 = protocolManager.createPacket(PacketType.Play.Server.ENTITY_METADATA);
        packet2.getIntegers().write(0, (Object)entity.getEntityId());
        WrappedDataWatcher wpw = entity.updateAndGetWrappedDataWatcher();
        packet2.getWatchableCollectionModifier().write(0, (Object)wpw.getWatchableObjects());
        ArrayList<ValuePairs<EquipmentSlot, ItemStack>> equipments = new ArrayList<ValuePairs<EquipmentSlot, ItemStack>>();
        equipments.add(new ValuePairs<EquipmentSlot, ItemStack>(EquipmentSlot.HAND, entity.getItemInMainHand()));
        equipments.add(new ValuePairs<EquipmentSlot, ItemStack>(EquipmentSlot.HEAD, entity.getHelmet()));
        PacketContainer[] packet3 = nms.createEntityEquipmentPacket(entity.getEntityId(), equipments);
        if (!plugin.isEnabled()) {
            return;
        }
        Bukkit.getScheduler().runTask(plugin, () -> {
            for (Player player : players) {
                protocolManager.sendServerPacket(player, packet1);
                protocolManager.sendServerPacket(player, packet2);
                for (PacketContainer packet : packet3) {
                    protocolManager.sendServerPacket(player, packet);
                }
            }
        });
    }

    public static void updateArmorStand(Collection<Player> players, ArmorStand entity) {
        PacketContainer packet1 = protocolManager.createPacket(PacketType.Play.Server.ENTITY_TELEPORT);
        packet1.getIntegers().write(0, (Object)entity.getEntityId());
        packet1.getDoubles().write(0, (Object)entity.getLocation().getX());
        packet1.getDoubles().write(1, (Object)entity.getLocation().getY());
        packet1.getDoubles().write(2, (Object)entity.getLocation().getZ());
        packet1.getBytes().write(0, (Object)((byte)(entity.getLocation().getYaw() * 256.0f / 360.0f)));
        packet1.getBytes().write(1, (Object)((byte)(entity.getLocation().getPitch() * 256.0f / 360.0f)));
        PacketContainer packet2 = protocolManager.createPacket(PacketType.Play.Server.ENTITY_METADATA);
        packet2.getIntegers().write(0, (Object)entity.getEntityId());
        WrappedDataWatcher wpw = entity.updateAndGetWrappedDataWatcher();
        packet2.getWatchableCollectionModifier().write(0, (Object)wpw.getWatchableObjects());
        ArrayList<ValuePairs<EquipmentSlot, ItemStack>> equipments = new ArrayList<ValuePairs<EquipmentSlot, ItemStack>>();
        equipments.add(new ValuePairs<EquipmentSlot, ItemStack>(EquipmentSlot.HAND, entity.getItemInMainHand()));
        equipments.add(new ValuePairs<EquipmentSlot, ItemStack>(EquipmentSlot.HEAD, entity.getHelmet()));
        PacketContainer[] packet3 = nms.createEntityEquipmentPacket(entity.getEntityId(), equipments);
        if (!plugin.isEnabled()) {
            return;
        }
        Bukkit.getScheduler().runTask(plugin, () -> {
            for (Player player : players) {
                protocolManager.sendServerPacket(player, packet1);
                protocolManager.sendServerPacket(player, packet2);
                for (PacketContainer packet : packet3) {
                    protocolManager.sendServerPacket(player, packet);
                }
            }
        });
    }

    public static void updateArmorStandOnlyMeta(Collection<Player> players, ArmorStand entity) {
        PacketContainer packet1 = protocolManager.createPacket(PacketType.Play.Server.ENTITY_METADATA);
        packet1.getIntegers().write(0, (Object)entity.getEntityId());
        WrappedDataWatcher wpw = entity.updateAndGetWrappedDataWatcher();
        packet1.getWatchableCollectionModifier().write(0, (Object)wpw.getWatchableObjects());
        if (!plugin.isEnabled()) {
            return;
        }
        Bukkit.getScheduler().runTask(plugin, () -> {
            for (Player player : players) {
                protocolManager.sendServerPacket(player, packet1);
            }
        });
    }

    public static void removeArmorStand(Collection<Player> players, ArmorStand entity) {
        PacketContainer[] packets = NMS.getInstance().createEntityDestroyPacket(entity.getEntityId());
        if (!plugin.isEnabled()) {
            return;
        }
        Bukkit.getScheduler().runTask(plugin, () -> {
            for (Player player : players) {
                for (PacketContainer packet : packets) {
                    protocolManager.sendServerPacket(player, packet);
                }
            }
        });
    }

    public static void spawnItem(Collection<Player> players, Item entity) {
        if (entity.getItemStack().getType().equals((Object)Material.AIR)) {
            return;
        }
        PacketContainer packet1 = protocolManager.createPacket(PacketType.Play.Server.SPAWN_ENTITY);
        packet1.getIntegers().write(0, (Object)entity.getEntityId());
        if (packet1.getUUIDs().size() > 0) {
            packet1.getUUIDs().write(0, (Object)entity.getUniqueId());
        }
        if (version.isNewerOrEqualTo(MCVersion.V1_19)) {
            int i = 1;
            packet1.getEntityTypeModifier().write(0, (Object)entity.getType());
            packet1.getIntegers().write(i++, (Object)((int)(entity.getVelocity().getX() * 8000.0)));
            packet1.getIntegers().write(i++, (Object)((int)(entity.getVelocity().getY() * 8000.0)));
            packet1.getIntegers().write(i++, (Object)((int)(entity.getVelocity().getZ() * 8000.0)));
            packet1.getDoubles().write(0, (Object)entity.getLocation().getX());
            packet1.getDoubles().write(1, (Object)entity.getLocation().getY());
            packet1.getDoubles().write(2, (Object)entity.getLocation().getZ());
            packet1.getBytes().write(0, (Object)((byte)(entity.getLocation().getYaw() * 256.0f / 360.0f)));
            packet1.getBytes().write(1, (Object)((byte)(entity.getLocation().getPitch() * 256.0f / 360.0f)));
            packet1.getBytes().write(2, (Object)((byte)(entity.getLocation().getYaw() * 256.0f / 360.0f)));
            if (packet1.getIntegers().size() > i) {
                packet1.getIntegers().write(i, (Object)0);
            }
        } else {
            packet1.getIntegers().write(1, (Object)((int)(entity.getVelocity().getX() * 8000.0)));
            packet1.getIntegers().write(2, (Object)((int)(entity.getVelocity().getY() * 8000.0)));
            packet1.getIntegers().write(3, (Object)((int)(entity.getVelocity().getZ() * 8000.0)));
            packet1.getIntegers().write(4, (Object)((int)(entity.getLocation().getPitch() * 256.0f / 360.0f)));
            packet1.getIntegers().write(5, (Object)((int)(entity.getLocation().getYaw() * 256.0f / 360.0f)));
            if (version.isLegacy() || version.equals((Object)MCVersion.V1_13) || version.equals((Object)MCVersion.V1_13_1)) {
                packet1.getIntegers().write(6, (Object)2);
                packet1.getIntegers().write(7, (Object)1);
            } else {
                packet1.getEntityTypeModifier().write(0, (Object)entity.getType());
                packet1.getIntegers().write(6, (Object)1);
            }
            packet1.getUUIDs().write(0, (Object)entity.getUniqueId());
            Location location = entity.getLocation();
            packet1.getDoubles().write(0, (Object)location.getX());
            packet1.getDoubles().write(1, (Object)location.getY());
            packet1.getDoubles().write(2, (Object)location.getZ());
        }
        PacketContainer packet2 = protocolManager.createPacket(PacketType.Play.Server.ENTITY_METADATA);
        packet2.getIntegers().write(0, (Object)entity.getEntityId());
        WrappedDataWatcher wpw = entity.updateAndGetWrappedDataWatcher();
        packet2.getWatchableCollectionModifier().write(0, (Object)wpw.getWatchableObjects());
        PacketContainer packet3 = protocolManager.createPacket(PacketType.Play.Server.ENTITY_VELOCITY);
        packet3.getIntegers().write(0, (Object)entity.getEntityId());
        packet3.getIntegers().write(1, (Object)((int)(entity.getVelocity().getX() * 8000.0)));
        packet3.getIntegers().write(2, (Object)((int)(entity.getVelocity().getY() * 8000.0)));
        packet3.getIntegers().write(3, (Object)((int)(entity.getVelocity().getZ() * 8000.0)));
        if (!plugin.isEnabled()) {
            return;
        }
        Bukkit.getScheduler().runTask(plugin, () -> {
            for (Player player : players) {
                protocolManager.sendServerPacket(player, packet1);
                protocolManager.sendServerPacket(player, packet2);
                protocolManager.sendServerPacket(player, packet3);
            }
        });
    }

    public static void updateItem(Collection<Player> players, Item entity) {
        if (entity.getItemStack().getType().equals((Object)Material.AIR)) {
            return;
        }
        PacketContainer packet1 = protocolManager.createPacket(PacketType.Play.Server.ENTITY_METADATA);
        packet1.getIntegers().write(0, (Object)entity.getEntityId());
        WrappedDataWatcher wpw = entity.updateAndGetWrappedDataWatcher();
        packet1.getWatchableCollectionModifier().write(0, (Object)wpw.getWatchableObjects());
        PacketContainer packet2 = protocolManager.createPacket(PacketType.Play.Server.ENTITY_TELEPORT);
        packet2.getIntegers().write(0, (Object)entity.getEntityId());
        packet2.getDoubles().write(0, (Object)entity.getLocation().getX());
        packet2.getDoubles().write(1, (Object)entity.getLocation().getY());
        packet2.getDoubles().write(2, (Object)entity.getLocation().getZ());
        packet2.getBytes().write(0, (Object)((byte)(entity.getLocation().getYaw() * 256.0f / 360.0f)));
        packet2.getBytes().write(1, (Object)((byte)(entity.getLocation().getPitch() * 256.0f / 360.0f)));
        PacketContainer packet3 = protocolManager.createPacket(PacketType.Play.Server.ENTITY_VELOCITY);
        packet3.getIntegers().write(0, (Object)entity.getEntityId());
        packet3.getIntegers().write(1, (Object)((int)(entity.getVelocity().getX() * 8000.0)));
        packet3.getIntegers().write(2, (Object)((int)(entity.getVelocity().getY() * 8000.0)));
        packet3.getIntegers().write(3, (Object)((int)(entity.getVelocity().getZ() * 8000.0)));
        if (!plugin.isEnabled()) {
            return;
        }
        Bukkit.getScheduler().runTask(plugin, () -> {
            for (Player player : players) {
                protocolManager.sendServerPacket(player, packet1);
                protocolManager.sendServerPacket(player, packet2);
                protocolManager.sendServerPacket(player, packet3);
            }
        });
    }

    public static void updateItemAsync(Collection<Player> players, Item entity) {
        if (entity.getItemStack().getType().equals((Object)Material.AIR)) {
            return;
        }
        PacketContainer packet1 = protocolManager.createPacket(PacketType.Play.Server.ENTITY_METADATA);
        packet1.getIntegers().write(0, (Object)entity.getEntityId());
        WrappedDataWatcher wpw = entity.updateAndGetWrappedDataWatcher();
        packet1.getWatchableCollectionModifier().write(0, (Object)wpw.getWatchableObjects());
        PacketContainer packet2 = protocolManager.createPacket(PacketType.Play.Server.ENTITY_TELEPORT);
        packet2.getIntegers().write(0, (Object)entity.getEntityId());
        packet2.getDoubles().write(0, (Object)entity.getLocation().getX());
        packet2.getDoubles().write(1, (Object)entity.getLocation().getY());
        packet2.getDoubles().write(2, (Object)entity.getLocation().getZ());
        packet2.getBytes().write(0, (Object)((byte)(entity.getLocation().getYaw() * 256.0f / 360.0f)));
        packet2.getBytes().write(1, (Object)((byte)(entity.getLocation().getPitch() * 256.0f / 360.0f)));
        PacketContainer packet3 = protocolManager.createPacket(PacketType.Play.Server.ENTITY_VELOCITY);
        packet3.getIntegers().write(0, (Object)entity.getEntityId());
        packet3.getIntegers().write(1, (Object)((int)(entity.getVelocity().getX() * 8000.0)));
        packet3.getIntegers().write(2, (Object)((int)(entity.getVelocity().getY() * 8000.0)));
        packet3.getIntegers().write(3, (Object)((int)(entity.getVelocity().getZ() * 8000.0)));
        for (Player player : players) {
            protocolManager.sendServerPacket(player, packet1);
            protocolManager.sendServerPacket(player, packet2);
            protocolManager.sendServerPacket(player, packet3);
        }
    }

    public static void removeItem(Collection<Player> players, Item entity) {
        PacketContainer[] packets = NMS.getInstance().createEntityDestroyPacket(entity.getEntityId());
        if (!plugin.isEnabled()) {
            return;
        }
        Bukkit.getScheduler().runTask(plugin, () -> {
            for (Player player : players) {
                for (PacketContainer packet : packets) {
                    protocolManager.sendServerPacket(player, packet);
                }
            }
        });
    }

    public static void spawnItemFrame(Collection<Player> players, ItemFrame entity) {
        PacketContainer packet1 = protocolManager.createPacket(PacketType.Play.Server.SPAWN_ENTITY);
        packet1.getIntegers().write(0, (Object)entity.getEntityId());
        if (packet1.getUUIDs().size() > 0) {
            packet1.getUUIDs().write(0, (Object)entity.getUniqueId());
        }
        if (version.isNewerOrEqualTo(MCVersion.V1_19)) {
            int i = 1;
            packet1.getEntityTypeModifier().write(0, (Object)entity.getType());
            packet1.getIntegers().write(i++, (Object)0);
            packet1.getIntegers().write(i++, (Object)0);
            packet1.getIntegers().write(i++, (Object)0);
            packet1.getDoubles().write(0, (Object)entity.getLocation().getX());
            packet1.getDoubles().write(1, (Object)entity.getLocation().getY());
            packet1.getDoubles().write(2, (Object)entity.getLocation().getZ());
            packet1.getBytes().write(0, (Object)((byte)(entity.getLocation().getYaw() * 256.0f / 360.0f)));
            packet1.getBytes().write(1, (Object)((byte)(entity.getLocation().getPitch() * 256.0f / 360.0f)));
            packet1.getBytes().write(2, (Object)((byte)(entity.getLocation().getYaw() * 256.0f / 360.0f)));
            if (packet1.getIntegers().size() > i) {
                packet1.getIntegers().write(i, (Object)ServerPacketSender.getItemFrameData(entity));
            }
        } else {
            packet1.getIntegers().write(1, (Object)0);
            packet1.getIntegers().write(2, (Object)0);
            packet1.getIntegers().write(3, (Object)0);
            packet1.getIntegers().write(4, (Object)((int)(entity.getPitch() * 256.0f / 360.0f)));
            packet1.getIntegers().write(5, (Object)((int)(entity.getYaw() * 256.0f / 360.0f)));
            if (version.isLegacy() || version.equals((Object)MCVersion.V1_13) || version.equals((Object)MCVersion.V1_13_1)) {
                packet1.getIntegers().write(6, (Object)33);
                packet1.getIntegers().write(7, (Object)ServerPacketSender.getItemFrameData(entity));
            } else {
                packet1.getEntityTypeModifier().write(0, (Object)entity.getType());
                packet1.getIntegers().write(6, (Object)ServerPacketSender.getItemFrameData(entity));
            }
            packet1.getUUIDs().write(0, (Object)entity.getUniqueId());
            Location location = entity.getLocation();
            packet1.getDoubles().write(0, (Object)location.getX());
            packet1.getDoubles().write(1, (Object)location.getY());
            packet1.getDoubles().write(2, (Object)location.getZ());
        }
        PacketContainer packet2 = protocolManager.createPacket(PacketType.Play.Server.ENTITY_METADATA);
        packet2.getIntegers().write(0, (Object)entity.getEntityId());
        WrappedDataWatcher wpw = entity.updateAndGetWrappedDataWatcher();
        packet2.getWatchableCollectionModifier().write(0, (Object)wpw.getWatchableObjects());
        if (!plugin.isEnabled()) {
            return;
        }
        Bukkit.getScheduler().runTask(plugin, () -> {
            for (Player player : players) {
                protocolManager.sendServerPacket(player, packet1);
                protocolManager.sendServerPacket(player, packet2);
            }
        });
    }

    public static int getItemFrameData(ItemFrame frame) {
        switch (frame.getAttachedFace()) {
            case DOWN: {
                return 0;
            }
            case UP: {
                return 1;
            }
            case NORTH: {
                return 2;
            }
            case SOUTH: {
                return 3;
            }
            case WEST: {
                return 4;
            }
            case EAST: {
                return 5;
            }
        }
        return 0;
    }

    public static void updateItemFrame(Collection<Player> players, ItemFrame entity) {
        PacketContainer packet1 = protocolManager.createPacket(PacketType.Play.Server.ENTITY_METADATA);
        packet1.getIntegers().write(0, (Object)entity.getEntityId());
        WrappedDataWatcher wpw = entity.updateAndGetWrappedDataWatcher();
        packet1.getWatchableCollectionModifier().write(0, (Object)wpw.getWatchableObjects());
        if (!plugin.isEnabled()) {
            return;
        }
        Bukkit.getScheduler().runTask(plugin, () -> {
            for (Player player : players) {
                protocolManager.sendServerPacket(player, packet1);
            }
        });
    }

    public static void removeItemFrame(Collection<Player> players, ItemFrame entity) {
        PacketContainer[] packets = NMS.getInstance().createEntityDestroyPacket(entity.getEntityId());
        if (!plugin.isEnabled()) {
            return;
        }
        Bukkit.getScheduler().runTask(plugin, () -> {
            for (Player player : players) {
                for (PacketContainer packet : packets) {
                    protocolManager.sendServerPacket(player, packet);
                }
            }
        });
    }
}

