/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.interactionvisualizer.objectholders;

import java.util.ArrayList;
import java.util.List;
import org.bukkit.World;

public class ChunkSectionPosition {
    private final boolean[] flags;

    public static ChunkSectionPosition of(World world, int ... sections) {
        return new ChunkSectionPosition(world.getMaxHeight() >> 4, sections);
    }

    public static ChunkSectionPosition of(World world, boolean extra, int ... sections) {
        if (extra) {
            return new ChunkSectionPosition((world.getMaxHeight() >> 4) + 2, sections);
        }
        return ChunkSectionPosition.of(world, sections);
    }

    public static ChunkSectionPosition of(int size, int ... sections) {
        return new ChunkSectionPosition(size, sections);
    }

    public static byte[] changeLight(byte[] levels, int x, int y, int z, int newValue) {
        if (levels.length != 2048) {
            throw new IllegalArgumentException("Light Level array length not equal to 2048.");
        }
        byte value = levels[(y %= 16) * 128 + (z %= 16) * 8 + (x %= 16) / 2];
        if (x % 2 == 0) {
            value = (byte)(value & 0xFFFFFFF0);
            value = (byte)(value | (byte)newValue);
        } else {
            value = (byte)(value & 0xF);
            value = (byte)(value | (byte)newValue << 4);
        }
        levels[y * 128 + z * 8 + x / 2] = value;
        return levels;
    }

    private ChunkSectionPosition(int size, int ... sections) {
        this.flags = new boolean[size];
        for (int i : sections) {
            this.flags[i] = true;
        }
    }

    public void set(int position, boolean value) {
        this.flags[position] = value;
    }

    public int getSize() {
        return this.flags.length;
    }

    public boolean get(int position) {
        return this.flags[position];
    }

    public List<Integer> getSetPositions() {
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (int i = 0; i < this.flags.length; ++i) {
            if (!this.flags[i]) continue;
            list.add(i);
        }
        return list;
    }

    public int getBitmask() {
        int bitmask = 0;
        for (int i = 0; i < this.flags.length; ++i) {
            if (!this.flags[i]) continue;
            bitmask |= 1 << i;
        }
        return bitmask;
    }
}

