/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.interactionvisualizer.nms;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.events.PacketContainer;
import com.loohp.interactionvisualizer.InteractionVisualizer;
import com.loohp.interactionvisualizer.nms.NMS;
import com.loohp.interactionvisualizer.objectholders.BoundingBox;
import com.loohp.interactionvisualizer.objectholders.ChunkPosition;
import com.loohp.interactionvisualizer.objectholders.NMSTileEntitySet;
import com.loohp.interactionvisualizer.objectholders.TileEntity;
import com.loohp.interactionvisualizer.objectholders.ValuePairs;
import com.loohp.interactionvisualizer.objectholders.WrappedIterable;
import com.mojang.datafixers.util.Pair;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.game.PacketPlayOutEntityDestroy;
import net.minecraft.network.protocol.game.PacketPlayOutEntityEquipment;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.entity.PersistentEntitySectionManager;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.bukkit.Material;
import org.bukkit.craftbukkit.v1_18_R1.CraftChunk;
import org.bukkit.craftbukkit.v1_18_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_18_R1.entity.CraftItem;
import org.bukkit.craftbukkit.v1_18_R1.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_18_R1.util.CraftMagicNumbers;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;

public class V1_18
extends NMS {
    private static Method voxelShapeGetAABBList;
    private static boolean entityDestroyIsInt;
    private static Method nmsTileEntityGetNBTTag;
    private static Field worldServerPersistentEntitySectionManager;
    private static Method nmsEntityGetBukkitEntity;

    @Override
    public List<BoundingBox> getBoundingBoxes(com.loohp.interactionvisualizer.objectholders.BlockPosition pos) {
        BlockPosition blockpos = new BlockPosition(pos.getX(), pos.getY(), pos.getZ());
        WorldServer world = ((CraftWorld)pos.getWorld()).getHandle();
        VoxelShape shape = world.a_(blockpos).j((IBlockAccess)world, blockpos);
        try {
            return ((List)voxelShapeGetAABBList.invoke((Object)shape, new Object[0])).stream().map(each -> new BoundingBox(each.a + (double)pos.getX(), each.b + (double)pos.getY(), each.c + (double)pos.getZ(), each.d + (double)pos.getX(), each.e + (double)pos.getY(), each.f + (double)pos.getZ())).collect(Collectors.toList());
        }
        catch (Exception e) {
            ArrayList<BoundingBox> boxes = new ArrayList<BoundingBox>();
            boxes.add(BoundingBox.of(pos.getBlock()));
            return boxes;
        }
    }

    @Override
    public NMSTileEntitySet<?, ?> getTileEntities(ChunkPosition chunk, boolean load) {
        if (!chunk.isLoaded() && !load) {
            return null;
        }
        org.bukkit.World world = chunk.getWorld();
        return new NMSTileEntitySet(((CraftChunk)chunk.getChunk()).getHandle().E(), entry -> {
            BlockPosition pos = (BlockPosition)entry.getKey();
            Material type = CraftMagicNumbers.getMaterial((Block)((TileEntity)entry.getValue()).q().b());
            TileEntity.TileEntityType tileEntityType = com.loohp.interactionvisualizer.objectholders.TileEntity.getTileEntityType(type);
            if (tileEntityType != null) {
                return new com.loohp.interactionvisualizer.objectholders.TileEntity(world, pos.u(), pos.v(), pos.w(), tileEntityType);
            }
            return null;
        });
    }

    @Override
    public PacketContainer[] createEntityEquipmentPacket(int entityId, List<ValuePairs<EquipmentSlot, ItemStack>> equipments) {
        ArrayList<Pair> nmsList = new ArrayList<Pair>();
        for (ValuePairs<EquipmentSlot, ItemStack> pair : equipments) {
            EnumItemSlot nmsSlot;
            switch (pair.getFirst()) {
                case CHEST: {
                    nmsSlot = EnumItemSlot.e;
                    break;
                }
                case FEET: {
                    nmsSlot = EnumItemSlot.c;
                    break;
                }
                case HEAD: {
                    nmsSlot = EnumItemSlot.f;
                    break;
                }
                case LEGS: {
                    nmsSlot = EnumItemSlot.d;
                    break;
                }
                case OFF_HAND: {
                    nmsSlot = EnumItemSlot.b;
                    break;
                }
                default: {
                    nmsSlot = EnumItemSlot.a;
                }
            }
            net.minecraft.world.item.ItemStack nmsItem = CraftItemStack.asNMSCopy((ItemStack)pair.getSecond());
            nmsList.add(new Pair((Object)nmsSlot, (Object)nmsItem));
        }
        PacketPlayOutEntityEquipment packet = new PacketPlayOutEntityEquipment(entityId, nmsList);
        return new PacketContainer[]{PacketContainer.fromPacket((Object)packet)};
    }

    @Override
    public PacketContainer[] createEntityDestroyPacket(int ... entityIds) {
        if (entityDestroyIsInt) {
            PacketContainer[] packets = new PacketContainer[entityIds.length];
            for (int i = 0; i < entityIds.length; ++i) {
                PacketContainer packet = InteractionVisualizer.protocolManager.createPacket(PacketType.Play.Server.ENTITY_DESTROY);
                packet.getIntegers().write(0, (Object)entityIds[i]);
                packets[i] = packet;
            }
            return packets;
        }
        return new PacketContainer[]{PacketContainer.fromPacket((Object)new PacketPlayOutEntityDestroy(entityIds))};
    }

    @Override
    public int getItemDespawnRate(Item item) {
        int despawnRate;
        try {
            Object spigotWorldConfig = World.class.getField("spigotConfig").get(((CraftWorld)item.getWorld()).getHandle());
            despawnRate = spigotWorldConfig.getClass().getField("itemDespawnRate").getInt(spigotWorldConfig);
            try {
                despawnRate = (Integer)EntityItem.class.getMethod("getDespawnRate", new Class[0]).invoke((Object)((CraftItem)item).getHandle(), new Object[0]);
            }
            catch (Throwable throwable) {}
        }
        catch (Throwable e) {
            despawnRate = 6000;
        }
        return despawnRate;
    }

    @Override
    public String getBannerCustomName(org.bukkit.block.Block block) {
        try {
            return ((NBTTagCompound)nmsTileEntityGetNBTTag.invoke((Object)((CraftWorld)block.getWorld()).getHandle().c_(new BlockPosition(block.getX(), block.getY(), block.getZ())), new Object[0])).l("CustomName");
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            e.printStackTrace();
            return "";
        }
    }

    @Override
    public WrappedIterable<?, Entity> getEntities(org.bukkit.World world) {
        try {
            PersistentEntitySectionManager manager = (PersistentEntitySectionManager)worldServerPersistentEntitySectionManager.get(((CraftWorld)world).getHandle());
            return new WrappedIterable<net.minecraft.world.entity.Entity, Entity>(manager.d().a(), entry -> {
                try {
                    return (Entity)nmsEntityGetBukkitEntity.invoke(entry, new Object[0]);
                }
                catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                    e.printStackTrace();
                    return null;
                }
            });
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            return new WrappedIterable<Object, Entity>(Collections.emptyList(), entry -> null);
        }
    }

    static {
        try {
            try {
                voxelShapeGetAABBList = VoxelShape.class.getMethod("d", new Class[0]);
            }
            catch (NoSuchMethodException | SecurityException e) {
                voxelShapeGetAABBList = VoxelShape.class.getMethod("toList", new Class[0]);
            }
            try {
                PacketPlayOutEntityDestroy.class.getConstructor(Integer.TYPE);
                entityDestroyIsInt = true;
            }
            catch (NoSuchMethodException e) {
                entityDestroyIsInt = false;
            }
            nmsTileEntityGetNBTTag = TileEntity.class.getMethod("Z_", new Class[0]);
            worldServerPersistentEntitySectionManager = WorldServer.class.getField("P");
            nmsEntityGetBukkitEntity = net.minecraft.world.entity.Entity.class.getMethod("getBukkitEntity", new Class[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

