/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.interactionvisualizer.nms;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.events.PacketContainer;
import com.loohp.interactionvisualizer.InteractionVisualizer;
import com.loohp.interactionvisualizer.nms.V1_11;
import com.loohp.interactionvisualizer.nms.V1_12;
import com.loohp.interactionvisualizer.nms.V1_13;
import com.loohp.interactionvisualizer.nms.V1_13_1;
import com.loohp.interactionvisualizer.nms.V1_14;
import com.loohp.interactionvisualizer.nms.V1_15;
import com.loohp.interactionvisualizer.nms.V1_16;
import com.loohp.interactionvisualizer.nms.V1_16_2;
import com.loohp.interactionvisualizer.nms.V1_16_4;
import com.loohp.interactionvisualizer.nms.V1_17;
import com.loohp.interactionvisualizer.nms.V1_18;
import com.loohp.interactionvisualizer.nms.V1_18_2;
import com.loohp.interactionvisualizer.nms.V1_19;
import com.loohp.interactionvisualizer.objectholders.BlockPosition;
import com.loohp.interactionvisualizer.objectholders.BoundingBox;
import com.loohp.interactionvisualizer.objectholders.ChunkPosition;
import com.loohp.interactionvisualizer.objectholders.NMSTileEntitySet;
import com.loohp.interactionvisualizer.objectholders.ValuePairs;
import com.loohp.interactionvisualizer.objectholders.WrappedIterable;
import java.util.List;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;

public abstract class NMS {
    private static NMS instance = null;

    public static NMS getInstance() {
        if (instance == null) {
            switch (InteractionVisualizer.version) {
                case V1_19: {
                    instance = new V1_19();
                    break;
                }
                case V1_18_2: {
                    instance = new V1_18_2();
                    break;
                }
                case V1_18: {
                    instance = new V1_18();
                    break;
                }
                case V1_17: {
                    instance = new V1_17();
                    break;
                }
                case V1_16_4: {
                    instance = new V1_16_4();
                    break;
                }
                case V1_16_2: {
                    instance = new V1_16_2();
                    break;
                }
                case V1_16: {
                    instance = new V1_16();
                    break;
                }
                case V1_15: {
                    instance = new V1_15();
                    break;
                }
                case V1_14: {
                    instance = new V1_14();
                    break;
                }
                case V1_13_1: {
                    instance = new V1_13_1();
                    break;
                }
                case V1_13: {
                    instance = new V1_13();
                    break;
                }
                case V1_12: {
                    instance = new V1_12();
                    break;
                }
                case V1_11: {
                    instance = new V1_11();
                    break;
                }
            }
        }
        return instance;
    }

    public abstract PacketContainer[] createEntityEquipmentPacket(int var1, List<ValuePairs<EquipmentSlot, ItemStack>> var2);

    public PacketContainer[] createEntityDestroyPacket(int ... entityIds) {
        PacketContainer packet = InteractionVisualizer.protocolManager.createPacket(PacketType.Play.Server.ENTITY_DESTROY);
        packet.getIntegerArrays().write(0, (Object)entityIds);
        return new PacketContainer[]{packet};
    }

    public abstract List<BoundingBox> getBoundingBoxes(BlockPosition var1);

    public abstract NMSTileEntitySet<?, ?> getTileEntities(ChunkPosition var1, boolean var2);

    public abstract int getItemDespawnRate(Item var1);

    public abstract String getBannerCustomName(Block var1);

    public abstract WrappedIterable<?, Entity> getEntities(World var1);
}

