/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.interactionvisualizer.managers;

import com.loohp.interactionvisualizer.InteractionVisualizer;
import com.loohp.interactionvisualizer.api.InteractionVisualizerAPI;
import com.loohp.interactionvisualizer.api.events.TileEntityRemovedEvent;
import com.loohp.interactionvisualizer.managers.PlayerLocationManager;
import com.loohp.interactionvisualizer.nms.NMS;
import com.loohp.interactionvisualizer.objectholders.ChunkPosition;
import com.loohp.interactionvisualizer.objectholders.NMSTileEntitySet;
import com.loohp.interactionvisualizer.objectholders.TileEntity;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockExplodeEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.entity.EntityChangeBlockEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.event.vehicle.VehicleMoveEvent;
import org.bukkit.plugin.Plugin;

public class TileEntityManager
implements Listener {
    private static final Plugin plugin = InteractionVisualizer.plugin;
    private static final TileEntity.TileEntityType[] tileEntityTypes = TileEntity.TileEntityType.values();
    private static final Map<TileEntity.TileEntityType, Set<Block>> active = new EnumMap<TileEntity.TileEntityType, Set<Block>>(TileEntity.TileEntityType.class);
    private static final Map<ChunkPosition, Set<Block>> byChunk = new HashMap<ChunkPosition, Set<Block>>();

    public static void _init_() {
        for (TileEntity.TileEntityType type : tileEntityTypes) {
            active.put(type, Collections.newSetFromMap(new ConcurrentHashMap()));
        }
        TileEntityManager instance = new TileEntityManager();
        Bukkit.getPluginManager().registerEvents((Listener)instance, plugin);
        Bukkit.getScheduler().runTaskTimerAsynchronously(plugin, () -> {
            for (TileEntity.TileEntityType type : tileEntityTypes) {
                Set<Block> blocks = active.get((Object)type);
                Iterator<Block> itr = blocks.iterator();
                while (itr.hasNext()) {
                    Block block = itr.next();
                    if (PlayerLocationManager.hasPlayerNearby(block.getLocation())) continue;
                    itr.remove();
                }
            }
        }, 0L, (long)InteractionVisualizerAPI.getGCPeriod());
        for (Player player : Bukkit.getOnlinePlayers()) {
            instance.onJoin(new PlayerJoinEvent(player, ""));
        }
    }

    public static Set<Block> getTileEntites(TileEntity.TileEntityType type) {
        LinkedHashSet set = active.get((Object)type);
        return set != null ? set : new LinkedHashSet();
    }

    private static Set<ChunkPosition> getAllChunks(Location location) {
        LinkedHashSet<ChunkPosition> chunks = new LinkedHashSet<ChunkPosition>();
        World world = location.getWorld();
        int chunkX = location.getBlockX() >> 4;
        int chunkZ = location.getBlockZ() >> 4;
        for (int z = -InteractionVisualizer.tileEntityCheckingRange.intValue(); z <= InteractionVisualizer.tileEntityCheckingRange; ++z) {
            for (int x = -InteractionVisualizer.tileEntityCheckingRange.intValue(); x <= InteractionVisualizer.tileEntityCheckingRange; ++x) {
                chunks.add(new ChunkPosition(world, chunkX + x, chunkZ + z));
            }
        }
        return chunks;
    }

    private static ChunkPosition getChunk(Location location) {
        World world = location.getWorld();
        int chunkX = location.getBlockX() >> 4;
        int chunkZ = location.getBlockZ() >> 4;
        return new ChunkPosition(world, chunkX, chunkZ);
    }

    private static void addTileEntities(Collection<ChunkPosition> chunks) {
        for (ChunkPosition chunk : chunks) {
            TileEntityManager.addTileEntities(chunk);
        }
    }

    private static synchronized void addTileEntities(ChunkPosition chunk) {
        NMSTileEntitySet<?, ?> list = NMS.getInstance().getTileEntities(chunk, false);
        Set<Block> blocks = byChunk.get(chunk);
        if (blocks == null) {
            blocks = new LinkedHashSet<Block>();
            byChunk.put(chunk, blocks);
        }
        LinkedHashMap<Block, TileEntity.TileEntityType> newBlocks = new LinkedHashMap<Block, TileEntity.TileEntityType>();
        if (list != null) {
            for (TileEntity tile : list) {
                if (tile == null) continue;
                Block block = tile.getBlock();
                TileEntity.TileEntityType type = tile.getType();
                active.get((Object)type).add(block);
                newBlocks.put(block, type);
                blocks.add(block);
            }
        }
        Iterator<Block> itr = blocks.iterator();
        while (itr.hasNext()) {
            Block block = itr.next();
            TileEntity.TileEntityType type = (TileEntity.TileEntityType)((Object)newBlocks.get(block));
            if (type == null) {
                itr.remove();
                for (TileEntity.TileEntityType t : tileEntityTypes) {
                    if (!active.get((Object)t).remove(block)) continue;
                    Bukkit.getPluginManager().callEvent((Event)new TileEntityRemovedEvent(block, t));
                }
                continue;
            }
            for (TileEntity.TileEntityType t : tileEntityTypes) {
                if (t.equals((Object)type) || !active.get((Object)t).remove(block)) continue;
                Bukkit.getPluginManager().callEvent((Event)new TileEntityRemovedEvent(block, t));
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onJoin(PlayerJoinEvent event) {
        TileEntityManager.addTileEntities(TileEntityManager.getAllChunks(event.getPlayer().getLocation()));
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onInteract(PlayerInteractEvent event) {
        TileEntity.TileEntityType type;
        Block block = event.getClickedBlock();
        if (block != null && (type = TileEntity.getTileEntityType(block.getType())) != null && !active.get((Object)type).contains(block)) {
            TileEntityManager.addTileEntities(TileEntityManager.getChunk(block.getLocation()));
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onTeleport(PlayerTeleportEvent event) {
        Location from = event.getFrom();
        Location to = event.getTo();
        if (!from.getWorld().equals(to.getWorld()) || from.getBlockX() >> 4 != to.getBlockX() >> 4 || from.getBlockZ() >> 4 != to.getBlockZ() >> 4) {
            TileEntityManager.addTileEntities(TileEntityManager.getAllChunks(to));
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerMove(PlayerMoveEvent event) {
        Location from = event.getFrom();
        Location to = event.getTo();
        if (!from.getWorld().equals(to.getWorld()) || (from.getBlockX() >> 4 != to.getBlockX() >> 4 || from.getBlockZ() >> 4 != to.getBlockZ() >> 4) && !this.isMovingTooFast(event.getPlayer(), from, to)) {
            TileEntityManager.addTileEntities(TileEntityManager.getAllChunks(to));
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onVehicleMove(VehicleMoveEvent event) {
        if (event.getVehicle().getPassengers().stream().anyMatch(each -> each instanceof Player)) {
            Location from = event.getFrom();
            Location to = event.getTo();
            if (!from.getWorld().equals(to.getWorld()) || (from.getBlockX() >> 4 != to.getBlockX() >> 4 || from.getBlockZ() >> 4 != to.getBlockZ() >> 4) && !this.isMovingTooFast(null, from, to)) {
                TileEntityManager.addTileEntities(TileEntityManager.getAllChunks(to));
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onBreakBlock(BlockBreakEvent event) {
        if (TileEntity.isTileEntityType(event.getBlock().getType())) {
            Bukkit.getScheduler().runTaskLater(plugin, () -> TileEntityManager.addTileEntities(TileEntityManager.getChunk(event.getBlock().getLocation())), 1L);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlaceBlock(BlockPlaceEvent event) {
        if (TileEntity.isTileEntityType(event.getBlock().getType())) {
            Bukkit.getScheduler().runTaskLater(plugin, () -> TileEntityManager.addTileEntities(TileEntityManager.getChunk(event.getBlock().getLocation())), 1L);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onBlockExplode(BlockExplodeEvent event) {
        LinkedHashSet<ChunkPosition> chunks = new LinkedHashSet<ChunkPosition>();
        if (TileEntity.isTileEntityType(event.getBlock().getType())) {
            chunks.add(TileEntityManager.getChunk(event.getBlock().getLocation()));
        }
        for (Block block : event.blockList()) {
            if (!TileEntity.isTileEntityType(block.getType())) continue;
            chunks.add(TileEntityManager.getChunk(block.getLocation()));
        }
        Bukkit.getScheduler().runTaskLater(plugin, () -> TileEntityManager.addTileEntities(chunks), 1L);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onEntityExplode(EntityExplodeEvent event) {
        LinkedHashSet<ChunkPosition> chunks = new LinkedHashSet<ChunkPosition>();
        for (Block block : event.blockList()) {
            if (!TileEntity.isTileEntityType(block.getType())) continue;
            chunks.add(TileEntityManager.getChunk(block.getLocation()));
        }
        Bukkit.getScheduler().runTaskLater(plugin, () -> TileEntityManager.addTileEntities(chunks), 1L);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onEntityChangeBlock(EntityChangeBlockEvent event) {
        if (TileEntity.isTileEntityType(event.getBlock().getType())) {
            Bukkit.getScheduler().runTaskLater(plugin, () -> TileEntityManager.addTileEntities(TileEntityManager.getChunk(event.getBlock().getLocation())), 1L);
        }
    }

    private boolean isMovingTooFast(Player player, Location from, Location to) {
        double changeX = Math.abs(from.getX() - to.getX());
        double changeZ = Math.abs(from.getZ() - to.getZ());
        double horizontalDistanceSquared = changeX * changeX + changeZ * changeZ;
        if (player != null && player.isGliding()) {
            return horizontalDistanceSquared > InteractionVisualizer.ignoreGlideSquared;
        }
        if (player != null && player.isFlying()) {
            return horizontalDistanceSquared > InteractionVisualizer.ignoreFlySquared;
        }
        return horizontalDistanceSquared > InteractionVisualizer.ignoreWalkSquared;
    }
}

