/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.interactionvisualizer.managers;

import com.loohp.interactionvisualizer.InteractionVisualizer;
import com.loohp.interactionvisualizer.api.VisualizerDisplay;
import com.loohp.interactionvisualizer.api.VisualizerInteractDisplay;
import com.loohp.interactionvisualizer.api.VisualizerRunnableDisplay;
import com.loohp.interactionvisualizer.blocks.AnvilDisplay;
import com.loohp.interactionvisualizer.blocks.BannerDisplay;
import com.loohp.interactionvisualizer.blocks.BarrelDisplay;
import com.loohp.interactionvisualizer.blocks.BeaconDisplay;
import com.loohp.interactionvisualizer.blocks.BeeHiveDisplay;
import com.loohp.interactionvisualizer.blocks.BeeNestDisplay;
import com.loohp.interactionvisualizer.blocks.BlastFurnaceDisplay;
import com.loohp.interactionvisualizer.blocks.BrewingStandDisplay;
import com.loohp.interactionvisualizer.blocks.CampfireDisplay;
import com.loohp.interactionvisualizer.blocks.CartographyTableDisplay;
import com.loohp.interactionvisualizer.blocks.ChestDisplay;
import com.loohp.interactionvisualizer.blocks.ConduitDisplay;
import com.loohp.interactionvisualizer.blocks.CraftingTableDisplay;
import com.loohp.interactionvisualizer.blocks.DispenserDisplay;
import com.loohp.interactionvisualizer.blocks.DoubleChestDisplay;
import com.loohp.interactionvisualizer.blocks.DropperDisplay;
import com.loohp.interactionvisualizer.blocks.EnchantmentTableDisplay;
import com.loohp.interactionvisualizer.blocks.EnderchestDisplay;
import com.loohp.interactionvisualizer.blocks.FurnaceDisplay;
import com.loohp.interactionvisualizer.blocks.GrindstoneDisplay;
import com.loohp.interactionvisualizer.blocks.HopperDisplay;
import com.loohp.interactionvisualizer.blocks.JukeBoxDisplay;
import com.loohp.interactionvisualizer.blocks.LecternDisplay;
import com.loohp.interactionvisualizer.blocks.LoomDisplay;
import com.loohp.interactionvisualizer.blocks.NoteBlockDisplay;
import com.loohp.interactionvisualizer.blocks.ShulkerBoxDisplay;
import com.loohp.interactionvisualizer.blocks.SmithingTableDisplay;
import com.loohp.interactionvisualizer.blocks.SmokerDisplay;
import com.loohp.interactionvisualizer.blocks.SoulCampfireDisplay;
import com.loohp.interactionvisualizer.blocks.SpawnerDisplay;
import com.loohp.interactionvisualizer.blocks.StonecutterDisplay;
import com.loohp.interactionvisualizer.debug.Debug;
import com.loohp.interactionvisualizer.entities.ItemDisplay;
import com.loohp.interactionvisualizer.entities.VillagerDisplay;
import com.loohp.interactionvisualizer.libs.com.loohp.yamlconfiguration.YamlConfiguration;
import com.loohp.interactionvisualizer.listeners.ChunkEvents;
import com.loohp.interactionvisualizer.listeners.Events;
import com.loohp.interactionvisualizer.managers.PacketManager;
import com.loohp.interactionvisualizer.objectholders.EntryKey;
import com.loohp.interactionvisualizer.updater.Updater;
import com.loohp.interactionvisualizer.utils.MCVersion;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.plugin.Plugin;

public class TaskManager {
    public static Plugin plugin = InteractionVisualizer.plugin;
    public static MCVersion version;
    public static boolean anvil;
    public static boolean banner;
    public static boolean barrel;
    public static boolean beacon;
    public static boolean beehive;
    public static boolean beenest;
    public static boolean blastfurnace;
    public static boolean brewingstand;
    public static boolean campfire;
    public static boolean cartographytable;
    public static boolean chest;
    public static boolean conduit;
    public static boolean craftingtable;
    public static boolean dispenser;
    public static boolean doublechest;
    public static boolean dropper;
    public static boolean enchantmenttable;
    public static boolean enderchest;
    public static boolean furnace;
    public static boolean grindstone;
    public static boolean hopper;
    public static boolean jukebox;
    public static boolean lectern;
    public static boolean loom;
    public static boolean noteblock;
    public static boolean shulkerbox;
    public static boolean smoker;
    public static boolean soulcampfire;
    public static boolean spawner;
    public static boolean stonecutter;
    public static boolean smithingtable;
    public static boolean item;
    public static boolean villager;
    public static Map<InventoryType, List<VisualizerInteractDisplay>> processes;
    public static List<VisualizerRunnableDisplay> runnables;

    public static void setup() {
        VisualizerDisplay bd;
        VisualizerDisplay dd;
        VisualizerDisplay cd;
        VisualizerDisplay sd;
        VisualizerDisplay ld;
        VisualizerInteractDisplay ctd;
        anvil = false;
        banner = false;
        barrel = false;
        beacon = false;
        beehive = false;
        beenest = false;
        blastfurnace = false;
        brewingstand = false;
        campfire = false;
        cartographytable = false;
        chest = false;
        conduit = false;
        craftingtable = false;
        dispenser = false;
        doublechest = false;
        dropper = false;
        enchantmenttable = false;
        enderchest = false;
        furnace = false;
        grindstone = false;
        hopper = false;
        jukebox = false;
        lectern = false;
        loom = false;
        noteblock = false;
        shulkerbox = false;
        smoker = false;
        soulcampfire = false;
        spawner = false;
        stonecutter = false;
        smithingtable = false;
        item = false;
        villager = false;
        version = InteractionVisualizer.version;
        ArrayList<EntryKey> keys = new ArrayList<EntryKey>();
        Bukkit.getPluginManager().registerEvents((Listener)new Debug(), plugin);
        Bukkit.getPluginManager().registerEvents((Listener)new Updater(), plugin);
        Bukkit.getPluginManager().registerEvents((Listener)new Events(), plugin);
        Bukkit.getPluginManager().registerEvents((Listener)new PacketManager(), plugin);
        if (version.isLegacy()) {
            ChunkEvents.setup();
            InteractionVisualizer.getDefaultWorld().getChunkAt(0, 0).load();
            Bukkit.getPluginManager().registerEvents((Listener)new ChunkEvents(), plugin);
        }
        for (InventoryType type : InventoryType.values()) {
            processes.put(type, new ArrayList());
        }
        if (TaskManager.getConfig().getBoolean("Blocks.CraftingTable.Enabled")) {
            ctd = new CraftingTableDisplay();
            keys.add(ctd.registerNative(InventoryType.WORKBENCH));
            Bukkit.getPluginManager().registerEvents((Listener)ctd, plugin);
            craftingtable = true;
        }
        if (TaskManager.getConfig().getBoolean("Blocks.Loom.Enabled") && version.isNewerOrEqualTo(MCVersion.V1_14)) {
            ld = new LoomDisplay();
            keys.add(((VisualizerInteractDisplay)ld).registerNative(InventoryType.LOOM));
            Bukkit.getPluginManager().registerEvents((Listener)ld, plugin);
            loom = true;
        }
        if (TaskManager.getConfig().getBoolean("Blocks.EnchantmentTable.Enabled")) {
            EnchantmentTableDisplay etd = new EnchantmentTableDisplay();
            keys.add(etd.registerNative(InventoryType.ENCHANTING));
            Bukkit.getPluginManager().registerEvents((Listener)etd, plugin);
            enchantmenttable = true;
        }
        if (TaskManager.getConfig().getBoolean("Blocks.CartographyTable.Enabled") && version.isNewerOrEqualTo(MCVersion.V1_14)) {
            ctd = new CartographyTableDisplay();
            keys.add(ctd.registerNative(InventoryType.CARTOGRAPHY));
            Bukkit.getPluginManager().registerEvents((Listener)ctd, plugin);
            cartographytable = true;
        }
        if (TaskManager.getConfig().getBoolean("Blocks.Anvil.Enabled")) {
            AnvilDisplay ad = new AnvilDisplay();
            keys.add(ad.registerNative(InventoryType.ANVIL));
            Bukkit.getPluginManager().registerEvents((Listener)ad, plugin);
            anvil = true;
        }
        if (TaskManager.getConfig().getBoolean("Blocks.Grindstone.Enabled") && version.isNewerOrEqualTo(MCVersion.V1_14)) {
            GrindstoneDisplay gd = new GrindstoneDisplay();
            keys.add(gd.registerNative(InventoryType.GRINDSTONE));
            Bukkit.getPluginManager().registerEvents((Listener)gd, plugin);
            grindstone = true;
        }
        if (TaskManager.getConfig().getBoolean("Blocks.Stonecutter.Enabled") && version.isNewerOrEqualTo(MCVersion.V1_14)) {
            sd = new StonecutterDisplay();
            keys.add(((VisualizerInteractDisplay)sd).registerNative(InventoryType.STONECUTTER));
            Bukkit.getPluginManager().registerEvents((Listener)sd, plugin);
            stonecutter = true;
        }
        if (TaskManager.getConfig().getBoolean("Blocks.BrewingStand.Enabled")) {
            BrewingStandDisplay bsd = new BrewingStandDisplay();
            keys.add(bsd.registerNative());
            Bukkit.getPluginManager().registerEvents((Listener)bsd, plugin);
            brewingstand = true;
        }
        if (TaskManager.getConfig().getBoolean("Blocks.Chest.Enabled")) {
            cd = new ChestDisplay();
            keys.add(cd.registerNative());
            Bukkit.getPluginManager().registerEvents((Listener)cd, plugin);
            chest = true;
        }
        if (TaskManager.getConfig().getBoolean("Blocks.DoubleChest.Enabled")) {
            DoubleChestDisplay dcd = new DoubleChestDisplay();
            keys.add(dcd.registerNative());
            Bukkit.getPluginManager().registerEvents((Listener)dcd, plugin);
            doublechest = true;
        }
        if (TaskManager.getConfig().getBoolean("Blocks.Furnace.Enabled")) {
            FurnaceDisplay fd = new FurnaceDisplay();
            keys.add(fd.registerNative());
            Bukkit.getPluginManager().registerEvents((Listener)fd, plugin);
            furnace = true;
        }
        if (TaskManager.getConfig().getBoolean("Blocks.BlastFurnace.Enabled") && version.isNewerOrEqualTo(MCVersion.V1_14)) {
            BlastFurnaceDisplay bfd = new BlastFurnaceDisplay();
            keys.add(bfd.registerNative());
            Bukkit.getPluginManager().registerEvents((Listener)bfd, plugin);
            blastfurnace = true;
        }
        if (TaskManager.getConfig().getBoolean("Blocks.Smoker.Enabled") && version.isNewerOrEqualTo(MCVersion.V1_14)) {
            sd = new SmokerDisplay();
            keys.add(((VisualizerRunnableDisplay)sd).registerNative());
            Bukkit.getPluginManager().registerEvents((Listener)sd, plugin);
            smoker = true;
        }
        if (TaskManager.getConfig().getBoolean("Blocks.EnderChest.Enabled")) {
            EnderchestDisplay ed = new EnderchestDisplay();
            keys.add(ed.registerNative());
            Bukkit.getPluginManager().registerEvents((Listener)ed, plugin);
            enderchest = true;
        }
        if (TaskManager.getConfig().getBoolean("Blocks.ShulkerBox.Enabled") && !version.isOld()) {
            ShulkerBoxDisplay sbd = new ShulkerBoxDisplay();
            keys.add(sbd.registerNative());
            Bukkit.getPluginManager().registerEvents((Listener)sbd, plugin);
            shulkerbox = true;
        }
        if (TaskManager.getConfig().getBoolean("Blocks.Dispenser.Enabled")) {
            dd = new DispenserDisplay();
            keys.add(dd.registerNative());
            Bukkit.getPluginManager().registerEvents((Listener)dd, plugin);
            dispenser = true;
        }
        if (TaskManager.getConfig().getBoolean("Blocks.Dropper.Enabled")) {
            dd = new DropperDisplay();
            keys.add(dd.registerNative());
            Bukkit.getPluginManager().registerEvents((Listener)dd, plugin);
            dropper = true;
        }
        if (TaskManager.getConfig().getBoolean("Blocks.Hopper.Enabled")) {
            HopperDisplay hd = new HopperDisplay();
            keys.add(hd.registerNative());
            Bukkit.getPluginManager().registerEvents((Listener)hd, plugin);
            hopper = true;
        }
        if (TaskManager.getConfig().getBoolean("Blocks.Beacon.Enabled")) {
            bd = new BeaconDisplay();
            keys.add(bd.registerNative());
            Bukkit.getPluginManager().registerEvents((Listener)bd, plugin);
            beacon = true;
        }
        if (TaskManager.getConfig().getBoolean("Blocks.NoteBlock.Enabled")) {
            NoteBlockDisplay nbd = new NoteBlockDisplay();
            keys.add(nbd.registerNative());
            Bukkit.getPluginManager().registerEvents((Listener)nbd, plugin);
            noteblock = true;
        }
        if (TaskManager.getConfig().getBoolean("Blocks.JukeBox.Enabled")) {
            JukeBoxDisplay jbd = new JukeBoxDisplay();
            keys.add(jbd.registerNative());
            Bukkit.getPluginManager().registerEvents((Listener)jbd, plugin);
            jukebox = true;
        }
        if (TaskManager.getConfig().getBoolean("Blocks.SmithingTable.Enabled") && version.isNewerOrEqualTo(MCVersion.V1_16)) {
            SmithingTableDisplay std = new SmithingTableDisplay();
            keys.add(std.registerNative(InventoryType.SMITHING));
            Bukkit.getPluginManager().registerEvents((Listener)std, plugin);
            smithingtable = true;
        }
        if (TaskManager.getConfig().getBoolean("Blocks.BeeNest.Enabled") && version.isNewerOrEqualTo(MCVersion.V1_15)) {
            BeeNestDisplay bnd = new BeeNestDisplay();
            keys.add(bnd.registerNative());
            Bukkit.getPluginManager().registerEvents((Listener)bnd, plugin);
            beenest = true;
        }
        if (TaskManager.getConfig().getBoolean("Blocks.BeeHive.Enabled") && version.isNewerOrEqualTo(MCVersion.V1_15)) {
            BeeHiveDisplay bhd = new BeeHiveDisplay();
            keys.add(bhd.registerNative());
            Bukkit.getPluginManager().registerEvents((Listener)bhd, plugin);
            beehive = true;
        }
        if (TaskManager.getConfig().getBoolean("Blocks.Lectern.Enabled") && version.isNewerOrEqualTo(MCVersion.V1_14)) {
            ld = new LecternDisplay();
            keys.add(((VisualizerRunnableDisplay)ld).registerNative());
            Bukkit.getPluginManager().registerEvents((Listener)ld, plugin);
            lectern = true;
        }
        if (TaskManager.getConfig().getBoolean("Blocks.Campfire.Enabled") && version.isNewerOrEqualTo(MCVersion.V1_14)) {
            cd = new CampfireDisplay();
            keys.add(((VisualizerRunnableDisplay)cd).registerNative());
            Bukkit.getPluginManager().registerEvents((Listener)cd, plugin);
            campfire = true;
        }
        if (TaskManager.getConfig().getBoolean("Blocks.SoulCampfire.Enabled") && version.isNewerOrEqualTo(MCVersion.V1_16)) {
            SoulCampfireDisplay scd = new SoulCampfireDisplay();
            keys.add(scd.registerNative());
            Bukkit.getPluginManager().registerEvents((Listener)scd, plugin);
            soulcampfire = true;
        }
        if (TaskManager.getConfig().getBoolean("Blocks.Spawner.Enabled")) {
            sd = new SpawnerDisplay();
            keys.add(((VisualizerRunnableDisplay)sd).registerNative());
            Bukkit.getPluginManager().registerEvents((Listener)sd, plugin);
            spawner = true;
        }
        if (TaskManager.getConfig().getBoolean("Blocks.Conduit.Enabled") && version.isNewerOrEqualTo(MCVersion.V1_13)) {
            cd = new ConduitDisplay();
            keys.add(((VisualizerRunnableDisplay)cd).registerNative());
            Bukkit.getPluginManager().registerEvents((Listener)cd, plugin);
            conduit = true;
        }
        if (TaskManager.getConfig().getBoolean("Blocks.Banner.Enabled")) {
            bd = new BannerDisplay();
            keys.add(bd.registerNative());
            Bukkit.getPluginManager().registerEvents((Listener)bd, plugin);
            banner = true;
        }
        if (TaskManager.getConfig().getBoolean("Blocks.Barrel.Enabled") && version.isNewerOrEqualTo(MCVersion.V1_14)) {
            bd = new BarrelDisplay();
            keys.add(bd.registerNative());
            Bukkit.getPluginManager().registerEvents((Listener)bd, plugin);
            barrel = true;
        }
        if (TaskManager.getConfig().getBoolean("Entities.Item.Enabled")) {
            ItemDisplay id = new ItemDisplay();
            keys.add(id.registerNative());
            Bukkit.getPluginManager().registerEvents((Listener)id, plugin);
            item = true;
        }
        if (TaskManager.getConfig().getBoolean("Entities.Villager.Enabled")) {
            VillagerDisplay vd = new VillagerDisplay();
            keys.add(vd.registerNative());
            Bukkit.getPluginManager().registerEvents((Listener)vd, plugin);
            villager = true;
        }
        InteractionVisualizer.preferenceManager.registerEntry(keys.toArray(new EntryKey[keys.size()]));
        InteractionVisualizer.lightManager.run();
        PacketManager.update();
    }

    public static void run() {
        int next = 1;
        int count = 0;
        int size = Bukkit.getOnlinePlayers().size();
        int maxper = (int)Math.ceil((double)size / 5.0);
        if (maxper > 10) {
            maxper = 10;
        }
        int delay = 1;
        for (Player eachPlayer : Bukkit.getOnlinePlayers()) {
            if (eachPlayer.getOpenInventory().getType().equals((Object)InventoryType.CRAFTING) || eachPlayer.getOpenInventory().getType().equals((Object)InventoryType.CREATIVE)) continue;
            if (++count > maxper) {
                count = 0;
                ++delay;
            }
            UUID uuid = eachPlayer.getUniqueId();
            Bukkit.getScheduler().runTaskLater(plugin, () -> {
                Player player = Bukkit.getPlayer((UUID)uuid);
                if (player == null) {
                    return;
                }
                Inventory inv = player.getOpenInventory().getTopInventory();
                processes.get(inv.getType()).forEach(each -> each.process(player));
            }, (long)delay);
        }
        Bukkit.getScheduler().runTaskLater(plugin, () -> TaskManager.run(), (long)(next += delay));
    }

    private static YamlConfiguration getConfig() {
        return InteractionVisualizer.plugin.getConfiguration();
    }

    static {
        processes = new HashMap<InventoryType, List<VisualizerInteractDisplay>>();
        runnables = new ArrayList<VisualizerRunnableDisplay>();
    }
}

