/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.interactionvisualizer.managers;

import com.loohp.interactionvisualizer.InteractionVisualizer;
import com.loohp.interactionvisualizer.api.InteractionVisualizerAPI;
import com.loohp.interactionvisualizer.database.Database;
import com.loohp.interactionvisualizer.libs.org.awaitility.Awaitility;
import com.loohp.interactionvisualizer.libs.org.awaitility.core.ConditionTimeoutException;
import com.loohp.interactionvisualizer.managers.PacketManager;
import com.loohp.interactionvisualizer.objectholders.EntryKey;
import com.loohp.interactionvisualizer.objectholders.SynchronizedFilteredCollection;
import com.loohp.interactionvisualizer.utils.ArrayUtils;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BooleanSupplier;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;

public class PreferenceManager
implements Listener,
AutoCloseable {
    private final InteractionVisualizer plugin;
    private final List<EntryKey> entries;
    private final Map<UUID, Map<InteractionVisualizerAPI.Modules, BitSet>> preferences;
    private final Collection<Player> backingPlayerList;
    private final AtomicBoolean valid;

    public PreferenceManager(InteractionVisualizer plugin) {
        this.plugin = plugin;
        this.valid = new AtomicBoolean(true);
        this.entries = Collections.synchronizedList(ArrayUtils.putToArrayList(Database.getBitIndex(), new ArrayList()));
        this.preferences = new ConcurrentHashMap<UUID, Map<InteractionVisualizerAPI.Modules, BitSet>>();
        this.backingPlayerList = Collections.synchronizedCollection(new LinkedHashSet());
        for (Player player : Bukkit.getOnlinePlayers()) {
            this.backingPlayerList.add(player);
            this.loadPlayer(player.getUniqueId(), player.getName(), true);
        }
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    @Override
    public synchronized void close() {
        this.backingPlayerList.clear();
        for (UUID uuid : this.preferences.keySet()) {
            this.savePlayer(uuid, true);
        }
        this.saveBitmaskIndex();
        this.valid.set(false);
    }

    public boolean isValid() {
        return this.valid.get();
    }

    public void saveBitmaskIndex() {
        Bukkit.getConsoleSender().sendMessage(ChatColor.AQUA + "[InteractionVisualizer] Saving player preferences bitmask index, do not halt the server.");
        try {
            Awaitility.await().atMost(30L, TimeUnit.SECONDS).pollInterval(500L, TimeUnit.MILLISECONDS).pollDelay(0L, TimeUnit.MILLISECONDS).until(() -> !Database.isLocked());
        }
        catch (ConditionTimeoutException e) {
            Bukkit.getConsoleSender().sendMessage(ChatColor.YELLOW + "Tried to save player preference but database is locked for more than 30 seconds, performing save anyway...");
        }
        Database.setLocked(true);
        Database.setBitIndex(ArrayUtils.putToMap(this.entries, new HashMap()));
        Database.setLocked(false);
    }

    public void registerEntry(EntryKey entryKey, EntryKey ... entryKeys) {
        EntryKey[] keys = new EntryKey[entryKeys.length + 1];
        keys[0] = entryKey;
        System.arraycopy(entryKeys, 0, keys, 1, entryKeys.length);
        this.registerEntry(keys);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerEntry(EntryKey[] entryKeys) {
        if (entryKeys.length > 0) {
            List<EntryKey> list = this.entries;
            synchronized (list) {
                try {
                    Awaitility.await().atMost(30L, TimeUnit.SECONDS).pollInterval(500L, TimeUnit.MILLISECONDS).pollDelay(0L, TimeUnit.MILLISECONDS).until(() -> !Database.isLocked());
                }
                catch (ConditionTimeoutException e) {
                    Bukkit.getConsoleSender().sendMessage(ChatColor.YELLOW + "Tried to save player preference but database is locked for more than 30 seconds, performing save anyway...");
                }
                Database.setLocked(true);
                List<EntryKey> updatedEntries = ArrayUtils.putToArrayList(Database.getBitIndex(), new ArrayList());
                this.entries.clear();
                this.entries.addAll(updatedEntries);
                boolean changes = false;
                for (EntryKey entry : entryKeys) {
                    if (this.entries.contains(entry)) continue;
                    changes = true;
                    this.entries.add(entry);
                }
                if (changes) {
                    Database.setBitIndex(ArrayUtils.putToMap(this.entries, new HashMap()));
                }
                Database.setLocked(false);
            }
        }
    }

    @EventHandler
    public void onJoinEvent(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        this.backingPlayerList.add(player);
        InteractionVisualizer.asyncExecutorManager.runTaskAsynchronously(() -> {
            this.loadPlayer(player.getUniqueId(), player.getName(), true);
            this.updatePlayer(player, false);
        });
    }

    @EventHandler
    public void onQuitEvent(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        this.backingPlayerList.remove(player);
        InteractionVisualizer.asyncExecutorManager.runTaskAsynchronously(() -> this.savePlayer(event.getPlayer().getUniqueId(), true));
    }

    public void loadPlayer(UUID uuid, String name, boolean createIfNotFound) {
        if (createIfNotFound) {
            boolean newPlayer = false;
            if (!Database.playerExists(uuid)) {
                Database.createPlayer(uuid, name);
                newPlayer = true;
            }
            Map<InteractionVisualizerAPI.Modules, BitSet> info = Database.getPlayerInfo(uuid);
            this.preferences.put(uuid, info);
            if (newPlayer && InteractionVisualizer.defaultDisabledAll) {
                this.setPlayerAllPreference(uuid, false, false);
                this.savePlayer(uuid, false);
            }
        } else if (Database.playerExists(uuid)) {
            Map<InteractionVisualizerAPI.Modules, BitSet> info = Database.getPlayerInfo(uuid);
            this.preferences.put(uuid, info);
        }
    }

    public void savePlayer(UUID uuid, boolean unload) {
        Map<InteractionVisualizerAPI.Modules, BitSet> info;
        Map<InteractionVisualizerAPI.Modules, BitSet> map = info = unload ? this.preferences.remove(uuid) : this.preferences.get(uuid);
        if (info != null) {
            for (Map.Entry<InteractionVisualizerAPI.Modules, BitSet> entry : info.entrySet()) {
                switch (entry.getKey()) {
                    case HOLOGRAM: {
                        Database.setHologram(uuid, entry.getValue());
                        break;
                    }
                    case ITEMDROP: {
                        Database.setItemDrop(uuid, entry.getValue());
                        break;
                    }
                    case ITEMSTAND: {
                        Database.setItemStand(uuid, entry.getValue());
                    }
                }
            }
        }
    }

    public void unloadPlayerWithoutSaving(UUID uuid) {
        this.preferences.remove(uuid);
    }

    public void updatePlayer(Player player, boolean reset) {
        if (reset) {
            PacketManager.reset(player);
        } else {
            PacketManager.sendPlayerPackets(player);
        }
    }

    public boolean isRegisteredEntry(EntryKey entry) {
        return this.entries.contains(entry);
    }

    public List<EntryKey> getRegisteredEntries() {
        return Collections.unmodifiableList(this.entries);
    }

    public boolean getPlayerPreference(UUID uuid, InteractionVisualizerAPI.Modules module, EntryKey entry) {
        int i = this.entries.indexOf(entry);
        if (i < 0) {
            return false;
        }
        Map<InteractionVisualizerAPI.Modules, BitSet> info = this.preferences.get(uuid);
        if (info != null) {
            BitSet bitset = info.get((Object)module);
            return !bitset.get(i);
        }
        return false;
    }

    public Map<InteractionVisualizerAPI.Modules, Map<EntryKey, Boolean>> getPlayerPreferences(UUID uuid) {
        HashMap<InteractionVisualizerAPI.Modules, Map<EntryKey, Boolean>> preferences = new HashMap<InteractionVisualizerAPI.Modules, Map<EntryKey, Boolean>>();
        for (InteractionVisualizerAPI.Modules module : InteractionVisualizerAPI.Modules.values()) {
            HashMap<EntryKey, Boolean> entryPreference = new HashMap<EntryKey, Boolean>();
            for (EntryKey entry : this.getRegisteredEntries()) {
                entryPreference.put(entry, this.getPlayerPreference(uuid, module, entry));
            }
            preferences.put(module, entryPreference);
        }
        return preferences;
    }

    public void setPlayerPreference(UUID uuid, InteractionVisualizerAPI.Modules module, EntryKey entry, boolean enabled, boolean update) {
        Player player;
        int i = this.entries.indexOf(entry);
        if (i < 0) {
            return;
        }
        Map<InteractionVisualizerAPI.Modules, BitSet> info = this.preferences.get(uuid);
        if (info != null) {
            BitSet bitset = info.get((Object)module);
            bitset.set(i, !enabled);
        }
        if (update && (player = Bukkit.getPlayer((UUID)uuid)) != null) {
            this.updatePlayer(player, true);
        }
    }

    public void setPlayerAllPreference(UUID uuid, InteractionVisualizerAPI.Modules module, boolean enabled, boolean update) {
        Player player;
        for (EntryKey entry : this.getRegisteredEntries()) {
            this.setPlayerPreference(uuid, module, entry, enabled, false);
        }
        if (update && (player = Bukkit.getPlayer((UUID)uuid)) != null) {
            this.updatePlayer(player, true);
        }
    }

    public void setPlayerAllPreference(UUID uuid, EntryKey entry, boolean enabled, boolean update) {
        Player player;
        for (InteractionVisualizerAPI.Modules module : InteractionVisualizerAPI.Modules.values()) {
            this.setPlayerPreference(uuid, module, entry, enabled, false);
        }
        if (update && (player = Bukkit.getPlayer((UUID)uuid)) != null) {
            this.updatePlayer(player, true);
        }
    }

    public void setPlayerAllPreference(UUID uuid, boolean enabled, boolean update) {
        Player player;
        for (InteractionVisualizerAPI.Modules module : InteractionVisualizerAPI.Modules.values()) {
            for (EntryKey entry : this.getRegisteredEntries()) {
                this.setPlayerPreference(uuid, module, entry, enabled, false);
            }
        }
        if (update && (player = Bukkit.getPlayer((UUID)uuid)) != null) {
            this.updatePlayer(player, true);
        }
    }

    public boolean hasAnyPreferenceDisabled(UUID uuid, InteractionVisualizerAPI.Modules module) {
        Map<InteractionVisualizerAPI.Modules, BitSet> info = this.preferences.get(uuid);
        if (info != null) {
            BitSet bitset = info.get((Object)module);
            return bitset.cardinality() > 0;
        }
        return false;
    }

    public boolean hasAnyPreferenceDisabled(UUID uuid, EntryKey entry) {
        int i = this.entries.indexOf(entry);
        if (i < 0) {
            return false;
        }
        Map<InteractionVisualizerAPI.Modules, BitSet> info = this.preferences.get(uuid);
        if (info != null) {
            for (BitSet bitset : info.values()) {
                if (!bitset.get(i)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasAnyPreferenceDisabled(UUID uuid) {
        Map<InteractionVisualizerAPI.Modules, BitSet> info = this.preferences.get(uuid);
        if (info != null) {
            for (BitSet bitset : info.values()) {
                if (bitset.cardinality() <= 0) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasAnyPreferenceEnabled(UUID uuid, InteractionVisualizerAPI.Modules module) {
        Map<InteractionVisualizerAPI.Modules, BitSet> info = this.preferences.get(uuid);
        if (info != null) {
            BitSet bitset = info.get((Object)module);
            for (int i = 0; i < this.entries.size(); ++i) {
                if (bitset.get(i)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasAnyPreferenceEnabled(UUID uuid, EntryKey entry) {
        int i = this.entries.indexOf(entry);
        if (i < 0) {
            return false;
        }
        Map<InteractionVisualizerAPI.Modules, BitSet> info = this.preferences.get(uuid);
        if (info != null) {
            for (BitSet bitset : info.values()) {
                if (bitset.get(i)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasAnyPreferenceEnabled(UUID uuid) {
        Map<InteractionVisualizerAPI.Modules, BitSet> info = this.preferences.get(uuid);
        if (info != null) {
            for (BitSet bitset : info.values()) {
                for (int i = 0; i < this.entries.size(); ++i) {
                    if (bitset.get(i)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public boolean hasAllPreferenceEnabled(UUID uuid, InteractionVisualizerAPI.Modules module) {
        Map<InteractionVisualizerAPI.Modules, BitSet> info = this.preferences.get(uuid);
        if (info != null) {
            BitSet bitset = info.get((Object)module);
            for (int i = 0; i < this.entries.size(); ++i) {
                if (!bitset.get(i)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean hasAllPreferenceEnabled(UUID uuid, EntryKey entry) {
        int i = this.entries.indexOf(entry);
        if (i < 0) {
            return false;
        }
        Map<InteractionVisualizerAPI.Modules, BitSet> info = this.preferences.get(uuid);
        if (info != null) {
            for (BitSet bitset : info.values()) {
                if (!bitset.get(i)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean hasAllPreferenceEnabled(UUID uuid) {
        Map<InteractionVisualizerAPI.Modules, BitSet> info = this.preferences.get(uuid);
        if (info != null) {
            for (BitSet bitset : info.values()) {
                for (int i = 0; i < this.entries.size(); ++i) {
                    if (!bitset.get(i)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public Collection<Player> getPlayerList(InteractionVisualizerAPI.Modules module, EntryKey entry) {
        BooleanSupplier serverSetting;
        switch (module) {
            case HOLOGRAM: {
                serverSetting = () -> InteractionVisualizer.hologramsEnabled && !InteractionVisualizer.hologramsDisabled.contains(entry);
                break;
            }
            case ITEMDROP: {
                serverSetting = () -> InteractionVisualizer.itemDropEnabled && !InteractionVisualizer.itemDropDisabled.contains(entry);
                break;
            }
            case ITEMSTAND: {
                serverSetting = () -> InteractionVisualizer.itemStandEnabled && !InteractionVisualizer.itemStandDisabled.contains(entry);
                break;
            }
            default: {
                serverSetting = () -> true;
            }
        }
        return SynchronizedFilteredCollection.filterSynchronized(this.backingPlayerList, player -> {
            if (!serverSetting.getAsBoolean()) {
                return false;
            }
            if (!this.isRegisteredEntry(entry)) {
                return false;
            }
            return this.getPlayerPreference(player.getUniqueId(), module, entry);
        });
    }

    public Collection<Player> getPlayerListIgnoreServerSetting(InteractionVisualizerAPI.Modules module, EntryKey entry) {
        return SynchronizedFilteredCollection.filterSynchronized(this.backingPlayerList, player -> {
            if (!this.isRegisteredEntry(entry)) {
                return false;
            }
            return this.getPlayerPreference(player.getUniqueId(), module, entry);
        });
    }

    public Collection<Player> getPlayerList() {
        return Collections.unmodifiableCollection(this.backingPlayerList);
    }
}

