/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.interactionvisualizer.managers;

import com.loohp.interactionvisualizer.InteractionVisualizer;
import com.loohp.interactionvisualizer.api.InteractionVisualizerAPI;
import com.loohp.interactionvisualizer.entityholders.ArmorStand;
import com.loohp.interactionvisualizer.entityholders.DynamicVisualizerEntity;
import com.loohp.interactionvisualizer.entityholders.Item;
import com.loohp.interactionvisualizer.entityholders.ItemFrame;
import com.loohp.interactionvisualizer.entityholders.VisualizerEntity;
import com.loohp.interactionvisualizer.managers.PlayerLocationManager;
import com.loohp.interactionvisualizer.protocol.ServerPacketSender;
import com.loohp.interactionvisualizer.utils.LineOfSightUtils;
import com.loohp.interactionvisualizer.utils.LocationUtils;
import com.loohp.interactionvisualizer.utils.SyncUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public class PacketManager
implements Listener {
    private static final Vector VECTOR_ZERO = new Vector(0.0, 0.0, 0.0);
    private static final Plugin plugin = InteractionVisualizer.plugin;
    private static final Map<VisualizerEntity, Integer> cache = new ConcurrentHashMap<VisualizerEntity, Integer>();
    private static final Map<DynamicVisualizerEntity, Set<Player>> dynamicTracking = new ConcurrentHashMap<DynamicVisualizerEntity, Set<Player>>();
    public static Map<VisualizerEntity, Collection<Player>> active = new ConcurrentHashMap<VisualizerEntity, Collection<Player>>();
    public static Map<VisualizerEntity, Boolean> loaded = new ConcurrentHashMap<VisualizerEntity, Boolean>();
    public static Map<Player, Set<VisualizerEntity>> playerStatus = new ConcurrentHashMap<Player, Set<VisualizerEntity>>();

    public static void run() {
        if (!plugin.isEnabled()) {
            return;
        }
        InteractionVisualizer.asyncExecutorManager.runTaskAsynchronously(() -> {
            for (Map.Entry<VisualizerEntity, Boolean> entry : loaded.entrySet()) {
                ItemFrame frame;
                Collection<Player> players;
                VisualizerEntity entity = entry.getKey();
                if (entity instanceof ArmorStand) {
                    ArmorStand stand = (ArmorStand)entity;
                    if (!PlayerLocationManager.hasPlayerNearby(stand.getLocation())) continue;
                    if (entry.getValue().booleanValue()) {
                        players = active.get(entity);
                        if (players == null) continue;
                        SyncUtils.runAsyncWithSyncCondition(() -> LocationUtils.isLoaded(stand.getLocation()) && PacketManager.isOccluding(stand.getLocation().getBlock().getType()), 200L, () -> {
                            if (active.containsKey(entity)) {
                                PacketManager.removeArmorStand(InteractionVisualizerAPI.getPlayers(), stand, false, false);
                                loaded.put(entity, false);
                            }
                        });
                        continue;
                    }
                    players = active.get(entity);
                    if (players == null) continue;
                    SyncUtils.runAsyncWithSyncCondition(() -> LocationUtils.isLoaded(stand.getLocation()) && !PacketManager.isOccluding(stand.getLocation().getBlock().getType()), 200L, () -> {
                        if (active.containsKey(entity)) {
                            PacketManager.sendArmorStandSpawn(players, stand);
                            PacketManager.updateArmorStand(stand);
                            loaded.put(entity, true);
                        }
                    });
                    continue;
                }
                if (entity instanceof Item) {
                    Item item = (Item)entity;
                    if (!PlayerLocationManager.hasPlayerNearby(item.getLocation())) continue;
                    if (entry.getValue().booleanValue()) {
                        players = active.get(entity);
                        if (players == null) continue;
                        if (item.getVelocity().equals((Object)VECTOR_ZERO) && !item.hasGravity()) {
                            PacketManager.updateItemAsync(item, true);
                        }
                        SyncUtils.runAsyncWithSyncCondition(() -> LocationUtils.isLoaded(item.getLocation()) && PacketManager.isOccluding(item.getLocation().getBlock().getType()), 200L, () -> {
                            if (active.containsKey(entity)) {
                                PacketManager.removeItem(InteractionVisualizerAPI.getPlayers(), item, false, false);
                                loaded.put(entity, false);
                            }
                        });
                        continue;
                    }
                    players = active.get(entity);
                    if (players == null) continue;
                    SyncUtils.runAsyncWithSyncCondition(() -> LocationUtils.isLoaded(item.getLocation()) && !PacketManager.isOccluding(item.getLocation().getBlock().getType()), 200L, () -> {
                        if (active.containsKey(entity)) {
                            PacketManager.sendItemSpawn(players, item);
                            PacketManager.updateItem(item);
                            loaded.put(entity, true);
                        }
                    });
                    continue;
                }
                if (!(entity instanceof ItemFrame) || !PlayerLocationManager.hasPlayerNearby((frame = (ItemFrame)entity).getLocation())) continue;
                if (entry.getValue().booleanValue()) {
                    players = active.get(entity);
                    if (players == null) continue;
                    SyncUtils.runAsyncWithSyncCondition(() -> LocationUtils.isLoaded(frame.getLocation()) && PacketManager.isOccluding(frame.getLocation().getBlock().getType()), 200L, () -> {
                        if (active.containsKey(entity)) {
                            PacketManager.removeItemFrame(InteractionVisualizerAPI.getPlayers(), frame, false, false);
                            loaded.put(entity, false);
                        }
                    });
                    continue;
                }
                players = active.get(entity);
                if (players == null) continue;
                SyncUtils.runAsyncWithSyncCondition(() -> LocationUtils.isLoaded(frame.getLocation()) && !PacketManager.isOccluding(frame.getLocation().getBlock().getType()), 200L, () -> {
                    if (active.containsKey(entity)) {
                        PacketManager.sendItemFrameSpawn(players, frame);
                        PacketManager.updateItemFrame(frame);
                        loaded.put(entity, true);
                    }
                });
            }
            try {
                TimeUnit.MILLISECONDS.sleep(5L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            PacketManager.run();
        });
    }

    public static void dynamicEntity() {
        Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)InteractionVisualizer.plugin, () -> {
            Iterator<DynamicVisualizerEntity> itr = dynamicTracking.keySet().iterator();
            while (itr.hasNext()) {
                DynamicVisualizerEntity entity = itr.next();
                Set<Player> players = dynamicTracking.get(entity);
                if (players == null || players.isEmpty()) {
                    itr.remove();
                    continue;
                }
                Iterator<Player> itr2 = players.iterator();
                while (itr2.hasNext()) {
                    Player player = itr2.next();
                    Location location = player.getEyeLocation();
                    if (!location.getWorld().equals(entity.getWorld())) {
                        itr2.remove();
                        continue;
                    }
                    ServerPacketSender.teleportEntity(player, entity.getEntityId(), entity.getViewingLocation(location, location.getDirection()));
                }
            }
        }, 0L, 2L);
    }

    private static boolean isOccluding(Material material) {
        if (InteractionVisualizer.exemptBlocks.contains(material.toString().toUpperCase())) {
            return false;
        }
        return material.isOccluding();
    }

    public static void update() {
        if (!plugin.isEnabled()) {
            return;
        }
        InteractionVisualizer.asyncExecutorManager.runTaskAsynchronously(() -> {
            for (Player player : Bukkit.getOnlinePlayers()) {
                try {
                    Set<VisualizerEntity> activeList = playerStatus.get(player);
                    if (activeList == null) continue;
                    HashSet<Player> playerList = new HashSet<Player>();
                    playerList.add(player);
                    Location playerLocation = PlayerLocationManager.getPlayerLocation(player);
                    Location playerEyeLocation = PlayerLocationManager.getPlayerEyeLocation(player);
                    for (Map.Entry<VisualizerEntity, Collection<Player>> entry : active.entrySet()) {
                        ItemFrame frame;
                        Item item;
                        ArmorStand stand;
                        VisualizerEntity entity = entry.getKey();
                        int range = InteractionVisualizer.playerTrackingRange.getOrDefault(entity.getWorld(), 64);
                        range *= range;
                        boolean playerActive = activeList.contains(entity);
                        boolean sameWorld = entity.getWorld().equals(playerLocation.getWorld());
                        boolean inRange = sameWorld && entity.getLocation().distanceSquared(playerLocation) <= (double)range;
                        Boolean hasLineOfSight = InteractionVisualizer.hideIfObstructed ? null : Boolean.valueOf(true);
                        boolean isLoaded = loaded.getOrDefault(entity, false);
                        Location entityCenter = entity.getLocation();
                        entityCenter.setY(entityCenter.getY() + (entity instanceof Item ? entity.getHeight() * 1.7 : entity.getHeight() * 0.7));
                        if (!(!playerActive || sameWorld && inRange && (hasLineOfSight != null ? hasLineOfSight : (hasLineOfSight = Boolean.valueOf(LineOfSightUtils.hasLineOfSight(playerEyeLocation, entityCenter)))).booleanValue())) {
                            if (entity instanceof ArmorStand) {
                                stand = (ArmorStand)entity;
                                PacketManager.removeArmorStand(playerList, stand, false, true);
                                continue;
                            }
                            if (entity instanceof Item) {
                                item = (Item)entity;
                                PacketManager.removeItem(playerList, item, false, true);
                                continue;
                            }
                            if (!(entity instanceof ItemFrame)) continue;
                            frame = (ItemFrame)entity;
                            PacketManager.removeItemFrame(playerList, frame, false, true);
                            continue;
                        }
                        if (playerActive || !entry.getValue().contains(player) || !isLoaded || !sameWorld || !inRange || !(hasLineOfSight != null ? hasLineOfSight : (hasLineOfSight = Boolean.valueOf(LineOfSightUtils.hasLineOfSight(playerEyeLocation, entityCenter)))).booleanValue()) continue;
                        if (entity instanceof ArmorStand) {
                            stand = (ArmorStand)entity;
                            PacketManager.sendArmorStandSpawn(playerList, stand);
                            PacketManager.updateArmorStand(playerList, stand);
                            continue;
                        }
                        if (entity instanceof Item) {
                            item = (Item)entity;
                            PacketManager.sendItemSpawn(playerList, item);
                            PacketManager.updateItem(playerList, item);
                            continue;
                        }
                        if (!(entity instanceof ItemFrame)) continue;
                        frame = (ItemFrame)entity;
                        PacketManager.sendItemFrameSpawn(playerList, frame);
                        PacketManager.updateItemFrame(playerList, frame);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            try {
                TimeUnit.MILLISECONDS.sleep(5L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            PacketManager.update();
        });
    }

    public static void sendHandMovement(Collection<Player> players, Player entity) {
        if (!plugin.isEnabled()) {
            return;
        }
        InteractionVisualizer.asyncExecutorManager.runTaskAsynchronously(() -> {
            Collection<Player> playersInRange = PlayerLocationManager.filterOutOfRange(players, (Entity)entity);
            ServerPacketSender.sendHandMovement(playersInRange, entity);
        });
    }

    public static void sendArmorStandSpawn(Collection<Player> players, ArmorStand entity) {
        if (!active.containsKey(entity)) {
            active.put(entity, players);
            loaded.put(entity, true);
        }
        if (!plugin.isEnabled()) {
            return;
        }
        InteractionVisualizer.asyncExecutorManager.runTaskAsynchronously(() -> {
            Collection<Player> playersInRange = PlayerLocationManager.filterOutOfRange(players, entity);
            ServerPacketSender.spawnArmorStand(playersInRange, entity);
            playersInRange.forEach(each -> {
                Set<VisualizerEntity> list = playerStatus.get(each);
                if (list != null) {
                    list.add(entity);
                }
            });
            if (entity instanceof DynamicVisualizerEntity) {
                boolean absent = false;
                Set<Object> tracking = dynamicTracking.get((DynamicVisualizerEntity)((Object)entity));
                if (tracking == null) {
                    tracking = Collections.newSetFromMap(new ConcurrentHashMap());
                    absent = true;
                }
                tracking.addAll(playersInRange);
                if (absent) {
                    dynamicTracking.put((DynamicVisualizerEntity)((Object)entity), tracking);
                }
            }
        });
    }

    public static void updateArmorStand(ArmorStand entity) {
        Collection<Player> players = active.get(entity);
        if (players == null) {
            return;
        }
        PacketManager.updateArmorStand(players, entity);
    }

    public static void updateArmorStand(Collection<Player> players, ArmorStand entity) {
        PacketManager.updateArmorStand(players, entity, false);
    }

    public static void updateArmorStand(Collection<Player> players, ArmorStand entity, boolean bypasscache) {
        Integer lastCode;
        if (!bypasscache && (lastCode = cache.get(entity)) != null && lastCode.intValue() == entity.cacheCode()) {
            return;
        }
        if (!plugin.isEnabled()) {
            return;
        }
        InteractionVisualizer.asyncExecutorManager.runTaskAsynchronously(() -> {
            Collection<Player> playersInRange = PlayerLocationManager.filterOutOfRange(players, entity);
            ServerPacketSender.updateArmorStand(playersInRange, entity);
        });
        cache.put(entity, entity.cacheCode());
    }

    public static void updateArmorStandOnlyMeta(ArmorStand entity) {
        Collection<Player> players = active.get(entity);
        if (players == null) {
            return;
        }
        PacketManager.updateArmorStandOnlyMeta(players, entity);
    }

    public static void updateArmorStandOnlyMeta(Collection<Player> players, ArmorStand entity) {
        PacketManager.updateArmorStandOnlyMeta(players, entity, false);
    }

    public static void updateArmorStandOnlyMeta(Collection<Player> players, ArmorStand entity, boolean bypasscache) {
        Integer lastCode;
        if (!bypasscache && (lastCode = cache.get(entity)) != null && lastCode.intValue() == entity.cacheCode()) {
            return;
        }
        if (!plugin.isEnabled()) {
            return;
        }
        InteractionVisualizer.asyncExecutorManager.runTaskAsynchronously(() -> {
            Collection<Player> playersInRange = PlayerLocationManager.filterOutOfRange(players, entity);
            ServerPacketSender.updateArmorStandOnlyMeta(playersInRange, entity);
        });
        cache.put(entity, entity.cacheCode());
    }

    public static void removeArmorStand(Collection<Player> players, ArmorStand entity, boolean removeFromActive, boolean bypassFilter) {
        if (removeFromActive) {
            active.remove(entity);
            loaded.remove(entity);
            cache.remove(entity);
        }
        if (!plugin.isEnabled()) {
            return;
        }
        InteractionVisualizer.asyncExecutorManager.runTaskAsynchronously(() -> {
            Set<Player> tracking;
            Collection<Player> playersInRange = bypassFilter ? players : PlayerLocationManager.filterOutOfRange(players, entity);
            ServerPacketSender.removeArmorStand(playersInRange, entity);
            playersInRange.forEach(each -> {
                Set<VisualizerEntity> list = playerStatus.get(each);
                if (list != null) {
                    list.remove(entity);
                }
            });
            if (entity instanceof DynamicVisualizerEntity && (tracking = dynamicTracking.get((DynamicVisualizerEntity)((Object)entity))) != null) {
                tracking.removeAll(playersInRange);
            }
        });
    }

    public static void removeArmorStand(Collection<Player> players, ArmorStand entity) {
        PacketManager.removeArmorStand(players, entity, true, false);
    }

    public static void sendItemSpawn(Collection<Player> players, Item entity) {
        if (!active.containsKey(entity)) {
            active.put(entity, players);
            loaded.put(entity, true);
        }
        if (entity.getItemStack().getType().equals((Object)Material.AIR)) {
            return;
        }
        if (!plugin.isEnabled()) {
            return;
        }
        InteractionVisualizer.asyncExecutorManager.runTaskAsynchronously(() -> {
            Collection<Player> playersInRange = PlayerLocationManager.filterOutOfRange(players, entity);
            ServerPacketSender.spawnItem(playersInRange, entity);
            playersInRange.forEach(each -> {
                Set<VisualizerEntity> list = playerStatus.get(each);
                if (list != null) {
                    list.add(entity);
                }
            });
        });
    }

    public static void updateItem(Item entity) {
        Collection<Player> players = active.get(entity);
        if (players == null) {
            return;
        }
        PacketManager.updateItem(players, entity);
    }

    public static void updateItem(Collection<Player> players, Item entity) {
        PacketManager.updateItem(players, entity, false);
    }

    public static void updateItem(Collection<Player> players, Item entity, boolean bypasscache) {
        Integer lastCode;
        if (!bypasscache && (lastCode = cache.get(entity)) != null && lastCode.intValue() == entity.cacheCode()) {
            return;
        }
        if (!plugin.isEnabled()) {
            return;
        }
        InteractionVisualizer.asyncExecutorManager.runTaskAsynchronously(() -> {
            Collection<Player> playersInRange = PlayerLocationManager.filterOutOfRange(players, entity);
            ServerPacketSender.updateItem(playersInRange, entity);
        });
        cache.put(entity, entity.cacheCode());
    }

    public static void updateItemAsync(Item entity, boolean bypasscache) {
        Collection<Player> players = active.get(entity);
        if (players == null) {
            return;
        }
        PacketManager.updateItemAsync(players, entity, bypasscache);
    }

    public static void updateItemAsync(Collection<Player> players, Item entity, boolean bypasscache) {
        Integer lastCode;
        if (!bypasscache && (lastCode = cache.get(entity)) != null && lastCode.intValue() == entity.cacheCode()) {
            return;
        }
        if (!plugin.isEnabled()) {
            return;
        }
        Runnable task = () -> {
            Collection<Player> playersInRange = PlayerLocationManager.filterOutOfRange(players, entity);
            ServerPacketSender.updateItemAsync(playersInRange, entity);
        };
        if (InteractionVisualizer.allPacketsSync) {
            Bukkit.getScheduler().runTask(plugin, task);
        } else {
            InteractionVisualizer.asyncExecutorManager.runTaskAsynchronously(task);
        }
        cache.put(entity, entity.cacheCode());
    }

    public static void removeItem(Collection<Player> players, Item entity, boolean removeFromActive, boolean bypassFilter) {
        if (entity.getItemStack().getType().equals((Object)Material.AIR)) {
            return;
        }
        if (removeFromActive) {
            active.remove(entity);
            loaded.remove(entity);
            cache.remove(entity);
        }
        if (!plugin.isEnabled()) {
            return;
        }
        InteractionVisualizer.asyncExecutorManager.runTaskAsynchronously(() -> {
            Collection<Player> playersInRange = bypassFilter ? players : PlayerLocationManager.filterOutOfRange(players, entity);
            ServerPacketSender.removeItem(playersInRange, entity);
            playersInRange.forEach(each -> {
                Set<VisualizerEntity> list = playerStatus.get(each);
                if (list != null) {
                    list.remove(entity);
                }
            });
        });
    }

    public static void removeItem(Collection<Player> players, Item entity) {
        PacketManager.removeItem(players, entity, true, false);
    }

    public static void sendItemFrameSpawn(Collection<Player> players, ItemFrame entity) {
        if (!active.containsKey(entity)) {
            active.put(entity, players);
            loaded.put(entity, true);
        }
        if (!plugin.isEnabled()) {
            return;
        }
        InteractionVisualizer.asyncExecutorManager.runTaskAsynchronously(() -> {
            Collection<Player> playersInRange = PlayerLocationManager.filterOutOfRange(players, entity);
            ServerPacketSender.spawnItemFrame(playersInRange, entity);
            playersInRange.forEach(each -> {
                Set<VisualizerEntity> list = playerStatus.get(each);
                if (list != null) {
                    list.add(entity);
                }
            });
        });
    }

    public static void updateItemFrame(ItemFrame entity) {
        Collection<Player> players = active.get(entity);
        if (players == null) {
            return;
        }
        PacketManager.updateItemFrame(players, entity);
    }

    public static void updateItemFrame(Collection<Player> players, ItemFrame entity) {
        PacketManager.updateItemFrame(players, entity, false);
    }

    public static void updateItemFrame(Collection<Player> players, ItemFrame entity, boolean bypasscache) {
        Integer lastCode;
        if (!bypasscache && (lastCode = cache.get(entity)) != null && lastCode.intValue() == entity.cacheCode()) {
            return;
        }
        if (!plugin.isEnabled()) {
            return;
        }
        InteractionVisualizer.asyncExecutorManager.runTaskAsynchronously(() -> {
            Collection<Player> playersInRange = PlayerLocationManager.filterOutOfRange(players, entity);
            ServerPacketSender.updateItemFrame(playersInRange, entity);
        });
        cache.put(entity, entity.cacheCode());
    }

    public static void removeItemFrame(Collection<Player> players, ItemFrame entity, boolean removeFromActive, boolean bypassFilter) {
        if (removeFromActive) {
            active.remove(entity);
            loaded.remove(entity);
            cache.remove(entity);
        }
        if (!plugin.isEnabled()) {
            return;
        }
        InteractionVisualizer.asyncExecutorManager.runTaskAsynchronously(() -> {
            Collection<Player> playersInRange = bypassFilter ? players : PlayerLocationManager.filterOutOfRange(players, entity);
            ServerPacketSender.removeItemFrame(playersInRange, entity);
            playersInRange.forEach(each -> {
                Set<VisualizerEntity> list = playerStatus.get(each);
                if (list != null) {
                    list.remove(entity);
                }
            });
        });
    }

    public static void removeItemFrame(Collection<Player> players, ItemFrame entity) {
        PacketManager.removeItemFrame(players, entity, true, false);
    }

    public static void reset(Player theplayer) {
        Bukkit.getScheduler().runTask(plugin, () -> PacketManager.removeAll(theplayer));
        int delay = 10 + (int)Math.ceil((double)active.size() / 5.0);
        Bukkit.getScheduler().runTaskLater(plugin, () -> PacketManager.sendPlayerPackets(theplayer), (long)delay);
    }

    public static void removeAll(Player theplayer) {
        playerStatus.put(theplayer, Collections.newSetFromMap(new ConcurrentHashMap()));
        if (!plugin.isEnabled()) {
            return;
        }
        InteractionVisualizer.asyncExecutorManager.runTaskAsynchronously(() -> {
            HashSet<Player> player = new HashSet<Player>();
            player.add(theplayer);
            int count = 0;
            int delay = 1;
            for (Map.Entry<VisualizerEntity, Collection<Player>> entry : active.entrySet()) {
                VisualizerEntity entity;
                if (++count > 5) {
                    ++delay;
                    count = 0;
                }
                if ((entity = entry.getKey()) instanceof ArmorStand) {
                    Bukkit.getScheduler().runTaskLater(plugin, () -> PacketManager.removeArmorStand(player, (ArmorStand)entity, false, false), (long)delay);
                }
                if (entity instanceof Item) {
                    Bukkit.getScheduler().runTaskLater(plugin, () -> PacketManager.removeItem(player, (Item)entity, false, false), (long)delay);
                }
                if (!(entity instanceof ItemFrame)) continue;
                Bukkit.getScheduler().runTaskLater(plugin, () -> PacketManager.removeItemFrame(player, (ItemFrame)entity, false, false), (long)delay);
            }
        });
    }

    public static void sendPlayerPackets(Player theplayer) {
        playerStatus.put(theplayer, Collections.newSetFromMap(new ConcurrentHashMap()));
        if (!plugin.isEnabled()) {
            return;
        }
        InteractionVisualizer.asyncExecutorManager.runTaskAsynchronously(() -> {
            HashSet<Player> player = new HashSet<Player>();
            player.add(theplayer);
            int count = 0;
            int delay = 1;
            for (Map.Entry<VisualizerEntity, Collection<Player>> entry : active.entrySet()) {
                Boolean isLoaded;
                VisualizerEntity entity = entry.getKey();
                if (!entry.getValue().contains(theplayer) || (isLoaded = loaded.get(entity)) == null || !isLoaded.booleanValue()) continue;
                if (++count > 5) {
                    ++delay;
                    count = 0;
                }
                if (entity instanceof ArmorStand) {
                    Bukkit.getScheduler().runTaskLater(plugin, () -> {
                        PacketManager.sendArmorStandSpawn(player, (ArmorStand)entity);
                        PacketManager.updateArmorStand(player, (ArmorStand)entity, true);
                    }, (long)delay);
                }
                if (entity instanceof Item) {
                    Bukkit.getScheduler().runTaskLater(plugin, () -> {
                        PacketManager.sendItemSpawn(player, (Item)entity);
                        PacketManager.updateItem(player, (Item)entity, true);
                    }, (long)delay);
                }
                if (!(entity instanceof ItemFrame)) continue;
                Bukkit.getScheduler().runTaskLater(plugin, () -> {
                    PacketManager.sendItemFrameSpawn(player, (ItemFrame)entity);
                    PacketManager.updateItemFrame(player, (ItemFrame)entity, true);
                }, (long)delay);
            }
        });
    }

    @EventHandler
    public void onJoin(PlayerJoinEvent event) {
        playerStatus.put(event.getPlayer(), Collections.newSetFromMap(new ConcurrentHashMap()));
    }

    @EventHandler
    public void onWorldChange(PlayerChangedWorldEvent event) {
        playerStatus.put(event.getPlayer(), Collections.newSetFromMap(new ConcurrentHashMap()));
    }

    @EventHandler
    public void onLeave(PlayerQuitEvent event) {
        playerStatus.remove(event.getPlayer());
    }
}

