/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.interactionvisualizer.managers;

import com.loohp.interactionvisualizer.InteractionVisualizer;
import com.loohp.interactionvisualizer.config.Config;
import com.loohp.interactionvisualizer.libs.com.loohp.yamlconfiguration.YamlConfiguration;
import java.io.File;
import java.io.IOException;
import java.util.EnumSet;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.plugin.Plugin;

public class MaterialManager {
    public static final String MATERIAL_CONFIG_ID = "material";
    public static YamlConfiguration config;
    public static File file;
    private static Set<Material> tools;
    private static Set<Material> standing;
    private static Set<Material> lowblocks;
    private static Set<Material> blockexceptions;
    private static Set<Material> nonSolid;

    public static void setup() {
        if (!InteractionVisualizer.plugin.getDataFolder().exists()) {
            InteractionVisualizer.plugin.getDataFolder().mkdir();
        }
        try {
            Config.loadConfig(MATERIAL_CONFIG_ID, new File(InteractionVisualizer.plugin.getDataFolder(), "material.yml"), ((Object)((Object)InteractionVisualizer.plugin)).getClass().getClassLoader().getResourceAsStream("material.yml"), ((Object)((Object)InteractionVisualizer.plugin)).getClass().getClassLoader().getResourceAsStream("material.yml"), true);
        }
        catch (IOException e) {
            e.printStackTrace();
            Bukkit.getPluginManager().disablePlugin((Plugin)InteractionVisualizer.plugin);
            return;
        }
        MaterialManager.reload();
    }

    public static YamlConfiguration getMaterialConfig() {
        return Config.getConfig(MATERIAL_CONFIG_ID).getConfiguration();
    }

    public static void saveConfig() {
        Config.getConfig(MATERIAL_CONFIG_ID).save();
    }

    public static void reloadConfig() {
        Config.getConfig(MATERIAL_CONFIG_ID).reload();
        MaterialManager.reload();
    }

    public static void reload() {
        MaterialManager.getTools().clear();
        MaterialManager.getBlockexceptions().clear();
        MaterialManager.getStanding().clear();
        MaterialManager.getLowblocks().clear();
        MaterialManager.getNonSolid().clear();
        for (String material : MaterialManager.getMaterialConfig().getStringList("Tools")) {
            try {
                MaterialManager.getTools().add(Material.valueOf((String)material));
            }
            catch (Exception exception) {}
        }
        for (String material : MaterialManager.getMaterialConfig().getStringList("BlockExceptions")) {
            try {
                MaterialManager.getBlockexceptions().add(Material.valueOf((String)material));
            }
            catch (Exception exception) {}
        }
        for (String material : MaterialManager.getMaterialConfig().getStringList("Standing")) {
            try {
                MaterialManager.getStanding().add(Material.valueOf((String)material));
            }
            catch (Exception exception) {}
        }
        for (String material : MaterialManager.getMaterialConfig().getStringList("LowBlocks")) {
            try {
                MaterialManager.getLowblocks().add(Material.valueOf((String)material));
            }
            catch (Exception exception) {}
        }
        for (Material material : Material.values()) {
            if (!material.isBlock() || material.isSolid()) continue;
            MaterialManager.getNonSolid().add(material);
        }
    }

    public static Set<Material> getTools() {
        return tools;
    }

    public static void setTools(EnumSet<Material> tools) {
        MaterialManager.tools = tools;
    }

    public static Set<Material> getStanding() {
        return standing;
    }

    public static void setStanding(Set<Material> standing) {
        if (standing instanceof EnumSet) {
            MaterialManager.standing = EnumSet.copyOf(standing);
        } else {
            MaterialManager.standing = EnumSet.noneOf(Material.class);
            MaterialManager.standing.addAll(standing);
        }
    }

    public static Set<Material> getLowblocks() {
        return lowblocks;
    }

    public static void setLowblocks(Set<Material> lowblocks) {
        if (lowblocks instanceof EnumSet) {
            MaterialManager.lowblocks = EnumSet.copyOf(lowblocks);
        } else {
            MaterialManager.lowblocks = EnumSet.noneOf(Material.class);
            MaterialManager.lowblocks.addAll(lowblocks);
        }
    }

    public static Set<Material> getBlockexceptions() {
        return blockexceptions;
    }

    public static void setBlockexceptions(Set<Material> blockexceptions) {
        if (blockexceptions instanceof EnumSet) {
            MaterialManager.blockexceptions = EnumSet.copyOf(blockexceptions);
        } else {
            MaterialManager.blockexceptions = EnumSet.noneOf(Material.class);
            MaterialManager.blockexceptions.addAll(blockexceptions);
        }
    }

    public static Set<Material> getNonSolid() {
        return nonSolid;
    }

    public static void setNonSolid(Set<Material> nonSolid) {
        if (nonSolid instanceof EnumSet) {
            MaterialManager.nonSolid = EnumSet.copyOf(nonSolid);
        } else {
            MaterialManager.nonSolid = EnumSet.noneOf(Material.class);
            MaterialManager.nonSolid.addAll(nonSolid);
        }
    }

    static {
        tools = EnumSet.noneOf(Material.class);
        standing = EnumSet.noneOf(Material.class);
        lowblocks = EnumSet.noneOf(Material.class);
        blockexceptions = EnumSet.noneOf(Material.class);
        nonSolid = EnumSet.noneOf(Material.class);
    }
}

