/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.interactionvisualizer.managers;

import com.loohp.interactionvisualizer.InteractionVisualizer;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;

public class AsyncExecutorManager
implements AutoCloseable {
    private final ExecutorService executor;
    private final AtomicBoolean valid;

    public AsyncExecutorManager(ExecutorService executor) {
        this.executor = executor;
        this.valid = new AtomicBoolean(true);
    }

    public void runTaskAsynchronously(Runnable runnable) {
        if (!this.valid.get()) {
            return;
        }
        this.executor.submit(runnable);
    }

    public void runTaskLaterAsynchronously(Runnable runnable, long delay) {
        if (!this.valid.get()) {
            return;
        }
        Bukkit.getScheduler().runTaskLater((Plugin)InteractionVisualizer.plugin, () -> this.runTaskAsynchronously(runnable), delay);
    }

    public boolean isValid() {
        return this.valid.get();
    }

    @Override
    public void close() {
        if (!this.valid.get()) {
            return;
        }
        this.executor.shutdown();
    }
}

