/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.interactionvisualizer.libs.org.awaitility.reflect;

import com.loohp.interactionvisualizer.libs.org.awaitility.reflect.FieldMatcherStrategy;
import com.loohp.interactionvisualizer.libs.org.awaitility.reflect.exception.FieldNotFoundException;
import java.lang.reflect.Field;

class FieldNameAndTypeMatcherStrategy
extends FieldMatcherStrategy {
    private final String fieldName;
    private final Class<?> fieldType;

    public FieldNameAndTypeMatcherStrategy(String fieldName, Class<?> type) {
        if (fieldName == null || fieldName.equals("") || fieldName.startsWith(" ")) {
            throw new IllegalArgumentException("field name cannot be null.");
        }
        if (type == null) {
            throw new IllegalArgumentException("type cannot be null.");
        }
        this.fieldName = fieldName;
        this.fieldType = type;
    }

    @Override
    public boolean matches(Field field) {
        return this.fieldName.equals(field.getName()) && this.fieldType.equals(field.getType());
    }

    @Override
    public void notFound(Class<?> type, boolean isInstanceField) throws FieldNotFoundException {
        throw new FieldNotFoundException(String.format("No %s field with name \"%s\" and type \"%s\" could be found in the class hierarchy of %s.", isInstanceField ? "instance" : "static", this.fieldName, this.fieldType.getName(), type.getName()));
    }

    public String toString() {
        return "fieldName " + this.fieldName + ", fieldType = " + this.fieldType.getName();
    }
}

