/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.interactionvisualizer.libs.org.awaitility.core;

import com.loohp.interactionvisualizer.libs.org.awaitility.core.EvaluationCleanup;
import com.loohp.interactionvisualizer.libs.org.awaitility.core.Uninterruptibles;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Supplier;

public class ExecutorLifecycle {
    private final Supplier<ExecutorService> executorServiceSupplier;
    private final EvaluationCleanup evaluationCleanup;

    private ExecutorLifecycle(Supplier<ExecutorService> executorServiceSupplier, EvaluationCleanup evaluationCleanup) {
        this.executorServiceSupplier = executorServiceSupplier;
        this.evaluationCleanup = evaluationCleanup;
    }

    public static ExecutorLifecycle withoutCleanup(ExecutorService executorService) {
        return ExecutorLifecycle.withoutCleanup(() -> executorService);
    }

    public static ExecutorLifecycle withoutCleanup(Supplier<ExecutorService> executorServiceSupplier) {
        return new ExecutorLifecycle(executorServiceSupplier, ExecutorLifecycle.noCleanup());
    }

    public static ExecutorLifecycle withNormalCleanupBehavior(Supplier<ExecutorService> executorServiceSupplier) {
        return new ExecutorLifecycle(executorServiceSupplier, ExecutorLifecycle.normalCleanupBehavior());
    }

    public ExecutorService supplyExecutorService() {
        return this.executorServiceSupplier.get();
    }

    void executeNormalCleanupBehavior(ExecutorService executorService) {
        this.evaluationCleanup.executeNormalCleanupBehavior(executorService);
    }

    void executeUnexpectedCleanupBehavior(ExecutorService executorService) {
        this.evaluationCleanup.executeUnexpectedCleanupBehavior(executorService);
    }

    private static EvaluationCleanup noCleanup() {
        Consumer<ExecutorService> noop = executorService -> {};
        return new EvaluationCleanup(noop, noop);
    }

    private static EvaluationCleanup normalCleanupBehavior() {
        return new EvaluationCleanup(executor -> Uninterruptibles.shutdownUninterruptibly(executor, 1L, TimeUnit.SECONDS), ExecutorService::shutdownNow);
    }
}

