/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.interactionvisualizer.libs.com.loohp.yamlconfiguration.libs.com.amihaiemil.eoyaml.extensions;

import com.loohp.interactionvisualizer.libs.com.loohp.yamlconfiguration.libs.com.amihaiemil.eoyaml.BaseYamlSequence;
import com.loohp.interactionvisualizer.libs.com.loohp.yamlconfiguration.libs.com.amihaiemil.eoyaml.Comment;
import com.loohp.interactionvisualizer.libs.com.loohp.yamlconfiguration.libs.com.amihaiemil.eoyaml.Yaml;
import com.loohp.interactionvisualizer.libs.com.loohp.yamlconfiguration.libs.com.amihaiemil.eoyaml.YamlNode;
import com.loohp.interactionvisualizer.libs.com.loohp.yamlconfiguration.libs.com.amihaiemil.eoyaml.YamlSequence;
import com.loohp.interactionvisualizer.libs.com.loohp.yamlconfiguration.libs.com.amihaiemil.eoyaml.YamlSequenceBuilder;
import java.util.Collection;
import java.util.Iterator;
import java.util.function.Supplier;

public final class MergedYamlSequence
extends BaseYamlSequence {
    private YamlSequence merged;

    public MergedYamlSequence(YamlSequence original, YamlSequence changed) {
        this(original, changed, false);
    }

    public MergedYamlSequence(YamlSequence original, Supplier<YamlSequence> changed) {
        this(original, changed, false);
    }

    public MergedYamlSequence(YamlSequence original, Supplier<YamlSequence> changed, boolean overrideIndices) {
        this(original, changed.get(), overrideIndices);
    }

    public MergedYamlSequence(YamlSequence original, YamlSequence changed, boolean overrideIndices) {
        if (original == null && changed == null) {
            throw new IllegalArgumentException("Both sequences cannot be null!");
        }
        this.merged = MergedYamlSequence.merge(original, changed, overrideIndices);
    }

    @Override
    public Collection<YamlNode> values() {
        return this.merged.values();
    }

    @Override
    public Comment comment() {
        return this.merged.comment();
    }

    private static YamlSequence merge(YamlSequence original, YamlSequence changed, boolean overrideIndices) {
        YamlSequence merged;
        if (original == null || original.size() == 0) {
            merged = changed;
        } else if (changed == null || changed.size() == 0) {
            merged = original;
        } else if (overrideIndices) {
            if (changed.size() >= original.size()) {
                merged = changed;
            } else {
                YamlSequenceBuilder builder = Yaml.createYamlSequenceBuilder();
                int continueFrom = -1;
                for (YamlNode node : changed) {
                    builder = builder.add(node);
                    ++continueFrom;
                }
                Iterator<YamlNode> originalIt = original.iterator();
                int originalIdx = -1;
                while (originalIt.hasNext()) {
                    if (originalIdx >= continueFrom) {
                        builder = builder.add(originalIt.next());
                    } else {
                        originalIt.next();
                    }
                    ++originalIdx;
                }
                merged = builder.build();
            }
        } else {
            YamlSequenceBuilder builder = Yaml.createYamlSequenceBuilder();
            for (YamlNode node : original) {
                builder = builder.add(node);
            }
            for (YamlNode node : changed) {
                builder = builder.add(node);
            }
            merged = builder.build();
        }
        return merged;
    }
}

