/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.interactionvisualizer.libs.com.loohp.yamlconfiguration.libs.com.amihaiemil.eoyaml;

import com.loohp.interactionvisualizer.libs.com.loohp.yamlconfiguration.libs.com.amihaiemil.eoyaml.BaseYamlNode;
import com.loohp.interactionvisualizer.libs.com.loohp.yamlconfiguration.libs.com.amihaiemil.eoyaml.ReadFoldedBlockScalar;
import com.loohp.interactionvisualizer.libs.com.loohp.yamlconfiguration.libs.com.amihaiemil.eoyaml.ReadLiteralBlockScalar;
import com.loohp.interactionvisualizer.libs.com.loohp.yamlconfiguration.libs.com.amihaiemil.eoyaml.ReadPlainScalar;
import com.loohp.interactionvisualizer.libs.com.loohp.yamlconfiguration.libs.com.amihaiemil.eoyaml.ReadYamlMapping;
import com.loohp.interactionvisualizer.libs.com.loohp.yamlconfiguration.libs.com.amihaiemil.eoyaml.ReadYamlSequence;
import com.loohp.interactionvisualizer.libs.com.loohp.yamlconfiguration.libs.com.amihaiemil.eoyaml.Skip;
import com.loohp.interactionvisualizer.libs.com.loohp.yamlconfiguration.libs.com.amihaiemil.eoyaml.YamlLine;
import com.loohp.interactionvisualizer.libs.com.loohp.yamlconfiguration.libs.com.amihaiemil.eoyaml.YamlLines;
import com.loohp.interactionvisualizer.libs.com.loohp.yamlconfiguration.libs.com.amihaiemil.eoyaml.YamlNode;
import com.loohp.interactionvisualizer.libs.com.loohp.yamlconfiguration.libs.com.amihaiemil.eoyaml.exceptions.YamlReadingException;
import java.util.Collection;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class AllYamlLines
implements YamlLines {
    private static final Pattern SEQUENCE_OR_MAP = Pattern.compile("^(([\\-](|[ ]+.*))|((?:('(?:[^'\\\\]|\\\\.)*')|(\"(?:[^\"\\\\]|\\\\.)*\")|([^\"']*)):(|[ ].*)))$");
    private Collection<YamlLine> lines;

    AllYamlLines(Collection<YamlLine> lines) {
        this.lines = lines;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (YamlLine line : this.lines) {
            builder.append(line.toString()).append(System.lineSeparator());
        }
        return builder.toString();
    }

    @Override
    public Collection<YamlLine> original() {
        return this.lines;
    }

    @Override
    public YamlNode toYamlNode(YamlLine prev, boolean guessIndentation) {
        YamlNode node;
        String prevLine = prev.trimmed();
        if (prevLine.isEmpty()) {
            node = this.mappingSequenceOrPlainScalar(prev, guessIndentation);
        } else {
            String lastChar = prevLine.substring(prevLine.length() - 1);
            node = prevLine.matches("^.+\\|[ ]*\\-$") ? new ReadYamlSequence(prev, this, guessIndentation) : (lastChar.equals("|") ? new ReadLiteralBlockScalar(prev, this) : (lastChar.equals(">") ? new ReadFoldedBlockScalar(prev, this) : this.mappingSequenceOrPlainScalar(prev, guessIndentation)));
        }
        return node;
    }

    @Override
    public Iterator<YamlLine> iterator() {
        return this.lines.iterator();
    }

    private YamlNode mappingSequenceOrPlainScalar(YamlLine prev, boolean guessIndentation) {
        BaseYamlNode node = null;
        YamlLine first = new Skip(this, line -> line.number() <= prev.number(), line -> line.trimmed().startsWith("#"), line -> line.trimmed().startsWith("---"), line -> line.trimmed().startsWith("..."), line -> line.trimmed().startsWith("%"), line -> line.trimmed().startsWith("!!")).iterator().next();
        Matcher matcher = SEQUENCE_OR_MAP.matcher(first.trimmed());
        if (matcher.matches()) {
            if (matcher.group(2) != null) {
                node = new ReadYamlSequence(prev, this, guessIndentation);
            } else if (matcher.group(4) != null) {
                node = new ReadYamlMapping(prev.number(), prev, this, guessIndentation);
            }
        } else if (this.original().size() == 1) {
            node = new ReadPlainScalar(this, first);
        }
        if (node == null) {
            throw new YamlReadingException("Could not parse YAML starting at line " + (first.number() + 1) + " . It should be a sequence (line should start with '-'), a mapping (line should contain ':') or it should be a plain scalar, but it has " + this.lines.size() + " lines, while a plain scalar should be only 1 line!");
        }
        return node;
    }
}

