/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.interactionvisualizer.libs.com.loohp.yamlconfiguration;

import com.loohp.interactionvisualizer.libs.com.loohp.yamlconfiguration.IConfigurationSection;
import com.loohp.interactionvisualizer.libs.com.loohp.yamlconfiguration.RootConfigurationSection;
import com.loohp.interactionvisualizer.libs.com.loohp.yamlconfiguration.libs.com.amihaiemil.eoyaml.Comment;
import com.loohp.interactionvisualizer.libs.com.loohp.yamlconfiguration.libs.com.amihaiemil.eoyaml.Scalar;
import com.loohp.interactionvisualizer.libs.com.loohp.yamlconfiguration.libs.com.amihaiemil.eoyaml.ScalarComment;
import com.loohp.interactionvisualizer.libs.com.loohp.yamlconfiguration.libs.com.amihaiemil.eoyaml.Yaml;
import com.loohp.interactionvisualizer.libs.com.loohp.yamlconfiguration.libs.com.amihaiemil.eoyaml.YamlMapping;
import com.loohp.interactionvisualizer.libs.com.loohp.yamlconfiguration.libs.com.amihaiemil.eoyaml.YamlNode;
import com.loohp.interactionvisualizer.libs.com.loohp.yamlconfiguration.libs.com.amihaiemil.eoyaml.YamlSequence;
import com.loohp.interactionvisualizer.libs.com.loohp.yamlconfiguration.libs.com.amihaiemil.eoyaml.YamlSequenceBuilder;
import com.loohp.interactionvisualizer.libs.com.loohp.yamlconfiguration.utils.UnicodeUtils;
import com.loohp.interactionvisualizer.libs.com.loohp.yamlconfiguration.utils.YamlConfigurationException;
import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class ConfigurationSection
implements IConfigurationSection {
    protected RootConfigurationSection root;
    protected String currentPath;
    protected YamlMapping currentMapping;

    public static ConfigurationSection newConfigurationSection() {
        return new RootConfigurationSection(Yaml.createYamlMappingBuilder().build());
    }

    public static ConfigurationSection newConfigurationSection(ConfigurationSection section) {
        return new RootConfigurationSection(section.currentMapping);
    }

    protected ConfigurationSection(RootConfigurationSection root, String currentPath, YamlMapping currentMapping) {
        this.root = root;
        this.currentPath = currentPath;
        this.currentMapping = currentMapping;
    }

    public boolean isRoot() {
        return false;
    }

    public boolean fromExistingYaml() {
        if (this.root == this) {
            return false;
        }
        return this.root.fromExistingYaml();
    }

    @Override
    public void set(String path, Object value) {
        this.root.set(this.toFullPath(path), value);
    }

    @Override
    public List<String> getKeys(boolean recursive) {
        if (recursive) {
            Set<YamlNode> keys = this.currentMapping.keys();
            ArrayList<String> recursiveKeys = new ArrayList<String>(keys.size());
            for (YamlNode node : keys) {
                String key = node.asScalar().value();
                recursiveKeys.add(key);
                if (!this.isConfigurationSection(key)) continue;
                recursiveKeys.addAll(this.getConfigurationSection(key).getKeys(true).stream().map(each -> key + "." + each).collect(Collectors.toList()));
            }
            return recursiveKeys;
        }
        return this.currentMapping.keys().stream().map(each -> each.asScalar().value()).collect(Collectors.toList());
    }

    @Override
    public Map<String, Object> getValues(boolean recursive) {
        LinkedHashMap<String, Object> mapping = new LinkedHashMap<String, Object>();
        for (String key : this.getKeys(recursive)) {
            if (this.isConfigurationSection(key)) {
                mapping.put(key, this.getConfigurationSection(key));
                continue;
            }
            if (this.isList(key)) {
                mapping.put(key, this.getList(key));
                continue;
            }
            mapping.put(key, this.get(key));
        }
        return mapping;
    }

    @Override
    public boolean contains(String path) {
        return this.getNode(path) != null;
    }

    @Override
    public void setAboveComment(String path, String comment) {
        this.root.setAboveComment(this.toFullPath(path), comment);
    }

    @Override
    public void setInlineComment(String path, String comment) {
        this.root.setInlineComment(this.toFullPath(path), comment);
    }

    @Override
    public String getAboveComment(String path) {
        YamlNode node = this.getNode(path);
        if (node == null) {
            return null;
        }
        return node.comment().value();
    }

    @Override
    public String getInlineComment(String path) {
        YamlNode node = this.getNode(path);
        if (node == null) {
            return null;
        }
        Comment comment = node.comment();
        if (comment instanceof ScalarComment) {
            return ((ScalarComment)comment).inline().value();
        }
        return "";
    }

    @Override
    public ConfigurationSection getConfigurationSection(String path) {
        YamlMapping mapping = this.getMapping(path);
        if (mapping == null) {
            return null;
        }
        return this.root.createOrGetSubsection(this.toFullPath(path), mapping);
    }

    @Override
    public boolean isConfigurationSection(String path) {
        return this.getMapping(path) != null;
    }

    @Override
    public Object get(String path, Object def) {
        YamlNode node = this.getNode(path);
        if (node instanceof Scalar) {
            return UnicodeUtils.unescape((Scalar)node);
        }
        if (node instanceof YamlSequence) {
            return this.getList(path);
        }
        if (node instanceof YamlMapping) {
            return this.getConfigurationSection(path);
        }
        return def;
    }

    @Override
    public String getString(String path, String def) {
        Scalar scalar = this.getScalar(path);
        return scalar == null ? def : UnicodeUtils.unescape(scalar);
    }

    @Override
    public boolean isString(String path) {
        return this.getScalar(path) != null;
    }

    @Override
    public int getInt(String path, int def) {
        Scalar scalar = this.getScalar(path);
        return scalar == null ? def : Integer.parseInt(scalar.value());
    }

    @Override
    public boolean isInt(String path) {
        Scalar scalar = this.getScalar(path);
        if (scalar == null) {
            return false;
        }
        try {
            Integer.parseInt(scalar.value());
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    @Override
    public boolean getBoolean(String path, boolean def) {
        Scalar scalar = this.getScalar(path);
        if (scalar == null) {
            return def;
        }
        if (scalar.value().equalsIgnoreCase("true")) {
            return true;
        }
        if (scalar.value().equalsIgnoreCase("false")) {
            return false;
        }
        return def;
    }

    @Override
    public boolean isBoolean(String path) {
        Scalar scalar = this.getScalar(path);
        if (scalar == null) {
            return false;
        }
        return scalar.value().equalsIgnoreCase("true") || scalar.value().equalsIgnoreCase("false");
    }

    @Override
    public double getDouble(String path, double def) {
        Scalar scalar = this.getScalar(path);
        return scalar == null ? def : Double.parseDouble(scalar.value());
    }

    @Override
    public boolean isDouble(String path) {
        Scalar scalar = this.getScalar(path);
        if (scalar == null) {
            return false;
        }
        try {
            Double.parseDouble(scalar.value());
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    @Override
    public long getLong(String path, long def) {
        Scalar scalar = this.getScalar(path);
        return scalar == null ? def : Long.parseLong(scalar.value());
    }

    @Override
    public boolean isLong(String path) {
        Scalar scalar = this.getScalar(path);
        if (scalar == null) {
            return false;
        }
        try {
            Long.parseLong(scalar.value());
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    @Override
    public boolean isList(String path) {
        return this.getSequence(path) != null;
    }

    @Override
    public List<Object> getList(String path) {
        YamlSequence sequence = this.getSequence(path);
        if (sequence == null) {
            return null;
        }
        return this.extractList(sequence);
    }

    @Override
    public List<String> getStringList(String path) {
        YamlSequence sequence = this.getSequence(path);
        if (sequence == null) {
            return null;
        }
        return sequence.values().stream().map(each -> UnicodeUtils.unescape(each.asScalar())).collect(Collectors.toList());
    }

    @Override
    public List<Integer> getIntegerList(String path) {
        YamlSequence sequence = this.getSequence(path);
        if (sequence == null) {
            return null;
        }
        return sequence.values().stream().map(each -> Integer.parseInt(each.asScalar().value())).collect(Collectors.toList());
    }

    @Override
    public List<Boolean> getBooleanList(String path) {
        YamlSequence sequence = this.getSequence(path);
        if (sequence == null) {
            return null;
        }
        return sequence.values().stream().map(each -> {
            String value = each.asScalar().value();
            if (value.equalsIgnoreCase("true")) {
                return true;
            }
            if (value.equalsIgnoreCase("false")) {
                return false;
            }
            throw new IllegalArgumentException(value + " is not a valid boolean!");
        }).collect(Collectors.toList());
    }

    @Override
    public List<Double> getDoubleList(String path) {
        YamlSequence sequence = this.getSequence(path);
        if (sequence == null) {
            return null;
        }
        return sequence.values().stream().map(each -> Double.parseDouble(each.asScalar().value())).collect(Collectors.toList());
    }

    @Override
    public List<Float> getFloatList(String path) {
        YamlSequence sequence = this.getSequence(path);
        if (sequence == null) {
            return null;
        }
        return sequence.values().stream().map(each -> Float.valueOf(Float.parseFloat(each.asScalar().value()))).collect(Collectors.toList());
    }

    @Override
    public List<Long> getLongList(String path) {
        YamlSequence sequence = this.getSequence(path);
        if (sequence == null) {
            return null;
        }
        return sequence.values().stream().map(each -> Long.parseLong(each.asScalar().value())).collect(Collectors.toList());
    }

    @Override
    public List<Byte> getByteList(String path) {
        YamlSequence sequence = this.getSequence(path);
        if (sequence == null) {
            return null;
        }
        return sequence.values().stream().map(each -> Byte.parseByte(each.asScalar().value())).collect(Collectors.toList());
    }

    @Override
    public List<Character> getCharacterList(String path) {
        YamlSequence sequence = this.getSequence(path);
        if (sequence == null) {
            return null;
        }
        return sequence.values().stream().map(each -> {
            String value = UnicodeUtils.unescape(each.asScalar());
            char[] chars = value.toCharArray();
            if (chars.length == 1) {
                return Character.valueOf(chars[0]);
            }
            throw new IllegalArgumentException(value + " is not a character");
        }).collect(Collectors.toList());
    }

    @Override
    public List<Short> getShortList(String path) {
        YamlSequence sequence = this.getSequence(path);
        if (sequence == null) {
            return null;
        }
        return sequence.values().stream().map(each -> Short.parseShort(each.asScalar().value())).collect(Collectors.toList());
    }

    @Override
    public String saveToString() {
        StringWriter writer = new StringWriter();
        try {
            Yaml.createYamlPrinter(writer).print(this.currentMapping);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return writer.toString();
    }

    protected void toSubsection(RootConfigurationSection root, String currentPath) {
    }

    public String toString() {
        return this.getValues(true).toString();
    }

    protected YamlNode getNode(String path) {
        try {
            String[] paths = this.toPathArray(path);
            YamlNode node = this.currentMapping;
            for (String p : paths) {
                if (!(node instanceof YamlMapping)) {
                    return null;
                }
                node = node.asMapping().value(p);
            }
            return node;
        }
        catch (Throwable e) {
            throw new YamlConfigurationException("There is a problem while reading yaml node at \"" + path + "\"", e);
        }
    }

    protected Scalar getScalar(String path) {
        YamlNode node = this.getNode(path);
        if (!(node instanceof Scalar)) {
            return null;
        }
        return node.asScalar();
    }

    protected YamlSequence getSequence(String path) {
        YamlNode node = this.getNode(path);
        if (!(node instanceof YamlSequence)) {
            return null;
        }
        return node.asSequence();
    }

    protected YamlMapping getMapping(String path) {
        YamlNode node = this.getNode(path);
        if (!(node instanceof YamlMapping)) {
            return null;
        }
        return node.asMapping();
    }

    protected List<Object> extractList(YamlSequence sequence) {
        Collection<YamlNode> values = sequence.values();
        ArrayList<Object> list = new ArrayList<Object>(values.size());
        for (YamlNode node : values) {
            if (node instanceof Scalar) {
                list.add(UnicodeUtils.unescape((Scalar)node));
                continue;
            }
            if (node instanceof YamlSequence) {
                list.add(this.extractList((YamlSequence)node));
                continue;
            }
            if (node instanceof YamlMapping) {
                list.add(new RootConfigurationSection((YamlMapping)node));
                continue;
            }
            list.add(node);
        }
        return list;
    }

    protected YamlSequenceBuilder createSequence(Collection<?> list) {
        YamlSequenceBuilder builder = Yaml.createYamlSequenceBuilder();
        for (Object obj : list) {
            if (obj instanceof Collection) {
                builder = builder.add(this.createSequence((Collection)obj).build());
                continue;
            }
            if (obj instanceof ConfigurationSection && ((ConfigurationSection)obj).isRoot()) {
                builder = builder.add(((ConfigurationSection)obj).currentMapping);
                continue;
            }
            if (obj instanceof String) {
                builder = builder.add(UnicodeUtils.escape((String)obj));
                continue;
            }
            builder = builder.add(obj.toString());
        }
        return builder;
    }

    protected String toFullPath(String relativePath) {
        if (this.currentPath.isEmpty()) {
            return relativePath;
        }
        return this.currentPath + "." + relativePath;
    }

    protected String[] toPathArray(String path) {
        if (path.isEmpty()) {
            return new String[0];
        }
        return path.split("\\.");
    }

    protected String fromPathArray(String[] paths) {
        return String.join((CharSequence)".", paths);
    }

    protected String fromPathList(List<String> paths) {
        return String.join((CharSequence)".", paths);
    }
}

