/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.interactionvisualizer.entities;

import com.loohp.interactionvisualizer.InteractionVisualizer;
import com.loohp.interactionvisualizer.api.InteractionVisualizerAPI;
import com.loohp.interactionvisualizer.api.VisualizerDisplay;
import com.loohp.interactionvisualizer.entityholders.Item;
import com.loohp.interactionvisualizer.managers.PacketManager;
import com.loohp.interactionvisualizer.objectholders.EntryKey;
import com.loohp.interactionvisualizer.utils.InventoryUtils;
import com.loohp.interactionvisualizer.utils.MCVersion;
import com.loohp.interactionvisualizer.utils.VanishUtils;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.AbstractVillager;
import org.bukkit.entity.NPC;
import org.bukkit.entity.Player;
import org.bukkit.entity.Villager;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.MerchantInventory;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public class VillagerDisplay
implements Listener,
VisualizerDisplay {
    public static final EntryKey KEY = new EntryKey("villager");

    @Override
    public EntryKey key() {
        return KEY;
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onVillageTrade(InventoryClickEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (VanishUtils.isVanished((Player)event.getWhoClicked())) {
            return;
        }
        if (!(event.getView().getTopInventory() instanceof MerchantInventory)) {
            return;
        }
        if (event.getRawSlot() != 2) {
            return;
        }
        if (event.getCurrentItem() == null) {
            return;
        }
        if (event.getCurrentItem().getType().equals((Object)Material.AIR)) {
            return;
        }
        if (event.getCursor() != null && !event.getCursor().getType().equals((Object)Material.AIR) && event.getCursor().getAmount() >= event.getCursor().getType().getMaxStackSize()) {
            return;
        }
        if (event.isShiftClick() && !InventoryUtils.stillHaveSpace((Inventory)event.getWhoClicked().getInventory(), event.getView().getItem(2).getType())) {
            return;
        }
        ItemStack item0 = null;
        if (event.getView().getItem(0) != null && !event.getView().getItem(0).getType().equals((Object)Material.AIR)) {
            item0 = event.getView().getItem(0).clone();
        }
        ItemStack item1 = null;
        if (event.getView().getItem(1) != null && !event.getView().getItem(1).getType().equals((Object)Material.AIR)) {
            item1 = event.getView().getItem(1).clone();
        }
        ItemStack item2 = event.getCurrentItem().clone();
        Player player = (Player)event.getWhoClicked();
        MerchantInventory tradeinv = (MerchantInventory)event.getView().getTopInventory();
        if (InteractionVisualizer.version.isNewerOrEqualTo(MCVersion.V1_14) ? !(tradeinv.getHolder() instanceof AbstractVillager) : !(tradeinv.getHolder() instanceof Villager)) {
            return;
        }
        NPC villager = (NPC)tradeinv.getHolder();
        Vector lift = new Vector(0.0, 0.2, 0.0);
        if (item0 != null) {
            Item in = new Item(player.getEyeLocation());
            Vector vector = villager.getEyeLocation().add(0.0, -0.5, 0.0).toVector().subtract(player.getEyeLocation().toVector()).multiply(0.12).add(lift);
            in.setItemStack(item0);
            in.setGravity(true);
            in.setVelocity(vector);
            PacketManager.sendItemSpawn(InteractionVisualizerAPI.getPlayerModuleList(InteractionVisualizerAPI.Modules.ITEMDROP, KEY), in);
            PacketManager.updateItem(in);
            Bukkit.getScheduler().runTaskLater((Plugin)InteractionVisualizer.plugin, () -> PacketManager.removeItem(InteractionVisualizerAPI.getPlayers(), in), 14L);
        }
        ItemStack item1final = item1;
        Bukkit.getScheduler().runTaskLater((Plugin)InteractionVisualizer.plugin, () -> {
            if (item1final != null) {
                Item in = new Item(player.getEyeLocation());
                Vector vector = villager.getEyeLocation().add(0.0, -0.5, 0.0).toVector().subtract(player.getEyeLocation().toVector()).multiply(0.12).add(lift);
                in.setItemStack(item1final);
                in.setGravity(true);
                in.setVelocity(vector);
                PacketManager.sendItemSpawn(InteractionVisualizerAPI.getPlayerModuleList(InteractionVisualizerAPI.Modules.ITEMDROP, KEY), in);
                PacketManager.updateItem(in);
                Bukkit.getScheduler().runTaskLater((Plugin)InteractionVisualizer.plugin, () -> PacketManager.removeItem(InteractionVisualizerAPI.getPlayers(), in), 14L);
            }
        }, 8L);
        Bukkit.getScheduler().runTaskLater((Plugin)InteractionVisualizer.plugin, () -> {
            Item out = new Item(villager.getEyeLocation());
            Vector vector = player.getEyeLocation().add(0.0, -0.5, 0.0).toVector().subtract(villager.getEyeLocation().toVector()).multiply(0.1).add(lift);
            out.setItemStack(item2);
            out.setGravity(true);
            out.setVelocity(vector);
            PacketManager.sendItemSpawn(InteractionVisualizerAPI.getPlayerModuleList(InteractionVisualizerAPI.Modules.ITEMDROP, KEY), out);
            PacketManager.updateItem(out);
            Bukkit.getScheduler().runTaskLater((Plugin)InteractionVisualizer.plugin, () -> PacketManager.removeItem(InteractionVisualizerAPI.getPlayers(), out), 12L);
        }, 40L);
    }
}

