/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.interactionvisualizer.entities;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.wrappers.WrappedDataWatcher;
import com.loohp.interactionvisualizer.InteractionVisualizer;
import com.loohp.interactionvisualizer.api.InteractionVisualizerAPI;
import com.loohp.interactionvisualizer.api.VisualizerRunnableDisplay;
import com.loohp.interactionvisualizer.api.events.InteractionVisualizerReloadEvent;
import com.loohp.interactionvisualizer.libs.com.cryptomorin.xseries.XMaterial;
import com.loohp.interactionvisualizer.libs.io.github.bananapuncher714.nbteditor.NBTEditor;
import com.loohp.interactionvisualizer.libs.net.kyori.adventure.text.Component;
import com.loohp.interactionvisualizer.libs.net.kyori.adventure.text.TextReplacementConfig;
import com.loohp.interactionvisualizer.libs.net.kyori.adventure.text.TranslatableComponent;
import com.loohp.interactionvisualizer.libs.net.kyori.adventure.text.format.TextDecoration;
import com.loohp.interactionvisualizer.libs.net.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import com.loohp.interactionvisualizer.libs.net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import com.loohp.interactionvisualizer.managers.PlayerLocationManager;
import com.loohp.interactionvisualizer.nms.NMS;
import com.loohp.interactionvisualizer.objectholders.BoundingBox;
import com.loohp.interactionvisualizer.objectholders.EntryKey;
import com.loohp.interactionvisualizer.objectholders.WrappedIterable;
import com.loohp.interactionvisualizer.protocol.WatchableCollection;
import com.loohp.interactionvisualizer.utils.ChatColorUtils;
import com.loohp.interactionvisualizer.utils.ColorUtils;
import com.loohp.interactionvisualizer.utils.ComponentFont;
import com.loohp.interactionvisualizer.utils.JsonUtils;
import com.loohp.interactionvisualizer.utils.LanguageUtils;
import com.loohp.interactionvisualizer.utils.LineOfSightUtils;
import com.loohp.interactionvisualizer.utils.RarityUtils;
import com.loohp.interactionvisualizer.utils.SyncUtils;
import com.loohp.interactionvisualizer.utils.XMaterialUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BookMeta;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class ItemDisplay
extends VisualizerRunnableDisplay
implements Listener {
    public static final EntryKey KEY = new EntryKey("item");
    private static final ItemStack AIR = new ItemStack(Material.AIR);
    private final Map<Item, Set<Player>> outOfRangePlayersMap = Collections.synchronizedMap(new WeakHashMap());
    private final Map<Item, WrappedDataWatcher> defaultWatchers = Collections.synchronizedMap(new WeakHashMap());
    private final Map<Item, WrappedDataWatcher> modifiedWatchers = Collections.synchronizedMap(new WeakHashMap());
    private String regularFormatting;
    private String singularFormatting;
    private String toolsFormatting;
    private String highColor = "";
    private String mediumColor = "";
    private String lowColor = "";
    private int cramp = 6;
    private int updateRate = 20;
    private boolean stripColorBlacklist;
    private BiPredicate<String, Material> blacklist;

    public ItemDisplay() {
        this.onReload(new InteractionVisualizerReloadEvent());
    }

    @EventHandler
    public void onReload(InteractionVisualizerReloadEvent event) {
        this.regularFormatting = ChatColorUtils.translateAlternateColorCodes('&', InteractionVisualizer.plugin.getConfiguration().getString("Entities.Item.Options.RegularFormat"));
        this.singularFormatting = ChatColorUtils.translateAlternateColorCodes('&', InteractionVisualizer.plugin.getConfiguration().getString("Entities.Item.Options.SingularFormat"));
        this.toolsFormatting = ChatColorUtils.translateAlternateColorCodes('&', InteractionVisualizer.plugin.getConfiguration().getString("Entities.Item.Options.ToolsFormat"));
        this.highColor = ChatColorUtils.translateAlternateColorCodes('&', InteractionVisualizer.plugin.getConfiguration().getString("Entities.Item.Options.Color.High"));
        this.mediumColor = ChatColorUtils.translateAlternateColorCodes('&', InteractionVisualizer.plugin.getConfiguration().getString("Entities.Item.Options.Color.Medium"));
        this.lowColor = ChatColorUtils.translateAlternateColorCodes('&', InteractionVisualizer.plugin.getConfiguration().getString("Entities.Item.Options.Color.Low"));
        this.cramp = InteractionVisualizer.plugin.getConfiguration().getInt("Entities.Item.Options.Cramping");
        this.updateRate = InteractionVisualizer.plugin.getConfiguration().getInt("Entities.Item.Options.UpdateRate");
        this.stripColorBlacklist = InteractionVisualizer.plugin.getConfiguration().getBoolean("Entities.Item.Options.Blacklist.StripColorWhenMatching");
        this.blacklist = InteractionVisualizer.plugin.getConfiguration().getList("Entities.Item.Options.Blacklist.List").stream().map(each -> {
            Predicate<Material> material;
            List entry = (List)each;
            Pattern pattern = Pattern.compile((String)entry.get(0));
            Predicate<String> name = str -> pattern.matcher((CharSequence)str).matches();
            if (entry.size() > 1 && !((String)entry.get(1)).equals("*")) {
                try {
                    Material m2 = Material.valueOf((String)((String)entry.get(1)).toUpperCase());
                    material = e -> e.equals((Object)m2);
                }
                catch (Exception er) {
                    Bukkit.getConsoleSender().sendMessage(ChatColor.RED + "[InteractionVisualizer] " + ((String)entry.get(1)).toUpperCase() + " is not a valid material");
                    material = e -> true;
                }
            } else {
                material = e -> true;
            }
            Predicate<Material> finalmaterial = material;
            return (s, m) -> name.test((String)s) && finalmaterial.test((Material)m);
        }).reduce(BiPredicate::or).orElse((s, m) -> false);
    }

    @Override
    public EntryKey key() {
        return KEY;
    }

    @Override
    public int gc() {
        return -1;
    }

    @Override
    public int run() {
        return new BukkitRunnable(){
            int i = 0;

            public void run() {
                if (--this.i > 0) {
                    return;
                }
                this.i = ItemDisplay.this.updateRate;
                for (World world : Bukkit.getWorlds()) {
                    WrappedIterable<?, Entity> entities = NMS.getInstance().getEntities(world);
                    for (Entity entity : entities) {
                        SyncUtils.runAsyncWithSyncCondition(() -> entity.isValid() && entity instanceof Item, 200L, () -> ItemDisplay.this.tick((Item)entity, entities));
                    }
                }
            }
        }.runTaskTimer((Plugin)InteractionVisualizer.plugin, 0L, 1L).getTaskId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tick(Item item, WrappedIterable<?, Entity> items) {
        block10: {
            World world = item.getWorld();
            Location location = item.getLocation();
            BoundingBox area = BoundingBox.of(item.getLocation(), 0.5, 0.5, 0.5);
            short ticks = NBTEditor.getShort(item, "Age");
            ItemStack itemstack = item.getItemStack();
            itemstack = itemstack == null ? new ItemStack(Material.AIR) : itemstack.clone();
            Component name = this.getDisplayName(itemstack);
            String matchingname = this.getMatchingName(itemstack, this.stripColorBlacklist);
            if (this.blacklist.test(matchingname, itemstack.getType())) break block10;
            if (NBTEditor.getShort(item, "PickupDelay") >= Short.MAX_VALUE || ticks < 0 || this.isCramping(world, area, items)) {
                PacketContainer defaultPacket = InteractionVisualizer.protocolManager.createPacket(PacketType.Play.Server.ENTITY_METADATA);
                defaultPacket.getIntegers().write(0, (Object)item.getEntityId());
                WrappedDataWatcher watcher = WatchableCollection.resetCustomNameWatchableCollection((Entity)item, this.defaultWatchers.get(item));
                defaultPacket.getWatchableCollectionModifier().write(0, (Object)watcher.getWatchableObjects());
                this.defaultWatchers.put(item, watcher);
                Collection<Player> players = InteractionVisualizerAPI.getPlayerModuleList(InteractionVisualizerAPI.Modules.HOLOGRAM, KEY);
                for (Player player2 : players) {
                    InteractionVisualizer.protocolManager.sendServerPacket(player2, defaultPacket);
                }
            } else {
                Set<Player> outOfRangePlayers;
                int despawnRate;
                int ticksLeft;
                int secondsLeft;
                int amount = itemstack.getAmount();
                String durDisplay = null;
                if (itemstack.getType().getMaxDurability() > 0) {
                    short maxDur;
                    int durability = itemstack.getType().getMaxDurability() - (InteractionVisualizer.version.isLegacy() ? itemstack.getDurability() : ((Damageable)itemstack.getItemMeta()).getDamage());
                    double percentage = (double)durability / (double)(maxDur = itemstack.getType().getMaxDurability()) * 100.0;
                    String color = percentage > 66.666 ? this.highColor : (percentage > 33.333 ? this.mediumColor : this.lowColor);
                    durDisplay = color + durability + "/" + maxDur;
                }
                String timerColor = (secondsLeft = (ticksLeft = (despawnRate = NMS.getInstance().getItemDespawnRate(item)) - ticks) / 20) <= 30 ? this.lowColor : (secondsLeft <= 120 ? this.mediumColor : this.highColor);
                String timer = timerColor + String.format("%02d:%02d", secondsLeft / 60, secondsLeft % 60);
                String line1 = ticksLeft >= 600 && durDisplay != null ? this.toolsFormatting.replace("{Amount}", amount + "").replace("{Timer}", timer).replace("{Durability}", durDisplay) : (amount == 1 ? this.singularFormatting.replace("{Amount}", amount + "").replace("{Timer}", timer) : this.regularFormatting.replace("{Amount}", amount + "").replace("{Timer}", timer));
                Component display = ComponentFont.parseFont(LegacyComponentSerializer.legacySection().deserialize(line1));
                display = display.replaceText((TextReplacementConfig)TextReplacementConfig.builder().matchLiteral("{Item}").replacement(name).build());
                WrappedDataWatcher modifiedWatcher = WatchableCollection.createCustomNameWatchableCollection(display, this.modifiedWatchers.get(item));
                WrappedDataWatcher defaultWatcher = WatchableCollection.resetCustomNameWatchableCollection((Entity)item, this.defaultWatchers.get(item));
                this.modifiedWatchers.put(item, modifiedWatcher);
                this.defaultWatchers.put(item, defaultWatcher);
                PacketContainer modifiedPacket = InteractionVisualizer.protocolManager.createPacket(PacketType.Play.Server.ENTITY_METADATA);
                PacketContainer defaultPacket = InteractionVisualizer.protocolManager.createPacket(PacketType.Play.Server.ENTITY_METADATA);
                modifiedPacket.getIntegers().write(0, (Object)item.getEntityId());
                defaultPacket.getIntegers().write(0, (Object)item.getEntityId());
                modifiedPacket.getWatchableCollectionModifier().write(0, (Object)modifiedWatcher.getWatchableObjects());
                defaultPacket.getWatchableCollectionModifier().write(0, (Object)defaultWatcher.getWatchableObjects());
                Location entityCenter = location.clone();
                entityCenter.setY(entityCenter.getY() + item.getHeight() * 1.7);
                Map<Item, Set<Player>> map = this.outOfRangePlayersMap;
                synchronized (map) {
                    outOfRangePlayers = this.outOfRangePlayersMap.get(item);
                    if (outOfRangePlayers == null) {
                        outOfRangePlayers = ConcurrentHashMap.newKeySet();
                        this.outOfRangePlayersMap.put(item, outOfRangePlayers);
                    }
                }
                List players = location.getWorld().getPlayers();
                Collection<Player> enabledPlayers = InteractionVisualizerAPI.getPlayerModuleList(InteractionVisualizerAPI.Modules.HOLOGRAM, KEY);
                Collection<Player> playersInRange = PlayerLocationManager.filterOutOfRange(players, location, player -> !InteractionVisualizer.hideIfObstructed || LineOfSightUtils.hasLineOfSight(player.getEyeLocation(), entityCenter));
                for (Player player3 : players) {
                    if (playersInRange.contains(player3) && enabledPlayers.contains(player3)) {
                        InteractionVisualizer.protocolManager.sendServerPacket(player3, modifiedPacket);
                        outOfRangePlayers.remove(player3);
                        continue;
                    }
                    if (outOfRangePlayers.contains(player3)) continue;
                    InteractionVisualizer.protocolManager.sendServerPacket(player3, defaultPacket);
                    outOfRangePlayers.add(player3);
                }
            }
        }
    }

    private Component getDisplayName(ItemStack itemstack) {
        return this.getDisplayName(itemstack, ChatColor.WHITE);
    }

    private Component getDisplayName(ItemStack itemstack, ChatColor defaultRarityColor) {
        Component component;
        block12: {
            if (itemstack == null) {
                itemstack = AIR.clone();
            }
            XMaterial xMaterial = XMaterialUtils.matchXMaterial(itemstack);
            ChatColor rarityChatColor = RarityUtils.getRarityColor(itemstack);
            if (rarityChatColor.equals((Object)ChatColor.WHITE)) {
                rarityChatColor = defaultRarityColor;
            }
            component = Component.empty();
            if (rarityChatColor != null) {
                component = component.color(ColorUtils.toTextColor(rarityChatColor));
            }
            if (!itemstack.getType().equals((Object)Material.AIR) && NBTEditor.contains(itemstack, "display", "Name")) {
                String name = NBTEditor.getString(itemstack, "display", "Name");
                if (!InteractionVisualizer.version.isLegacy()) {
                    component = component.decorate(TextDecoration.ITALIC);
                }
                try {
                    if (JsonUtils.isValid(name)) {
                        component = component.append((Component)GsonComponentSerializer.gson().deserialize(name));
                        break block12;
                    }
                    component = component.append(LegacyComponentSerializer.legacySection().deserialize(name));
                }
                catch (Throwable e) {
                    component = component.append(LegacyComponentSerializer.legacySection().deserialize(name));
                }
            } else {
                BookMeta meta;
                String rawTitle;
                boolean displayNameCompleted = false;
                if (itemstack.hasItemMeta() && itemstack.getItemMeta() instanceof BookMeta && (rawTitle = (meta = (BookMeta)itemstack.getItemMeta()).getTitle()) != null) {
                    displayNameCompleted = true;
                    component = component.append(LegacyComponentSerializer.legacySection().deserialize(rawTitle));
                }
                if (!displayNameCompleted) {
                    String owner;
                    TranslatableComponent translatableComponent = Component.translatable(LanguageUtils.getTranslationKey(itemstack));
                    if (xMaterial.equals((Object)XMaterial.PLAYER_HEAD) && (owner = NBTEditor.getString(itemstack, "SkullOwner", "Name")) != null) {
                        translatableComponent = translatableComponent.args(Component.text(owner));
                    }
                    component = component.append(translatableComponent);
                }
            }
        }
        return component;
    }

    private String getMatchingName(ItemStack item, boolean stripColor) {
        ItemMeta meta;
        if (item.hasItemMeta() && item.getItemMeta() != null && (meta = item.getItemMeta()).hasDisplayName() && meta.getDisplayName() != null) {
            if (stripColor) {
                return ChatColorUtils.stripColor(meta.getDisplayName());
            }
            return meta.getDisplayName();
        }
        return "";
    }

    private boolean isCramping(World world, BoundingBox area, WrappedIterable<?, Entity> items) {
        if (this.cramp <= 0) {
            return false;
        }
        try {
            return items.stream().filter(each -> each != null && each.getWorld().equals(world) && area.contains(each.getLocation().toVector())).count() > (long)this.cramp;
        }
        catch (Throwable e) {
            return false;
        }
    }
}

