/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.interactionvisualizer.blocks;

import com.loohp.interactionvisualizer.InteractionVisualizer;
import com.loohp.interactionvisualizer.api.InteractionVisualizerAPI;
import com.loohp.interactionvisualizer.api.VisualizerInteractDisplay;
import com.loohp.interactionvisualizer.entityholders.Item;
import com.loohp.interactionvisualizer.managers.PacketManager;
import com.loohp.interactionvisualizer.managers.SoundManager;
import com.loohp.interactionvisualizer.objectholders.EntryKey;
import com.loohp.interactionvisualizer.utils.InventoryUtils;
import com.loohp.interactionvisualizer.utils.VanishUtils;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.FluidCollisionMode;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.StonecutterInventory;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class StonecutterDisplay
extends VisualizerInteractDisplay
implements Listener {
    public static final EntryKey KEY = new EntryKey("stonecutter");
    public Map<Block, Map<String, Object>> openedStonecutter = new HashMap<Block, Map<String, Object>>();
    public Map<Player, Block> playermap = new HashMap<Player, Block>();

    @Override
    public EntryKey key() {
        return KEY;
    }

    @Override
    public int run() {
        return new BukkitRunnable(){

            public void run() {
                Iterator<Block> itr = StonecutterDisplay.this.openedStonecutter.keySet().iterator();
                int count = 0;
                int maxper = (int)Math.ceil((double)StonecutterDisplay.this.openedStonecutter.size() / 5.0);
                int delay = 1;
                while (itr.hasNext()) {
                    if (++count > maxper) {
                        count = 0;
                        ++delay;
                    }
                    final Block block = itr.next();
                    new BukkitRunnable(){

                        public void run() {
                            Player player;
                            if (!StonecutterDisplay.this.openedStonecutter.containsKey(block)) {
                                return;
                            }
                            Map<String, Object> map = StonecutterDisplay.this.openedStonecutter.get(block);
                            if (block.getType().equals((Object)Material.STONECUTTER) && !(player = (Player)map.get("Player")).getGameMode().equals((Object)GameMode.SPECTATOR) && player.getOpenInventory() != null && player.getOpenInventory().getTopInventory() != null && player.getOpenInventory().getTopInventory() instanceof StonecutterInventory) {
                                return;
                            }
                            if (map.get("Item") instanceof Item) {
                                Item entity = (Item)map.get("Item");
                                PacketManager.removeItem(InteractionVisualizerAPI.getPlayers(), entity);
                            }
                            StonecutterDisplay.this.openedStonecutter.remove(block);
                        }
                    }.runTaskLater((Plugin)InteractionVisualizer.plugin, (long)delay);
                }
            }
        }.runTaskTimer((Plugin)InteractionVisualizer.plugin, 0L, 5L).getTaskId();
    }

    @Override
    public void process(final Player player) {
        ItemStack output;
        Map<Object, Object> map;
        if (VanishUtils.isVanished(player)) {
            return;
        }
        if (!this.playermap.containsKey(player)) {
            if (player.getGameMode().equals((Object)GameMode.SPECTATOR)) {
                return;
            }
            if (!(player.getOpenInventory().getTopInventory() instanceof StonecutterInventory)) {
                return;
            }
            Block block = player.getTargetBlockExact(7, FluidCollisionMode.NEVER);
            if (block == null || !block.getType().equals((Object)Material.STONECUTTER)) {
                return;
            }
            this.playermap.put(player, block);
        }
        InventoryView view = player.getOpenInventory();
        Block block = this.playermap.get(player);
        final Location loc = block.getLocation();
        if (!this.openedStonecutter.containsKey(block)) {
            map = new HashMap<String, Player>();
            map.put("Player", player);
            map.put("Item", "N/A");
            this.openedStonecutter.put(block, map);
        }
        if (!(map = this.openedStonecutter.get(block)).get("Player").equals(player)) {
            return;
        }
        ItemStack input = view.getItem(0);
        if (input != null && input.getType().equals((Object)Material.AIR)) {
            input = null;
        }
        if ((output = view.getItem(1)) != null && output.getType().equals((Object)Material.AIR)) {
            output = null;
        }
        ItemStack itemstack = null;
        if (output == null) {
            if (input != null) {
                itemstack = input;
            }
        } else {
            itemstack = output;
        }
        if (itemstack != null) {
            final ItemStack itempar = itemstack.clone();
            final int taskid = new BukkitRunnable(){

                public void run() {
                    player.getWorld().spawnParticle(Particle.ITEM_CRACK, loc.clone().add(0.5, 0.7, 0.5), 25, 0.1, 0.1, 0.1, 0.1, (Object)itempar);
                }
            }.runTaskTimer((Plugin)InteractionVisualizer.plugin, 0L, 1L).getTaskId();
            new BukkitRunnable(){

                public void run() {
                    Bukkit.getScheduler().cancelTask(taskid);
                }
            }.runTaskLater((Plugin)InteractionVisualizer.plugin, 4L);
        }
        Item item = null;
        if (map.get("Item") instanceof String) {
            if (itemstack != null) {
                item = new Item(loc.clone().add(0.5, 0.75, 0.5));
                item.setItemStack(itemstack);
                item.setVelocity(new Vector(0, 0, 0));
                item.setPickupDelay(Short.MAX_VALUE);
                item.setGravity(false);
                map.put("Item", item);
                PacketManager.sendItemSpawn(InteractionVisualizerAPI.getPlayerModuleList(InteractionVisualizerAPI.Modules.ITEMDROP, KEY), item);
                PacketManager.updateItem(item);
            } else {
                map.put("Item", "N/A");
            }
        } else {
            item = (Item)map.get("Item");
            if (itemstack != null) {
                if (!item.getItemStack().equals((Object)itemstack)) {
                    item.setItemStack(itemstack);
                    PacketManager.updateItem(item);
                }
                item.setPickupDelay(Short.MAX_VALUE);
                item.setGravity(false);
            } else {
                map.put("Item", "N/A");
                PacketManager.removeItem(InteractionVisualizerAPI.getPlayers(), item);
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onStonecutter(InventoryClickEvent event) {
        if (VanishUtils.isVanished((Player)event.getWhoClicked())) {
            return;
        }
        if (event.isCancelled()) {
            return;
        }
        if (event.getRawSlot() != 1) {
            return;
        }
        if (event.getCurrentItem() == null) {
            return;
        }
        if (event.getCurrentItem().getType().equals((Object)Material.AIR)) {
            return;
        }
        if (event.getCursor() != null && !event.getCursor().getType().equals((Object)Material.AIR) && event.getCursor().getAmount() >= event.getCursor().getType().getMaxStackSize()) {
            return;
        }
        if (event.isShiftClick() && !InventoryUtils.stillHaveSpace((Inventory)event.getWhoClicked().getInventory(), event.getView().getItem(1).getType())) {
            return;
        }
        if (event.getAction().equals((Object)InventoryAction.HOTBAR_MOVE_AND_READD) && event.getWhoClicked().getInventory().getItem(event.getHotbarButton()) != null && !event.getWhoClicked().getInventory().getItem(event.getHotbarButton()).getType().equals((Object)Material.AIR)) {
            return;
        }
        if (!this.playermap.containsKey((Player)event.getWhoClicked())) {
            return;
        }
        Block block = this.playermap.get((Player)event.getWhoClicked());
        if (!this.openedStonecutter.containsKey(block)) {
            return;
        }
        Map<String, Object> map = this.openedStonecutter.get(block);
        if (!map.get("Player").equals(event.getWhoClicked())) {
            return;
        }
        ItemStack itemstack = event.getCurrentItem().clone();
        Location loc = block.getLocation();
        Player player = (Player)event.getWhoClicked();
        if (map.get("Item") instanceof String) {
            map.put("Item", new Item(block.getLocation().clone().add(0.5, 1.2, 0.5)));
        }
        Item item = (Item)map.get("Item");
        Inventory before = Bukkit.createInventory(null, (int)9);
        before.setItem(0, player.getOpenInventory().getItem(0).clone());
        Bukkit.getScheduler().runTaskLater((Plugin)InteractionVisualizer.plugin, () -> {
            Inventory after = Bukkit.createInventory(null, (int)9);
            after.setItem(0, player.getOpenInventory().getItem(0).clone());
            if (InventoryUtils.compareContents(before, after)) {
                return;
            }
            item.setLocked(true);
            this.openedStonecutter.remove(block);
            item.setItemStack(itemstack);
            Vector lift = new Vector(0.0, 0.15, 0.0);
            Vector pickup = player.getEyeLocation().add(0.0, -0.5, 0.0).add(0.0, InteractionVisualizer.playerPickupYOffset.doubleValue(), 0.0).toVector().subtract(loc.clone().add(0.5, 1.2, 0.5).toVector()).multiply(0.15).add(lift);
            item.setVelocity(pickup);
            item.setGravity(true);
            item.setPickupDelay(Short.MAX_VALUE);
            PacketManager.updateItem(item);
            Bukkit.getScheduler().runTaskLater((Plugin)InteractionVisualizer.plugin, () -> {
                SoundManager.playItemPickup(item.getLocation(), InteractionVisualizerAPI.getPlayerModuleList(InteractionVisualizerAPI.Modules.ITEMDROP, KEY));
                PacketManager.removeItem(InteractionVisualizerAPI.getPlayers(), item);
            }, 8L);
        }, 1L);
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onUseStonecutter(InventoryClickEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (!this.playermap.containsKey((Player)event.getWhoClicked())) {
            return;
        }
        if (event.getRawSlot() >= 0 && event.getRawSlot() <= 1) {
            PacketManager.sendHandMovement(InteractionVisualizerAPI.getPlayers(), (Player)event.getWhoClicked());
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onDragStonecutter(InventoryDragEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (!this.playermap.containsKey((Player)event.getWhoClicked())) {
            return;
        }
        Iterator iterator = event.getRawSlots().iterator();
        while (iterator.hasNext()) {
            int slot = (Integer)iterator.next();
            if (slot < 0 || slot > 1) continue;
            PacketManager.sendHandMovement(InteractionVisualizerAPI.getPlayers(), (Player)event.getWhoClicked());
            break;
        }
    }

    @EventHandler
    public void onCloseStonecutter(InventoryCloseEvent event) {
        if (!this.playermap.containsKey((Player)event.getPlayer())) {
            return;
        }
        Block block = this.playermap.get((Player)event.getPlayer());
        if (!this.openedStonecutter.containsKey(block)) {
            return;
        }
        Map<String, Object> map = this.openedStonecutter.get(block);
        if (!map.get("Player").equals(event.getPlayer())) {
            return;
        }
        if (map.get("Item") instanceof Item) {
            Item entity = (Item)map.get("Item");
            PacketManager.removeItem(InteractionVisualizerAPI.getPlayers(), entity);
        }
        this.openedStonecutter.remove(block);
        this.playermap.remove((Player)event.getPlayer());
    }
}

