/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.interactionvisualizer.blocks;

import com.loohp.interactionvisualizer.InteractionVisualizer;
import com.loohp.interactionvisualizer.api.InteractionVisualizerAPI;
import com.loohp.interactionvisualizer.api.VisualizerInteractDisplay;
import com.loohp.interactionvisualizer.entityholders.ArmorStand;
import com.loohp.interactionvisualizer.entityholders.Item;
import com.loohp.interactionvisualizer.libs.net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import com.loohp.interactionvisualizer.managers.PacketManager;
import com.loohp.interactionvisualizer.managers.SoundManager;
import com.loohp.interactionvisualizer.objectholders.EntryKey;
import com.loohp.interactionvisualizer.objectholders.LightType;
import com.loohp.interactionvisualizer.utils.InventoryUtils;
import com.loohp.interactionvisualizer.utils.MaterialUtils;
import com.loohp.interactionvisualizer.utils.VanishUtils;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.FluidCollisionMode;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.SmithingInventory;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.EulerAngle;
import org.bukkit.util.Vector;

public class SmithingTableDisplay
extends VisualizerInteractDisplay
implements Listener {
    public static final EntryKey KEY = new EntryKey("smithing_table");
    public Map<Block, Map<String, Object>> openedSTables = new HashMap<Block, Map<String, Object>>();
    public Map<Player, Block> playermap = new HashMap<Player, Block>();

    @Override
    public EntryKey key() {
        return KEY;
    }

    @Override
    public void process(Player player) {
        Map<Object, Object> map;
        if (VanishUtils.isVanished(player)) {
            return;
        }
        if (!this.playermap.containsKey(player)) {
            if (player.getGameMode().equals((Object)GameMode.SPECTATOR)) {
                return;
            }
            if (!(player.getOpenInventory().getTopInventory() instanceof SmithingInventory)) {
                return;
            }
            Block block = player.getTargetBlockExact(7, FluidCollisionMode.NEVER);
            if (block == null || !block.getType().equals((Object)Material.SMITHING_TABLE)) {
                return;
            }
            this.playermap.put(player, block);
        }
        InventoryView view = player.getOpenInventory();
        Block block = this.playermap.get(player);
        Location loc = block.getLocation();
        if (!this.openedSTables.containsKey(block)) {
            map = new HashMap<String, Player>();
            map.put("Player", player);
            map.put("2", "N/A");
            map.putAll(this.spawnArmorStands(player, block));
            this.openedSTables.put(block, map);
        }
        if (!(map = this.openedSTables.get(block)).get("Player").equals(player)) {
            return;
        }
        ItemStack[] items = new ItemStack[]{view.getItem(0), view.getItem(1)};
        if (view.getItem(2) != null) {
            ItemStack itemstack = view.getItem(2);
            if (itemstack == null || itemstack.getType().equals((Object)Material.AIR)) {
                itemstack = null;
            }
            Item item = null;
            if (map.get("2") instanceof String) {
                if (itemstack != null) {
                    item = new Item(loc.clone().add(0.5, 1.2, 0.5));
                    item.setItemStack(itemstack);
                    item.setVelocity(new Vector(0, 0, 0));
                    item.setPickupDelay(Short.MAX_VALUE);
                    item.setGravity(false);
                    map.put("2", item);
                    PacketManager.sendItemSpawn(InteractionVisualizerAPI.getPlayerModuleList(InteractionVisualizerAPI.Modules.ITEMDROP, KEY), item);
                    PacketManager.updateItem(item);
                } else {
                    map.put("2", "N/A");
                }
            } else {
                item = (Item)map.get("2");
                if (itemstack != null) {
                    if (!item.getItemStack().equals((Object)itemstack)) {
                        item.setItemStack(itemstack);
                        PacketManager.updateItem(item);
                    }
                } else {
                    map.put("2", "N/A");
                    PacketManager.removeItem(InteractionVisualizerAPI.getPlayers(), item);
                }
            }
        }
        for (int i = 0; i < 2; ++i) {
            ArmorStand stand = (ArmorStand)map.get(String.valueOf(i));
            ItemStack item = items[i];
            if (item == null || item.getType().equals((Object)Material.AIR)) {
                item = null;
            }
            if (item != null) {
                boolean changed = true;
                if (MaterialUtils.getMaterialType(item.getType()).equals((Object)MaterialUtils.MaterialMode.BLOCK) && !this.standMode(stand).equals((Object)MaterialUtils.MaterialMode.BLOCK)) {
                    this.toggleStandMode(stand, "Block");
                } else if (MaterialUtils.getMaterialType(item.getType()).equals((Object)MaterialUtils.MaterialMode.TOOL) && !this.standMode(stand).equals((Object)MaterialUtils.MaterialMode.TOOL)) {
                    this.toggleStandMode(stand, "Tool");
                } else if (MaterialUtils.getMaterialType(item.getType()).equals((Object)MaterialUtils.MaterialMode.ITEM) && !this.standMode(stand).equals((Object)MaterialUtils.MaterialMode.ITEM)) {
                    this.toggleStandMode(stand, "Item");
                } else if (MaterialUtils.getMaterialType(item.getType()).equals((Object)MaterialUtils.MaterialMode.STANDING) && !this.standMode(stand).equals((Object)MaterialUtils.MaterialMode.STANDING)) {
                    this.toggleStandMode(stand, "Standing");
                } else if (MaterialUtils.getMaterialType(item.getType()).equals((Object)MaterialUtils.MaterialMode.LOWBLOCK) && !this.standMode(stand).equals((Object)MaterialUtils.MaterialMode.LOWBLOCK)) {
                    this.toggleStandMode(stand, "LowBlock");
                } else {
                    changed = false;
                }
                if (!item.getType().equals((Object)stand.getItemInMainHand().getType())) {
                    changed = true;
                    stand.setItemInMainHand(item);
                }
                if (!changed) continue;
                PacketManager.updateArmorStand(stand);
                continue;
            }
            if (stand.getItemInMainHand().getType().equals((Object)Material.AIR)) continue;
            stand.setItemInMainHand(new ItemStack(Material.AIR));
            PacketManager.updateArmorStand(stand);
        }
        Location loc1 = ((ArmorStand)map.get("0")).getLocation();
        InteractionVisualizer.lightManager.deleteLight(loc1);
        byte skylight = loc1.getBlock().getRelative(BlockFace.UP).getLightFromSky();
        int blocklight = loc1.getBlock().getRelative(BlockFace.UP).getLightFromBlocks() - 1;
        blocklight = Math.max(blocklight, 0);
        if (skylight > 0) {
            InteractionVisualizer.lightManager.createLight(loc1, skylight, LightType.SKY);
        }
        if (blocklight > 0) {
            InteractionVisualizer.lightManager.createLight(loc1, blocklight, LightType.BLOCK);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onSmithingTable(InventoryClickEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (event.getRawSlot() != 2) {
            return;
        }
        if (event.getCurrentItem() == null) {
            return;
        }
        if (event.getCurrentItem().getType().equals((Object)Material.AIR)) {
            return;
        }
        if (event.getCursor() != null && !event.getCursor().getType().equals((Object)Material.AIR) && event.getCursor().getAmount() >= event.getCursor().getType().getMaxStackSize()) {
            return;
        }
        if (event.isShiftClick() && !InventoryUtils.stillHaveSpace((Inventory)event.getWhoClicked().getInventory(), event.getView().getItem(2).getType())) {
            return;
        }
        if (event.getAction().equals((Object)InventoryAction.HOTBAR_MOVE_AND_READD) && event.getWhoClicked().getInventory().getItem(event.getHotbarButton()) != null && !event.getWhoClicked().getInventory().getItem(event.getHotbarButton()).getType().equals((Object)Material.AIR)) {
            return;
        }
        if (!this.playermap.containsKey((Player)event.getWhoClicked())) {
            return;
        }
        Block block = event.getWhoClicked().getTargetBlockExact(7, FluidCollisionMode.NEVER);
        if (!this.openedSTables.containsKey(block)) {
            return;
        }
        Map<String, Object> map = this.openedSTables.get(block);
        if (!map.get("Player").equals(event.getWhoClicked())) {
            return;
        }
        ItemStack itemstack = event.getCurrentItem();
        Location loc = block.getLocation();
        Player player = (Player)event.getWhoClicked();
        ArmorStand slot0 = (ArmorStand)map.get("0");
        ArmorStand slot1 = (ArmorStand)map.get("1");
        if (map.get("2") instanceof String) {
            map.put("2", new Item(block.getLocation().clone().add(0.5, 1.2, 0.5)));
        }
        Item item = (Item)map.get("2");
        Inventory before = Bukkit.createInventory(null, (int)9);
        before.setItem(0, player.getOpenInventory().getItem(0).clone());
        before.setItem(1, player.getOpenInventory().getItem(1).clone());
        Bukkit.getScheduler().runTaskLater((Plugin)InteractionVisualizer.plugin, () -> {
            Inventory after = Bukkit.createInventory(null, (int)9);
            after.setItem(0, player.getOpenInventory().getItem(0).clone());
            after.setItem(1, player.getOpenInventory().getItem(1).clone());
            if (InventoryUtils.compareContents(before, after)) {
                return;
            }
            slot0.setLocked(true);
            slot1.setLocked(true);
            item.setLocked(true);
            this.openedSTables.remove(block);
            float yaw = this.getCardinalDirection((Entity)player);
            Vector vector = new Location(slot0.getWorld(), slot0.getLocation().getX(), slot0.getLocation().getY(), slot0.getLocation().getZ(), yaw, 0.0f).getDirection().normalize();
            slot0.teleport(slot0.getLocation().add(this.rotateVectorAroundY(vector.clone(), 90.0).multiply(0.1)));
            slot1.teleport(slot1.getLocation().add(this.rotateVectorAroundY(vector.clone(), -90.0).multiply(0.1)));
            PacketManager.updateArmorStand(slot0);
            PacketManager.updateArmorStand(slot1);
            Bukkit.getScheduler().runTaskLater((Plugin)InteractionVisualizer.plugin, () -> {
                for (Player each : InteractionVisualizerAPI.getPlayerModuleList(InteractionVisualizerAPI.Modules.ITEMDROP, KEY)) {
                    each.spawnParticle(Particle.CLOUD, loc.clone().add(0.5, 1.1, 0.5), 10, 0.05, 0.05, 0.05, 0.05);
                }
            }, 6L);
            Bukkit.getScheduler().runTaskLater((Plugin)InteractionVisualizer.plugin, () -> {
                Vector lift = new Vector(0.0, 0.15, 0.0);
                Vector pickup = player.getEyeLocation().add(0.0, -0.5, 0.0).add(0.0, InteractionVisualizer.playerPickupYOffset.doubleValue(), 0.0).toVector().subtract(loc.clone().add(0.5, 1.2, 0.5).toVector()).multiply(0.15).add(lift);
                item.setItemStack(itemstack);
                item.setVelocity(pickup);
                item.setGravity(true);
                item.setPickupDelay(Short.MAX_VALUE);
                PacketManager.updateItem(item);
                Bukkit.getScheduler().runTaskLater((Plugin)InteractionVisualizer.plugin, () -> {
                    SoundManager.playItemPickup(item.getLocation(), InteractionVisualizerAPI.getPlayerModuleList(InteractionVisualizerAPI.Modules.ITEMDROP, KEY));
                    PacketManager.removeArmorStand(InteractionVisualizerAPI.getPlayers(), slot0);
                    PacketManager.removeArmorStand(InteractionVisualizerAPI.getPlayers(), slot1);
                    PacketManager.removeItem(InteractionVisualizerAPI.getPlayers(), item);
                }, 8L);
            }, 10L);
        }, 1L);
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onUseSmithingTable(InventoryClickEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (event.getWhoClicked().getGameMode().equals((Object)GameMode.SPECTATOR)) {
            return;
        }
        if (!this.playermap.containsKey((Player)event.getWhoClicked())) {
            return;
        }
        if (event.getRawSlot() >= 0 && event.getRawSlot() <= 2) {
            PacketManager.sendHandMovement(InteractionVisualizerAPI.getPlayers(), (Player)event.getWhoClicked());
        }
    }

    @EventHandler
    public void onDragSmithingTable(InventoryDragEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (event.getWhoClicked().getGameMode().equals((Object)GameMode.SPECTATOR)) {
            return;
        }
        if (event.getView().getTopInventory() == null) {
            return;
        }
        if (!this.playermap.containsKey((Player)event.getWhoClicked())) {
            return;
        }
        Iterator iterator = event.getRawSlots().iterator();
        while (iterator.hasNext()) {
            int slot = (Integer)iterator.next();
            if (slot < 0 || slot > 2) continue;
            PacketManager.sendHandMovement(InteractionVisualizerAPI.getPlayers(), (Player)event.getWhoClicked());
            break;
        }
    }

    @EventHandler
    public void onCloseSmithingTable(InventoryCloseEvent event) {
        if (!this.playermap.containsKey((Player)event.getPlayer())) {
            return;
        }
        Block block = this.playermap.get((Player)event.getPlayer());
        if (!this.openedSTables.containsKey(block)) {
            return;
        }
        Map<String, Object> map = this.openedSTables.get(block);
        if (!map.get("Player").equals(event.getPlayer())) {
            return;
        }
        for (int i = 0; i <= 2; ++i) {
            if (map.get(String.valueOf(i)) instanceof String) continue;
            Object entity = map.get(String.valueOf(i));
            if (entity instanceof Item) {
                PacketManager.removeItem(InteractionVisualizerAPI.getPlayers(), (Item)entity);
                continue;
            }
            if (!(entity instanceof ArmorStand)) continue;
            PacketManager.removeArmorStand(InteractionVisualizerAPI.getPlayers(), (ArmorStand)entity);
        }
        if (map.get("0") instanceof ArmorStand) {
            ArmorStand entity = (ArmorStand)map.get("0");
            InteractionVisualizer.lightManager.deleteLight(entity.getLocation());
            PacketManager.removeArmorStand(InteractionVisualizerAPI.getPlayers(), entity);
        }
        this.openedSTables.remove(block);
    }

    public MaterialUtils.MaterialMode standMode(ArmorStand stand) {
        String plain = PlainTextComponentSerializer.plainText().serialize(stand.getCustomName());
        if (plain.startsWith("IV.SmithingTable.")) {
            return MaterialUtils.MaterialMode.getModeFromName(plain.substring(plain.lastIndexOf(".") + 1));
        }
        return null;
    }

    public void toggleStandMode(ArmorStand stand, String mode) {
        String plain = PlainTextComponentSerializer.plainText().serialize(stand.getCustomName());
        if (!plain.equals("IV.SmithingTable.Item")) {
            if (plain.equals("IV.SmithingTable.Block")) {
                stand.setCustomName("IV.SmithingTable.Item");
                stand.setRotation(stand.getLocation().getYaw() - 45.0f, stand.getLocation().getPitch());
                stand.setRightArmPose(new EulerAngle(0.0, 0.0, 0.0));
                stand.teleport(stand.getLocation().add(0.0, -0.084, 0.0));
                stand.teleport(stand.getLocation().add(this.rotateVectorAroundY(stand.getLocation().clone().getDirection().normalize().multiply(-0.102), -90.0)));
                stand.teleport(stand.getLocation().add(stand.getLocation().clone().getDirection().normalize().multiply(-0.14)));
            }
            if (plain.equals("IV.SmithingTable.LowBlock")) {
                stand.setCustomName("IV.SmithingTable.Item");
                stand.setRotation(stand.getLocation().getYaw() - 45.0f, stand.getLocation().getPitch());
                stand.setRightArmPose(new EulerAngle(0.0, 0.0, 0.0));
                stand.teleport(stand.getLocation().add(0.0, -0.02, 0.0));
                stand.teleport(stand.getLocation().add(this.rotateVectorAroundY(stand.getLocation().clone().getDirection().normalize().multiply(-0.09), -90.0)));
                stand.teleport(stand.getLocation().add(stand.getLocation().clone().getDirection().normalize().multiply(-0.15)));
            }
            if (plain.equals("IV.SmithingTable.Tool")) {
                stand.setCustomName("IV.SmithingTable.Item");
                stand.teleport(stand.getLocation().add(this.rotateVectorAroundY(stand.getLocation().clone().getDirection().normalize().multiply(0.3), -90.0)));
                stand.teleport(stand.getLocation().add(stand.getLocation().clone().getDirection().normalize().multiply(0.1)));
                stand.teleport(stand.getLocation().add(0.0, 0.26, 0.0));
                stand.setRightArmPose(new EulerAngle(0.0, 0.0, 0.0));
            }
            if (plain.equals("IV.SmithingTable.Standing")) {
                stand.setCustomName("IV.SmithingTable.Item");
                stand.teleport(stand.getLocation().add(this.rotateVectorAroundY(stand.getLocation().getDirection().normalize().multiply(0.323), -90.0)));
                stand.teleport(stand.getLocation().add(stand.getLocation().getDirection().normalize().multiply(-0.115)));
                stand.teleport(stand.getLocation().add(0.0, 0.32, 0.0));
                stand.setRightArmPose(new EulerAngle(0.0, 0.0, 0.0));
            }
        }
        if (mode.equals("Block")) {
            stand.setCustomName("IV.SmithingTable.Block");
            stand.teleport(stand.getLocation().add(stand.getLocation().clone().getDirection().normalize().multiply(0.14)));
            stand.teleport(stand.getLocation().add(this.rotateVectorAroundY(stand.getLocation().clone().getDirection().normalize().multiply(0.102), -90.0)));
            stand.teleport(stand.getLocation().add(0.0, 0.084, 0.0));
            stand.setRightArmPose(new EulerAngle(357.9, 0.0, 0.0));
            stand.setRotation(stand.getLocation().getYaw() + 45.0f, stand.getLocation().getPitch());
        }
        if (mode.equals("LowBlock")) {
            stand.setCustomName("IV.SmithingTable.LowBlock");
            stand.teleport(stand.getLocation().add(stand.getLocation().clone().getDirection().normalize().multiply(0.15)));
            stand.teleport(stand.getLocation().add(this.rotateVectorAroundY(stand.getLocation().clone().getDirection().normalize().multiply(0.09), -90.0)));
            stand.teleport(stand.getLocation().add(0.0, 0.02, 0.0));
            stand.setRightArmPose(new EulerAngle(357.9, 0.0, 0.0));
            stand.setRotation(stand.getLocation().getYaw() + 45.0f, stand.getLocation().getPitch());
        }
        if (mode.equals("Tool")) {
            stand.setCustomName("IV.SmithingTable.Tool");
            stand.setRightArmPose(new EulerAngle(357.99, 0.0, 300.0));
            stand.teleport(stand.getLocation().add(0.0, -0.26, 0.0));
            stand.teleport(stand.getLocation().add(stand.getLocation().clone().getDirection().normalize().multiply(-0.1)));
            stand.teleport(stand.getLocation().add(this.rotateVectorAroundY(stand.getLocation().clone().getDirection().normalize().multiply(-0.3), -90.0)));
        }
        if (mode.equals("Standing")) {
            stand.setCustomName("IV.SmithingTable.Standing");
            stand.setRightArmPose(new EulerAngle(0.0, 4.7, 4.7));
            stand.teleport(stand.getLocation().add(0.0, -0.32, 0.0));
            stand.teleport(stand.getLocation().add(stand.getLocation().getDirection().normalize().multiply(0.115)));
            stand.teleport(stand.getLocation().add(this.rotateVectorAroundY(stand.getLocation().getDirection().normalize().multiply(-0.323), -90.0)));
        }
    }

    public Map<String, ArmorStand> spawnArmorStands(Player player, Block block) {
        HashMap<String, ArmorStand> map = new HashMap<String, ArmorStand>();
        Location loc = block.getLocation().clone().add(0.5, 0.600781, 0.5);
        ArmorStand center = new ArmorStand(loc);
        float yaw = this.getCardinalDirection((Entity)player);
        center.setRotation(yaw, center.getLocation().getPitch());
        this.setStand(center);
        center.setCustomName("IV.SmithingTable.Center");
        Vector vector = this.rotateVectorAroundY(center.getLocation().clone().getDirection().normalize().multiply(0.19), -100.0).add(center.getLocation().clone().getDirection().normalize().multiply(-0.11));
        ArmorStand middle = new ArmorStand(loc.clone().add(vector));
        this.setStand(middle, yaw);
        ArmorStand slot0 = new ArmorStand(middle.getLocation().clone().add(this.rotateVectorAroundY(center.getLocation().clone().getDirection().normalize().multiply(0.2), -90.0)));
        this.setStand(slot0, yaw + 20.0f);
        ArmorStand slot1 = new ArmorStand(middle.getLocation().clone().add(this.rotateVectorAroundY(center.getLocation().clone().getDirection().normalize().multiply(0.2), 90.0)));
        this.setStand(slot1, yaw - 20.0f);
        map.put("0", slot0);
        map.put("1", slot1);
        PacketManager.sendArmorStandSpawn(InteractionVisualizerAPI.getPlayerModuleList(InteractionVisualizerAPI.Modules.ITEMSTAND, KEY), slot0);
        PacketManager.sendArmorStandSpawn(InteractionVisualizerAPI.getPlayerModuleList(InteractionVisualizerAPI.Modules.ITEMSTAND, KEY), slot1);
        return map;
    }

    public void setStand(ArmorStand stand, float yaw) {
        stand.setArms(true);
        stand.setBasePlate(false);
        stand.setMarker(true);
        stand.setGravity(false);
        stand.setInvulnerable(true);
        stand.setVisible(false);
        stand.setSilent(true);
        stand.setSmall(true);
        stand.setRightArmPose(new EulerAngle(0.0, 0.0, 0.0));
        stand.setCustomName("IV.SmithingTable.Item");
        stand.setRotation(yaw, stand.getLocation().getPitch());
    }

    public void setStand(ArmorStand stand) {
        stand.setArms(true);
        stand.setBasePlate(false);
        stand.setMarker(true);
        stand.setSmall(true);
        stand.setSilent(true);
        stand.setGravity(false);
        stand.setInvulnerable(true);
        stand.setVisible(false);
    }

    public Vector rotateVectorAroundY(Vector vector, double degrees) {
        double rad = Math.toRadians(degrees);
        double currentX = vector.getX();
        double currentZ = vector.getZ();
        double cosine = Math.cos(rad);
        double sine = Math.sin(rad);
        return new Vector(cosine * currentX - sine * currentZ, vector.getY(), sine * currentX + cosine * currentZ);
    }

    public float getCardinalDirection(Entity e) {
        double rotation = (e.getLocation().getYaw() - 90.0f) % 360.0f;
        if (rotation < 0.0) {
            rotation += 360.0;
        }
        if (0.0 <= rotation && rotation < 45.0) {
            return 90.0f;
        }
        if (45.0 <= rotation && rotation < 135.0) {
            return 180.0f;
        }
        if (135.0 <= rotation && rotation < 225.0) {
            return -90.0f;
        }
        if (225.0 <= rotation && rotation < 315.0) {
            return 0.0f;
        }
        if (315.0 <= rotation && rotation < 360.0) {
            return 90.0f;
        }
        return 0.0f;
    }
}

