/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.interactionvisualizer.blocks;

import com.loohp.interactionvisualizer.InteractionVisualizer;
import com.loohp.interactionvisualizer.api.InteractionVisualizerAPI;
import com.loohp.interactionvisualizer.api.VisualizerRunnableDisplay;
import com.loohp.interactionvisualizer.entityholders.ArmorStand;
import com.loohp.interactionvisualizer.managers.MusicManager;
import com.loohp.interactionvisualizer.managers.PacketManager;
import com.loohp.interactionvisualizer.objectholders.EntryKey;
import com.loohp.interactionvisualizer.utils.LegacyInstrumentUtils;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Note;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.NoteBlock;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.plugin.Plugin;

public class NoteBlockDisplay
extends VisualizerRunnableDisplay
implements Listener {
    public static final EntryKey KEY = new EntryKey("note_block");
    public ConcurrentHashMap<Block, ConcurrentHashMap<String, Object>> displayingNotes = new ConcurrentHashMap();

    @Override
    public EntryKey key() {
        return KEY;
    }

    @Override
    public int gc() {
        return -1;
    }

    @Override
    public int run() {
        return Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)InteractionVisualizer.plugin, () -> {
            Iterator<Map.Entry<Block, ConcurrentHashMap<String, Object>>> itr = this.displayingNotes.entrySet().iterator();
            while (itr.hasNext()) {
                long timeout;
                Map.Entry<Block, ConcurrentHashMap<String, Object>> entry = itr.next();
                long unix = System.currentTimeMillis();
                if (unix <= (timeout = ((Long)entry.getValue().get("Timeout")).longValue())) continue;
                ArmorStand stand = (ArmorStand)entry.getValue().get("Stand");
                Bukkit.getScheduler().runTask((Plugin)InteractionVisualizer.plugin, () -> PacketManager.removeArmorStand(InteractionVisualizerAPI.getPlayers(), stand));
                itr.remove();
            }
        }, 0L, 20L).getTaskId();
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onUseNoteBlock(PlayerInteractEvent event) {
        boolean holdingAir;
        Block block = event.getClickedBlock();
        if (block == null) {
            return;
        }
        if (!block.getType().equals((Object)Material.NOTE_BLOCK)) {
            return;
        }
        Player player = event.getPlayer();
        if (player.getGameMode().equals((Object)GameMode.SPECTATOR)) {
            return;
        }
        boolean bl = holdingAir = player.getEquipment().getItemInMainHand() == null || player.getEquipment().getItemInMainHand().getType().equals((Object)Material.AIR);
        if (player.isSneaking() && !holdingAir) {
            return;
        }
        BlockFace face = event.getBlockFace();
        Location textLocation = this.getFaceOffset(block, face);
        Bukkit.getScheduler().runTaskLater((Plugin)InteractionVisualizer.plugin, () -> {
            String text;
            if (!block.getType().equals((Object)Material.NOTE_BLOCK)) {
                return;
            }
            ConcurrentHashMap<String, Object> map = this.displayingNotes.get(block);
            ArmorStand stand = map == null ? new ArmorStand(textLocation.clone().add(0.0, -0.3, 0.0)) : (ArmorStand)map.get("Stand");
            stand.teleport(textLocation.clone().add(0.0, -0.3, 0.0));
            this.setStand(stand);
            map = map == null ? new ConcurrentHashMap<String, Object>() : map;
            map.put("Stand", stand);
            map.put("Timeout", System.currentTimeMillis() + 3000L);
            this.displayingNotes.put(block, map);
            if (!InteractionVisualizer.version.isLegacy()) {
                org.bukkit.block.data.type.NoteBlock state = (org.bukkit.block.data.type.NoteBlock)block.getBlockData();
                Note.Tone tone = state.getNote().getTone();
                String inst = MusicManager.getMusicConfig().getString("Instruments." + state.getInstrument().toString().toUpperCase());
                text = ChatColor.GOLD + inst + " " + this.getColor(tone) + tone.toString().toUpperCase();
                text = state.getNote().isSharped() ? text + "#" : text;
                text = state.getNote().getOctave() == 0 ? text : text + " ^";
            } else {
                NoteBlock state = (NoteBlock)block.getState();
                Note.Tone tone = state.getNote().getTone();
                String inst = MusicManager.getMusicConfig().getString("Instruments." + LegacyInstrumentUtils.getInstrumentNameFromLegacy(block.getRelative(BlockFace.DOWN).getType().toString().toUpperCase()));
                text = ChatColor.GOLD + inst + " " + this.getColor(tone) + tone.toString().toUpperCase();
                text = state.getNote().isSharped() ? text + "#" : text;
                text = state.getNote().getOctave() == 0 ? text : text + " ^";
            }
            stand.setCustomName(text);
            PacketManager.sendArmorStandSpawn(InteractionVisualizerAPI.getPlayerModuleList(InteractionVisualizerAPI.Modules.HOLOGRAM, KEY), stand);
            PacketManager.updateArmorStand(stand);
        }, 1L);
    }

    public void setStand(ArmorStand stand) {
        stand.setArms(true);
        stand.setBasePlate(false);
        stand.setMarker(true);
        stand.setGravity(false);
        stand.setSmall(true);
        stand.setSilent(true);
        stand.setInvulnerable(true);
        stand.setVisible(false);
        stand.setCustomNameVisible(true);
    }

    public Location getFaceOffset(Block block, BlockFace face) {
        Location location = block.getLocation().clone().add(0.5, 0.5, 0.5);
        switch (face) {
            case DOWN: {
                return location.add(0.0, -0.8, 0.0);
            }
            case EAST: {
                return location.add(0.8, 0.0, 0.0);
            }
            case NORTH: {
                return location.add(0.0, 0.0, -0.8);
            }
            case SOUTH: {
                return location.add(0.0, 0.0, 0.8);
            }
            case UP: {
                return location.add(0.0, 0.8, 0.0);
            }
            case WEST: {
                return location.add(-0.8, 0.0, 0.0);
            }
        }
        return location.add(0.0, 0.8, 0.0);
    }

    public ChatColor getColor(Note.Tone tone) {
        switch (tone) {
            case A: {
                return ChatColor.RED;
            }
            case B: {
                return ChatColor.GOLD;
            }
            case C: {
                return ChatColor.YELLOW;
            }
            case D: {
                return ChatColor.GREEN;
            }
            case E: {
                return ChatColor.AQUA;
            }
            case F: {
                return ChatColor.BLUE;
            }
            case G: {
                return ChatColor.LIGHT_PURPLE;
            }
        }
        return ChatColor.AQUA;
    }
}

