/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.interactionvisualizer.blocks;

import com.loohp.interactionvisualizer.InteractionVisualizer;
import com.loohp.interactionvisualizer.api.InteractionVisualizerAPI;
import com.loohp.interactionvisualizer.api.VisualizerRunnableDisplay;
import com.loohp.interactionvisualizer.api.events.InteractionVisualizerReloadEvent;
import com.loohp.interactionvisualizer.api.events.TileEntityRemovedEvent;
import com.loohp.interactionvisualizer.entityholders.ArmorStand;
import com.loohp.interactionvisualizer.entityholders.Item;
import com.loohp.interactionvisualizer.libs.net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import com.loohp.interactionvisualizer.managers.PacketManager;
import com.loohp.interactionvisualizer.managers.PlayerLocationManager;
import com.loohp.interactionvisualizer.managers.SoundManager;
import com.loohp.interactionvisualizer.managers.TileEntityManager;
import com.loohp.interactionvisualizer.objectholders.EntryKey;
import com.loohp.interactionvisualizer.objectholders.TileEntity;
import com.loohp.interactionvisualizer.utils.ChatColorUtils;
import com.loohp.interactionvisualizer.utils.InventoryUtils;
import com.loohp.interactionvisualizer.utils.LegacyFacingUtils;
import com.loohp.interactionvisualizer.utils.MCVersion;
import com.loohp.interactionvisualizer.utils.VanishUtils;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.Furnace;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Directional;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.inventory.FurnaceInventory;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.EulerAngle;
import org.bukkit.util.Vector;

public class FurnaceDisplay
extends VisualizerRunnableDisplay
implements Listener {
    public static final EntryKey KEY = new EntryKey("furnace");
    public ConcurrentHashMap<Block, Map<String, Object>> furnaceMap = new ConcurrentHashMap();
    private int checkingPeriod = 20;
    private int gcPeriod = 600;
    private String progressBarCharacter = "";
    private String emptyColor = "&7";
    private String filledColor = "&e";
    private String noFuelColor = "&c";
    private int progressBarLength = 10;
    private String amountPending = " &7+{Amount}";

    public FurnaceDisplay() {
        this.onReload(new InteractionVisualizerReloadEvent());
    }

    @EventHandler
    public void onReload(InteractionVisualizerReloadEvent event) {
        this.checkingPeriod = InteractionVisualizer.plugin.getConfiguration().getInt("Blocks.Furnace.CheckingPeriod");
        this.gcPeriod = InteractionVisualizerAPI.getGCPeriod();
        this.progressBarCharacter = ChatColorUtils.translateAlternateColorCodes('&', InteractionVisualizer.plugin.getConfiguration().getString("Blocks.Furnace.Options.ProgressBarCharacter"));
        this.emptyColor = ChatColorUtils.translateAlternateColorCodes('&', InteractionVisualizer.plugin.getConfiguration().getString("Blocks.Furnace.Options.EmptyColor"));
        this.filledColor = ChatColorUtils.translateAlternateColorCodes('&', InteractionVisualizer.plugin.getConfiguration().getString("Blocks.Furnace.Options.FilledColor"));
        this.noFuelColor = ChatColorUtils.translateAlternateColorCodes('&', InteractionVisualizer.plugin.getConfiguration().getString("Blocks.Furnace.Options.NoFuelColor"));
        this.progressBarLength = InteractionVisualizer.plugin.getConfiguration().getInt("Blocks.Furnace.Options.ProgressBarLength");
        this.amountPending = ChatColorUtils.translateAlternateColorCodes('&', InteractionVisualizer.plugin.getConfiguration().getString("Blocks.Furnace.Options.AmountPending"));
    }

    @Override
    public EntryKey key() {
        return KEY;
    }

    @Override
    public int gc() {
        return Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)InteractionVisualizer.plugin, () -> {
            Iterator<Map.Entry<Block, Map<String, Object>>> itr = this.furnaceMap.entrySet().iterator();
            int count = 0;
            int maxper = (int)Math.ceil((double)this.furnaceMap.size() / (double)this.gcPeriod);
            int delay = 1;
            while (itr.hasNext()) {
                if (++count > maxper) {
                    count = 0;
                    ++delay;
                }
                Map.Entry<Block, Map<String, Object>> entry = itr.next();
                Bukkit.getScheduler().runTaskLater((Plugin)InteractionVisualizer.plugin, () -> {
                    Block block = (Block)entry.getKey();
                    if (!this.isActive(block.getLocation())) {
                        Map map = (Map)entry.getValue();
                        if (map.get("Item") instanceof Item) {
                            Item item = (Item)map.get("Item");
                            PacketManager.removeItem(InteractionVisualizerAPI.getPlayers(), item);
                        }
                        if (map.get("Stand") instanceof ArmorStand) {
                            ArmorStand stand = (ArmorStand)map.get("Stand");
                            PacketManager.removeArmorStand(InteractionVisualizerAPI.getPlayers(), stand);
                        }
                        this.furnaceMap.remove(block);
                        return;
                    }
                    if (!this.isFurnace(block.getType())) {
                        Map map = (Map)entry.getValue();
                        if (map.get("Item") instanceof Item) {
                            Item item = (Item)map.get("Item");
                            PacketManager.removeItem(InteractionVisualizerAPI.getPlayers(), item);
                        }
                        if (map.get("Stand") instanceof ArmorStand) {
                            ArmorStand stand = (ArmorStand)map.get("Stand");
                            PacketManager.removeArmorStand(InteractionVisualizerAPI.getPlayers(), stand);
                        }
                        this.furnaceMap.remove(block);
                        return;
                    }
                }, (long)delay);
            }
        }, 0L, (long)this.gcPeriod).getTaskId();
    }

    @Override
    public int run() {
        return Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)InteractionVisualizer.plugin, () -> {
            Bukkit.getScheduler().runTask((Plugin)InteractionVisualizer.plugin, () -> {
                Set<Block> list = this.nearbyFurnace();
                for (Block block : list) {
                    if (this.furnaceMap.get(block) != null || !this.isActive(block.getLocation()) || !this.isFurnace(block.getType())) continue;
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    map.put("Item", "N/A");
                    map.putAll(this.spawnArmorStands(block));
                    this.furnaceMap.put(block, map);
                }
            });
            Iterator<Map.Entry<Block, Map<String, Object>>> itr = this.furnaceMap.entrySet().iterator();
            int count = 0;
            int maxper = (int)Math.ceil((double)this.furnaceMap.size() / (double)this.checkingPeriod);
            int delay = 1;
            while (itr.hasNext()) {
                Map.Entry<Block, Map<String, Object>> entry = itr.next();
                if (++count > maxper) {
                    count = 0;
                    ++delay;
                }
                Bukkit.getScheduler().runTaskLater((Plugin)InteractionVisualizer.plugin, () -> {
                    Block block = (Block)entry.getKey();
                    if (!this.isActive(block.getLocation())) {
                        return;
                    }
                    if (!this.isFurnace(block.getType())) {
                        return;
                    }
                    Furnace furnace = (Furnace)block.getState();
                    InteractionVisualizer.asyncExecutorManager.runTaskAsynchronously(() -> {
                        FurnaceInventory inv = furnace.getInventory();
                        ItemStack itemstack = inv.getItem(0);
                        if (itemstack != null && itemstack.getType().equals((Object)Material.AIR)) {
                            itemstack = null;
                        }
                        if (itemstack == null && (itemstack = inv.getItem(2)) != null && itemstack.getType().equals((Object)Material.AIR)) {
                            itemstack = null;
                        }
                        Item item = null;
                        if (((Map)entry.getValue()).get("Item") instanceof String) {
                            if (itemstack != null) {
                                item = new Item(furnace.getLocation().clone().add(0.5, 1.0, 0.5));
                                item.setItemStack(itemstack);
                                item.setVelocity(new Vector(0, 0, 0));
                                item.setPickupDelay(Short.MAX_VALUE);
                                item.setGravity(false);
                                ((Map)entry.getValue()).put("Item", item);
                                PacketManager.sendItemSpawn(InteractionVisualizerAPI.getPlayerModuleList(InteractionVisualizerAPI.Modules.ITEMDROP, KEY), item);
                                PacketManager.updateItem(item);
                            } else {
                                ((Map)entry.getValue()).put("Item", "N/A");
                            }
                        } else {
                            item = (Item)((Map)entry.getValue()).get("Item");
                            if (itemstack != null) {
                                if (!item.getItemStack().equals((Object)itemstack)) {
                                    item.setItemStack(itemstack);
                                    PacketManager.updateItem(item);
                                }
                            } else {
                                ((Map)entry.getValue()).put("Item", "N/A");
                                PacketManager.removeItem(InteractionVisualizerAPI.getPlayers(), item);
                            }
                        }
                        ArmorStand stand = (ArmorStand)((Map)entry.getValue()).get("Stand");
                        if (this.hasItemToCook(furnace)) {
                            short time = furnace.getCookTime();
                            int max = 200;
                            if (!(InteractionVisualizer.version.isLegacy() || InteractionVisualizer.version.equals((Object)MCVersion.V1_13) || InteractionVisualizer.version.equals((Object)MCVersion.V1_13_1))) {
                                max = furnace.getCookTimeTotal();
                            }
                            String symbol = "";
                            double percentagescaled = (double)time / (double)max * (double)this.progressBarLength;
                            double i = 1.0;
                            for (i = 1.0; i < percentagescaled; i += 1.0) {
                                symbol = symbol + this.filledColor + this.progressBarCharacter;
                            }
                            if (percentagescaled - (i -= 1.0) > 0.0 && percentagescaled - i < 0.33) {
                                symbol = symbol + this.emptyColor + this.progressBarCharacter;
                            } else if (percentagescaled - i > 0.0 && percentagescaled - i < 0.67) {
                                symbol = symbol + this.emptyColor + this.progressBarCharacter;
                            } else if (percentagescaled - i > 0.0) {
                                symbol = symbol + this.filledColor + this.progressBarCharacter;
                            }
                            for (i = (double)(this.progressBarLength - 1); i >= percentagescaled; i -= 1.0) {
                                symbol = symbol + this.emptyColor + this.progressBarCharacter;
                            }
                            int left = inv.getItem(0).getAmount() - 1;
                            if (left > 0) {
                                symbol = symbol + this.amountPending.replace("{Amount}", left + "");
                            }
                            if (symbol.contains("{CompletedAmount}")) {
                                symbol = symbol.replace("{CompletedAmount}", (inv.getItem(2) == null ? 0 : inv.getItem(2).getAmount()) + "");
                            }
                            if (this.hasFuel(furnace)) {
                                if (!PlainTextComponentSerializer.plainText().serialize(stand.getCustomName()).equals(symbol) || !stand.isCustomNameVisible()) {
                                    stand.setCustomNameVisible(true);
                                    stand.setCustomName(symbol);
                                    PacketManager.updateArmorStandOnlyMeta(stand);
                                }
                            } else {
                                symbol = this.noFuelColor + ChatColor.stripColor((String)symbol);
                                if (!PlainTextComponentSerializer.plainText().serialize(stand.getCustomName()).equals(symbol) || !stand.isCustomNameVisible()) {
                                    stand.setCustomNameVisible(true);
                                    stand.setCustomName(symbol);
                                    PacketManager.updateArmorStandOnlyMeta(stand);
                                }
                            }
                        } else if (!PlainTextComponentSerializer.plainText().serialize(stand.getCustomName()).equals("") || stand.isCustomNameVisible()) {
                            stand.setCustomNameVisible(false);
                            stand.setCustomName("");
                            PacketManager.updateArmorStandOnlyMeta(stand);
                        }
                    });
                }, (long)delay);
            }
        }, 0L, (long)this.checkingPeriod).getTaskId();
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onFurnace(InventoryClickEvent event) {
        if (VanishUtils.isVanished((Player)event.getWhoClicked())) {
            return;
        }
        if (event.isCancelled()) {
            return;
        }
        if (event.getRawSlot() != 0 && event.getRawSlot() != 2) {
            return;
        }
        if (event.getCurrentItem() == null) {
            return;
        }
        if (event.getCurrentItem().getType().equals((Object)Material.AIR)) {
            return;
        }
        if (event.getRawSlot() == 2 ? event.getCursor() != null && !event.getCursor().getType().equals((Object)Material.AIR) && event.getCursor().getAmount() >= event.getCursor().getType().getMaxStackSize() : event.getCursor() != null && event.getCursor().getType().equals((Object)event.getCurrentItem().getType())) {
            return;
        }
        if (event.isShiftClick() && !InventoryUtils.stillHaveSpace((Inventory)event.getWhoClicked().getInventory(), event.getView().getItem(event.getRawSlot()).getType())) {
            return;
        }
        if (event.getAction().equals((Object)InventoryAction.HOTBAR_MOVE_AND_READD) && event.getWhoClicked().getInventory().getItem(event.getHotbarButton()) != null && !event.getWhoClicked().getInventory().getItem(event.getHotbarButton()).getType().equals((Object)Material.AIR)) {
            return;
        }
        if (event.getView().getTopInventory() == null) {
            return;
        }
        try {
            if (event.getView().getTopInventory().getLocation() == null) {
                return;
            }
        }
        catch (AbstractMethodError | Exception e) {
            return;
        }
        if (event.getView().getTopInventory().getLocation().getBlock() == null) {
            return;
        }
        if (!this.isFurnace(event.getView().getTopInventory().getLocation().getBlock().getType())) {
            return;
        }
        Block block = event.getView().getTopInventory().getLocation().getBlock();
        if (!this.furnaceMap.containsKey(block)) {
            return;
        }
        Map<String, Object> map = this.furnaceMap.get(block);
        int slot = event.getRawSlot();
        ItemStack itemstack = event.getCurrentItem().clone();
        Location loc = block.getLocation();
        Player player = (Player)event.getWhoClicked();
        Bukkit.getScheduler().runTaskLater((Plugin)InteractionVisualizer.plugin, () -> {
            if (player.getOpenInventory().getItem(slot) == null || itemstack.isSimilar(player.getOpenInventory().getItem(slot)) && itemstack.getAmount() == player.getOpenInventory().getItem(slot).getAmount()) {
                return;
            }
            if (map.get("Item") instanceof String) {
                map.put("Item", new Item(block.getLocation().clone().add(0.5, 1.2, 0.5)));
            }
            Item item = (Item)map.get("Item");
            map.put("Item", "N/A");
            item.setItemStack(itemstack);
            item.setLocked(true);
            Vector lift = new Vector(0.0, 0.15, 0.0);
            Vector pickup = player.getEyeLocation().add(0.0, -0.5, 0.0).add(0.0, InteractionVisualizer.playerPickupYOffset.doubleValue(), 0.0).toVector().subtract(loc.clone().add(0.5, 1.2, 0.5).toVector()).multiply(0.15).add(lift);
            item.setVelocity(pickup);
            item.setGravity(true);
            item.setPickupDelay(Short.MAX_VALUE);
            PacketManager.updateItem(item);
            Bukkit.getScheduler().runTaskLater((Plugin)InteractionVisualizer.plugin, () -> {
                SoundManager.playItemPickup(item.getLocation(), InteractionVisualizerAPI.getPlayerModuleList(InteractionVisualizerAPI.Modules.ITEMDROP, KEY));
                PacketManager.removeItem(InteractionVisualizerAPI.getPlayers(), item);
            }, 8L);
        }, 1L);
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onUseFurnace(InventoryClickEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (event.getWhoClicked().getGameMode().equals((Object)GameMode.SPECTATOR)) {
            return;
        }
        if (event.getView().getTopInventory() == null) {
            return;
        }
        try {
            if (event.getView().getTopInventory().getLocation() == null) {
                return;
            }
        }
        catch (AbstractMethodError | Exception e) {
            return;
        }
        if (event.getView().getTopInventory().getLocation().getBlock() == null) {
            return;
        }
        if (!this.isFurnace(event.getView().getTopInventory().getLocation().getBlock().getType())) {
            return;
        }
        if (event.getRawSlot() >= 0 && event.getRawSlot() <= 2) {
            PacketManager.sendHandMovement(InteractionVisualizerAPI.getPlayers(), (Player)event.getWhoClicked());
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onDragFurnace(InventoryDragEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (event.getWhoClicked().getGameMode().equals((Object)GameMode.SPECTATOR)) {
            return;
        }
        if (event.getView().getTopInventory() == null) {
            return;
        }
        try {
            if (event.getView().getTopInventory().getLocation() == null) {
                return;
            }
        }
        catch (AbstractMethodError | Exception e) {
            return;
        }
        if (event.getView().getTopInventory().getLocation().getBlock() == null) {
            return;
        }
        if (!this.isFurnace(event.getView().getTopInventory().getLocation().getBlock().getType())) {
            return;
        }
        Iterator iterator = event.getRawSlots().iterator();
        while (iterator.hasNext()) {
            int slot = (Integer)iterator.next();
            if (slot < 0 || slot > 2) continue;
            PacketManager.sendHandMovement(InteractionVisualizerAPI.getPlayers(), (Player)event.getWhoClicked());
            break;
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onBreakFurnace(TileEntityRemovedEvent event) {
        Block block = event.getBlock();
        if (!this.furnaceMap.containsKey(block)) {
            return;
        }
        Map<String, Object> map = this.furnaceMap.get(block);
        if (map.get("Item") instanceof Item) {
            Item item = (Item)map.get("Item");
            PacketManager.removeItem(InteractionVisualizerAPI.getPlayers(), item);
        }
        if (map.get("Stand") instanceof ArmorStand) {
            ArmorStand stand = (ArmorStand)map.get("Stand");
            PacketManager.removeArmorStand(InteractionVisualizerAPI.getPlayers(), stand);
        }
        this.furnaceMap.remove(block);
    }

    public boolean hasItemToCook(Furnace furnace) {
        FurnaceInventory inv = furnace.getInventory();
        if (inv.getItem(0) != null) {
            return !inv.getItem(0).getType().equals((Object)Material.AIR);
        }
        return false;
    }

    public boolean hasFuel(Furnace furnace) {
        if (furnace.getBurnTime() > 0) {
            return true;
        }
        FurnaceInventory inv = furnace.getInventory();
        if (inv.getItem(1) != null) {
            return !inv.getItem(1).getType().equals((Object)Material.AIR);
        }
        return false;
    }

    public Set<Block> nearbyFurnace() {
        return TileEntityManager.getTileEntites(TileEntity.TileEntityType.FURNACE);
    }

    public boolean isActive(Location loc) {
        return PlayerLocationManager.hasPlayerNearby(loc);
    }

    public Map<String, ArmorStand> spawnArmorStands(Block block) {
        HashMap<String, ArmorStand> map = new HashMap<String, ArmorStand>();
        Location origin = block.getLocation();
        BlockFace facing = null;
        if (!InteractionVisualizer.version.isLegacy()) {
            BlockData blockData = block.getState().getBlockData();
            facing = ((Directional)blockData).getFacing();
        } else {
            facing = LegacyFacingUtils.getFacing(block);
        }
        Location target = block.getRelative(facing).getLocation();
        Vector direction = target.toVector().subtract(origin.toVector()).multiply(0.7);
        Location loc = block.getLocation().clone().add(direction).add(0.5, 0.2, 0.5);
        ArmorStand slot1 = new ArmorStand(loc.clone());
        this.setStand(slot1);
        map.put("Stand", slot1);
        PacketManager.sendArmorStandSpawn(InteractionVisualizerAPI.getPlayerModuleList(InteractionVisualizerAPI.Modules.HOLOGRAM, KEY), slot1);
        return map;
    }

    public void setStand(ArmorStand stand) {
        stand.setBasePlate(false);
        stand.setMarker(true);
        stand.setGravity(false);
        stand.setSmall(true);
        stand.setInvulnerable(true);
        stand.setSilent(true);
        stand.setVisible(false);
        stand.setCustomName("");
        stand.setRightArmPose(new EulerAngle(0.0, 0.0, 0.0));
    }

    public boolean isFurnace(String material) {
        if (material.equalsIgnoreCase("FURNACE")) {
            return true;
        }
        return material.equalsIgnoreCase("BURNING_FURNACE");
    }

    public boolean isFurnace(Material material) {
        return this.isFurnace(material.toString());
    }
}

