/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.interactionvisualizer.blocks;

import com.loohp.interactionvisualizer.InteractionVisualizer;
import com.loohp.interactionvisualizer.api.InteractionVisualizerAPI;
import com.loohp.interactionvisualizer.api.VisualizerDisplay;
import com.loohp.interactionvisualizer.entityholders.Item;
import com.loohp.interactionvisualizer.managers.PacketManager;
import com.loohp.interactionvisualizer.objectholders.EntryKey;
import com.loohp.interactionvisualizer.utils.InventoryUtils;
import com.loohp.interactionvisualizer.utils.MCVersion;
import com.loohp.interactionvisualizer.utils.MaterialUtils;
import com.loohp.interactionvisualizer.utils.OpenInvUtils;
import com.loohp.interactionvisualizer.utils.VanishUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Bukkit;
import org.bukkit.FluidCollisionMode;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public class EnderchestDisplay
implements Listener,
VisualizerDisplay {
    public static final EntryKey KEY = new EntryKey("ender_chest");
    public static ConcurrentHashMap<Player, List<Item>> link = new ConcurrentHashMap();
    public static ConcurrentHashMap<Player, Block> playermap = new ConcurrentHashMap();

    @Override
    public EntryKey key() {
        return KEY;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @EventHandler(priority=EventPriority.MONITOR)
    public void onOpenEnderChest(InventoryOpenEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (VanishUtils.isVanished((Player)event.getPlayer())) {
            return;
        }
        if (OpenInvUtils.isSlientChest((Player)event.getPlayer())) {
            return;
        }
        if (event.getPlayer().getGameMode().equals((Object)GameMode.SPECTATOR)) {
            return;
        }
        if (event.getView().getTopInventory() == null) {
            return;
        }
        if (!event.getView().getTopInventory().getType().equals((Object)InventoryType.ENDER_CHEST)) {
            return;
        }
        if (!InventoryUtils.compareContents(event.getPlayer().getEnderChest(), event.getView().getTopInventory())) {
            return;
        }
        if (!(InteractionVisualizer.version.isLegacy() || InteractionVisualizer.version.equals((Object)MCVersion.V1_13) || InteractionVisualizer.version.equals((Object)MCVersion.V1_13_1))) {
            if (event.getPlayer().getTargetBlockExact(7, FluidCollisionMode.NEVER) == null) return;
            if (!event.getPlayer().getTargetBlockExact(7, FluidCollisionMode.NEVER).getType().equals((Object)Material.ENDER_CHEST)) {
                return;
            }
        } else {
            if (event.getPlayer().getTargetBlock(MaterialUtils.getNonSolidSet(), 7) == null) return;
            if (!event.getPlayer().getTargetBlock(MaterialUtils.getNonSolidSet(), 7).getType().equals((Object)Material.ENDER_CHEST)) {
                return;
            }
        }
        Block block = null;
        block = !InteractionVisualizer.version.isLegacy() && !InteractionVisualizer.version.equals((Object)MCVersion.V1_13) && !InteractionVisualizer.version.equals((Object)MCVersion.V1_13_1) ? event.getPlayer().getTargetBlockExact(7, FluidCollisionMode.NEVER) : event.getPlayer().getTargetBlock(MaterialUtils.getNonSolidSet(), 7);
        playermap.put((Player)event.getPlayer(), block);
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onUseEnderChest(InventoryClickEvent event) {
        Player player = (Player)event.getWhoClicked();
        if (event.isCancelled()) {
            return;
        }
        if (!playermap.containsKey(player)) {
            return;
        }
        if (event.getClick().equals((Object)ClickType.MIDDLE) && !event.getWhoClicked().getGameMode().equals((Object)GameMode.CREATIVE)) {
            return;
        }
        Inventory topInventory = event.getView().getTopInventory();
        Block block = playermap.get(player);
        Location loc = block.getLocation();
        boolean isIn = true;
        boolean isMove = false;
        ItemStack itemstack = null;
        if (event.getRawSlot() >= 0 && event.getRawSlot() < topInventory.getSize()) {
            itemstack = event.getCurrentItem();
            if (itemstack != null) {
                if (itemstack.getType().equals((Object)Material.AIR)) {
                    itemstack = null;
                } else {
                    isIn = false;
                    isMove = true;
                }
            }
            if (itemstack == null) {
                itemstack = event.getCursor();
                if (itemstack != null) {
                    if (itemstack.getType().equals((Object)Material.AIR)) {
                        itemstack = null;
                    } else {
                        isMove = true;
                    }
                }
            } else if (event.getCursor() != null && event.getCursor().getType().equals((Object)itemstack.getType())) {
                isIn = true;
            }
            if (itemstack == null && (event.getAction().equals((Object)InventoryAction.HOTBAR_MOVE_AND_READD) || event.getAction().equals((Object)InventoryAction.HOTBAR_SWAP)) && (itemstack = event.getWhoClicked().getInventory().getItem(event.getHotbarButton())) != null) {
                if (itemstack.getType().equals((Object)Material.AIR)) {
                    itemstack = null;
                } else {
                    isMove = true;
                }
            }
        }
        if (itemstack == null && event.getAction().equals((Object)InventoryAction.MOVE_TO_OTHER_INVENTORY) && (itemstack = event.getCurrentItem()) != null) {
            if (itemstack.getType().equals((Object)Material.AIR)) {
                itemstack = null;
            } else {
                isMove = true;
            }
        }
        if (event.isShiftClick() && event.getView().getItem(event.getRawSlot()) != null && (isIn ? !InventoryUtils.stillHaveSpace(event.getView().getTopInventory(), event.getView().getItem(event.getRawSlot()).getType()) : !InventoryUtils.stillHaveSpace((Inventory)event.getWhoClicked().getInventory(), event.getView().getItem(event.getRawSlot()).getType()))) {
            return;
        }
        if (event.getCursor() != null && !event.getCursor().getType().equals((Object)Material.AIR) && event.getCurrentItem() != null && !event.getCurrentItem().getType().equals((Object)Material.AIR) && event.getCurrentItem().getType().equals((Object)event.getCursor().getType()) && event.getCurrentItem().getAmount() >= event.getCurrentItem().getType().getMaxStackSize()) {
            return;
        }
        if (isMove) {
            PacketManager.sendHandMovement(InteractionVisualizerAPI.getPlayers(), player);
            if (itemstack != null) {
                Item item = new Item(loc.clone().add(0.5, 1.0, 0.5));
                Vector offset = new Vector(0.0, 0.15, 0.0);
                Vector vector = loc.clone().add(0.5, 1.0, 0.5).toVector().subtract(event.getWhoClicked().getEyeLocation().clone().add(0.0, -0.5, 0.0).add(0.0, InteractionVisualizer.playerPickupYOffset.doubleValue(), 0.0).toVector()).multiply(-0.15).add(offset);
                item.setVelocity(vector);
                if (isIn) {
                    item.teleport(event.getWhoClicked().getEyeLocation().add(0.0, InteractionVisualizer.playerPickupYOffset.doubleValue(), 0.0));
                    vector = loc.clone().add(0.5, 1.0, 0.5).toVector().subtract(event.getWhoClicked().getEyeLocation().clone().add(0.0, InteractionVisualizer.playerPickupYOffset.doubleValue(), 0.0).toVector()).multiply(0.15).add(offset);
                    item.setVelocity(vector);
                }
                PacketManager.sendItemSpawn(InteractionVisualizerAPI.getPlayerModuleList(InteractionVisualizerAPI.Modules.ITEMDROP, KEY), item);
                item.setItemStack(itemstack);
                item.setPickupDelay(Short.MAX_VALUE);
                item.setGravity(true);
                PacketManager.updateItem(item);
                if (!link.containsKey(player)) {
                    link.put(player, new ArrayList());
                }
                List<Item> list = link.get(player);
                list.add(item);
                boolean finalIsIn = isIn;
                Bukkit.getScheduler().runTaskLater((Plugin)InteractionVisualizer.plugin, () -> {
                    if (finalIsIn) {
                        item.teleport(loc.clone().add(0.5, 1.0, 0.5));
                    } else {
                        item.teleport(event.getWhoClicked().getEyeLocation().add(0.0, -0.5, 0.0).add(0.0, InteractionVisualizer.playerPickupYOffset.doubleValue(), 0.0));
                    }
                    item.setVelocity(new Vector(0.0, 0.0, 0.0));
                    item.setGravity(false);
                    PacketManager.updateItem(item);
                }, 8L);
                Bukkit.getScheduler().runTaskLater((Plugin)InteractionVisualizer.plugin, () -> {
                    PacketManager.removeItem(InteractionVisualizerAPI.getPlayers(), item);
                    list.remove(item);
                }, 20L);
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onDragEnderChest(InventoryDragEvent event) {
        Player player = (Player)event.getWhoClicked();
        if (event.isCancelled()) {
            return;
        }
        if (!playermap.containsKey(player)) {
            return;
        }
        boolean ok = false;
        for (Map.Entry entry : event.getNewItems().entrySet()) {
            ItemStack item = event.getView().getItem(((Integer)entry.getKey()).intValue());
            if (item == null) {
                ok = true;
                break;
            }
            if (item.getType().equals((Object)Material.AIR)) {
                ok = true;
                break;
            }
            if (!item.getType().equals((Object)((ItemStack)entry.getValue()).getType()) || item.getAmount() >= item.getType().getMaxStackSize()) continue;
            ok = true;
            break;
        }
        if (!ok) {
            return;
        }
        Inventory topInventory = event.getView().getTopInventory();
        Block block = playermap.get(player);
        Location loc = block.getLocation();
        Iterator iterator = event.getRawSlots().iterator();
        while (iterator.hasNext()) {
            int slot = (Integer)iterator.next();
            if (slot < 0 || slot >= topInventory.getSize()) continue;
            PacketManager.sendHandMovement(InteractionVisualizerAPI.getPlayers(), player);
            ItemStack itemstack = event.getOldCursor();
            if (itemstack != null && itemstack.getType().equals((Object)Material.AIR)) {
                itemstack = null;
            }
            if (itemstack == null) break;
            Item item = new Item(event.getWhoClicked().getEyeLocation().add(0.0, InteractionVisualizer.playerPickupYOffset.doubleValue(), 0.0));
            Vector offset = new Vector(0.0, 0.15, 0.0);
            Vector vector = loc.clone().add(0.5, 1.0, 0.5).toVector().subtract(event.getWhoClicked().getEyeLocation().clone().add(0.0, InteractionVisualizer.playerPickupYOffset.doubleValue(), 0.0).toVector()).multiply(0.15).add(offset);
            item.setVelocity(vector);
            PacketManager.sendItemSpawn(InteractionVisualizerAPI.getPlayerModuleList(InteractionVisualizerAPI.Modules.ITEMDROP, KEY), item);
            item.setItemStack(itemstack);
            item.setCustomName(System.currentTimeMillis() + "");
            item.setPickupDelay(Short.MAX_VALUE);
            item.setGravity(true);
            PacketManager.updateItem(item);
            if (!link.containsKey(player)) {
                link.put(player, new ArrayList());
            }
            List<Item> list = link.get(player);
            list.add(item);
            Bukkit.getScheduler().runTaskLater((Plugin)InteractionVisualizer.plugin, () -> {
                item.teleport(loc.clone().add(0.5, 1.0, 0.5));
                item.setVelocity(new Vector(0.0, 0.0, 0.0));
                item.setGravity(false);
                PacketManager.updateItem(item);
            }, 8L);
            Bukkit.getScheduler().runTaskLater((Plugin)InteractionVisualizer.plugin, () -> {
                PacketManager.removeItem(InteractionVisualizerAPI.getPlayers(), item);
                list.remove(item);
            }, 20L);
            break;
        }
    }

    @EventHandler
    public void onCloseEnderChest(InventoryCloseEvent event) {
        Player player = (Player)event.getPlayer();
        if (!playermap.containsKey(player)) {
            return;
        }
        List<Item> list = link.get(player);
        if (list != null) {
            for (Item item : list) {
                PacketManager.removeItem(InteractionVisualizerAPI.getPlayers(), item);
            }
            link.remove(player);
        }
        playermap.remove(player);
    }
}

