/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.interactionvisualizer.blocks;

import com.loohp.interactionvisualizer.InteractionVisualizer;
import com.loohp.interactionvisualizer.api.InteractionVisualizerAPI;
import com.loohp.interactionvisualizer.api.VisualizerInteractDisplay;
import com.loohp.interactionvisualizer.api.events.InteractionVisualizerReloadEvent;
import com.loohp.interactionvisualizer.managers.PacketManager;
import com.loohp.interactionvisualizer.objectholders.EnchantmentTableAnimation;
import com.loohp.interactionvisualizer.objectholders.EntryKey;
import com.loohp.interactionvisualizer.utils.CustomMapUtils;
import com.loohp.interactionvisualizer.utils.InventoryUtils;
import com.loohp.interactionvisualizer.utils.VanishUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.enchantment.EnchantItemEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.EnchantmentStorageMeta;
import org.bukkit.plugin.Plugin;

public class EnchantmentTableDisplay
extends VisualizerInteractDisplay
implements Listener {
    public static final Pattern VALID_NUMBER = Pattern.compile("-?[0-9]+");
    private static Method bukkitEnchantmentGetIdMethod;
    private static Set<String> translatableEnchantments;
    private static Map<String, String> customDefinedEnchantmentNames;
    public Map<Player, Block> playermap = new ConcurrentHashMap<Player, Block>();

    public static Set<String> getTranslatableEnchantments() {
        return translatableEnchantments;
    }

    public static Map<String, String> getCustomDefinedEnchantmentNames() {
        return customDefinedEnchantmentNames;
    }

    public static String getEnchantmentIdOrKey(Enchantment enchantment) {
        if (InteractionVisualizer.version.isLegacy()) {
            try {
                return bukkitEnchantmentGetIdMethod.invoke((Object)enchantment, new Object[0]).toString();
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                e.printStackTrace();
                return "-1";
            }
        }
        return enchantment.getKey().toString();
    }

    public EnchantmentTableDisplay() {
        this.onReload(new InteractionVisualizerReloadEvent());
    }

    @EventHandler
    public void onReload(InteractionVisualizerReloadEvent event) {
        translatableEnchantments = new HashSet<String>(InteractionVisualizer.plugin.getConfiguration().getStringList("Blocks.EnchantmentTable.Options.TranslatableEnchantments"));
        customDefinedEnchantmentNames = new HashMap<String, String>();
        if (InteractionVisualizer.plugin.getConfiguration().isConfigurationSection("Blocks.EnchantmentTable.Options.CustomDefinedEnchantmentNames")) {
            for (Map.Entry<String, Object> entry : InteractionVisualizer.plugin.getConfiguration().getConfigurationSection("Blocks.EnchantmentTable.Options.CustomDefinedEnchantmentNames").getValues(false).entrySet()) {
                String key = entry.getKey();
                if (!key.contains(":") && !VALID_NUMBER.matcher(key).matches()) {
                    key = "minecraft:" + key;
                }
                customDefinedEnchantmentNames.put(key, entry.getValue().toString());
            }
        }
    }

    @Override
    public EntryKey key() {
        return EnchantmentTableAnimation.KEY;
    }

    @Override
    public void process(Player player) {
        Block block;
        InventoryView view;
        if (VanishUtils.isVanished(player)) {
            return;
        }
        if (!this.playermap.containsKey(player)) {
            if (player.getGameMode().equals((Object)GameMode.SPECTATOR)) {
                return;
            }
            if (player.getOpenInventory().getTopInventory().getLocation() == null) {
                return;
            }
            if (player.getOpenInventory().getTopInventory().getLocation().getBlock() == null) {
                return;
            }
            if (!InteractionVisualizer.version.isLegacy() ? !player.getOpenInventory().getTopInventory().getLocation().getBlock().getType().toString().equalsIgnoreCase("ENCHANTING_TABLE") : !player.getOpenInventory().getTopInventory().getLocation().getBlock().getType().toString().equalsIgnoreCase("ENCHANTMENT_TABLE")) {
                return;
            }
            view = player.getOpenInventory();
            block = view.getTopInventory().getLocation().getBlock();
            this.playermap.put(player, block);
        }
        view = player.getOpenInventory();
        block = this.playermap.get(player);
        EnchantmentTableAnimation animation = EnchantmentTableAnimation.getTableAnimation(block, player);
        if (animation == null) {
            return;
        }
        ItemStack itemstack = view.getItem(0) != null && !view.getItem(0).getType().equals((Object)Material.AIR) ? view.getItem(0).clone() : null;
        Bukkit.getScheduler().runTaskLater((Plugin)InteractionVisualizer.plugin, () -> {
            if (!animation.isEnchanting()) {
                animation.queueSetItem(itemstack, a -> {
                    InventoryView inventory = player.getOpenInventory();
                    if (inventory.equals(view) && inventory.countSlots() > 0) {
                        ItemStack current = view.getItem(0) != null && !view.getItem(0).getType().equals((Object)Material.AIR) ? view.getItem(0).clone() : null;
                        return current.isSimilar(itemstack);
                    }
                    return false;
                });
            }
        }, 2L);
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onEnchant(EnchantItemEvent event) {
        if (VanishUtils.isVanished(event.getEnchanter())) {
            return;
        }
        if (event.isCancelled()) {
            return;
        }
        Block block = event.getEnchantBlock();
        Player player = event.getEnchanter();
        Bukkit.getScheduler().runTaskLater((Plugin)InteractionVisualizer.plugin, () -> {
            if (!player.getOpenInventory().getTopInventory().getType().equals((Object)InventoryType.ENCHANTING)) {
                return;
            }
            ItemStack itemstack = player.getOpenInventory().getItem(0).clone();
            HashMap<Enchantment, Integer> enchantsAdded = new HashMap<Enchantment, Integer>();
            if (itemstack.getType().equals((Object)Material.ENCHANTED_BOOK)) {
                enchantsAdded.putAll(((EnchantmentStorageMeta)itemstack.getItemMeta()).getStoredEnchants());
            }
            enchantsAdded.putAll(itemstack.getEnchantments());
            enchantsAdded = CustomMapUtils.sortMapByValueReverse(enchantsAdded);
            EnchantmentTableAnimation animation = EnchantmentTableAnimation.getTableAnimation(block, player);
            if (animation == null) {
                return;
            }
            if (!animation.isEnchanting()) {
                animation.queueEnchant(enchantsAdded, event.getExpLevelCost(), itemstack, a -> true);
            }
        }, 2L);
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onEnchantmentTableTake(InventoryClickEvent event) {
        Player player;
        if (VanishUtils.isVanished((Player)event.getWhoClicked())) {
            return;
        }
        if (event.isCancelled()) {
            return;
        }
        if (event.getRawSlot() != 0) {
            return;
        }
        if (event.getCurrentItem() == null) {
            return;
        }
        if (event.getCurrentItem().getType().equals((Object)Material.AIR)) {
            return;
        }
        if (event.getCursor() != null && event.getCursor().getType().equals((Object)event.getCurrentItem().getType())) {
            return;
        }
        if (event.isShiftClick() && !InventoryUtils.stillHaveSpace((Inventory)event.getWhoClicked().getInventory(), event.getView().getItem(event.getRawSlot()).getType())) {
            return;
        }
        if (!this.playermap.containsKey((Player)event.getWhoClicked())) {
            return;
        }
        Block block = this.playermap.get((Player)event.getWhoClicked());
        EnchantmentTableAnimation animation = EnchantmentTableAnimation.getTableAnimation(block, player = (Player)event.getWhoClicked());
        if (animation == null) {
            return;
        }
        ItemStack itemstack = event.getCurrentItem().clone();
        int slot = event.getRawSlot();
        Bukkit.getScheduler().runTaskLater((Plugin)InteractionVisualizer.plugin, () -> {
            if (player.getOpenInventory().getItem(slot) == null || itemstack.isSimilar(player.getOpenInventory().getItem(slot)) && itemstack.getAmount() == player.getOpenInventory().getItem(slot).getAmount()) {
                return;
            }
            animation.queuePickupAnimation(itemstack, a -> {
                ItemStack stack = a.getItemStack();
                return stack != null && stack.isSimilar(itemstack);
            });
        }, 1L);
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onUseEnchantmentTable(InventoryClickEvent event) {
        if (event.isCancelled()) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        if (!this.playermap.containsKey(player)) {
            return;
        }
        if (event.getRawSlot() >= 0 && event.getRawSlot() <= 1) {
            PacketManager.sendHandMovement(InteractionVisualizerAPI.getPlayers(), player);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onDragEnchantmentTable(InventoryDragEvent event) {
        if (event.isCancelled()) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        if (!this.playermap.containsKey(player)) {
            return;
        }
        Iterator iterator = event.getRawSlots().iterator();
        while (iterator.hasNext()) {
            int slot = (Integer)iterator.next();
            if (slot < 0 || slot > 1) continue;
            PacketManager.sendHandMovement(InteractionVisualizerAPI.getPlayers(), player);
            break;
        }
    }

    @EventHandler
    public void onCloseEnchantmentTable(InventoryCloseEvent event) {
        Player player = (Player)event.getPlayer();
        if (!this.playermap.containsKey(player)) {
            return;
        }
        Block block = this.playermap.remove(player);
        ItemStack itemstack = event.getView().getItem(0) != null ? (!event.getView().getItem(0).getType().equals((Object)Material.AIR) ? event.getView().getItem(0).clone() : null) : null;
        Bukkit.getScheduler().runTaskLater((Plugin)InteractionVisualizer.plugin, () -> {
            EnchantmentTableAnimation animation = EnchantmentTableAnimation.getTableAnimation(block, player);
            if (animation == null) {
                return;
            }
            animation.queuePickupAnimation(itemstack, a -> {
                ItemStack stack = a.getItemStack();
                return stack != null && stack.isSimilar(itemstack);
            });
            animation.queueClose(a -> true);
        }, 1L);
    }

    static {
        translatableEnchantments = new HashSet<String>();
        customDefinedEnchantmentNames = new HashMap<String, String>();
        if (InteractionVisualizer.version.isLegacy()) {
            try {
                bukkitEnchantmentGetIdMethod = Enchantment.class.getMethod("getId", new Class[0]);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

