/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.interactionvisualizer.blocks;

import com.loohp.interactionvisualizer.InteractionVisualizer;
import com.loohp.interactionvisualizer.api.InteractionVisualizerAPI;
import com.loohp.interactionvisualizer.api.VisualizerRunnableDisplay;
import com.loohp.interactionvisualizer.api.events.InteractionVisualizerReloadEvent;
import com.loohp.interactionvisualizer.api.events.TileEntityRemovedEvent;
import com.loohp.interactionvisualizer.entityholders.ArmorStand;
import com.loohp.interactionvisualizer.entityholders.DynamicVisualizerEntity;
import com.loohp.interactionvisualizer.entityholders.SurroundingPlaneArmorStand;
import com.loohp.interactionvisualizer.libs.net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import com.loohp.interactionvisualizer.managers.PacketManager;
import com.loohp.interactionvisualizer.managers.PlayerLocationManager;
import com.loohp.interactionvisualizer.managers.TileEntityManager;
import com.loohp.interactionvisualizer.objectholders.EntryKey;
import com.loohp.interactionvisualizer.objectholders.TileEntity;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.EulerAngle;

public class ConduitDisplay
extends VisualizerRunnableDisplay
implements Listener {
    public static final EntryKey KEY = new EntryKey("conduit");
    public ConcurrentHashMap<Block, Map<String, Object>> conduitMap = new ConcurrentHashMap();
    public ConcurrentHashMap<Block, float[]> placemap = new ConcurrentHashMap();
    private int checkingPeriod = 20;
    private int gcPeriod = 600;
    private DynamicVisualizerEntity.PathType pathType = DynamicVisualizerEntity.PathType.CIRCLE;

    public ConduitDisplay() {
        this.onReload(new InteractionVisualizerReloadEvent());
    }

    @EventHandler
    public void onReload(InteractionVisualizerReloadEvent event) {
        this.checkingPeriod = InteractionVisualizer.plugin.getConfiguration().getInt("Blocks.Conduit.CheckingPeriod");
        this.gcPeriod = InteractionVisualizerAPI.getGCPeriod();
        this.pathType = DynamicVisualizerEntity.PathType.valueOf(InteractionVisualizer.plugin.getConfiguration().getString("Blocks.Conduit.PathType"));
    }

    @Override
    public EntryKey key() {
        return KEY;
    }

    @Override
    public int gc() {
        return Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)InteractionVisualizer.plugin, () -> {
            Iterator<Map.Entry<Block, Map<String, Object>>> itr = this.conduitMap.entrySet().iterator();
            int count = 0;
            int maxper = (int)Math.ceil((double)this.conduitMap.size() / (double)this.gcPeriod);
            int delay = 1;
            while (itr.hasNext()) {
                if (++count > maxper) {
                    count = 0;
                    ++delay;
                }
                Map.Entry<Block, Map<String, Object>> entry = itr.next();
                Bukkit.getScheduler().runTaskLater((Plugin)InteractionVisualizer.plugin, () -> {
                    Block block = (Block)entry.getKey();
                    if (!this.isActive(block.getLocation())) {
                        ArmorStand stand;
                        Map map = (Map)entry.getValue();
                        if (map.get("1") instanceof ArmorStand) {
                            stand = (ArmorStand)map.get("1");
                            PacketManager.removeArmorStand(InteractionVisualizerAPI.getPlayers(), stand);
                        }
                        if (map.get("2") instanceof ArmorStand) {
                            stand = (ArmorStand)map.get("2");
                            PacketManager.removeArmorStand(InteractionVisualizerAPI.getPlayers(), stand);
                        }
                        this.conduitMap.remove(block);
                        return;
                    }
                    if (!block.getType().equals((Object)Material.CONDUIT)) {
                        ArmorStand stand;
                        Map map = (Map)entry.getValue();
                        if (map.get("1") instanceof ArmorStand) {
                            stand = (ArmorStand)map.get("1");
                            PacketManager.removeArmorStand(InteractionVisualizerAPI.getPlayers(), stand);
                        }
                        if (map.get("2") instanceof ArmorStand) {
                            stand = (ArmorStand)map.get("2");
                            PacketManager.removeArmorStand(InteractionVisualizerAPI.getPlayers(), stand);
                        }
                        this.conduitMap.remove(block);
                        return;
                    }
                }, (long)delay);
            }
        }, 0L, (long)this.gcPeriod).getTaskId();
    }

    @Override
    public int run() {
        return Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)InteractionVisualizer.plugin, () -> {
            Bukkit.getScheduler().runTask((Plugin)InteractionVisualizer.plugin, () -> {
                Set<Block> list = this.nearbyConduit();
                for (Block block : list) {
                    if (this.conduitMap.get(block) != null || !this.isActive(block.getLocation()) || !block.getType().equals((Object)Material.CONDUIT)) continue;
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    map.put("Item", "N/A");
                    map.putAll(this.spawnArmorStands(block));
                    this.conduitMap.put(block, map);
                }
            });
            Iterator<Map.Entry<Block, Map<String, Object>>> itr = this.conduitMap.entrySet().iterator();
            int count = 0;
            int maxper = (int)Math.ceil((double)this.conduitMap.size() / (double)this.checkingPeriod);
            int delay = 1;
            while (itr.hasNext()) {
                Map.Entry<Block, Map<String, Object>> entry = itr.next();
                if (++count > maxper) {
                    count = 0;
                    ++delay;
                }
                Bukkit.getScheduler().runTaskLater((Plugin)InteractionVisualizer.plugin, () -> {
                    Block block = (Block)entry.getKey();
                    if (!this.isActive(block.getLocation())) {
                        return;
                    }
                    if (!block.getType().equals((Object)Material.CONDUIT)) {
                        return;
                    }
                    int amount = this.getFrameAmount(block);
                    InteractionVisualizer.asyncExecutorManager.runTaskAsynchronously(() -> {
                        String arrow = "\u27f9";
                        String square = "\u2b1b";
                        ArmorStand line1 = (ArmorStand)((Map)entry.getValue()).get("1");
                        ArmorStand line2 = (ArmorStand)((Map)entry.getValue()).get("2");
                        int range = this.getRange(amount);
                        ChatColor color = range > 0 ? ChatColor.AQUA : ChatColor.YELLOW;
                        String one = color + square + amount + " " + arrow + " " + range + "m";
                        if (!PlainTextComponentSerializer.plainText().serialize(line1.getCustomName()).equals(one) || !line1.isCustomNameVisible()) {
                            line1.setCustomName(one);
                            line1.setCustomNameVisible(true);
                            PacketManager.updateArmorStandOnlyMeta(line1);
                        }
                        if (range < 96) {
                            if (!PlainTextComponentSerializer.plainText().serialize(line2.getCustomName()).equals("") || line2.isCustomNameVisible()) {
                                line2.setCustomName("");
                                line2.setCustomNameVisible(false);
                                PacketManager.updateArmorStandOnlyMeta(line2);
                            }
                        } else {
                            String damage = ChatColor.AQUA + "4(" + ChatColor.RED + "\u2665\u2665" + ChatColor.AQUA + ") / 2s";
                            if (!PlainTextComponentSerializer.plainText().serialize(line2.getCustomName()).equals(damage) || !line2.isCustomNameVisible()) {
                                line2.setCustomName(damage);
                                line2.setCustomNameVisible(true);
                                PacketManager.updateArmorStandOnlyMeta(line2);
                            }
                        }
                    });
                }, (long)delay);
            }
        }, 0L, (long)this.checkingPeriod).getTaskId();
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlaceConduit(BlockPlaceEvent event) {
        if (event.isCancelled()) {
            return;
        }
        Block block = event.getBlockPlaced();
        if (this.conduitMap.containsKey(block)) {
            return;
        }
        if (!block.getType().equals((Object)Material.CONDUIT)) {
            return;
        }
        this.placemap.put(block, new float[]{event.getPlayer().getLocation().getYaw(), event.getPlayer().getLocation().getPitch()});
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onBreakConduit(TileEntityRemovedEvent event) {
        ArmorStand stand;
        Block block = event.getBlock();
        if (!this.conduitMap.containsKey(block)) {
            return;
        }
        Map<String, Object> map = this.conduitMap.get(block);
        if (map.get("1") instanceof ArmorStand) {
            stand = (ArmorStand)map.get("1");
            PacketManager.removeArmorStand(InteractionVisualizerAPI.getPlayers(), stand);
        }
        if (map.get("2") instanceof ArmorStand) {
            stand = (ArmorStand)map.get("2");
            PacketManager.removeArmorStand(InteractionVisualizerAPI.getPlayers(), stand);
        }
        this.conduitMap.remove(block);
    }

    public Set<Block> nearbyConduit() {
        return TileEntityManager.getTileEntites(TileEntity.TileEntityType.CONDUIT);
    }

    public boolean isActive(Location loc) {
        return PlayerLocationManager.hasPlayerNearby(loc);
    }

    public Map<String, ArmorStand> spawnArmorStands(Block block) {
        HashMap<String, ArmorStand> map = new HashMap<String, ArmorStand>();
        Location origin = block.getLocation().add(0.5, 0.001, 0.5);
        SurroundingPlaneArmorStand line1 = new SurroundingPlaneArmorStand(origin.clone().add(0.0, 0.28, 0.0), 0.4, this.pathType);
        this.setStand(line1);
        SurroundingPlaneArmorStand line2 = new SurroundingPlaneArmorStand(origin.clone(), 0.4, this.pathType);
        this.setStand(line2);
        map.put("1", line1);
        map.put("2", line2);
        PacketManager.sendArmorStandSpawn(InteractionVisualizerAPI.getPlayerModuleList(InteractionVisualizerAPI.Modules.HOLOGRAM, KEY), line1);
        PacketManager.sendArmorStandSpawn(InteractionVisualizerAPI.getPlayerModuleList(InteractionVisualizerAPI.Modules.HOLOGRAM, KEY), line2);
        return map;
    }

    public void setStand(ArmorStand stand) {
        stand.setBasePlate(false);
        stand.setMarker(true);
        stand.setGravity(false);
        stand.setSmall(true);
        stand.setSilent(true);
        stand.setInvulnerable(true);
        stand.setVisible(false);
        stand.setCustomName("");
        stand.setRightArmPose(new EulerAngle(0.0, 0.0, 0.0));
    }

    public int getFrameAmount(Block block) {
        ArrayList<Block> blocks = new ArrayList<Block>();
        Block up = block.getRelative(BlockFace.UP, 2);
        Block down = block.getRelative(BlockFace.DOWN, 2);
        Block north = block.getRelative(BlockFace.NORTH, 2);
        Block east = block.getRelative(BlockFace.EAST, 2);
        Block south = block.getRelative(BlockFace.SOUTH, 2);
        Block west = block.getRelative(BlockFace.WEST, 2);
        blocks.add(up);
        blocks.add(up.getRelative(BlockFace.NORTH, 1));
        blocks.add(up.getRelative(BlockFace.EAST, 1));
        blocks.add(up.getRelative(BlockFace.SOUTH, 1));
        blocks.add(up.getRelative(BlockFace.WEST, 1));
        blocks.add(down);
        blocks.add(down.getRelative(BlockFace.NORTH, 1));
        blocks.add(down.getRelative(BlockFace.EAST, 1));
        blocks.add(down.getRelative(BlockFace.SOUTH, 1));
        blocks.add(down.getRelative(BlockFace.WEST, 1));
        blocks.add(north);
        blocks.add(north.getRelative(BlockFace.UP, 1));
        blocks.add(north.getRelative(BlockFace.UP, 2));
        blocks.add(north.getRelative(BlockFace.DOWN, 1));
        blocks.add(north.getRelative(BlockFace.DOWN, 2));
        blocks.add(north.getRelative(BlockFace.EAST, 1));
        blocks.add(north.getRelative(BlockFace.WEST, 1));
        blocks.add(south);
        blocks.add(south.getRelative(BlockFace.UP, 1));
        blocks.add(south.getRelative(BlockFace.UP, 2));
        blocks.add(south.getRelative(BlockFace.DOWN, 1));
        blocks.add(south.getRelative(BlockFace.DOWN, 2));
        blocks.add(south.getRelative(BlockFace.EAST, 1));
        blocks.add(south.getRelative(BlockFace.WEST, 1));
        blocks.add(east);
        blocks.add(east.getRelative(BlockFace.UP, 1));
        blocks.add(east.getRelative(BlockFace.UP, 2));
        blocks.add(east.getRelative(BlockFace.DOWN, 1));
        blocks.add(east.getRelative(BlockFace.DOWN, 2));
        blocks.add(east.getRelative(BlockFace.NORTH, 1));
        blocks.add(east.getRelative(BlockFace.NORTH, 2));
        blocks.add(east.getRelative(BlockFace.SOUTH, 1));
        blocks.add(east.getRelative(BlockFace.SOUTH, 2));
        blocks.add(west);
        blocks.add(west.getRelative(BlockFace.UP, 1));
        blocks.add(west.getRelative(BlockFace.UP, 2));
        blocks.add(west.getRelative(BlockFace.DOWN, 1));
        blocks.add(west.getRelative(BlockFace.DOWN, 2));
        blocks.add(west.getRelative(BlockFace.NORTH, 1));
        blocks.add(west.getRelative(BlockFace.NORTH, 2));
        blocks.add(west.getRelative(BlockFace.SOUTH, 1));
        blocks.add(west.getRelative(BlockFace.SOUTH, 2));
        int amount = 0;
        for (Block frame : blocks) {
            Material type = frame.getType();
            if (!type.equals((Object)Material.PRISMARINE) && !type.equals((Object)Material.DARK_PRISMARINE) && !type.equals((Object)Material.PRISMARINE_BRICKS) && !type.equals((Object)Material.SEA_LANTERN)) continue;
            ++amount;
        }
        return amount;
    }

    public int getRange(int amount) {
        if (amount < 16) {
            return 0;
        }
        return amount / 7 * 16;
    }
}

