/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.interactionvisualizer.blocks;

import com.loohp.interactionvisualizer.InteractionVisualizer;
import com.loohp.interactionvisualizer.api.InteractionVisualizerAPI;
import com.loohp.interactionvisualizer.api.VisualizerRunnableDisplay;
import com.loohp.interactionvisualizer.api.events.InteractionVisualizerReloadEvent;
import com.loohp.interactionvisualizer.api.events.TileEntityRemovedEvent;
import com.loohp.interactionvisualizer.entityholders.ArmorStand;
import com.loohp.interactionvisualizer.libs.net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import com.loohp.interactionvisualizer.managers.PacketManager;
import com.loohp.interactionvisualizer.managers.PlayerLocationManager;
import com.loohp.interactionvisualizer.managers.TileEntityManager;
import com.loohp.interactionvisualizer.objectholders.EntryKey;
import com.loohp.interactionvisualizer.objectholders.TileEntity;
import com.loohp.interactionvisualizer.utils.ChatColorUtils;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Directional;
import org.bukkit.block.data.type.Beehive;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityChangeBlockEvent;
import org.bukkit.event.entity.EntityEnterBlockEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.EulerAngle;
import org.bukkit.util.Vector;

public class BeeHiveDisplay
extends VisualizerRunnableDisplay
implements Listener {
    public static final EntryKey KEY = new EntryKey("beehive");
    public ConcurrentHashMap<Block, Map<String, Object>> beehiveMap = new ConcurrentHashMap();
    private int checkingPeriod = 20;
    private int gcPeriod = 600;
    private String honeyLevelCharacter = "";
    private String emptyColor = "&7";
    private String filledColor = "&e";
    private String noCampfireColor = "&c";
    private String beeCountText = "&e{Current}&6/{Max}";

    public BeeHiveDisplay() {
        this.onReload(new InteractionVisualizerReloadEvent());
    }

    @EventHandler
    public void onReload(InteractionVisualizerReloadEvent event) {
        this.checkingPeriod = InteractionVisualizer.plugin.getConfiguration().getInt("Blocks.BeeHive.CheckingPeriod");
        this.gcPeriod = InteractionVisualizerAPI.getGCPeriod();
        this.honeyLevelCharacter = ChatColorUtils.translateAlternateColorCodes('&', InteractionVisualizer.plugin.getConfiguration().getString("Blocks.BeeHive.Options.HoneyLevelCharacter"));
        this.emptyColor = ChatColorUtils.translateAlternateColorCodes('&', InteractionVisualizer.plugin.getConfiguration().getString("Blocks.BeeHive.Options.EmptyColor"));
        this.filledColor = ChatColorUtils.translateAlternateColorCodes('&', InteractionVisualizer.plugin.getConfiguration().getString("Blocks.BeeHive.Options.FilledColor"));
        this.noCampfireColor = ChatColorUtils.translateAlternateColorCodes('&', InteractionVisualizer.plugin.getConfiguration().getString("Blocks.BeeHive.Options.NoCampfireColor"));
        this.beeCountText = ChatColorUtils.translateAlternateColorCodes('&', InteractionVisualizer.plugin.getConfiguration().getString("Blocks.BeeHive.Options.BeeCountText"));
    }

    @Override
    public EntryKey key() {
        return KEY;
    }

    @Override
    public int gc() {
        return Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)InteractionVisualizer.plugin, () -> {
            Iterator<Map.Entry<Block, Map<String, Object>>> itr = this.beehiveMap.entrySet().iterator();
            int count = 0;
            int maxper = (int)Math.ceil((double)this.beehiveMap.size() / (double)this.gcPeriod);
            int delay = 1;
            while (itr.hasNext()) {
                if (++count > maxper) {
                    count = 0;
                    ++delay;
                }
                Map.Entry<Block, Map<String, Object>> entry = itr.next();
                Bukkit.getScheduler().runTaskLater((Plugin)InteractionVisualizer.plugin, () -> {
                    Block block = (Block)entry.getKey();
                    if (!this.isActive(block.getLocation())) {
                        ArmorStand stand;
                        Map map = (Map)entry.getValue();
                        if (map.get("0") instanceof ArmorStand) {
                            stand = (ArmorStand)map.get("0");
                            PacketManager.removeArmorStand(InteractionVisualizerAPI.getPlayers(), stand);
                        }
                        if (map.get("1") instanceof ArmorStand) {
                            stand = (ArmorStand)map.get("1");
                            PacketManager.removeArmorStand(InteractionVisualizerAPI.getPlayers(), stand);
                        }
                        this.beehiveMap.remove(block);
                        return;
                    }
                    if (!block.getType().equals((Object)Material.BEEHIVE)) {
                        ArmorStand stand;
                        Map map = (Map)entry.getValue();
                        if (map.get("0") instanceof ArmorStand) {
                            stand = (ArmorStand)map.get("0");
                            PacketManager.removeArmorStand(InteractionVisualizerAPI.getPlayers(), stand);
                        }
                        if (map.get("1") instanceof ArmorStand) {
                            stand = (ArmorStand)map.get("1");
                            PacketManager.removeArmorStand(InteractionVisualizerAPI.getPlayers(), stand);
                        }
                        this.beehiveMap.remove(block);
                        return;
                    }
                }, (long)delay);
            }
        }, 0L, (long)this.gcPeriod).getTaskId();
    }

    @Override
    public int run() {
        return Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)InteractionVisualizer.plugin, () -> {
            Bukkit.getScheduler().runTask((Plugin)InteractionVisualizer.plugin, () -> {
                Set<Block> list = this.nearbyBeehive();
                for (Block block : list) {
                    if (this.beehiveMap.get(block) != null || !this.isActive(block.getLocation()) || !block.getType().equals((Object)Material.BEEHIVE)) continue;
                    HashMap<String, ArmorStand> map = new HashMap<String, ArmorStand>();
                    map.putAll(this.spawnArmorStands(block));
                    this.beehiveMap.put(block, map);
                }
            });
            Iterator<Map.Entry<Block, Map<String, Object>>> itr = this.beehiveMap.entrySet().iterator();
            int count = 0;
            int maxper = (int)Math.ceil((double)this.beehiveMap.size() / (double)this.checkingPeriod);
            int delay = 1;
            while (itr.hasNext()) {
                Map.Entry<Block, Map<String, Object>> entry = itr.next();
                if (++count > maxper) {
                    count = 0;
                    ++delay;
                }
                Bukkit.getScheduler().runTaskLater((Plugin)InteractionVisualizer.plugin, () -> {
                    Block block = (Block)entry.getKey();
                    this.updateBlock(block);
                }, (long)delay);
            }
        }, 0L, (long)this.checkingPeriod).getTaskId();
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onBeeEnterBeehive(EntityEnterBlockEvent event) {
        if (event.isCancelled()) {
            return;
        }
        Block block = event.getBlock();
        Bukkit.getScheduler().runTaskLater((Plugin)InteractionVisualizer.plugin, () -> this.updateBlock(block), 1L);
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onBeeLeaveBeehive(EntityChangeBlockEvent event) {
        if (event.isCancelled()) {
            return;
        }
        Block block = event.getBlock();
        Bukkit.getScheduler().runTaskLater((Plugin)InteractionVisualizer.plugin, () -> this.updateBlock(block), 1L);
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onInteractBeehive(PlayerInteractEvent event) {
        if (event.isCancelled()) {
            return;
        }
        Block block = event.getClickedBlock();
        if (block != null) {
            Bukkit.getScheduler().runTaskLater((Plugin)InteractionVisualizer.plugin, () -> this.updateBlock(block), 1L);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onBreakBeehive(TileEntityRemovedEvent event) {
        ArmorStand stand;
        Block block = event.getBlock();
        if (!this.beehiveMap.containsKey(block)) {
            return;
        }
        Map<String, Object> map = this.beehiveMap.get(block);
        if (map.get("0") instanceof ArmorStand) {
            stand = (ArmorStand)map.get("0");
            PacketManager.removeArmorStand(InteractionVisualizerAPI.getPlayers(), stand);
        }
        if (map.get("1") instanceof ArmorStand) {
            stand = (ArmorStand)map.get("1");
            PacketManager.removeArmorStand(InteractionVisualizerAPI.getPlayers(), stand);
        }
        this.beehiveMap.remove(block);
    }

    public void updateBlock(Block block) {
        if (!this.isActive(block.getLocation())) {
            return;
        }
        if (!block.getType().equals((Object)Material.BEEHIVE)) {
            return;
        }
        if (!this.beehiveMap.containsKey(block)) {
            return;
        }
        Map<String, Object> map = this.beehiveMap.get(block);
        org.bukkit.block.Beehive beehiveState = (org.bukkit.block.Beehive)block.getState();
        Beehive beehiveData = (Beehive)block.getBlockData();
        InteractionVisualizer.asyncExecutorManager.runTaskAsynchronously(() -> {
            int i;
            ArmorStand line0 = (ArmorStand)map.get("0");
            ArmorStand line1 = (ArmorStand)map.get("1");
            String str0 = "";
            for (i = 0; i < beehiveData.getHoneyLevel(); ++i) {
                str0 = str0 + (beehiveState.isSedated() ? this.filledColor : this.noCampfireColor) + this.honeyLevelCharacter;
            }
            for (i = beehiveData.getHoneyLevel(); i < beehiveData.getMaximumHoneyLevel(); ++i) {
                str0 = str0 + this.emptyColor + this.honeyLevelCharacter;
            }
            String str1 = this.beeCountText.replace("{Current}", beehiveState.getEntityCount() + "").replace("{Max}", beehiveState.getMaxEntities() + "");
            if (!PlainTextComponentSerializer.plainText().serialize(line0.getCustomName()).equals(str0)) {
                line0.setCustomName(str0);
                line0.setCustomNameVisible(true);
                PacketManager.updateArmorStandOnlyMeta(line0);
            }
            if (!PlainTextComponentSerializer.plainText().serialize(line1.getCustomName()).equals(str1)) {
                line1.setCustomName(str1);
                line1.setCustomNameVisible(true);
                PacketManager.updateArmorStandOnlyMeta(line1);
            }
        });
    }

    public Set<Block> nearbyBeehive() {
        return TileEntityManager.getTileEntites(TileEntity.TileEntityType.BEEHIVE);
    }

    public boolean isActive(Location loc) {
        return PlayerLocationManager.hasPlayerNearby(loc);
    }

    public Map<String, ArmorStand> spawnArmorStands(Block block) {
        HashMap<String, ArmorStand> map = new HashMap<String, ArmorStand>();
        Location origin = block.getLocation();
        BlockData blockData = block.getState().getBlockData();
        BlockFace facing = ((Directional)blockData).getFacing();
        Location target = block.getRelative(facing).getLocation();
        Vector direction = target.toVector().subtract(origin.toVector()).multiply(0.7);
        Location loc0 = block.getLocation().clone().add(direction).add(0.5, 0.25, 0.5);
        ArmorStand line0 = new ArmorStand(loc0.clone());
        this.setStand(line0);
        Location loc1 = block.getLocation().clone().add(direction).add(0.5, 0.0, 0.5);
        ArmorStand line1 = new ArmorStand(loc1.clone());
        this.setStand(line1);
        map.put("0", line0);
        map.put("1", line1);
        PacketManager.sendArmorStandSpawn(InteractionVisualizerAPI.getPlayerModuleList(InteractionVisualizerAPI.Modules.HOLOGRAM, KEY), line0);
        PacketManager.sendArmorStandSpawn(InteractionVisualizerAPI.getPlayerModuleList(InteractionVisualizerAPI.Modules.HOLOGRAM, KEY), line1);
        return map;
    }

    public void setStand(ArmorStand stand) {
        stand.setBasePlate(false);
        stand.setMarker(true);
        stand.setGravity(false);
        stand.setSmall(true);
        stand.setSilent(true);
        stand.setInvulnerable(true);
        stand.setVisible(false);
        stand.setCustomName("");
        stand.setRightArmPose(new EulerAngle(0.0, 0.0, 0.0));
    }
}

