/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.interactionvisualizer.blocks;

import com.loohp.interactionvisualizer.InteractionVisualizer;
import com.loohp.interactionvisualizer.api.InteractionVisualizerAPI;
import com.loohp.interactionvisualizer.api.VisualizerRunnableDisplay;
import com.loohp.interactionvisualizer.api.events.InteractionVisualizerReloadEvent;
import com.loohp.interactionvisualizer.api.events.TileEntityRemovedEvent;
import com.loohp.interactionvisualizer.entityholders.ArmorStand;
import com.loohp.interactionvisualizer.entityholders.DynamicVisualizerEntity;
import com.loohp.interactionvisualizer.entityholders.SurroundingPlaneArmorStand;
import com.loohp.interactionvisualizer.libs.net.kyori.adventure.text.Component;
import com.loohp.interactionvisualizer.libs.net.kyori.adventure.text.TranslatableComponent;
import com.loohp.interactionvisualizer.libs.net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import com.loohp.interactionvisualizer.libs.net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import com.loohp.interactionvisualizer.managers.PacketManager;
import com.loohp.interactionvisualizer.managers.PlayerLocationManager;
import com.loohp.interactionvisualizer.managers.TileEntityManager;
import com.loohp.interactionvisualizer.objectholders.EntryKey;
import com.loohp.interactionvisualizer.objectholders.TileEntity;
import com.loohp.interactionvisualizer.utils.ColorUtils;
import com.loohp.interactionvisualizer.utils.ComponentFont;
import com.loohp.interactionvisualizer.utils.RomanNumberUtils;
import com.loohp.interactionvisualizer.utils.TranslationUtils;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.Bukkit;
import org.bukkit.DyeColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Beacon;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.EulerAngle;

public class BeaconDisplay
extends VisualizerRunnableDisplay
implements Listener {
    public static final EntryKey KEY = new EntryKey("beacon");
    public Map<Block, Map<String, Object>> beaconMap = new ConcurrentHashMap<Block, Map<String, Object>>();
    private int checkingPeriod = 20;
    private int gcPeriod = 600;
    private DynamicVisualizerEntity.PathType pathType = DynamicVisualizerEntity.PathType.FACE;

    public BeaconDisplay() {
        this.onReload(new InteractionVisualizerReloadEvent());
    }

    @EventHandler
    public void onReload(InteractionVisualizerReloadEvent event) {
        this.checkingPeriod = InteractionVisualizer.plugin.getConfiguration().getInt("Blocks.Beacon.CheckingPeriod");
        this.gcPeriod = InteractionVisualizerAPI.getGCPeriod();
        this.pathType = DynamicVisualizerEntity.PathType.valueOf(InteractionVisualizer.plugin.getConfiguration().getString("Blocks.Beacon.PathType"));
    }

    @Override
    public EntryKey key() {
        return KEY;
    }

    @Override
    public int gc() {
        return Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)InteractionVisualizer.plugin, () -> {
            Iterator<Map.Entry<Block, Map<String, Object>>> itr = this.beaconMap.entrySet().iterator();
            int count = 0;
            int maxper = (int)Math.ceil((double)this.beaconMap.size() / (double)this.gcPeriod);
            int delay = 1;
            while (itr.hasNext()) {
                if (++count > maxper) {
                    count = 0;
                    ++delay;
                }
                Map.Entry<Block, Map<String, Object>> entry = itr.next();
                Bukkit.getScheduler().runTaskLater((Plugin)InteractionVisualizer.plugin, () -> {
                    Block block = (Block)entry.getKey();
                    if (!this.isActive(block.getLocation())) {
                        ArmorStand stand;
                        Map map = (Map)entry.getValue();
                        if (map.get("1") instanceof ArmorStand) {
                            stand = (ArmorStand)map.get("1");
                            PacketManager.removeArmorStand(InteractionVisualizerAPI.getPlayers(), stand);
                        }
                        if (map.get("2") instanceof ArmorStand) {
                            stand = (ArmorStand)map.get("2");
                            PacketManager.removeArmorStand(InteractionVisualizerAPI.getPlayers(), stand);
                        }
                        if (map.get("3") instanceof ArmorStand) {
                            stand = (ArmorStand)map.get("3");
                            PacketManager.removeArmorStand(InteractionVisualizerAPI.getPlayers(), stand);
                        }
                        this.beaconMap.remove(block);
                        return;
                    }
                    if (!block.getType().equals((Object)Material.BEACON)) {
                        ArmorStand stand;
                        Map map = (Map)entry.getValue();
                        if (map.get("1") instanceof ArmorStand) {
                            stand = (ArmorStand)map.get("1");
                            PacketManager.removeArmorStand(InteractionVisualizerAPI.getPlayers(), stand);
                        }
                        if (map.get("2") instanceof ArmorStand) {
                            stand = (ArmorStand)map.get("2");
                            PacketManager.removeArmorStand(InteractionVisualizerAPI.getPlayers(), stand);
                        }
                        if (map.get("3") instanceof ArmorStand) {
                            stand = (ArmorStand)map.get("3");
                            PacketManager.removeArmorStand(InteractionVisualizerAPI.getPlayers(), stand);
                        }
                        this.beaconMap.remove(block);
                        return;
                    }
                }, (long)delay);
            }
        }, 0L, (long)this.gcPeriod).getTaskId();
    }

    @Override
    public int run() {
        return Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)InteractionVisualizer.plugin, () -> {
            Bukkit.getScheduler().runTask((Plugin)InteractionVisualizer.plugin, () -> {
                Set<Block> list = this.nearbyBeacon();
                for (Block block : list) {
                    if (this.beaconMap.get(block) != null || !this.isActive(block.getLocation()) || !block.getType().equals((Object)Material.BEACON)) continue;
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    map.put("Item", "N/A");
                    map.putAll(this.spawnArmorStands(block));
                    this.beaconMap.put(block, map);
                }
            });
            Iterator<Map.Entry<Block, Map<String, Object>>> itr = this.beaconMap.entrySet().iterator();
            int count = 0;
            int maxper = (int)Math.ceil((double)this.beaconMap.size() / (double)this.checkingPeriod);
            int delay = 1;
            while (itr.hasNext()) {
                Map.Entry<Block, Map<String, Object>> entry = itr.next();
                if (++count > maxper) {
                    count = 0;
                    ++delay;
                }
                Bukkit.getScheduler().runTaskLater((Plugin)InteractionVisualizer.plugin, () -> {
                    Block block = (Block)entry.getKey();
                    if (!this.isActive(block.getLocation())) {
                        return;
                    }
                    if (!block.getType().equals((Object)Material.BEACON)) {
                        return;
                    }
                    Beacon beacon = (Beacon)block.getState();
                    InteractionVisualizer.asyncExecutorManager.runTaskAsynchronously(() -> {
                        String arrow = "\u27f9";
                        String up = "\u25b2";
                        ChatColor color = this.getBeaconColor(block);
                        ArmorStand line1 = (ArmorStand)((Map)entry.getValue()).get("1");
                        ArmorStand line2 = (ArmorStand)((Map)entry.getValue()).get("2");
                        ArmorStand line3 = (ArmorStand)((Map)entry.getValue()).get("3");
                        String one = color + up + beacon.getTier() + " " + arrow + " " + this.getRange(beacon.getTier()) + "m";
                        if (beacon.getTier() == 0) {
                            if (!PlainTextComponentSerializer.plainText().serialize(line1.getCustomName()).equals("") || line1.isCustomNameVisible()) {
                                line1.setCustomName("");
                                line1.setCustomNameVisible(false);
                                PacketManager.updateArmorStandOnlyMeta(line1);
                            }
                            if (!PlainTextComponentSerializer.plainText().serialize(line2.getCustomName()).equals(one) || !line2.isCustomNameVisible()) {
                                line2.setCustomName(one);
                                line2.setCustomNameVisible(true);
                                PacketManager.updateArmorStandOnlyMeta(line2);
                            }
                            if (!PlainTextComponentSerializer.plainText().serialize(line3.getCustomName()).equals("") || line3.isCustomNameVisible()) {
                                line3.setCustomName("");
                                line3.setCustomNameVisible(false);
                                PacketManager.updateArmorStandOnlyMeta(line3);
                            }
                        } else {
                            Component levelText;
                            TranslatableComponent effectTrans;
                            TranslatableComponent primaryEffectText = null;
                            TranslatableComponent secondaryEffectText = null;
                            if (beacon.getPrimaryEffect() != null) {
                                effectTrans = Component.translatable(TranslationUtils.getEffect(beacon.getPrimaryEffect().getType()));
                                effectTrans = (TranslatableComponent)effectTrans.color(ColorUtils.toTextColor(color));
                                levelText = ComponentFont.parseFont(LegacyComponentSerializer.legacySection().deserialize(" " + color + RomanNumberUtils.toRoman(beacon.getPrimaryEffect().getAmplifier() + 1)));
                                primaryEffectText = effectTrans = (TranslatableComponent)effectTrans.append(levelText);
                            }
                            if (beacon.getSecondaryEffect() != null) {
                                effectTrans = Component.translatable(TranslationUtils.getEffect(beacon.getSecondaryEffect().getType()));
                                effectTrans = (TranslatableComponent)effectTrans.color(ColorUtils.toTextColor(color));
                                levelText = ComponentFont.parseFont(LegacyComponentSerializer.legacySection().deserialize(" " + color + RomanNumberUtils.toRoman(beacon.getSecondaryEffect().getAmplifier() + 1)));
                                secondaryEffectText = effectTrans = (TranslatableComponent)effectTrans.append(levelText);
                            }
                            if (secondaryEffectText == null) {
                                if (!PlainTextComponentSerializer.plainText().serialize(line1.getCustomName()).equals("") || line1.isCustomNameVisible()) {
                                    line1.setCustomName("");
                                    line1.setCustomNameVisible(false);
                                    PacketManager.updateArmorStandOnlyMeta(line1);
                                }
                                if (!PlainTextComponentSerializer.plainText().serialize(line2.getCustomName()).equals(one) || !line2.isCustomNameVisible()) {
                                    line2.setCustomName(one);
                                    line2.setCustomNameVisible(true);
                                    PacketManager.updateArmorStandOnlyMeta(line2);
                                }
                                if (primaryEffectText == null) {
                                    if (!PlainTextComponentSerializer.plainText().serialize(line3.getCustomName()).equals("") || line3.isCustomNameVisible()) {
                                        line3.setCustomName("");
                                        line3.setCustomNameVisible(false);
                                        PacketManager.updateArmorStandOnlyMeta(line3);
                                    }
                                } else if (!line3.getCustomName().equals(primaryEffectText) || !line3.isCustomNameVisible()) {
                                    line3.setCustomName(primaryEffectText);
                                    line3.setCustomNameVisible(true);
                                    PacketManager.updateArmorStandOnlyMeta(line3);
                                }
                            } else {
                                if (!PlainTextComponentSerializer.plainText().serialize(line1.getCustomName()).equals(one) || !line1.isCustomNameVisible()) {
                                    line1.setCustomName(one);
                                    line1.setCustomNameVisible(true);
                                    PacketManager.updateArmorStandOnlyMeta(line1);
                                }
                                if (primaryEffectText == null) {
                                    if (!PlainTextComponentSerializer.plainText().serialize(line2.getCustomName()).equals("") || line2.isCustomNameVisible()) {
                                        line2.setCustomName("");
                                        line2.setCustomNameVisible(false);
                                        PacketManager.updateArmorStandOnlyMeta(line2);
                                    }
                                } else if (!line2.getCustomName().equals(primaryEffectText) || !line2.isCustomNameVisible()) {
                                    line2.setCustomName(primaryEffectText);
                                    line2.setCustomNameVisible(true);
                                    PacketManager.updateArmorStandOnlyMeta(line2);
                                }
                                if (!line3.getCustomName().equals(secondaryEffectText) || !line3.isCustomNameVisible()) {
                                    line3.setCustomName(secondaryEffectText);
                                    line3.setCustomNameVisible(true);
                                    PacketManager.updateArmorStandOnlyMeta(line3);
                                }
                            }
                        }
                    });
                }, (long)delay);
            }
        }, 0L, (long)this.checkingPeriod).getTaskId();
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onBreakBeacon(TileEntityRemovedEvent event) {
        ArmorStand stand;
        Block block = event.getBlock();
        if (!this.beaconMap.containsKey(block)) {
            return;
        }
        Map<String, Object> map = this.beaconMap.get(block);
        if (map.get("1") instanceof ArmorStand) {
            stand = (ArmorStand)map.get("1");
            PacketManager.removeArmorStand(InteractionVisualizerAPI.getPlayers(), stand);
        }
        if (map.get("2") instanceof ArmorStand) {
            stand = (ArmorStand)map.get("2");
            PacketManager.removeArmorStand(InteractionVisualizerAPI.getPlayers(), stand);
        }
        if (map.get("3") instanceof ArmorStand) {
            stand = (ArmorStand)map.get("3");
            PacketManager.removeArmorStand(InteractionVisualizerAPI.getPlayers(), stand);
        }
        this.beaconMap.remove(block);
    }

    public Set<Block> nearbyBeacon() {
        return TileEntityManager.getTileEntites(TileEntity.TileEntityType.BEACON);
    }

    public boolean isActive(Location loc) {
        return PlayerLocationManager.hasPlayerNearby(loc);
    }

    public Map<String, ArmorStand> spawnArmorStands(Block block) {
        HashMap<String, ArmorStand> map = new HashMap<String, ArmorStand>();
        Location origin = block.getLocation().add(0.5, 0.25, 0.5);
        SurroundingPlaneArmorStand line1 = new SurroundingPlaneArmorStand(origin.clone().add(0.0, 0.25, 0.0), 0.7, this.pathType);
        this.setStand(line1);
        SurroundingPlaneArmorStand line2 = new SurroundingPlaneArmorStand(origin.clone(), 0.7, this.pathType);
        this.setStand(line2);
        SurroundingPlaneArmorStand line3 = new SurroundingPlaneArmorStand(origin.clone().add(0.0, -0.25, 0.0), 0.7, this.pathType);
        this.setStand(line3);
        map.put("1", line1);
        map.put("2", line2);
        map.put("3", line3);
        PacketManager.sendArmorStandSpawn(InteractionVisualizerAPI.getPlayerModuleList(InteractionVisualizerAPI.Modules.HOLOGRAM, KEY), line1);
        PacketManager.sendArmorStandSpawn(InteractionVisualizerAPI.getPlayerModuleList(InteractionVisualizerAPI.Modules.HOLOGRAM, KEY), line2);
        PacketManager.sendArmorStandSpawn(InteractionVisualizerAPI.getPlayerModuleList(InteractionVisualizerAPI.Modules.HOLOGRAM, KEY), line3);
        return map;
    }

    public void setStand(ArmorStand stand) {
        stand.setBasePlate(false);
        stand.setMarker(true);
        stand.setGravity(false);
        stand.setSmall(true);
        stand.setSilent(true);
        stand.setInvulnerable(true);
        stand.setVisible(false);
        stand.setCustomName("");
        stand.setRightArmPose(new EulerAngle(0.0, 0.0, 0.0));
    }

    public ChatColor getBeaconColor(Block block) {
        Block glass = block.getRelative(BlockFace.UP);
        if (!InteractionVisualizer.version.isLegacy()) {
            switch (glass.getType()) {
                case ORANGE_STAINED_GLASS: 
                case ORANGE_STAINED_GLASS_PANE: {
                    return ChatColor.GOLD;
                }
                case MAGENTA_STAINED_GLASS: 
                case MAGENTA_STAINED_GLASS_PANE: {
                    return ChatColor.LIGHT_PURPLE;
                }
                case LIGHT_BLUE_STAINED_GLASS: 
                case LIGHT_BLUE_STAINED_GLASS_PANE: {
                    return ChatColor.AQUA;
                }
                case YELLOW_STAINED_GLASS: 
                case YELLOW_STAINED_GLASS_PANE: {
                    return ChatColor.YELLOW;
                }
                case LIME_STAINED_GLASS: 
                case LIME_STAINED_GLASS_PANE: {
                    return ChatColor.GREEN;
                }
                case PINK_STAINED_GLASS: 
                case PINK_STAINED_GLASS_PANE: {
                    return ChatColor.LIGHT_PURPLE;
                }
                case GRAY_STAINED_GLASS: 
                case GRAY_STAINED_GLASS_PANE: {
                    return ChatColor.DARK_GRAY;
                }
                case LIGHT_GRAY_STAINED_GLASS: 
                case LIGHT_GRAY_STAINED_GLASS_PANE: {
                    return ChatColor.GRAY;
                }
                case CYAN_STAINED_GLASS: 
                case CYAN_STAINED_GLASS_PANE: {
                    return ChatColor.DARK_AQUA;
                }
                case PURPLE_STAINED_GLASS: 
                case PURPLE_STAINED_GLASS_PANE: {
                    return ChatColor.DARK_PURPLE;
                }
                case BLUE_STAINED_GLASS: 
                case BLUE_STAINED_GLASS_PANE: {
                    return ChatColor.BLUE;
                }
                case BROWN_STAINED_GLASS: 
                case BROWN_STAINED_GLASS_PANE: {
                    return ChatColor.GOLD;
                }
                case GREEN_STAINED_GLASS: 
                case GREEN_STAINED_GLASS_PANE: {
                    return ChatColor.DARK_GREEN;
                }
                case RED_STAINED_GLASS: 
                case RED_STAINED_GLASS_PANE: {
                    return ChatColor.RED;
                }
            }
            return ChatColor.WHITE;
        }
        if (!glass.getType().name().toUpperCase().contains("GLASS")) {
            return ChatColor.WHITE;
        }
        DyeColor color = DyeColor.getByWoolData((byte)glass.getData());
        switch (color.toString().toUpperCase()) {
            case "BLACK": {
                return ChatColor.WHITE;
            }
            case "BLUE": {
                return ChatColor.BLUE;
            }
            case "BROWN": {
                return ChatColor.GOLD;
            }
            case "CYAN": {
                return ChatColor.DARK_AQUA;
            }
            case "GRAY": {
                return ChatColor.DARK_GRAY;
            }
            case "GREEN": {
                return ChatColor.DARK_GREEN;
            }
            case "LIGHT_BLUE": {
                return ChatColor.AQUA;
            }
            case "SILVER": 
            case "LIGHT_GRAY": {
                return ChatColor.GRAY;
            }
            case "LIME": {
                return ChatColor.GREEN;
            }
            case "MAGENTA": {
                return ChatColor.LIGHT_PURPLE;
            }
            case "ORANGE": {
                return ChatColor.GOLD;
            }
            case "PINK": {
                return ChatColor.LIGHT_PURPLE;
            }
            case "PURPLE": {
                return ChatColor.DARK_PURPLE;
            }
            case "RED": {
                return ChatColor.RED;
            }
            case "WHITE": {
                return ChatColor.WHITE;
            }
            case "YELLOW": {
                return ChatColor.YELLOW;
            }
        }
        return ChatColor.WHITE;
    }

    public int getRange(int tier) {
        switch (tier) {
            case 0: {
                return 0;
            }
            case 1: {
                return 20;
            }
            case 2: {
                return 30;
            }
            case 3: {
                return 40;
            }
            case 4: {
                return 50;
            }
        }
        return 0;
    }
}

