/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.interactionvisualizer;

import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.ProtocolManager;
import com.comphenix.protocol.events.PacketContainer;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.loohp.interactionvisualizer.Commands;
import com.loohp.interactionvisualizer.api.events.InteractionVisualizerReloadEvent;
import com.loohp.interactionvisualizer.config.Config;
import com.loohp.interactionvisualizer.database.Database;
import com.loohp.interactionvisualizer.libs.com.loohp.yamlconfiguration.YamlConfiguration;
import com.loohp.interactionvisualizer.libs.net.kyori.adventure.text.Component;
import com.loohp.interactionvisualizer.libs.net.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import com.loohp.interactionvisualizer.libs.net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import com.loohp.interactionvisualizer.managers.AsyncExecutorManager;
import com.loohp.interactionvisualizer.managers.LangManager;
import com.loohp.interactionvisualizer.managers.LightManager;
import com.loohp.interactionvisualizer.managers.MaterialManager;
import com.loohp.interactionvisualizer.managers.MusicManager;
import com.loohp.interactionvisualizer.managers.PacketManager;
import com.loohp.interactionvisualizer.managers.PreferenceManager;
import com.loohp.interactionvisualizer.managers.SoundManager;
import com.loohp.interactionvisualizer.managers.TaskManager;
import com.loohp.interactionvisualizer.managers.TileEntityManager;
import com.loohp.interactionvisualizer.metrics.Charts;
import com.loohp.interactionvisualizer.metrics.Metrics;
import com.loohp.interactionvisualizer.nms.NMS;
import com.loohp.interactionvisualizer.objectholders.EntryKey;
import com.loohp.interactionvisualizer.objectholders.ILightManager;
import com.loohp.interactionvisualizer.placeholderAPI.Placeholders;
import com.loohp.interactionvisualizer.protocol.WatchableCollection;
import com.loohp.interactionvisualizer.updater.Updater;
import com.loohp.interactionvisualizer.utils.LanguageUtils;
import com.loohp.interactionvisualizer.utils.MCVersion;
import com.loohp.interactionvisualizer.utils.PotionUtils;
import java.io.File;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.chat.ComponentSerializer;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class InteractionVisualizer
extends JavaPlugin {
    public static final int BSTATS_PLUGIN_ID = 7024;
    public static final String CONFIG_ID = "config";
    public static InteractionVisualizer plugin = null;
    public static ProtocolManager protocolManager;
    public static String exactMinecraftVersion;
    public static MCVersion version;
    public static Integer metaversion;
    public static Boolean lightapi;
    public static Boolean openinv;
    public static Boolean vanish;
    public static Boolean cmi;
    public static Boolean ess3;
    public static Set<String> exemptBlocks;
    public static Set<String> disabledWorlds;
    public static Reference<World> defaultWorld;
    public static Location defaultLocation;
    public static boolean itemStandEnabled;
    public static boolean itemDropEnabled;
    public static boolean hologramsEnabled;
    public static Set<EntryKey> itemStandDisabled;
    public static Set<EntryKey> itemDropDisabled;
    public static Set<EntryKey> hologramsDisabled;
    public static Double playerPickupYOffset;
    public static Integer tileEntityCheckingRange;
    public static double ignoreWalkSquared;
    public static double ignoreFlySquared;
    public static double ignoreGlideSquared;
    public static Boolean handMovementEnabled;
    public static Integer lightUpdatePeriod;
    public static boolean updaterEnabled;
    public static Map<World, Integer> playerTrackingRange;
    public static boolean hideIfObstructed;
    public static String language;
    public static boolean allPacketsSync;
    public static boolean defaultDisabledAll;
    public static ILightManager lightManager;
    public static PreferenceManager preferenceManager;
    public static AsyncExecutorManager asyncExecutorManager;

    private static void unsupportedMessage() {
        Bukkit.getConsoleSender().sendMessage(ChatColor.RED + "This version of minecraft is unsupported!");
    }

    private static void hookMessage(String pluginName) {
        Bukkit.getConsoleSender().sendMessage(ChatColor.LIGHT_PURPLE + "[InteractionVisualizer] InteractionVisualizer has hooked into " + pluginName + "!");
    }

    public static void sendMessage(CommandSender sender, Component component) {
        block5: {
            if (version.isLegacyRGB()) {
                try {
                    sender.spigot().sendMessage(ComponentSerializer.parse((String)((String)GsonComponentSerializer.colorDownsamplingGson().serialize(component))));
                }
                catch (Throwable e) {
                    if (sender instanceof Player) {
                        ((Player)sender).spigot().sendMessage(ComponentSerializer.parse((String)((String)GsonComponentSerializer.colorDownsamplingGson().serialize(component))));
                        break block5;
                    }
                    sender.sendMessage(LegacyComponentSerializer.legacySection().serialize(component));
                }
            } else {
                sender.spigot().sendMessage(ComponentSerializer.parse((String)((String)GsonComponentSerializer.gson().serialize(component))));
            }
        }
    }

    public static boolean isPluginEnabled(String name) {
        Plugin plugin = Bukkit.getPluginManager().getPlugin(name);
        return plugin != null && plugin.isEnabled();
    }

    public void onEnable() {
        plugin = this;
        protocolManager = ProtocolLibrary.getProtocolManager();
        Metrics metrics = new Metrics((Plugin)this, 7024);
        exactMinecraftVersion = Bukkit.getVersion().substring(Bukkit.getVersion().indexOf("(") + 5, Bukkit.getVersion().indexOf(")"));
        version = MCVersion.fromPackageName(this.getServer().getClass().getPackage().getName());
        ThreadFactory factory = new ThreadFactoryBuilder().setNameFormat("InteractionVisualizer Async Processing Thread #%d").build();
        ThreadPoolExecutor threadPool = new ThreadPoolExecutor(8, 120, 5000L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), factory);
        asyncExecutorManager = new AsyncExecutorManager(threadPool);
        switch (version) {
            case V1_19: 
            case V1_18_2: 
            case V1_18: 
            case V1_17: {
                metaversion = 4;
                break;
            }
            case V1_16_4: 
            case V1_16_2: 
            case V1_16: 
            case V1_15: {
                metaversion = 3;
                break;
            }
            case V1_14: {
                metaversion = 2;
                break;
            }
            case V1_13_1: 
            case V1_13: {
                metaversion = 1;
                break;
            }
            case V1_12: 
            case V1_11: {
                metaversion = 0;
                break;
            }
            default: {
                InteractionVisualizer.unsupportedMessage();
            }
        }
        if (InteractionVisualizer.isPluginEnabled("LightAPI")) {
            try {
                Class.forName("ru.beykerykt.lightapi.utils.Debug");
                InteractionVisualizer.hookMessage("LightAPI");
                lightapi = true;
                lightManager = new LightManager(this);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if (!lightapi.booleanValue()) {
            if (version.isOlderOrEqualTo(MCVersion.V1_16_4)) {
                Bukkit.getConsoleSender().sendMessage(ChatColor.YELLOW + "[InteractionVisualizer] LightAPI (Fork) is recommended to be installed on servers with Minecraft version 1.16.5 or below!");
            }
            lightManager = ILightManager.DUMMY_INSTANCE;
        }
        if (InteractionVisualizer.isPluginEnabled("OpenInv")) {
            InteractionVisualizer.hookMessage("OpenInv");
            openinv = true;
        }
        if (InteractionVisualizer.isPluginEnabled("SuperVanish") || InteractionVisualizer.isPluginEnabled("PremiumVanish")) {
            InteractionVisualizer.hookMessage("SuperVanish/PremiumVanish");
            vanish = true;
        }
        if (InteractionVisualizer.isPluginEnabled("CMI")) {
            InteractionVisualizer.hookMessage("CMI");
            cmi = true;
        }
        if (InteractionVisualizer.isPluginEnabled("Essentials")) {
            InteractionVisualizer.hookMessage("Essentials");
            ess3 = true;
        }
        if (!this.getDataFolder().exists()) {
            this.getDataFolder().mkdirs();
        }
        try {
            Config.loadConfig(CONFIG_ID, new File(this.getDataFolder(), "config.yml"), ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("config.yml"), ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("config.yml"), true);
        }
        catch (IOException e) {
            e.printStackTrace();
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        this.loadConfig();
        defaultWorld = new WeakReference<World>((World)this.getServer().getWorlds().get(0));
        defaultLocation = new Location(InteractionVisualizer.getDefaultWorld(), 0.0, 0.0, 0.0);
        if (!(version.isLegacy() || version.equals((Object)MCVersion.V1_13) || version.equals((Object)MCVersion.V1_13_1))) {
            InteractionVisualizer.getDefaultWorld().setChunkForceLoaded(0, 0, true);
        }
        if (this.getConfiguration().getBoolean("Options.DownloadLanguageFiles")) {
            this.getServer().getScheduler().runTaskAsynchronously((Plugin)this, () -> LangManager.generate());
        }
        WatchableCollection.setup();
        SoundManager.setup();
        MusicManager.setup();
        Database.setup();
        preferenceManager = new PreferenceManager(this);
        TaskManager.setup();
        TileEntityManager._init_();
        PacketManager.run();
        PacketManager.dynamicEntity();
        PotionUtils.setupPotions();
        MaterialManager.setup();
        this.getCommand("interactionvisualizer").setExecutor((CommandExecutor)new Commands());
        TaskManager.run();
        Charts.registerCharts(metrics);
        if (InteractionVisualizer.isPluginEnabled("PlaceholderAPI")) {
            new Placeholders().register();
        }
        for (World world : Bukkit.getWorlds()) {
            for (Entity entity : world.getNearbyEntities(new Location(world, 0.0, 0.0, 0.0), 2.0, 2.0, 2.0)) {
                if (!entity.getScoreboardTags().contains("isInteractionVisualizer")) continue;
                entity.remove();
            }
        }
        exemptBlocks.add("CRAFTING_TABLE");
        exemptBlocks.add("WORKBENCH");
        exemptBlocks.add("LOOM");
        exemptBlocks.add("SMITHING_TABLE");
        exemptBlocks.add("SPAWNER");
        exemptBlocks.add("MOB_SPAWNER");
        exemptBlocks.add("BEACON");
        this.getServer().getConsoleSender().sendMessage(ChatColor.GREEN + "[InteractionVisualizer] InteractionVisualizer has been enabled!");
        Bukkit.getScheduler().runTask((Plugin)this, () -> {
            for (Player player : Bukkit.getOnlinePlayers()) {
                PacketManager.playerStatus.put(player, Collections.newSetFromMap(new ConcurrentHashMap()));
            }
        });
        asyncExecutorManager.runTaskLaterAsynchronously(() -> {
            Updater.UpdaterResponse version;
            if (updaterEnabled && !(version = Updater.checkUpdate()).getResult().equals("latest")) {
                Updater.sendUpdateMessage((CommandSender)Bukkit.getConsoleSender(), version.getResult(), version.getSpigotPluginId());
                for (Player player : Bukkit.getOnlinePlayers()) {
                    if (!player.hasPermission("interactionvisualizer.update")) continue;
                    Updater.sendUpdateMessage((CommandSender)player, version.getResult(), version.getSpigotPluginId());
                }
            }
        }, 100L);
    }

    public void onDisable() {
        preferenceManager.close();
        if (!Bukkit.getOnlinePlayers().isEmpty()) {
            this.getServer().getConsoleSender().sendMessage(ChatColor.YELLOW + "[InteractionVisualizer] Plugin reload detected, attempting to despawn all visual entities. If anything went wrong, please restart! (Reloads are always not recommended)");
            int[] entityIdArray = PacketManager.active.keySet().stream().mapToInt(each -> each.getEntityId()).toArray();
            PacketContainer[] packets = NMS.getInstance().createEntityDestroyPacket(entityIdArray);
            for (Player player : Bukkit.getOnlinePlayers()) {
                for (PacketContainer packet : packets) {
                    protocolManager.sendServerPacket(player, packet);
                }
            }
        }
        asyncExecutorManager.close();
        this.getServer().getConsoleSender().sendMessage(ChatColor.RED + "[InteractionVisualizer] InteractionVisualizer has been disabled!");
    }

    public YamlConfiguration getConfiguration() {
        return Config.getConfig(CONFIG_ID).getConfiguration();
    }

    public void loadConfig() {
        Config config = Config.getConfig(CONFIG_ID);
        config.reload();
        itemStandEnabled = this.getConfiguration().getBoolean("Modules.ItemStand.Enabled");
        itemDropEnabled = this.getConfiguration().getBoolean("Modules.ItemDrop.Enabled");
        hologramsEnabled = this.getConfiguration().getBoolean("Modules.Hologram.Enabled");
        itemStandDisabled = this.getConfiguration().getStringList("Modules.ItemStand.OverridingDisabled").stream().map(each -> new EntryKey((String)each)).collect(Collectors.toSet());
        itemDropDisabled = this.getConfiguration().getStringList("Modules.ItemDrop.OverridingDisabled").stream().map(each -> new EntryKey((String)each)).collect(Collectors.toSet());
        hologramsDisabled = this.getConfiguration().getStringList("Modules.Hologram.OverridingDisabled").stream().map(each -> new EntryKey((String)each)).collect(Collectors.toSet());
        playerPickupYOffset = this.getConfiguration().getDouble("Settings.PickupAnimationPlayerYOffset");
        tileEntityCheckingRange = this.getConfiguration().getInt("TileEntityUpdate.CheckingRange");
        ignoreWalkSquared = this.getConfiguration().getDouble("TileEntityUpdate.IgnoreMovementSpeed.Normal");
        ignoreWalkSquared *= ignoreWalkSquared;
        ignoreFlySquared = this.getConfiguration().getDouble("TileEntityUpdate.IgnoreMovementSpeed.Flying");
        ignoreFlySquared *= ignoreFlySquared;
        ignoreGlideSquared = this.getConfiguration().getDouble("TileEntityUpdate.IgnoreMovementSpeed.Gliding");
        ignoreGlideSquared *= ignoreGlideSquared;
        handMovementEnabled = this.getConfiguration().getBoolean("Settings.UseHandSwingAnimation");
        disabledWorlds = new HashSet<String>(this.getConfiguration().getStringList("Settings.DisabledWorlds"));
        hideIfObstructed = this.getConfiguration().getBoolean("Settings.HideIfViewObstructed");
        lightUpdatePeriod = this.getConfiguration().getInt("LightUpdate.Period");
        updaterEnabled = this.getConfiguration().getBoolean("Options.Updater");
        language = this.getConfiguration().getString("Settings.Language");
        playerTrackingRange.clear();
        int defaultRange = this.getServer().spigot().getConfig().getInt("world-settings.default.entity-tracking-range.players", 64);
        for (World world : this.getServer().getWorlds()) {
            int range = this.getServer().spigot().getConfig().getInt("world-settings." + world.getName() + ".entity-tracking-range.players", defaultRange);
            playerTrackingRange.put(world, range);
        }
        allPacketsSync = this.getConfiguration().getBoolean("Settings.SendAllPacketsInSync");
        defaultDisabledAll = this.getConfiguration().getBoolean("Settings.DefaultDisableAll");
        LanguageUtils.loadTranslations(language);
        this.getServer().getPluginManager().callEvent((Event)new InteractionVisualizerReloadEvent());
    }

    public static World getDefaultWorld() {
        if (defaultWorld == null) {
            World world = (World)Bukkit.getWorlds().get(0);
            defaultWorld = new WeakReference<World>(world);
            return world;
        }
        return defaultWorld.get();
    }

    static {
        metaversion = 0;
        lightapi = false;
        openinv = false;
        vanish = false;
        cmi = false;
        ess3 = false;
        exemptBlocks = new HashSet<String>();
        disabledWorlds = new HashSet<String>();
        itemStandEnabled = true;
        itemDropEnabled = true;
        hologramsEnabled = true;
        itemStandDisabled = new HashSet<EntryKey>();
        itemDropDisabled = new HashSet<EntryKey>();
        hologramsDisabled = new HashSet<EntryKey>();
        playerPickupYOffset = 0.0;
        tileEntityCheckingRange = 1;
        ignoreWalkSquared = 0.0;
        ignoreFlySquared = 0.0;
        ignoreGlideSquared = 0.0;
        handMovementEnabled = true;
        lightUpdatePeriod = 10;
        updaterEnabled = true;
        playerTrackingRange = new HashMap<World, Integer>();
        hideIfObstructed = false;
        language = "en_us";
        allPacketsSync = false;
        defaultDisabledAll = false;
    }
}

