/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.ingamereviews.persistence;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import me.athlaeos.ingamereviews.main.Main;
import me.athlaeos.ingamereviews.managers.DisablePluginManager;
import me.athlaeos.ingamereviews.utils.Utils;

public class DatabaseConnection {
    private static DatabaseConnection instance = null;
    private String host;
    private String database;
    private String username;
    private String password;
    private Connection conn = null;

    public static DatabaseConnection getInstance() {
        if (instance == null) {
            instance = new DatabaseConnection();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection getConnection(Main plugin) throws SQLException, ClassNotFoundException {
        try {
            this.host = plugin.getConfig().getString("db_host");
            this.database = plugin.getConfig().getString("db_database");
            this.username = plugin.getConfig().getString("db_username");
            this.password = plugin.getConfig().getString("db_password");
            if (this.conn != null && !this.conn.isClosed()) {
                return this.conn;
            }
            Main main = plugin;
            synchronized (main) {
                if (this.conn != null && !this.conn.isClosed()) {
                    return this.conn;
                }
                Class.forName("com.mysql.jdbc.Driver");
                this.conn = DriverManager.getConnection("jdbc:mysql://" + this.host + "/" + this.database, this.username, this.password);
            }
        }
        catch (Exception e) {
            plugin.getServer().getConsoleSender().sendMessage(Utils.chat("&c[IngameReviews] Failed database connection, wrong credentials"));
            plugin.getServer().getConsoleSender().sendMessage(Utils.chat("&c[IngameReviews] Disabling IngameReviews' functionality"));
            DisablePluginManager.disablePlugin();
            return null;
        }
        return this.conn;
    }

    public void closeConnection() throws SQLException {
        try {
            this.conn.close();
        }
        catch (Exception e) {
            return;
        }
    }
}

