/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.ingamereviews.managers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.athlaeos.ingamereviews.commands.AddSubjectCommand;
import me.athlaeos.ingamereviews.commands.Command;
import me.athlaeos.ingamereviews.commands.ConfirmRepeatReviewCommand;
import me.athlaeos.ingamereviews.commands.HelpCommand;
import me.athlaeos.ingamereviews.commands.NewReviewCommand;
import me.athlaeos.ingamereviews.commands.RemoveSubjectCommand;
import me.athlaeos.ingamereviews.commands.ShowSubjectsCommand;
import me.athlaeos.ingamereviews.commands.ViewMyReviewsCommand;
import me.athlaeos.ingamereviews.commands.ViewSubjectReviewsCommand;
import me.athlaeos.ingamereviews.commands.WipeIngameReviewsTableCommand;
import me.athlaeos.ingamereviews.main.Main;
import me.athlaeos.ingamereviews.managers.DisablePluginManager;
import me.athlaeos.ingamereviews.utils.Utils;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabExecutor;

public class CommandManager
implements TabExecutor {
    private Main plugin;
    private Map<String, Command> commands = new HashMap<String, Command>();

    public CommandManager(Main plugin) {
        this.plugin = plugin;
        this.commands.put("new", new NewReviewCommand(plugin));
        this.commands.put("post", new ConfirmRepeatReviewCommand(plugin));
        this.commands.put("help", new HelpCommand(plugin));
        this.commands.put("subjects", new ShowSubjectsCommand(plugin));
        this.commands.put("addsubject", new AddSubjectCommand(plugin));
        this.commands.put("delsubject", new RemoveSubjectCommand(plugin));
        this.commands.put("reset", new WipeIngameReviewsTableCommand(plugin));
        this.commands.put("myreviews", new ViewMyReviewsCommand(plugin));
        this.commands.put("view", new ViewSubjectReviewsCommand(plugin));
        ((HelpCommand)this.commands.get("help")).giveCommandMap(this.commands);
        plugin.getCommand("reviews").setExecutor((CommandExecutor)this);
    }

    public boolean onCommand(CommandSender sender, org.bukkit.command.Command cmd, String name, String[] args) {
        if (!DisablePluginManager.isEnabled()) {
            sender.sendMessage(Utils.chat("&cPlugin disabled due to MySQL connection issue"));
            return true;
        }
        if (args.length == 0) {
            sender.sendMessage(Utils.chat(String.format("&6-=&eIngameReviews v%s by Athlaeos&6=-", this.plugin.getDescription().getVersion())));
            sender.sendMessage(Utils.chat("&eType &6/reviews help &eto view your commands"));
            return true;
        }
        for (String subcommand : this.commands.keySet()) {
            if (!args[0].equalsIgnoreCase(subcommand)) continue;
            if (!this.commands.get(subcommand).execute(sender, args)) {
                sender.sendMessage(Utils.chat(this.commands.get(subcommand).getFailureMessage()));
            }
            return true;
        }
        sender.sendMessage(Utils.chat("&cCommand not recognized! Type &4/reports help &cto view available commands."));
        return false;
    }

    public List<String> onTabComplete(CommandSender sender, org.bukkit.command.Command cmd, String name, String[] args) {
        if (args.length == 1) {
            ArrayList<String> completelist = new ArrayList<String>();
            for (String arg : this.commands.keySet()) {
                completelist.add(arg);
            }
            return completelist;
        }
        if (args.length > 1) {
            for (String arg : this.commands.keySet()) {
                if (!args[0].equalsIgnoreCase(arg)) continue;
                return this.commands.get(arg).getSubcommandArgs(sender, args);
            }
        }
        return null;
    }
}

