/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.ingamereviews.commands;

import java.util.ArrayList;
import java.util.List;
import me.athlaeos.ingamereviews.commands.Command;
import me.athlaeos.ingamereviews.domain.Review;
import me.athlaeos.ingamereviews.main.Main;
import me.athlaeos.ingamereviews.managers.ReviewCacheManager;
import me.athlaeos.ingamereviews.persistence.MySQLReviewDao;
import me.athlaeos.ingamereviews.utils.Utils;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class ConfirmRepeatReviewCommand
implements Command {
    private Main plugin;
    private String[] permissionRequired = new String[]{"reviews.postreview"};
    private ReviewCacheManager cache = ReviewCacheManager.getInstance();
    private MySQLReviewDao reviewdao = MySQLReviewDao.getInstance();

    public ConfirmRepeatReviewCommand(Main plugin) {
        this.plugin = plugin;
    }

    @Override
    public boolean execute(CommandSender sender, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(Utils.chat("&cOnly players can do this!"));
            return true;
        }
        boolean hasPermission = false;
        for (String permission : this.permissionRequired) {
            if (!sender.hasPermission(permission)) continue;
            hasPermission = true;
            break;
        }
        if (!hasPermission) {
            sender.sendMessage(Utils.chat(this.plugin.getConfig().getString("error_no_permission")));
            return true;
        }
        if (args.length == 1) {
            if (this.cache.getCache().containsKey(((Player)sender).getUniqueId())) {
                final Review review = this.cache.getCache().get(((Player)sender).getUniqueId());
                new BukkitRunnable(){

                    public void run() {
                        ConfirmRepeatReviewCommand.this.reviewdao.updateReview(review);
                    }
                }.runTaskAsynchronously((Plugin)this.plugin);
                sender.sendMessage(Utils.chat(this.plugin.getConfig().getString("post_repeat_review").replace("{player}", sender.getName()).replace("{subject}", this.cache.getCache().get(((Player)sender).getUniqueId()).getSubject())));
                List commands = this.plugin.getConfig().getStringList("commands_repeat_review");
                if (commands.size() != 0) {
                    for (String command : commands) {
                        if (command.equalsIgnoreCase("")) continue;
                        this.plugin.getServer().dispatchCommand((CommandSender)this.plugin.getServer().getConsoleSender(), command.replace("{player}", sender.getName()));
                    }
                }
                this.cache.removeReview(review);
                return true;
            }
            sender.sendMessage(Utils.chat(this.plugin.getConfig().getString("error_no_review_saved")));
            return true;
        }
        return false;
    }

    @Override
    public String[] getRequiredPermission() {
        return this.permissionRequired;
    }

    @Override
    public String getFailureMessage() {
        return String.format("&c%s: &4/reviews post", this.plugin.getConfig().getString("translation_invalid_command_usage"));
    }

    @Override
    public String[] getHelpEntry() {
        String[] entry = new String[]{"&e/reviews post", "&8>&7 " + this.plugin.getConfig().getString("description_post"), "&8>&7 " + this.plugin.getConfig().getString("translation_permissions") + ": &e" + String.join((CharSequence)", ", this.permissionRequired)};
        return entry;
    }

    @Override
    public List<String> getSubcommandArgs(CommandSender sender, String[] args) {
        ArrayList<String> subargs = new ArrayList<String>();
        subargs.add(" ");
        return subargs;
    }
}

