/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.ingamereviews.commands;

import java.util.ArrayList;
import java.util.List;
import me.athlaeos.ingamereviews.commands.Command;
import me.athlaeos.ingamereviews.main.Main;
import me.athlaeos.ingamereviews.utils.Utils;
import org.bukkit.command.CommandSender;

public class AddSubjectCommand
implements Command {
    private Main plugin;
    private String[] permissionRequired = new String[]{"reviews.addsubject"};

    public AddSubjectCommand(Main plugin) {
        this.plugin = plugin;
    }

    @Override
    public boolean execute(CommandSender sender, String[] args) {
        boolean hasPermission = false;
        for (String permission : this.permissionRequired) {
            if (!sender.hasPermission(permission)) continue;
            hasPermission = true;
            break;
        }
        if (!hasPermission) {
            sender.sendMessage(Utils.chat(this.plugin.getConfig().getString("error_no_permission")));
            return true;
        }
        if (args.length == 2) {
            String newsubject = args[1];
            List subjects = this.plugin.getConfig().getStringList("subject_list");
            subjects.add(newsubject);
            this.plugin.getConfig().set("subject_list", (Object)subjects);
            sender.sendMessage(Utils.chat(this.plugin.getConfig().getString("notify_success_addsubject")));
            this.plugin.saveConfig();
            return true;
        }
        return false;
    }

    @Override
    public String[] getRequiredPermission() {
        return this.permissionRequired;
    }

    @Override
    public String getFailureMessage() {
        return String.format("&c%s: &4/reviews addsubject", this.plugin.getConfig().getString("translation_invalid_command_usage"));
    }

    @Override
    public String[] getHelpEntry() {
        String[] entry = new String[]{"&e/reviews addsubject", "&8>&7 " + this.plugin.getConfig().getString("description_addsubject"), "&8>&7 " + this.plugin.getConfig().getString("translation_permissions") + ": &e" + String.join((CharSequence)", ", this.permissionRequired)};
        return entry;
    }

    @Override
    public List<String> getSubcommandArgs(CommandSender sender, String[] args) {
        if (args.length == 2) {
            ArrayList<String> subargs = new ArrayList<String>();
            subargs.add("''");
            return subargs;
        }
        ArrayList<String> subargs = new ArrayList<String>();
        subargs.add(" ");
        return subargs;
    }
}

