package net.voidrealms.InfiniteGapple;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.ChatColor;
import org.bukkit.Effect;
import org.bukkit.Location;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerItemConsumeEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitRunnable;

public class main extends JavaPlugin implements Listener {

	public static main instance;
	public HashMap<String, HashMap<String, Long>> cooldownMap = new HashMap<String, HashMap<String, Long>>();
	private String prefix;
	private HashMap<String, String> gappleName = new HashMap<String, String>();
	private HashMap<String, Boolean> particles = new HashMap<String, Boolean>();
	private HashMap<String, String> particle1 = new HashMap<String, String>();
	private HashMap<String, String> particle2 = new HashMap<String, String>();
	private HashMap<String, Integer> cooldown = new HashMap<String, Integer>();
	private HashMap<String, String> sound = new HashMap<String, String>();
	private HashMap<String, List<String>> potions = new HashMap<String, List<String>>();

	public main() {
		instance = this;
	}

	public static main getInstance() {
		return instance;
	}

	public void onEnable() {
		this.saveDefaultConfig();
		Config.getInstance().loadFiles();

		prefix = ChatColor.translateAlternateColorCodes('&', Config.getInstance().fc.getString("prefix"));

		for (String s : Config.getInstance().fc.getConfigurationSection("gapples").getKeys(false)) {
			gappleName.put(s, Config.getInstance().fc.getString("gapples." + s + ".gapple-name").replace("&", ""));
			particles.put(s, Config.getInstance().fc.getBoolean("gapples." + s + ".use-particles"));
			particle1.put(s, Config.getInstance().fc.getString("gapples." + s + ".particle1"));
			particle2.put(s, Config.getInstance().fc.getString("gapples." + s + ".particle2"));
			cooldown.put(s, Config.getInstance().fc.getInt("gapples." + s + ".cooldown"));
			sound.put(s, Config.getInstance().fc.getString("gapples." + s + ".sound"));
			potions.put(s, Config.getInstance().fc.getStringList("gapples." + s + ".potion-effects"));
			cooldownMap.put(s, new HashMap<String, Long>());
		}

		Bukkit.getPluginManager().registerEvents(this, this);
	}

	public void onDisable() {
		getLogger().info(getDescription().getName() + " has been disabled!");
	}

	@Override
	public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
		if (cmd.getName().equalsIgnoreCase("gapple")) {
			if (args.length >= 3) {
				if (args[0].equalsIgnoreCase("give")) {
					Player p = Bukkit.getServer().getPlayerExact(args[1]);
					if (p != null) {
						int amount = 1;

						if (args.length >= 4) {
							try {
								amount = Integer.parseInt(args[3]);
							} catch (Exception e) {
								sender.sendMessage(prefix + "Invalid amount! Defaulting to 1.");
							}
						}

						String type = args[2];
						ItemStack gapple = new ItemStack(Material.ENCHANTED_GOLDEN_APPLE, amount, (short) 1);
						ItemMeta meta = gapple.getItemMeta();
						meta.setDisplayName(gappleName.get(type));
						meta.setLore(Arrays.asList(ChatColor.DARK_GRAY + ChatColor.stripColor(gappleName.get(type)),
								"7Consume Count:", "b0"));
						gapple.setItemMeta(meta);
						if (isGappleSimilar(gapple) != null) {
							p.getInventory().addItem(gapple);
							sender.sendMessage(prefix + "b" + p.getName() + " 7has recieved an Infinite Gapple");
						} else
							sender.sendMessage(prefix + "The gapple ID b" + type + "7 is not valid!");

					} else
						sender.sendMessage(prefix + args[1] + " is not a valid player!");
				}
			} else
				sender.sendMessage(prefix + "/Gapple give <player> <gappleID> [amount]");
		}
		return true;
	}

	@EventHandler
	public void onPlayerItemConsume(PlayerItemConsumeEvent event) {
		if (isGappleSimilar(event.getItem()) != null) {
			event.setCancelled(true);

			ItemStack gapple = event.getItem();
			String type = isGappleSimilar(event.getItem());
			Long c = (long) -1;

			if (cooldownMap.get(type).containsKey(event.getPlayer().getName()))
				c = System.currentTimeMillis() - cooldownMap.get(type).get(event.getPlayer().getName());

			if (c == -1 || (cooldown.get(type) * 1000) - c < 1) {
				cooldownMap.get(type).put(event.getPlayer().getName(), System.currentTimeMillis());

				event.getPlayer().playSound(event.getPlayer().getLocation(), Sound.valueOf(sound.get(type)), 3F, 1F);
				if (particles.get(type))
					makeParticle(event.getPlayer(), type);

				ItemMeta meta = gapple.getItemMeta();

				List<String> lore = meta.getLore();

				if (!lore.contains(ChatColor.DARK_GRAY + ChatColor.stripColor(gappleName.get(type))))
					lore.add(0, ChatColor.DARK_GRAY + ChatColor.stripColor(gappleName.get(type)));

				for (int i = 0; i < lore.size(); i++) {
					if (lore.get(i).contains("Consume Count:")) {
						String str = ChatColor.stripColor(lore.get(i + 1));
						int count = Integer.parseInt(str);
						count++;
						lore.set(i + 1, "b" + count);
						break;
					}
				}
				meta.setLore(lore);

				if (Bukkit.getBukkitVersion().contains("1.8")) {
					event.getPlayer().getItemInHand().setItemMeta(meta);
				} else {
					if (isGappleSimilar(event.getPlayer().getInventory().getItemInMainHand()) != null)
						event.getPlayer().getInventory().getItemInMainHand().setItemMeta(meta);
					else
						event.getPlayer().getInventory().getItemInOffHand().setItemMeta(meta);
				}
				// Simulate Gapple effects
				for (int i = 0; i < potions.get(type).size(); i++) {
					String[] s = potions.get(type).get(i).split(":");
					PotionEffectType potion = PotionEffectType.getByName(s[0]);
					int duration = Integer.parseInt(s[1]) * 20;
					int level = Integer.parseInt(s[2]) - 1;
					event.getPlayer().addPotionEffect(new PotionEffect(potion, duration, level, true));
				}

				// Simulate food gain
				if (event.getPlayer().getFoodLevel() > 16)
					event.getPlayer().setFoodLevel(20);
				else
					event.getPlayer().setFoodLevel(event.getPlayer().getFoodLevel() + 4);
			} else {
				event.getPlayer().sendMessage(
						prefix + "You cannot use this for " + (cooldown.get(type) - (c / 1000)) + " seconds!");
			}

		}
	}

	public String isGappleSimilar(ItemStack item) {
		if (item.getType() == Material.ENCHANTED_GOLDEN_APPLE && item.getDurability() == 1) {
			for (String s : gappleName.values()) {
				if (item.getItemMeta().hasDisplayName() && item.getItemMeta().getDisplayName().equalsIgnoreCase(s)) {
					return getKeyFromValue(gappleName, s);
				} else if (item.getItemMeta().hasLore()
						&& item.getItemMeta().getLore().get(0).contains(ChatColor.stripColor(s))) {
					return getKeyFromValue(gappleName, s);
				}
			}
		}
		return null;
	}

	public static String getKeyFromValue(HashMap<String, String> hm, String value) {
		for (String o : hm.keySet()) {
			if (hm.get(o).equals(value)) {
				return o;
			}
		}
		return null;
	}

	public void makeParticle(final Player player, String type) {
		new BukkitRunnable() {
			double t = 0;
			Location loc = player.getLocation();

			public void run() {
				t += 0.3141592653589793D;
				for (double theta = 0.0D; theta <= 6.283185307179586D; theta = theta + 0.09817477042468103D) {
					double x = t * Math.cos(theta);
					double y = 2.0D * Math.exp(-0.1D * t) * Math.sin(t) + 1.5D;
					double z = t * Math.sin(theta);
					loc.add(x, y, z);
					player.getWorld().spawnParticle(Particle.valueOf(particle1.get(type)), loc, 1);
					loc.subtract(x, y, z);

					theta += 0.04908738521234052D;

					x = t * Math.cos(theta);
					y = 2.0D * Math.exp(-0.1D * t) * Math.sin(t) + 1.5D;
					z = t * Math.sin(theta);
					loc.add(x, y, z);
					player.getWorld().spawnParticle(Particle.valueOf(particle2.get(type)), loc, 1);
					loc.subtract(x, y, z);
				}
				if (t > 3.0D) {
					cancel();
				}
			}
		}.runTaskTimer(this, 0L, 1L);
	}
}
