/*
 * Decompiled with CFR 0.152.
 */
package pack.plug;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.World;
import org.bukkit.WorldCreator;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.Dispenser;
import org.bukkit.block.Dropper;
import org.bukkit.block.Furnace;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;
import pack.plug.Industrial;

public class EUtil {
    private static FileConfiguration lang;
    public static Industrial ind;

    public static void init(Industrial i) {
        ind = i;
    }

    public static void b(String s, Industrial in) {
        in.getServer().broadcastMessage(s);
    }

    public static int getCharge(String s) {
        return Integer.parseInt(s.split("/")[0].substring(lang.getString("charge").length() + 2));
    }

    public static void setLanguageFile(FileConfiguration l) {
        lang = l;
    }

    public static boolean isJetpackItem(ItemStack is) {
        if (is != null) {
            return is.hasItemMeta() && is.containsEnchantment(Enchantment.ARROW_DAMAGE) && is.getType() == Material.LEATHER_CHESTPLATE && is.getItemMeta().getLore().size() == 2;
        }
        return false;
    }

    public static int getMaxCharge(String s) {
        return Integer.parseInt(s.split("/")[1].replace("pd", ""));
    }

    public static List<ItemStack> getChargingStationBatteries(Block b) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        int i = 0;
        while (i < 3) {
            if (((Dropper)b.getState()).getInventory().getItem(i) != null) {
                items.add(((Dropper)b.getState()).getInventory().getItem(i));
            }
            ++i;
        }
        return items;
    }

    public static boolean isMachineBlock(Block b) {
        return b.hasMetadata("id");
    }

    public static boolean isBatteryItem(ItemStack is) {
        return is.hasItemMeta() && is.getItemMeta().hasLore() && ((String)is.getItemMeta().getLore().get(1)).contains(lang.getString("charge")) && (is.getType() == Material.BRICK || is.getType() == Material.NETHER_BRICK || is.getType() == Material.IRON_INGOT) && is.containsEnchantment(Enchantment.ARROW_DAMAGE);
    }

    public static int getGeneratorFuel(ItemStack fuel, Block b) {
        int total = 0;
        if (b.getType() == Material.DISPENSER && b.hasMetadata("id")) {
            int i = 0;
            while (i < ((Dispenser)b.getState()).getInventory().getContents().length) {
                if (((Dispenser)b.getState()).getInventory().getContents()[i] != null && ((Dispenser)b.getState()).getInventory().getContents()[i].isSimilar(fuel)) {
                    total += ((Dispenser)b.getState()).getInventory().getContents()[i].getAmount();
                }
                ++i;
            }
        }
        return total;
    }

    public static void chargeInventorySlot(final int slot, final Inventory inv, final Block b, final Industrial p) {
        final FileConfiguration config = p.getConfig();
        new BukkitRunnable(){

            public void run() {
                if (inv.getItem(slot) != null) {
                    if (inv.getItem(slot).hasItemMeta() && inv.getItem(slot).getItemMeta().getLore().size() == 2 && ((String)inv.getItem(slot).getItemMeta().getLore().get(1)).contains(lang.getString("charge"))) {
                        if (((MetadataValue)b.getMetadata("charge").get(0)).asInt() >= config.getInt("charging-station-pd-rate")) {
                            int fill = EUtil.getCharge((String)inv.getItem(slot).getItemMeta().getLore().get(1));
                            if (fill <= EUtil.getMaxCharge((String)inv.getItem(slot).getItemMeta().getLore().get(1)) - config.getInt("charging-station-pd-rate")) {
                                b.setMetadata("charge", (MetadataValue)new FixedMetadataValue((Plugin)p, (Object)(((MetadataValue)b.getMetadata("charge").get(0)).asInt() - config.getInt("charging-station-pd-rate"))));
                                String s = ChatColor.BLUE + lang.getString("charge") + (fill + config.getInt("charging-station-pd-rate")) + "/" + EUtil.getMaxCharge((String)inv.getItem(slot).getItemMeta().getLore().get(1)) + "pd";
                                ArrayList<String> lore = new ArrayList<String>();
                                lore.add("");
                                lore.add(s);
                                ItemMeta im = inv.getItem(slot).getItemMeta();
                                im.setLore(lore);
                                inv.getItem(slot).setItemMeta(im);
                            } else {
                                this.cancel();
                            }
                        }
                    } else {
                        this.cancel();
                    }
                } else {
                    this.cancel();
                }
            }
        }.runTaskTimer((Plugin)p, 1L, (long)config.getInt("default-input-ticks"));
    }

    public static void setMeta(Block b, String id, Object value) {
        b.setMetadata(id, (MetadataValue)new FixedMetadataValue((Plugin)ind, value));
    }

    public static MetadataValue getMeta(Block b, String id) {
        return (MetadataValue)b.getMetadata(id).get(0);
    }

    public static void createInputUtilization(final Block in, final Block out, final Industrial p) {
        FileConfiguration config = p.config;
        final int output = config.getInt("default-output");
        new BukkitRunnable(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void run() {
                if (!EUtil.getClosestPowerSource(in).equals(out)) {
                    EUtil.createInputUtilization(in, EUtil.getClosestPowerSource(in), p);
                    EUtil.setMeta(in, "input", 0);
                    EUtil.setMeta(out, "output", 0);
                    this.cancel();
                    return;
                }
                if (EUtil.isMachineBlock(in) && EUtil.isMachineBlock(out) && out.hasMetadata("output")) {
                    switch (out.getType()) {
                        case DAYLIGHT_DETECTOR: {
                            if (in.getType() != Material.DAYLIGHT_DETECTOR) {
                                HashSet<Block> panels = EUtil.getSolarPanel(new HashSet<Block>(), out);
                                int pcharge = EUtil.getPanelCharge(panels);
                                if (pcharge <= output) return;
                                if (EUtil.getMeta(in, "charge").asInt() + output < EUtil.getMaxCharge((String)EUtil.machineToItemStack(in, p).getItemMeta().getLore().get(1))) {
                                    EUtil.setMeta(in, "charge", EUtil.getMeta(in, "charge").asInt() + output);
                                    for (Block pa : panels) {
                                        EUtil.setMeta(pa, "charge", (double)(pcharge / panels.size()) - (panels.size() == 1 ? (double)output : Math.ceil(output / panels.size() + 2)));
                                    }
                                    return;
                                }
                                EUtil.setMeta(in, "charge", EUtil.getMaxCharge((String)EUtil.machineToItemStack(in, p).getItemMeta().getLore().get(1)));
                                return;
                            }
                            EUtil.setMeta(in, "connection", false);
                            EUtil.setMeta(in, "input", 0);
                            EUtil.setMeta(out, "output", 0);
                            this.cancel();
                            return;
                        }
                        case NOTE_BLOCK: {
                            if (in.getType() != Material.NOTE_BLOCK) {
                                HashSet<Block> bats = EUtil.getBatteryBank(new HashSet<Block>(), out);
                                int bcharge = EUtil.getBatteryBankInfo(bats, 0);
                                if (bcharge <= output) return;
                                if (EUtil.getMeta(in, "charge").asInt() + output < EUtil.getMaxCharge((String)EUtil.machineToItemStack(in, p).getItemMeta().getLore().get(1))) {
                                    EUtil.setMeta(in, "charge", EUtil.getMeta(in, "charge").asInt() + output);
                                    for (Block pa : bats) {
                                        EUtil.setMeta(pa, "charge", (double)(bcharge / bats.size()) - (bats.size() == 1 ? (double)output : Math.ceil(output / bats.size() + 2)));
                                    }
                                    return;
                                }
                                EUtil.setMeta(in, "charge", EUtil.getMaxCharge((String)EUtil.machineToItemStack(in, p).getItemMeta().getLore().get(1)));
                                return;
                            }
                            EUtil.setMeta(in, "connection", false);
                            EUtil.setMeta(in, "input", 0);
                            EUtil.setMeta(out, "output", 0);
                            this.cancel();
                            return;
                        }
                        default: {
                            if (!out.hasMetadata("input")) {
                                EUtil.setMeta(in, "input", EUtil.getMeta(out, "output").asInt());
                                EUtil.setMeta(in, "conncetion", true);
                                if (EUtil.getMeta(in, "charge").asInt() > EUtil.getMaxCharge((String)EUtil.machineToItemStack(in, p).getItemMeta().getLore().get(1)) - output || EUtil.getMeta(out, "charge").asInt() <= output) return;
                                EUtil.setMeta(in, "charge", EUtil.getMeta(in, "charge").asInt() + output);
                                EUtil.setMeta(out, "charge", EUtil.getMeta(out, "charge").asInt() - output);
                                return;
                            }
                            this.cancel();
                            EUtil.setMeta(in, "connection", false);
                            return;
                        }
                    }
                }
                this.cancel();
                EUtil.setMeta(in, "connection", false);
                EUtil.setMeta(in, "input", 0);
            }
        }.runTaskTimer((Plugin)p, 1L, (long)config.getInt("default-input-ticks"));
    }

    public static void createOutputUtilization(final Block out, final Industrial p) {
        final FileConfiguration config = p.config;
        new BukkitRunnable(){

            public void run() {
                if (EUtil.isMachineBlock(out)) {
                    if (((MetadataValue)out.getMetadata("running").get(0)).asBoolean() && ((MetadataValue)out.getMetadata("charge").get(0)).asInt() <= 50000 - config.getInt("default-output")) {
                        if (((MetadataValue)out.getMetadata("fueltype").get(0)).asInt() == 0) {
                            if (EUtil.getGeneratorFuel(new ItemStack(Material.COAL), out) != 0) {
                                out.setMetadata("output", (MetadataValue)new FixedMetadataValue((Plugin)p, (Object)config.getInt("default-output")));
                                out.setMetadata("charge", (MetadataValue)new FixedMetadataValue((Plugin)p, (Object)(((MetadataValue)out.getMetadata("charge").get(0)).asInt() + config.getInt("default-output"))));
                                if (config.getBoolean("smokey-generators")) {
                                    out.getWorld().spawnParticle(Particle.SMOKE_NORMAL, out.getLocation().add(0.5, 1.0, 0.5), 7, 0.1, 0.3, 0.1, 0.0);
                                }
                            } else {
                                out.setMetadata("running", (MetadataValue)new FixedMetadataValue((Plugin)p, (Object)false));
                                this.cancel();
                            }
                        }
                        if (((MetadataValue)out.getMetadata("fueltype").get(0)).asInt() == 1) {
                            if (EUtil.getGeneratorFuel(new ItemStack(Material.ENDER_PEARL), out) != 0) {
                                out.setMetadata("output", (MetadataValue)new FixedMetadataValue((Plugin)p, (Object)config.getInt("default-output")));
                                out.setMetadata("charge", (MetadataValue)new FixedMetadataValue((Plugin)p, (Object)((double)((MetadataValue)out.getMetadata("charge").get(0)).asInt() + (double)config.getInt("default-output") * config.getDouble("ender-power-multiplier"))));
                                if (config.getBoolean("smokey-generators")) {
                                    out.getWorld().spawnParticle(Particle.SMOKE_NORMAL, out.getLocation().add(0.5, 1.0, 0.5), 7, 0.1, 0.3, 0.1, 0.0);
                                }
                            } else {
                                out.setMetadata("running", (MetadataValue)new FixedMetadataValue((Plugin)p, (Object)false));
                                this.cancel();
                            }
                        }
                        if (((MetadataValue)out.getMetadata("fueltype").get(0)).asInt() == 2) {
                            if (EUtil.getGeneratorFuel(new ItemStack(Material.DRAGON_BREATH), out) != 0) {
                                out.setMetadata("output", (MetadataValue)new FixedMetadataValue((Plugin)p, (Object)config.getInt("default-output")));
                                out.setMetadata("charge", (MetadataValue)new FixedMetadataValue((Plugin)p, (Object)((double)((MetadataValue)out.getMetadata("charge").get(0)).asInt() + (double)config.getInt("default-output") * config.getDouble("gas-power-multiplier"))));
                                if (config.getBoolean("smokey-generators")) {
                                    out.getWorld().spawnParticle(Particle.SMOKE_NORMAL, out.getLocation().add(0.5, 1.0, 0.5), 7, 0.1, 0.3, 0.1, 0.0);
                                }
                            } else {
                                out.setMetadata("running", (MetadataValue)new FixedMetadataValue((Plugin)p, (Object)false));
                                this.cancel();
                            }
                        }
                    } else {
                        out.setMetadata("running", (MetadataValue)new FixedMetadataValue((Plugin)p, (Object)false));
                        this.cancel();
                    }
                } else {
                    this.cancel();
                }
            }
        }.runTaskTimer((Plugin)p, 1L, (long)config.getInt("default-input-ticks"));
    }

    public static void createFuelConsumption(final Block gen, Industrial p) {
        FileConfiguration config = p.config;
        new BukkitRunnable(){

            public void run() {
                if (EUtil.isMachineBlock(gen)) {
                    if (((MetadataValue)gen.getMetadata("running").get(0)).asBoolean()) {
                        int i;
                        if (((MetadataValue)gen.getMetadata("fueltype").get(0)).asInt() == 0) {
                            if (EUtil.getGeneratorFuel(new ItemStack(Material.COAL), gen) == 0) {
                                this.cancel();
                            }
                            i = 0;
                            while (i < 9) {
                                if (((Dispenser)gen.getState()).getInventory().getItem(i) != null && ((Dispenser)gen.getState()).getInventory().getItem(i).getType() == Material.COAL) {
                                    if (((Dispenser)gen.getState()).getInventory().getItem(i).getAmount() != 1) {
                                        ((Dispenser)gen.getState()).getInventory().getItem(i).setAmount(((Dispenser)gen.getState()).getInventory().getItem(i).getAmount() - 1);
                                        break;
                                    }
                                    ((Dispenser)gen.getState()).getInventory().setItem(i, null);
                                }
                                ++i;
                            }
                        }
                        if (((MetadataValue)gen.getMetadata("fueltype").get(0)).asInt() == 1) {
                            if (EUtil.getGeneratorFuel(new ItemStack(Material.ENDER_PEARL), gen) == 0) {
                                this.cancel();
                            }
                            i = 0;
                            while (i < 9) {
                                if (((Dispenser)gen.getState()).getInventory().getItem(i) != null && ((Dispenser)gen.getState()).getInventory().getItem(i).getType() == Material.ENDER_PEARL) {
                                    if (((Dispenser)gen.getState()).getInventory().getItem(i).getAmount() != 1) {
                                        ((Dispenser)gen.getState()).getInventory().getItem(i).setAmount(((Dispenser)gen.getState()).getInventory().getItem(i).getAmount() - 1);
                                        break;
                                    }
                                    ((Dispenser)gen.getState()).getInventory().setItem(i, null);
                                }
                                ++i;
                            }
                        }
                        if (((MetadataValue)gen.getMetadata("fueltype").get(0)).asInt() == 2) {
                            if (EUtil.getGeneratorFuel(new ItemStack(Material.DRAGON_BREATH), gen) == 0) {
                                this.cancel();
                            }
                            i = 0;
                            while (i < 9) {
                                if (((Dispenser)gen.getState()).getInventory().getItem(i) != null && ((Dispenser)gen.getState()).getInventory().getItem(i).getType() == Material.DRAGON_BREATH) {
                                    if (((Dispenser)gen.getState()).getInventory().getItem(i).getAmount() != 1) {
                                        ((Dispenser)gen.getState()).getInventory().getItem(i).setAmount(((Dispenser)gen.getState()).getInventory().getItem(i).getAmount() - 1);
                                        break;
                                    }
                                    ((Dispenser)gen.getState()).getInventory().setItem(i, null);
                                }
                                ++i;
                            }
                        }
                    } else {
                        this.cancel();
                    }
                } else {
                    this.cancel();
                }
            }
        }.runTaskTimer((Plugin)p, 1L, (long)config.getInt("generator-fuel-consumption-ticks"));
    }

    public static void createBankInput(final Block[] bank, final List<Block> from, final Industrial in) {
        final FileConfiguration config = in.config;
        new BukkitRunnable(){

            public void run() {
                int sep = config.getInt("default-output") / bank.length;
                HashSet<Block> var = EUtil.getBatteryBank(new HashSet<Block>(), bank[0]);
                if (bank.length != var.size()) {
                    this.cancel();
                    EUtil.createBankInput(EUtil.getBatteryBank(new HashSet<Block>(), bank[0]).toArray(new Block[var.size()]), from, in);
                    return;
                }
                List<Block> var2 = EUtil.getBatteryBankInputs(var);
                if (from.size() != var2.size()) {
                    this.cancel();
                    EUtil.createBankInput(bank, EUtil.getBatteryBankInputs(var), in);
                    return;
                }
                int i = 0;
                while (i < bank.length) {
                    int j = 0;
                    while (j < from.size()) {
                        if (EUtil.isMachineBlock((Block)from.get(j))) {
                            if (EUtil.isMachineBlock(bank[i]) && ((MetadataValue)((Block)from.get(j)).getMetadata("charge").get(0)).asInt() >= sep && ((MetadataValue)bank[i].getMetadata("charge").get(0)).asInt() <= 1000000 - sep) {
                                if (((Block)from.get(j)).getType() != Material.DAYLIGHT_DETECTOR) {
                                    bank[i].setMetadata("charge", (MetadataValue)new FixedMetadataValue((Plugin)in, (Object)(((MetadataValue)bank[i].getMetadata("charge").get(0)).asInt() + sep)));
                                    ((Block)from.get(j)).setMetadata("charge", (MetadataValue)new FixedMetadataValue((Plugin)in, (Object)(((MetadataValue)((Block)from.get(j)).getMetadata("charge").get(0)).asInt() - sep)));
                                } else {
                                    HashSet<Block> panels = EUtil.getSolarPanel(new HashSet<Block>(), (Block)from.get(j));
                                    if (EUtil.getPanelCharge(panels) > config.getInt("default-output")) {
                                        for (Block pa : panels) {
                                            if (((MetadataValue)pa.getMetadata("charge").get(0)).asInt() <= config.getInt("default-output") / panels.size()) continue;
                                            pa.setMetadata("charge", (MetadataValue)new FixedMetadataValue((Plugin)in, (Object)(((MetadataValue)pa.getMetadata("charge").get(0)).asInt() - config.getInt("default-output") / panels.size())));
                                            bank[i].setMetadata("charge", (MetadataValue)new FixedMetadataValue((Plugin)in, (Object)(((MetadataValue)bank[i].getMetadata("charge").get(0)).asInt() + config.getInt("default-output") / panels.size())));
                                        }
                                    }
                                }
                            }
                        } else {
                            this.cancel();
                        }
                        ++j;
                    }
                    ++i;
                }
            }
        }.runTaskTimer((Plugin)in, 1L, (long)config.getInt("default-input-ticks"));
    }

    public static void createJetpackUtilization(final Player p, Industrial in) {
        final FileConfiguration config = in.config;
        new BukkitRunnable(){

            public void run() {
                if (EUtil.isJetpackItem(p.getInventory().getChestplate()) && p.isOnline()) {
                    if (EUtil.getCharge((String)p.getInventory().getChestplate().getItemMeta().getLore().get(1)) >= config.getInt("jetpack-pd-use")) {
                        if (p.isSneaking()) {
                            p.setVelocity(new Vector(0.0, 0.45, 0.0));
                            ItemMeta im = p.getInventory().getChestplate().getItemMeta();
                            ArrayList<String> lore = new ArrayList<String>();
                            lore.add("");
                            lore.add(ChatColor.BLUE + lang.getString("charge") + (EUtil.getCharge((String)im.getLore().get(1)) - config.getInt("jetpack-pd-use")) + "/" + EUtil.getMaxCharge((String)im.getLore().get(1)));
                            im.setLore(lore);
                            p.getInventory().getChestplate().setItemMeta(im);
                            p.setFallDistance(0.0f);
                            p.getWorld().spawnParticle(Particle.FLAME, p.getLocation().add(0.0, 1.0, 0.0), 4, 0.0, 0.05, 0.0, 0.05);
                        }
                    } else {
                        this.cancel();
                    }
                } else {
                    this.cancel();
                }
            }
        }.runTaskTimer((Plugin)in, 1L, 3L);
    }

    public static void createGrinderUtilization(final Block g, final Industrial in) {
        final FileConfiguration config = in.config;
        new BukkitRunnable(){

            public void run() {
                if (EUtil.isMachineBlock(g)) {
                    if (!((MetadataValue)g.getMetadata("running").get(0)).asBoolean()) {
                        this.cancel();
                    }
                    if (((MetadataValue)g.getMetadata("charge").get(0)).asInt() >= config.getInt("grinder-pd-use")) {
                        ArrayList<LivingEntity> en = new ArrayList<LivingEntity>();
                        for (Entity entity : g.getLocation().getWorld().getNearbyEntities(g.getLocation(), 7.0, 3.0, 7.0)) {
                            if (!(entity instanceof LivingEntity)) continue;
                            en.add((LivingEntity)entity);
                        }
                        for (LivingEntity livingEntity : en) {
                            if (livingEntity.getType().equals((Object)EntityType.PLAYER)) continue;
                            if (EUtil.isMachineBlock(g)) {
                                if (((MetadataValue)g.getMetadata("charge").get(0)).asInt() >= config.getInt("grinder-pd-use")) {
                                    if (livingEntity.getHealth() <= 7.0) {
                                        livingEntity.damage(7.0);
                                        g.setMetadata("charge", (MetadataValue)new FixedMetadataValue((Plugin)in, (Object)(((MetadataValue)g.getMetadata("charge").get(0)).asInt() - config.getInt("grinder-pd-use"))));
                                        continue;
                                    }
                                    livingEntity.damage(7.0);
                                    g.setMetadata("charge", (MetadataValue)new FixedMetadataValue((Plugin)in, (Object)(((MetadataValue)g.getMetadata("charge").get(0)).asInt() - config.getInt("grinder-pd-use"))));
                                    continue;
                                }
                                g.setMetadata("running", (MetadataValue)new FixedMetadataValue((Plugin)in, (Object)false));
                                continue;
                            }
                            this.cancel();
                        }
                    } else {
                        this.cancel();
                    }
                }
            }
        }.runTaskTimer((Plugin)in, 1L, (long)config.getInt("grinder-attack-delay-ticks"));
    }

    public static void createSolarPanelUtilization(final Block s, final Industrial in) {
        final FileConfiguration config = in.config;
        new BukkitRunnable(){

            public void run() {
                if (EUtil.isMachineBlock(s)) {
                    if (s.getWorld().getTime() < 13000L) {
                        if (s.getLightFromSky() > 0) {
                            if (((MetadataValue)s.getMetadata("charge").get(0)).asInt() < 10000 - config.getInt("solar-panel-output-pd")) {
                                double full = (double)s.getWorld().getTime() / 4333.0;
                                if (full > 1.0) {
                                    full = 1.0;
                                }
                                if (s.getWorld().hasStorm()) {
                                    full /= 2.0;
                                }
                                s.setMetadata("output", (MetadataValue)new FixedMetadataValue((Plugin)in, (Object)((double)config.getInt("solar-panel-output-pd") * ((double)s.getLightFromSky() / 15.0) * full)));
                                s.setMetadata("charge", (MetadataValue)new FixedMetadataValue((Plugin)in, (Object)((double)((MetadataValue)s.getMetadata("charge").get(0)).asInt() + (double)config.getInt("solar-panel-output-pd") * ((double)s.getLightFromSky() / 15.0) * full)));
                            }
                        } else {
                            s.setMetadata("output", (MetadataValue)new FixedMetadataValue((Plugin)in, (Object)0));
                        }
                    } else {
                        s.setMetadata("output", (MetadataValue)new FixedMetadataValue((Plugin)in, (Object)0));
                    }
                } else {
                    this.cancel();
                }
            }
        }.runTaskTimer((Plugin)in, 1L, (long)config.getInt("default-input-ticks"));
    }

    public static void createLaserShot(final Location from, final Vector to, final Player shooter, final Industrial in) {
        final FileConfiguration config = in.config;
        new BukkitRunnable(){
            double range = 0.0;

            public void run() {
                for (Entity e : from.getWorld().getNearbyEntities(from, 1.0, 1.0, 1.0)) {
                    if (!(e instanceof LivingEntity) || e.equals(shooter) || !EUtil.canBuild(shooter, e.getLocation().getBlock(), in)) continue;
                    ((LivingEntity)e).damage((double)config.getInt("laser-rifle-damage"));
                    this.cancel();
                }
                from.add(to);
                from.getWorld().spawnParticle(Particle.DRAGON_BREATH, from, 4, 0.0, 0.005, 0.0, 0.005);
                if (from.getY() > 256.0 || this.range > (double)config.getInt("laser-rifle-range") || from.getBlock().getType() != Material.AIR) {
                    this.cancel();
                }
                this.range += 1.0;
            }
        }.runTaskTimer((Plugin)in, 1L, 1L);
    }

    public static void createFurnaceUtilization(final Furnace f, final Industrial in) {
        final FileConfiguration config = in.config;
        new BukkitRunnable(){

            public void run() {
                if (f.getBlock().getType() == Material.AIR) {
                    this.cancel();
                }
                if (f.getInventory().getSmelting() != null) {
                    if (((MetadataValue)f.getMetadata("charge").get(0)).asInt() >= config.getInt("furnace-pd-use") && f.getBurnTime() <= 2) {
                        f.setBurnTime((short)config.getInt("furnace-burn-time-ticks"));
                        f.setMetadata("charge", (MetadataValue)new FixedMetadataValue((Plugin)in, (Object)(((MetadataValue)f.getMetadata("charge").get(0)).asInt() - config.getInt("furnace-pd-use"))));
                        ItemStack charge = new ItemStack(Material.REDSTONE);
                        ItemMeta chargem = charge.getItemMeta();
                        chargem.setDisplayName(ChatColor.RED + in.lang.getString("charge") + ((MetadataValue)f.getMetadata("charge").get(0)).asInt());
                        charge.setItemMeta(chargem);
                        f.getInventory().setFuel(charge);
                    }
                } else {
                    this.cancel();
                }
            }
        }.runTaskTimer((Plugin)in, 1L, 9L);
    }

    public static ItemStack machineToItemStack(Block b) {
        ItemStack is = new ItemStack(b.getType());
        ItemMeta im = is.getItemMeta();
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("");
        switch (b.getType()) {
            case DROPPER: {
                im.setDisplayName(ChatColor.RED + lang.getString("charging-station"));
                lore.add(ChatColor.BLUE + lang.getString("charge") + Integer.parseInt(EUtil.getMachineBlockInfo(b).get(0)) + "/50000pd");
                break;
            }
            case DISPENSER: {
                im.setDisplayName(ChatColor.RED + lang.getString("generator"));
                lore.add(ChatColor.BLUE + lang.getString("charge") + Integer.parseInt(EUtil.getMachineBlockInfo(b).get(0)) + "/50000pd");
                break;
            }
            case NOTE_BLOCK: {
                im.setDisplayName(ChatColor.RED + lang.getString("battery-bank"));
                lore.add(ChatColor.BLUE + lang.getString("charge") + Integer.parseInt(EUtil.getMachineBlockInfo(b).get(0)) + "/1000000pd");
                break;
            }
            case OBSERVER: {
                im.setDisplayName(ChatColor.RED + lang.getString("mob-grinder"));
                lore.add(ChatColor.BLUE + lang.getString("charge") + Integer.parseInt(EUtil.getMachineBlockInfo(b).get(0)) + "/50000pd");
                break;
            }
            case DAYLIGHT_DETECTOR: {
                im.setDisplayName(ChatColor.RED + lang.getString("solar-panel"));
                lore.add(ChatColor.BLUE + lang.getString("charge") + Integer.parseInt(EUtil.getMachineBlockInfo(b).get(0)) + "/10000pd");
                break;
            }
            case FURNACE: {
                im.setDisplayName(ChatColor.RED + lang.getString("electric-furnace"));
                lore.add(ChatColor.BLUE + lang.getString("charge") + Integer.parseInt(EUtil.getMachineBlockInfo(b).get(0)) + "/50000pd");
                break;
            }
        }
        im.setLore(lore);
        im.addEnchant(Enchantment.ARROW_DAMAGE, 1, true);
        im.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
        is.setItemMeta(im);
        return is;
    }

    public static List<String> getMachineBlockInfo(Block b) {
        ArrayList<String> inf = new ArrayList<String>();
        if (EUtil.isMachineBlock(b)) {
            switch (b.getType()) {
                case DROPPER: {
                    inf.add(String.valueOf(((MetadataValue)b.getMetadata("charge").get(0)).asInt()));
                    inf.add(String.valueOf(((MetadataValue)b.getMetadata("connection").get(0)).asBoolean()));
                    inf.add(String.valueOf(((MetadataValue)b.getMetadata("input").get(0)).asInt()));
                    inf.add(((MetadataValue)b.getMetadata("owner").get(0)).asString());
                    inf.add(((MetadataValue)b.getMetadata("id").get(0)).asString());
                    break;
                }
                case DISPENSER: {
                    inf.add(String.valueOf(((MetadataValue)b.getMetadata("charge").get(0)).asInt()));
                    inf.add(String.valueOf(((MetadataValue)b.getMetadata("connection").get(0)).asBoolean()));
                    inf.add(String.valueOf(((MetadataValue)b.getMetadata("output").get(0)).asInt()));
                    inf.add(((MetadataValue)b.getMetadata("owner").get(0)).asString());
                    inf.add(((MetadataValue)b.getMetadata("id").get(0)).asString());
                    inf.add(String.valueOf(((MetadataValue)b.getMetadata("fueltype").get(0)).asInt()));
                    inf.add(String.valueOf(((MetadataValue)b.getMetadata("running").get(0)).asBoolean()));
                    break;
                }
                case NOTE_BLOCK: {
                    inf.add(String.valueOf(((MetadataValue)b.getMetadata("charge").get(0)).asInt()));
                    inf.add(String.valueOf(((MetadataValue)b.getMetadata("connection").get(0)).asBoolean()));
                    inf.add(String.valueOf(((MetadataValue)b.getMetadata("input").get(0)).asInt()));
                    inf.add(String.valueOf(((MetadataValue)b.getMetadata("output").get(0)).asInt()));
                    inf.add(((MetadataValue)b.getMetadata("owner").get(0)).asString());
                    inf.add(((MetadataValue)b.getMetadata("id").get(0)).asString());
                    break;
                }
                case OBSERVER: {
                    inf.add(String.valueOf(((MetadataValue)b.getMetadata("charge").get(0)).asInt()));
                    inf.add(String.valueOf(((MetadataValue)b.getMetadata("input").get(0)).asInt()));
                    inf.add(((MetadataValue)b.getMetadata("owner").get(0)).asString());
                    inf.add(((MetadataValue)b.getMetadata("id").get(0)).asString());
                    inf.add(String.valueOf(((MetadataValue)b.getMetadata("running").get(0)).asBoolean()));
                    break;
                }
                case DAYLIGHT_DETECTOR: {
                    inf.add(String.valueOf(((MetadataValue)b.getMetadata("charge").get(0)).asInt()));
                    inf.add(String.valueOf(((MetadataValue)b.getMetadata("output").get(0)).asInt()));
                    inf.add(((MetadataValue)b.getMetadata("owner").get(0)).asString());
                    inf.add(((MetadataValue)b.getMetadata("id").get(0)).asString());
                    break;
                }
                case FURNACE: {
                    inf.add(String.valueOf(((MetadataValue)b.getMetadata("charge").get(0)).asInt()));
                    inf.add(String.valueOf(((MetadataValue)b.getMetadata("input").get(0)).asInt()));
                    inf.add(((MetadataValue)b.getMetadata("owner").get(0)).asString());
                    inf.add(((MetadataValue)b.getMetadata("id").get(0)).asString());
                    break;
                }
            }
        }
        return inf;
    }

    public static List<String> getMachineBlockLocation(FileConfiguration config, String id) {
        return config.getStringList("macLocations." + id);
    }

    public static List<String> getMachineLocationInfo(Block b) {
        ArrayList<String> inf = new ArrayList<String>();
        if (EUtil.isMachineBlock(b)) {
            inf.add(String.valueOf(b.getLocation().getBlockX()));
            inf.add(String.valueOf(b.getLocation().getBlockY()));
            inf.add(String.valueOf(b.getLocation().getBlockZ()));
            inf.add(b.getLocation().getWorld().getName());
        }
        return inf;
    }

    public static BlockFace getMachineFace(int face) {
        switch (face) {
            case 0: {
                return BlockFace.DOWN;
            }
            case 1: {
                return BlockFace.UP;
            }
            case 2: {
                return BlockFace.NORTH;
            }
            case 3: {
                return BlockFace.SOUTH;
            }
            case 4: {
                return BlockFace.WEST;
            }
            case 5: {
                return BlockFace.EAST;
            }
        }
        return BlockFace.SOUTH;
    }

    public static int blockFaceToInteger(BlockFace f) {
        switch (f) {
            case NORTH_EAST: {
                return 0;
            }
            case NORTH: {
                return 1;
            }
            case DOWN: {
                return 2;
            }
            case EAST_NORTH_EAST: {
                return 3;
            }
            case EAST_SOUTH_EAST: {
                return 4;
            }
            case EAST: {
                return 5;
            }
        }
        return 0;
    }

    public static void seralizeMachineBlock(FileConfiguration info, FileConfiguration loc, Block b) {
        if (EUtil.isMachineBlock(b)) {
            info.set("machines." + ((MetadataValue)b.getMetadata("id").get(0)).asLong(), EUtil.getMachineBlockInfo(b));
            loc.set("macLocations." + ((MetadataValue)b.getMetadata("id").get(0)).asLong(), EUtil.getMachineLocationInfo(b));
        }
    }

    public static void removeBlockFromConfig(FileConfiguration loc, FileConfiguration info, String id) {
        loc.set("macLocations." + id, null);
        info.set("machines." + id, null);
    }

    public static void saveMetadataToConfig(FileConfiguration mloc, FileConfiguration info, Industrial p) {
        if (info.getConfigurationSection("machines") != null && mloc.getConfigurationSection("macLocations") != null) {
            Object[] infos;
            Object[] locs = mloc.getConfigurationSection("macLocations").getKeys(false).toArray();
            if (locs.length == (infos = info.getConfigurationSection("machines").getKeys(false).toArray()).length) {
                int i = 0;
                while (i < locs.length) {
                    List lloc = mloc.getStringList("macLocations." + locs[i]);
                    Block b = p.getServer().getWorld((String)lloc.get(3)).getBlockAt(Integer.parseInt((String)lloc.get(0)), Integer.parseInt((String)lloc.get(1)), Integer.parseInt((String)lloc.get(2)));
                    if (EUtil.isMachineBlock(b)) {
                        info.set("machines." + ((MetadataValue)b.getMetadata("id").get(0)).asLong(), EUtil.getMachineBlockInfo(b));
                    } else {
                        p.getServer().getLogger().warning("Block At: " + (String)lloc.get(0) + "," + (String)lloc.get(1) + "," + (String)lloc.get(2) + ", worldName: " + (String)lloc.get(3) + " was reported as MachineBlock, But Doesnt Contain an ID!");
                        p.getServer().getLogger().info("Machine-ID: " + locs[i] + " Has Been Removed From Config.");
                        mloc.set("macLocations." + locs[i], null);
                        info.set("machines." + locs[i], null);
                    }
                    ++i;
                }
            } else {
                p.getLogger().severe("!!ERROR WHILE SAVING MACHINES TO CONFIG!, ERROR: UNEQUAL AMOUNT OF MACHINES PER LOCATION!!");
            }
        }
    }

    public static void reMetadatafiyMachinesAfterRestart(FileConfiguration info, FileConfiguration loc, Industrial p) {
        if (info.getConfigurationSection("machines") != null && loc.getConfigurationSection("macLocations") != null) {
            Object[] infos = info.getConfigurationSection("machines").getKeys(false).toArray();
            Object[] locs = loc.getConfigurationSection("macLocations").getKeys(false).toArray();
            if (locs.length == infos.length) {
                int i = 0;
                while (i < locs.length) {
                    List linfo = info.getStringList("machines." + infos[i]);
                    List lloc = loc.getStringList("macLocations." + locs[i]);
                    Block b = p.getServer().getWorld((String)lloc.get(3)).getBlockAt(new Location(p.getServer().getWorld((String)lloc.get(3)), (double)Integer.parseInt((String)lloc.get(0)), (double)Integer.parseInt((String)lloc.get(1)), (double)Integer.parseInt((String)lloc.get(2))));
                    World w = p.getServer().getWorld((String)lloc.get(3));
                    if (w == null) {
                        w = p.getServer().createWorld(new WorldCreator((String)lloc.get(3)));
                    }
                    block0 : switch (b.getType()) {
                        case DROPPER: {
                            b.setMetadata("charge", (MetadataValue)new FixedMetadataValue((Plugin)p, linfo.get(0)));
                            b.setMetadata("connection", (MetadataValue)new FixedMetadataValue((Plugin)p, (Object)Boolean.parseBoolean((String)linfo.get(1))));
                            b.setMetadata("input", (MetadataValue)new FixedMetadataValue((Plugin)p, (Object)Integer.parseInt((String)linfo.get(2))));
                            b.setMetadata("owner", (MetadataValue)new FixedMetadataValue((Plugin)p, linfo.get(3)));
                            b.setMetadata("id", (MetadataValue)new FixedMetadataValue((Plugin)p, linfo.get(4)));
                            EUtil.createInputUtilization(b, EUtil.getClosestPowerSource(b), p);
                            List<ItemStack> bats = EUtil.getChargingStationBatteries(b);
                            Dropper d = (Dropper)b.getState();
                            for (ItemStack ba : bats) {
                                if (d.getInventory().getItem(0).isSimilar(ba)) {
                                    EUtil.chargeInventorySlot(0, d.getInventory(), b, p);
                                }
                                if (d.getInventory().getItem(1).isSimilar(ba)) {
                                    EUtil.chargeInventorySlot(1, d.getInventory(), b, p);
                                }
                                if (!d.getInventory().getItem(2).isSimilar(ba)) continue;
                                EUtil.chargeInventorySlot(2, d.getInventory(), b, p);
                            }
                            break;
                        }
                        case DISPENSER: {
                            b.setMetadata("charge", (MetadataValue)new FixedMetadataValue((Plugin)p, linfo.get(0)));
                            b.setMetadata("connection", (MetadataValue)new FixedMetadataValue((Plugin)p, (Object)Boolean.parseBoolean((String)linfo.get(1))));
                            b.setMetadata("output", (MetadataValue)new FixedMetadataValue((Plugin)p, (Object)Integer.parseInt((String)linfo.get(2))));
                            b.setMetadata("owner", (MetadataValue)new FixedMetadataValue((Plugin)p, linfo.get(3)));
                            b.setMetadata("id", (MetadataValue)new FixedMetadataValue((Plugin)p, linfo.get(4)));
                            b.setMetadata("fueltype", (MetadataValue)new FixedMetadataValue((Plugin)p, linfo.get(5)));
                            b.setMetadata("running", (MetadataValue)new FixedMetadataValue((Plugin)p, (Object)Boolean.parseBoolean((String)linfo.get(6))));
                            if (!Boolean.parseBoolean((String)linfo.get(6))) break;
                            EUtil.createFuelConsumption(b, p);
                            EUtil.createOutputUtilization(b, p);
                            break;
                        }
                        case NOTE_BLOCK: {
                            b.setMetadata("charge", (MetadataValue)new FixedMetadataValue((Plugin)p, linfo.get(0)));
                            b.setMetadata("connection", (MetadataValue)new FixedMetadataValue((Plugin)p, (Object)Boolean.parseBoolean((String)linfo.get(1))));
                            b.setMetadata("input", (MetadataValue)new FixedMetadataValue((Plugin)p, (Object)Integer.parseInt((String)linfo.get(2))));
                            b.setMetadata("output", (MetadataValue)new FixedMetadataValue((Plugin)p, (Object)Integer.parseInt((String)linfo.get(3))));
                            b.setMetadata("owner", (MetadataValue)new FixedMetadataValue((Plugin)p, linfo.get(4)));
                            b.setMetadata("id", (MetadataValue)new FixedMetadataValue((Plugin)p, linfo.get(5)));
                            int j = 0;
                            while (j < 6) {
                                if (EUtil.getPowerSourceAtDirection(b, EUtil.getMachineFace(j), -1).hasMetadata("output") && EUtil.getPowerSourceAtDirection(b, EUtil.getMachineFace(j), -1).getType() != Material.NOTE_BLOCK) {
                                    HashSet<Block> bank = EUtil.getBatteryBank(new HashSet<Block>(), b);
                                    EUtil.createBankInput(bank.toArray(new Block[bank.size()]), EUtil.getBatteryBankInputs(bank), p);
                                    break block0;
                                }
                                ++j;
                            }
                            break;
                        }
                        case OBSERVER: {
                            b.setMetadata("charge", (MetadataValue)new FixedMetadataValue((Plugin)p, linfo.get(0)));
                            b.setMetadata("input", (MetadataValue)new FixedMetadataValue((Plugin)p, linfo.get(1)));
                            b.setMetadata("owner", (MetadataValue)new FixedMetadataValue((Plugin)p, linfo.get(2)));
                            b.setMetadata("id", (MetadataValue)new FixedMetadataValue((Plugin)p, linfo.get(3)));
                            b.setMetadata("running", (MetadataValue)new FixedMetadataValue((Plugin)p, (Object)Boolean.parseBoolean((String)linfo.get(4))));
                            if (EUtil.getPowerSourceAtDirection(b, EUtil.getMachineFace(0), 1).hasMetadata("output")) {
                                EUtil.createInputUtilization(b, EUtil.getPowerSourceAtDirection(b, EUtil.getMachineFace(0), 1), p);
                            }
                            if (!Boolean.parseBoolean((String)linfo.get(4))) break;
                            EUtil.createGrinderUtilization(b, p);
                            break;
                        }
                        case DAYLIGHT_DETECTOR: {
                            b.setMetadata("charge", (MetadataValue)new FixedMetadataValue((Plugin)p, linfo.get(0)));
                            b.setMetadata("output", (MetadataValue)new FixedMetadataValue((Plugin)p, linfo.get(1)));
                            b.setMetadata("owner", (MetadataValue)new FixedMetadataValue((Plugin)p, linfo.get(2)));
                            b.setMetadata("id", (MetadataValue)new FixedMetadataValue((Plugin)p, linfo.get(3)));
                            EUtil.createSolarPanelUtilization(b, p);
                            break;
                        }
                        case FURNACE: {
                            Furnace f;
                            b.setMetadata("charge", (MetadataValue)new FixedMetadataValue((Plugin)p, linfo.get(0)));
                            b.setMetadata("input", (MetadataValue)new FixedMetadataValue((Plugin)p, linfo.get(1)));
                            b.setMetadata("owner", (MetadataValue)new FixedMetadataValue((Plugin)p, linfo.get(2)));
                            b.setMetadata("id", (MetadataValue)new FixedMetadataValue((Plugin)p, linfo.get(3)));
                            if (EUtil.getPowerSourceAtDirection(b, EUtil.getMachineFace(b.getData()).getOppositeFace(), EUtil.blockFaceToInteger(EUtil.getMachineFace(b.getData()))).hasMetadata("output")) {
                                EUtil.createInputUtilization(b, EUtil.getPowerSourceAtDirection(b, EUtil.getMachineFace(b.getData()).getOppositeFace(), EUtil.blockFaceToInteger(EUtil.getMachineFace(b.getData()))), p);
                            }
                            if ((f = (Furnace)b.getState()).getInventory().getSmelting() == null) break;
                            EUtil.createFurnaceUtilization(f, p);
                            break;
                        }
                    }
                    ++i;
                }
            } else {
                p.getLogger().severe("!!ERROR LOADING MACHINE INFORMATION, DISABLING MACHINES!, ERROR: UNEQUAL AMOUNT OF MACHINES PER LOCATIONS!!");
                p.getServer().shutdown();
            }
        }
    }

    public static Block getClosestPowerSource(Block b) {
        BlockFace facing = EUtil.getMachineFace(b.getState().getData().getData()).getOppositeFace();
        Block next = b.getRelative(facing);
        if (b.hasMetadata("id")) {
            while (next.getType() == Material.END_ROD) {
                next = next.getRelative(facing);
            }
            if (next.getType() == Material.CHISELED_STONE_BRICKS) {
                Block at = null;
                int i = 0;
                while (i < 6) {
                    at = EUtil.getPowerSourceAtDirection(next, EUtil.getMachineFace(i), EUtil.blockFaceToInteger(EUtil.getMachineFace(i).getOppositeFace()));
                    if (at != null && at.hasMetadata("output")) {
                        return at;
                    }
                    ++i;
                }
                return at;
            }
        }
        return next;
    }

    public static Block getPowerSourceAtDirection(Block b, BlockFace f, int e) {
        Block next = b.getRelative(f);
        while (next.getType() == Material.END_ROD) {
            next = next.getRelative(f);
        }
        if (next.getType() == Material.CHISELED_STONE_BRICKS) {
            Block at = null;
            int i = 0;
            while (i < 6) {
                if (i != e && (at = EUtil.getPowerSourceAtDirection(next, EUtil.getMachineFace(i), EUtil.blockFaceToInteger(EUtil.getMachineFace(i).getOppositeFace()))) != null && at.hasMetadata("output")) {
                    return at;
                }
                ++i;
            }
            return at;
        }
        return next;
    }

    public static HashSet<Block> getBatteryBank(HashSet<Block> beenBefore, Block b) {
        HashSet<Block> checked = beenBefore;
        ArrayList<Block> toCheck = new ArrayList<Block>();
        toCheck.add(b);
        while (!toCheck.isEmpty()) {
            int size = toCheck.size();
            int i = 0;
            while (i < size) {
                if (!checked.contains(toCheck.get(size - 1 - i))) {
                    checked.add((Block)toCheck.get(size - 1 - i));
                    toCheck.remove(size - 1 - i);
                }
                ++i;
            }
            i = 0;
            while (i < 6) {
                Block f = b.getRelative(EUtil.getMachineFace(i));
                if (f.hasMetadata("id") && f.getType() == Material.NOTE_BLOCK && !checked.contains(f)) {
                    EUtil.getBatteryBank(checked, f);
                }
                ++i;
            }
        }
        return checked;
    }

    public static int getBatteryBankInfo(HashSet<Block> bank, int info) {
        Block[] bs = bank.toArray(new Block[bank.size()]);
        int total = 0;
        int i = 0;
        while (i < bs.length) {
            switch (info) {
                case 0: {
                    total += ((MetadataValue)bs[i].getMetadata("charge").get(0)).asInt();
                    break;
                }
                case 1: {
                    List<Block> ins = EUtil.getBatteryBankInputs(bank);
                    int j = 0;
                    while (j < ins.size()) {
                        total += ((MetadataValue)ins.get(j).getMetadata("output").get(0)).asInt();
                        ++j;
                    }
                    break;
                }
                default: {
                    ++total;
                }
            }
            ++i;
        }
        return total;
    }

    public static List<Block> getBatteryBankInputs(HashSet<Block> bank) {
        ArrayList<Block> ins = new ArrayList<Block>();
        Block[] bnk = bank.toArray(new Block[bank.size()]);
        int i = 0;
        while (i < bnk.length) {
            int j = 0;
            while (j < 6) {
                if (EUtil.getPowerSourceAtDirection(bnk[i], EUtil.getMachineFace(j), -1).hasMetadata("output")) {
                    ins.add(EUtil.getPowerSourceAtDirection(bnk[i], EUtil.getMachineFace(j), -1));
                }
                ++j;
            }
            ++i;
        }
        return ins;
    }

    public static int getBatteryItemType(ItemStack is) {
        if (is.hasItemMeta() && is.getItemMeta().hasLore() && is.getItemMeta().getLore().size() == 2 && ((String)is.getItemMeta().getLore().get(1)).contains(lang.getString("charge")) && is.containsEnchantment(Enchantment.ARROW_DAMAGE)) {
            if (is.getType() == Material.BRICK) {
                return 0;
            }
            if (is.getType() == Material.NETHER_BRICK) {
                return 1;
            }
            if (is.getType() == Material.IRON_INGOT) {
                return 2;
            }
            return -1;
        }
        return -1;
    }

    public static int getBatteryHeld(Player p) {
        if (p.getInventory().getItemInMainHand().hasItemMeta() && p.getInventory().getItemInMainHand().getItemMeta().hasLore() && p.getInventory().getItemInMainHand().getItemMeta().getLore().size() == 2 && ((String)p.getInventory().getItemInMainHand().getItemMeta().getLore().get(1)).contains("Charge") && p.getInventory().getItemInMainHand().containsEnchantment(Enchantment.ARROW_DAMAGE)) {
            if (p.getInventory().getItemInMainHand().getType() == Material.BRICK) {
                return 0;
            }
            if (p.getInventory().getItemInMainHand().getType() == Material.NETHER_BRICK) {
                return 1;
            }
            if (p.getInventory().getItemInMainHand().getType() == Material.IRON_INGOT) {
                return 2;
            }
            return -1;
        }
        return -1;
    }

    public static BlockFace getQuaryFace(Block q) {
        int i = 2;
        while (i < 6) {
            if (q.getRelative(EUtil.getMachineFace(i)).getType() == Material.REDSTONE_TORCH) {
                return EUtil.getMachineFace(i);
            }
            ++i;
        }
        return BlockFace.SELF;
    }

    public static HashSet<Block> getSolarPanel(HashSet<Block> been, Block s) {
        HashSet<Block> panels = been;
        ArrayList<Block> toCheck = new ArrayList<Block>();
        toCheck.add(s);
        while (!toCheck.isEmpty()) {
            int size = toCheck.size();
            int i = 0;
            while (i < size) {
                if (!panels.contains(toCheck.get(size - 1 - i))) {
                    panels.add((Block)toCheck.get(size - 1 - i));
                    toCheck.remove(size - 1 - i);
                }
                ++i;
            }
            i = 2;
            while (i < 6) {
                Block f = s.getRelative(EUtil.getMachineFace(i));
                if (EUtil.isMachineBlock(f) && f.getType() == Material.DAYLIGHT_DETECTOR && !panels.contains(f)) {
                    EUtil.getSolarPanel(panels, f);
                }
                ++i;
            }
        }
        return panels;
    }

    public static int getPanelCharge(HashSet<Block> panel) {
        int total = 0;
        for (Block p : panel) {
            total += ((MetadataValue)p.getMetadata("charge").get(0)).asInt();
        }
        return total;
    }

    public static boolean isTool(ItemStack is) {
        if (EUtil.isShulkerBox(is.getType())) {
            return true;
        }
        switch (is.getType()) {
            case CARROT_ON_A_STICK: 
            case BOW: 
            case WOODEN_SWORD: 
            case WOODEN_SHOVEL: 
            case WOODEN_PICKAXE: 
            case WOODEN_AXE: 
            case WOODEN_HOE: 
            case STONE_SWORD: 
            case STONE_SHOVEL: 
            case STONE_PICKAXE: 
            case STONE_AXE: 
            case STONE_HOE: 
            case GOLDEN_SWORD: 
            case GOLDEN_SHOVEL: 
            case GOLDEN_PICKAXE: 
            case GOLDEN_AXE: 
            case GOLDEN_HOE: 
            case IRON_SWORD: 
            case IRON_SHOVEL: 
            case IRON_PICKAXE: 
            case IRON_AXE: 
            case IRON_HOE: 
            case DIAMOND_SWORD: 
            case DIAMOND_SHOVEL: 
            case DIAMOND_PICKAXE: 
            case DIAMOND_AXE: 
            case DIAMOND_HOE: 
            case LEATHER_HELMET: 
            case LEATHER_CHESTPLATE: 
            case LEATHER_LEGGINGS: 
            case LEATHER_BOOTS: 
            case CHAINMAIL_HELMET: 
            case CHAINMAIL_CHESTPLATE: 
            case CHAINMAIL_LEGGINGS: 
            case CHAINMAIL_BOOTS: 
            case IRON_HELMET: 
            case IRON_CHESTPLATE: 
            case IRON_LEGGINGS: 
            case IRON_BOOTS: 
            case DIAMOND_HELMET: 
            case DIAMOND_CHESTPLATE: 
            case DIAMOND_LEGGINGS: 
            case DIAMOND_BOOTS: 
            case GOLDEN_HELMET: 
            case GOLDEN_CHESTPLATE: 
            case GOLDEN_LEGGINGS: 
            case GOLDEN_BOOTS: 
            case FISHING_ROD: 
            case SHEARS: 
            case POTION: 
            case ENCHANTED_BOOK: 
            case SHIELD: {
                return true;
            }
        }
        return false;
    }

    public static boolean isShulkerBox(Material m) {
        switch (m) {
            case WHITE_SHULKER_BOX: 
            case ORANGE_SHULKER_BOX: 
            case MAGENTA_SHULKER_BOX: 
            case LIGHT_BLUE_SHULKER_BOX: 
            case YELLOW_SHULKER_BOX: 
            case LIME_SHULKER_BOX: 
            case PINK_SHULKER_BOX: 
            case GRAY_SHULKER_BOX: 
            case LIGHT_GRAY_SHULKER_BOX: 
            case CYAN_SHULKER_BOX: 
            case PURPLE_SHULKER_BOX: 
            case BROWN_SHULKER_BOX: 
            case GREEN_SHULKER_BOX: 
            case BLACK_SHULKER_BOX: {
                return true;
            }
        }
        return false;
    }

    public static boolean isValidWorld(Industrial in, String name) {
        return in.config.getStringList("worlds").contains(name);
    }

    public static boolean canBuild(Player p, Block b, Industrial in) {
        if (in.wg != null) {
            try {
                if (in.gp == null) {
                    return (Boolean)in.wg.getClass().getMethod("canBuild", p.getClass().getInterfaces()[0], b.getLocation().getClass()).invoke((Object)in.wg, p, b.getLocation());
                }
                boolean allowed = (Boolean)in.wg.getClass().getMethod("canBuild", p.getClass().getInterfaces()[0], b.getLocation().getClass()).invoke((Object)in.wg, p, b.getLocation());
                if (!allowed) {
                    return in.gp.getClass().getMethod("allowBreak", p.getClass().getInterfaces()[0], b.getClass().getInterfaces()[0], b.getLocation().getClass()).invoke((Object)in.gp, p, b, b.getLocation()) == null;
                }
                return allowed;
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                e.printStackTrace();
                return true;
            }
        }
        if (in.gp != null) {
            try {
                return in.gp.getClass().getMethod("allowBreak", p.getClass().getInterfaces()[0], b.getClass().getInterfaces()[0], b.getLocation().getClass()).invoke((Object)in.gp, p, b, b.getLocation()) == null;
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                e.printStackTrace();
                return true;
            }
        }
        return true;
    }

    public static int getMachineIndex(Block b) {
        switch (b.getType()) {
            case DROPPER: {
                return 0;
            }
            case DISPENSER: {
                return 1;
            }
            case NOTE_BLOCK: {
                return 2;
            }
            case BEACON: {
                return 3;
            }
            case OBSERVER: {
                return 4;
            }
            case DAYLIGHT_DETECTOR: {
                return 5;
            }
            case FURNACE: {
                return 6;
            }
            case HAY_BLOCK: {
                return 7;
            }
            case YELLOW_STAINED_GLASS: {
                return 8;
            }
            case WHITE_STAINED_GLASS: {
                return 17;
            }
            case BLUE_STAINED_GLASS: {
                return 18;
            }
            case ORANGE_STAINED_GLASS: {
                return 19;
            }
            case BLACK_STAINED_GLASS: {
                return 20;
            }
            case WHITE_WOOL: {
                return 9;
            }
            case EMERALD_BLOCK: {
                return 10;
            }
            case BOOKSHELF: {
                return 11;
            }
            case IRON_BLOCK: {
                return 12;
            }
            case GOLD_BLOCK: {
                return 13;
            }
            case DIAMOND_BLOCK: {
                return 14;
            }
            case SEA_LANTERN: {
                return 15;
            }
            case CRAFTING_TABLE: {
                return 16;
            }
            case BLACK_SHULKER_BOX: {
                return 21;
            }
            case SUNFLOWER: {
                return 99;
            }
        }
        return -1;
    }

    public static List<String> getMachineBlockInfo(Block b, Industrial in) {
        ArrayList<String> inf = new ArrayList<String>();
        if (EUtil.isMachineBlock(b)) {
            switch (EUtil.getMachineIndex(b)) {
                case 7: {
                    inf.add(String.valueOf(((MetadataValue)b.getMetadata("charge").get(0)).asInt()));
                    inf.add(String.valueOf(((MetadataValue)b.getMetadata("input").get(0)).asInt()));
                    inf.add(((MetadataValue)b.getMetadata("owner").get(0)).asString());
                    inf.add(((MetadataValue)b.getMetadata("id").get(0)).asString());
                    inf.add(String.valueOf(((MetadataValue)b.getMetadata("seeds").get(0)).asInt()));
                    inf.add(String.valueOf(((MetadataValue)b.getMetadata("wheat").get(0)).asInt()));
                    inf.add(String.valueOf(((MetadataValue)b.getMetadata("carrots").get(0)).asInt()));
                    inf.add(String.valueOf(((MetadataValue)b.getMetadata("potatoes").get(0)).asInt()));
                    inf.add(String.valueOf(((MetadataValue)b.getMetadata("beets").get(0)).asInt()));
                    break;
                }
                case 8: {
                    inf.add(String.valueOf(((MetadataValue)b.getMetadata("xp").get(0)).asInt()));
                    inf.add(((MetadataValue)b.getMetadata("owner").get(0)).asString());
                    inf.add(((MetadataValue)b.getMetadata("id").get(0)).asString());
                    break;
                }
                case 9: {
                    inf.add(((MetadataValue)b.getMetadata("owner").get(0)).asString());
                    inf.add(((MetadataValue)b.getMetadata("id").get(0)).asString());
                    break;
                }
                case 10: {
                    inf.add(String.valueOf(((MetadataValue)b.getMetadata("charge").get(0)).asInt()));
                    inf.add(String.valueOf(((MetadataValue)b.getMetadata("output").get(0)).asInt()));
                    inf.add(((MetadataValue)b.getMetadata("owner").get(0)).asString());
                    inf.add(((MetadataValue)b.getMetadata("id").get(0)).asString());
                    inf.add(String.valueOf(((MetadataValue)b.getMetadata("running").get(0)).asBoolean()));
                    inf.add(((MetadataValue)b.getMetadata("ice").get(0)).asString());
                    inf.add(((MetadataValue)b.getMetadata("fuel").get(0)).asString());
                    inf.add(((MetadataValue)b.getMetadata("temp").get(0)).asString());
                    break;
                }
                case 11: {
                    inf.add(String.valueOf(((MetadataValue)b.getMetadata("charge").get(0)).asInt()));
                    inf.add(String.valueOf(((MetadataValue)b.getMetadata("input").get(0)).asInt()));
                    inf.add(((MetadataValue)b.getMetadata("owner").get(0)).asString());
                    inf.add(((MetadataValue)b.getMetadata("id").get(0)).asString());
                    inf.add(((MetadataValue)b.getMetadata("sort").get(0)).asString());
                    break;
                }
                case 12: 
                case 13: 
                case 14: {
                    inf.add(((MetadataValue)b.getMetadata("owner").get(0)).asString());
                    inf.add(((MetadataValue)b.getMetadata("id").get(0)).asString());
                    break;
                }
                case 15: {
                    inf.add(String.valueOf(((MetadataValue)b.getMetadata("charge").get(0)).asInt()));
                    inf.add(String.valueOf(((MetadataValue)b.getMetadata("output").get(0)).asInt()));
                    inf.add(((MetadataValue)b.getMetadata("owner").get(0)).asString());
                    inf.add(((MetadataValue)b.getMetadata("id").get(0)).asString());
                    break;
                }
                case 16: {
                    inf.add(String.valueOf(((MetadataValue)b.getMetadata("charge").get(0)).asInt()));
                    inf.add(String.valueOf(((MetadataValue)b.getMetadata("input").get(0)).asInt()));
                    inf.add(((MetadataValue)b.getMetadata("owner").get(0)).asString());
                    inf.add(((MetadataValue)b.getMetadata("id").get(0)).asString());
                    inf.add(((MetadataValue)b.getMetadata("recipe").get(0)).value() != null ? ((ItemStack)((MetadataValue)b.getMetadata("recipe").get(0)).value()).getType().name() : "BIRCH_SAPLING");
                    inf.add(String.valueOf(((MetadataValue)b.getMetadata("running").get(0)).asBoolean()));
                    break;
                }
                case 17: 
                case 18: 
                case 19: 
                case 20: {
                    inf.add(((MetadataValue)b.getMetadata("owner").get(0)).asString());
                    inf.add(((MetadataValue)b.getMetadata("id").get(0)).asString());
                    inf.add(String.valueOf(((MetadataValue)b.getMetadata("fill").get(0)).asInt()));
                    break;
                }
                case 21: {
                    inf.add(((MetadataValue)b.getMetadata("charge").get(0)).asString());
                    inf.add(((MetadataValue)b.getMetadata("input").get(0)).asString());
                    inf.add(((MetadataValue)b.getMetadata("owner").get(0)).asString());
                    inf.add(((MetadataValue)b.getMetadata("id").get(0)).asString());
                    inf.add(String.valueOf(((MetadataValue)b.getMetadata("fill").get(0)).asInt()));
                    inf.add(String.valueOf(((MetadataValue)b.getMetadata("coal").get(0)).asInt()));
                    inf.add(String.valueOf(((MetadataValue)b.getMetadata("running").get(0)).asBoolean()));
                    break;
                }
                case 0: {
                    inf.add(String.valueOf(((MetadataValue)b.getMetadata("charge").get(0)).asInt()));
                    inf.add(String.valueOf(((MetadataValue)b.getMetadata("connection").get(0)).asBoolean()));
                    inf.add(String.valueOf(((MetadataValue)b.getMetadata("input").get(0)).asInt()));
                    inf.add(((MetadataValue)b.getMetadata("owner").get(0)).asString());
                    inf.add(((MetadataValue)b.getMetadata("id").get(0)).asString());
                    break;
                }
                case 1: {
                    inf.add(String.valueOf(((MetadataValue)b.getMetadata("charge").get(0)).asInt()));
                    inf.add(String.valueOf(((MetadataValue)b.getMetadata("connection").get(0)).asBoolean()));
                    inf.add(String.valueOf(((MetadataValue)b.getMetadata("output").get(0)).asInt()));
                    inf.add(((MetadataValue)b.getMetadata("owner").get(0)).asString());
                    inf.add(((MetadataValue)b.getMetadata("id").get(0)).asString());
                    inf.add(String.valueOf(((MetadataValue)b.getMetadata("fueltype").get(0)).asInt()));
                    inf.add(String.valueOf(((MetadataValue)b.getMetadata("running").get(0)).asBoolean()));
                    break;
                }
                case 2: {
                    inf.add(String.valueOf(((MetadataValue)b.getMetadata("charge").get(0)).asInt()));
                    inf.add(String.valueOf(((MetadataValue)b.getMetadata("connection").get(0)).asBoolean()));
                    inf.add(String.valueOf(((MetadataValue)b.getMetadata("input").get(0)).asInt()));
                    inf.add(String.valueOf(((MetadataValue)b.getMetadata("output").get(0)).asInt()));
                    inf.add(String.valueOf(((MetadataValue)b.getMetadata("owner").get(0)).asString()));
                    inf.add(String.valueOf(((MetadataValue)b.getMetadata("id").get(0)).asString()));
                    break;
                }
                case 3: {
                    inf.add(String.valueOf(((MetadataValue)b.getMetadata("charge").get(0)).asInt()));
                    inf.add(String.valueOf(((MetadataValue)b.getMetadata("input").get(0)).asInt()));
                    inf.add(((MetadataValue)b.getMetadata("owner").get(0)).asString());
                    inf.add(((MetadataValue)b.getMetadata("id").get(0)).asString());
                    inf.add(String.valueOf(((MetadataValue)b.getMetadata("running").get(0)).asBoolean()));
                    break;
                }
                case 4: {
                    inf.add(String.valueOf(((MetadataValue)b.getMetadata("charge").get(0)).asInt()));
                    inf.add(String.valueOf(((MetadataValue)b.getMetadata("input").get(0)).asInt()));
                    inf.add(((MetadataValue)b.getMetadata("owner").get(0)).asString());
                    inf.add(((MetadataValue)b.getMetadata("id").get(0)).asString());
                    inf.add(String.valueOf(((MetadataValue)b.getMetadata("running").get(0)).asBoolean()));
                    break;
                }
                case 5: {
                    inf.add(String.valueOf(((MetadataValue)b.getMetadata("charge").get(0)).asInt()));
                    inf.add(String.valueOf(((MetadataValue)b.getMetadata("output").get(0)).asInt()));
                    inf.add(((MetadataValue)b.getMetadata("owner").get(0)).asString());
                    inf.add(((MetadataValue)b.getMetadata("id").get(0)).asString());
                    break;
                }
                case 6: {
                    inf.add(String.valueOf(((MetadataValue)b.getMetadata("charge").get(0)).asInt()));
                    inf.add(String.valueOf(((MetadataValue)b.getMetadata("input").get(0)).asInt()));
                    inf.add(((MetadataValue)b.getMetadata("owner").get(0)).asString());
                    inf.add(((MetadataValue)b.getMetadata("id").get(0)).asString());
                    break;
                }
            }
        }
        return inf;
    }

    public static ItemStack machineToItemStack(Block b, Industrial in) {
        ItemStack is = new ItemStack(b.getType());
        ItemMeta im = is.getItemMeta();
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("");
        switch (EUtil.getMachineIndex(b)) {
            case 7: {
                im.setDisplayName(ChatColor.RED + lang.getString("harvester"));
                lore.add(ChatColor.BLUE + lang.getString("charge") + Integer.parseInt(EUtil.getMachineBlockInfo(b, in).get(0)) + "/50000pd");
                break;
            }
            case 8: {
                im.setDisplayName(ChatColor.RED + lang.getString("xp-tank"));
                lore.add(ChatColor.BLUE + lang.getString("liquid-xp") + Integer.parseInt(EUtil.getMachineBlockInfo(b, in).get(0)) + "/50000xp");
                break;
            }
            case 9: {
                im.setDisplayName(ChatColor.RED + lang.getString("elevator"));
                break;
            }
            case 10: {
                im.setDisplayName(ChatColor.RED + lang.getString("nuclear-reactor"));
                lore.add(ChatColor.BLUE + lang.getString("liquid-xp") + Integer.parseInt(EUtil.getMachineBlockInfo(b, in).get(0)) + "/1000000pd");
                break;
            }
            case 11: {
                im.setDisplayName(ChatColor.RED + lang.getString("storage-unit-monitor"));
                lore.add(ChatColor.BLUE + lang.getString("charge") + Integer.parseInt(EUtil.getMachineBlockInfo(b, in).get(0)) + "/50000pd");
                break;
            }
            case 15: {
                im.setDisplayName(ChatColor.RED + lang.getString("wind-turbine"));
                lore.add(ChatColor.BLUE + lang.getString("charge") + Integer.parseInt(EUtil.getMachineBlockInfo(b, in).get(0)) + "/50000pd");
                break;
            }
            case 16: {
                im.setDisplayName(ChatColor.RED + lang.getString("auto-crafter"));
                lore.add(ChatColor.BLUE + lang.getString("charge") + Integer.parseInt(EUtil.getMachineBlockInfo(b, in).get(0)) + "/50000pd");
                break;
            }
            case 17: {
                im.setDisplayName(ChatColor.RED + lang.getString("empty-tank"));
                lore.add(ChatColor.BLUE + lang.getString("capacity") + Integer.parseInt(EUtil.getMachineBlockInfo(b, in).get(2)) + "/" + in.config.getInt("tank-bucket-capacity") + " " + lang.getString("buckets"));
                break;
            }
            case 18: {
                im.setDisplayName(ChatColor.RED + lang.getString("water-tank"));
                lore.add(ChatColor.BLUE + lang.getString("capacity") + Integer.parseInt(EUtil.getMachineBlockInfo(b, in).get(2)) + "/" + in.config.getInt("tank-bucket-capacity") + " " + lang.getString("buckets"));
                break;
            }
            case 19: {
                im.setDisplayName(ChatColor.RED + lang.getString("lava-tank"));
                lore.add(ChatColor.BLUE + lang.getString("capacity") + Integer.parseInt(EUtil.getMachineBlockInfo(b, in).get(2)) + "/" + in.config.getInt("tank-bucket-capacity") + " " + lang.getString("buckets"));
                break;
            }
            case 20: {
                im.setDisplayName(ChatColor.RED + lang.getString("oil-tank"));
                lore.add(ChatColor.BLUE + lang.getString("capacity") + Integer.parseInt(EUtil.getMachineBlockInfo(b, in).get(2)) + "/" + in.config.getInt("tank-bucket-capacity") + " " + lang.getString("buckets"));
                break;
            }
            case 21: {
                im.setDisplayName(ChatColor.RED + lang.getString("coal-liquefactor"));
                lore.add(ChatColor.BLUE + lang.getString("charge") + Integer.parseInt(EUtil.getMachineBlockInfo(b, in).get(0)) + "/50000pd");
                break;
            }
            case 0: {
                im.setDisplayName(ChatColor.RED + lang.getString("charging-station"));
                lore.add(ChatColor.BLUE + lang.getString("charge") + Integer.parseInt(EUtil.getMachineBlockInfo(b, in).get(0)) + "/50000pd");
                break;
            }
            case 1: {
                im.setDisplayName(ChatColor.RED + lang.getString("generator"));
                lore.add(ChatColor.BLUE + lang.getString("charge") + Integer.parseInt(EUtil.getMachineBlockInfo(b, in).get(0)) + "/50000pd");
                break;
            }
            case 2: {
                im.setDisplayName(ChatColor.RED + lang.getString("battery-bank"));
                lore.add(ChatColor.BLUE + lang.getString("charge") + Integer.parseInt(EUtil.getMachineBlockInfo(b, in).get(0)) + "/1000000pd");
                break;
            }
            case 3: {
                im.setDisplayName(ChatColor.RED + lang.getString("quary"));
                lore.add(ChatColor.BLUE + lang.getString("charge") + Integer.parseInt(EUtil.getMachineBlockInfo(b, in).get(0)) + "/50000pd");
                break;
            }
            case 4: {
                im.setDisplayName(ChatColor.RED + lang.getString("mob-grinder"));
                lore.add(ChatColor.BLUE + lang.getString("charge") + Integer.parseInt(EUtil.getMachineBlockInfo(b, in).get(0)) + "/50000pd");
                break;
            }
            case 5: {
                im.setDisplayName(ChatColor.RED + lang.getString("solar-panel"));
                lore.add(ChatColor.BLUE + lang.getString("charge") + Integer.parseInt(EUtil.getMachineBlockInfo(b, in).get(0)) + "/10000pd");
                break;
            }
            case 6: {
                im.setDisplayName(ChatColor.RED + lang.getString("electric-furnace"));
                lore.add(ChatColor.BLUE + lang.getString("charge") + Integer.parseInt(EUtil.getMachineBlockInfo(b, in).get(0)) + "/50000pd");
                break;
            }
        }
        im.setLore(lore);
        im.addEnchant(Enchantment.ARROW_DAMAGE, 1, true);
        im.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
        is.setItemMeta(im);
        return is;
    }
}

