/*
 * Decompiled with CFR 0.152.
 */
package com.nowilltolife.ingameeditor.commands;

import com.nowilltolife.ingameeditor.Main;
import com.nowilltolife.ingameeditor.utils.PluginUtils;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.List;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;

public class EditCommand
implements CommandExecutor {
    public static HashMap<String, File> session = new HashMap();
    public static HashMap<String, Plugin> plugins = new HashMap();
    public static HashMap<String, YamlConfiguration> configs = new HashMap();

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (sender.hasPermission("ingameedit.edit")) {
            if (args.length == 0) {
                this.help(sender);
            } else if (args.length == 1) {
                if (args[0].equals("help")) {
                    this.help(sender);
                } else if (args[0].equals("save")) {
                    if (session.containsKey(sender.getName())) {
                        File file = session.get(sender.getName());
                        if (configs.containsKey(sender.getName())) {
                            try {
                                YamlConfiguration config = configs.get(sender.getName());
                                config.save(file);
                                sender.sendMessage(String.valueOf(Main.prefix) + "\u00a77File saved!");
                            }
                            catch (IOException e) {
                                sender.sendMessage("\u00a7Error while trying to save file. Is the file still there?");
                                e.printStackTrace();
                            }
                        } else {
                            sender.sendMessage(String.valueOf(Main.prefix) + "\u00a77Non Yaml files don't need to be saved!");
                        }
                    } else {
                        sender.sendMessage(String.valueOf(Main.prefix) + "\u00a77You dont have a editing session open!");
                    }
                } else if (args[0].equals("reload")) {
                    if (session.containsKey(sender.getName())) {
                        File file = session.get(sender.getName());
                        if (configs.containsKey(sender.getName())) {
                            try {
                                configs.get(sender.getName()).load(file);
                            }
                            catch (IOException | InvalidConfigurationException e) {
                                sender.sendMessage(String.valueOf(Main.errorprefix) + " while trying to reload. Is the config valid?");
                                e.printStackTrace();
                            }
                            sender.sendMessage(String.valueOf(Main.prefix) + "\u00a77File reloaded!");
                        } else {
                            sender.sendMessage(String.valueOf(Main.prefix) + "\u00a77Non Yaml files don't need to be reloaded!");
                        }
                    } else {
                        sender.sendMessage(String.valueOf(Main.prefix) + "\u00a77You dont have a editing session open!");
                    }
                } else if (args[0].equals("close")) {
                    if (session.containsKey(sender.getName())) {
                        session.remove(sender.getName());
                        sender.sendMessage(String.valueOf(Main.prefix) + "Session closed!");
                    } else {
                        sender.sendMessage(String.valueOf(Main.prefix) + "\u00a77You dont have a editing session open!");
                    }
                } else {
                    this.help(sender);
                }
            } else if (args.length == 2) {
                if (args[0].equals("start")) {
                    if (PluginUtils.getPluginByName(args[1]) != null) {
                        File config = new File(PluginUtils.getPluginByName(args[1]).getDataFolder() + "/config.yml");
                        session.put(sender.getName(), config);
                        configs.put(sender.getName(), YamlConfiguration.loadConfiguration((File)config));
                        sender.sendMessage(String.valueOf(Main.prefix) + "\u00a77Started editing session with the file: \u00a7aconfig.yml \u00a77from the plugin: \u00a7a" + PluginUtils.getPluginByName(args[1]).getName());
                    } else if (new File(args[1]).exists()) {
                        File config = new File(args[1]);
                        session.put(sender.getName(), config);
                        sender.sendMessage(String.valueOf(Main.prefix) + "\u00a77Started editing session with the file: \u00a7a" + config.getName());
                    }
                } else if (args[0].equals("get")) {
                    if (session.containsKey(sender.getName())) {
                        if (configs.containsKey(sender.getName())) {
                            StringBuilder builder = new StringBuilder();
                            int i = 1;
                            while (i < args.length) {
                                builder.append(" " + args[i]);
                                ++i;
                            }
                            sender.sendMessage(String.valueOf(Main.prefix) + "\u00a77The value of \u00a7a" + builder.substring(1) + " \u00a77is: '\u00a7a" + configs.get(sender.getName()).get(builder.substring(1)) + "\u00a77'");
                        } else {
                            sender.sendMessage(String.valueOf(Main.prefix) + "\u00a77Not supported for Non-Yaml files!");
                        }
                    } else {
                        sender.sendMessage(String.valueOf(Main.prefix) + "\u00a77You dont have a editing session open!");
                    }
                } else if (args[0].equals("read")) {
                    if (session.containsKey(sender.getName())) {
                        int min = 1;
                        try {
                            min = Integer.parseInt(args[1]);
                        }
                        catch (NumberFormatException e) {
                            sender.sendMessage(String.valueOf(Main.errorprefix) + " expected number");
                            e.printStackTrace();
                            return false;
                        }
                        try {
                            List<String> lines = Files.readAllLines(Paths.get(session.get(sender.getName()).getAbsolutePath(), new String[0]));
                            int max = lines.size();
                            if (min <= max) {
                                if (min > 0) {
                                    int i = min;
                                    while (i < max + 1) {
                                        if (((Main)Main.getPlugin(Main.class)).getConfig().getBoolean("showlinenumbers")) {
                                            sender.sendMessage(String.valueOf(i) + " " + lines.get(i - 1));
                                        } else {
                                            sender.sendMessage(lines.get(i - 1));
                                        }
                                        ++i;
                                    }
                                } else {
                                    sender.sendMessage(String.valueOf(Main.errorprefix) + " minimum needs to be bigger than 0");
                                }
                            } else {
                                sender.sendMessage(String.valueOf(Main.errorprefix) + " the file only has " + lines.size() + " line(s)!");
                            }
                        }
                        catch (IOException e) {
                            sender.sendMessage(String.valueOf(Main.errorprefix) + " while trying to save file. Is the file still there?");
                            e.printStackTrace();
                        }
                    } else {
                        sender.sendMessage(String.valueOf(Main.prefix) + "\u00a77You dont have a editing session open!");
                    }
                } else {
                    this.help(sender);
                }
            } else if (args.length > 2) {
                if (args[0].equals("start")) {
                    StringBuilder builder = new StringBuilder();
                    int i = 2;
                    while (i < args.length) {
                        builder.append(" " + args[i]);
                        ++i;
                    }
                    String name = builder.substring(1);
                    if (PluginUtils.getPluginByName(args[1]) != null) {
                        if (args[2].contains(".yml") && new File(PluginUtils.getPluginByName(args[1]).getDataFolder() + "/" + name).exists()) {
                            File config = new File(PluginUtils.getPluginByName(args[1]).getDataFolder() + "/" + name);
                            session.put(sender.getName(), config);
                            configs.put(sender.getName(), YamlConfiguration.loadConfiguration((File)config));
                            sender.sendMessage(String.valueOf(Main.prefix) + "\u00a77Started editing session with the file: \u00a7a" + config.getName() + " \u00a77from the plugin: \u00a7a" + PluginUtils.getPluginByName(args[1]).getName());
                        } else if (new File(PluginUtils.getPluginByName(args[1]).getDataFolder() + "/" + name + ".yml").exists()) {
                            File config = new File(PluginUtils.getPluginByName(args[1]).getDataFolder() + "/" + name + ".yml");
                            session.put(sender.getName(), config);
                            configs.put(sender.getName(), YamlConfiguration.loadConfiguration((File)config));
                            sender.sendMessage(String.valueOf(Main.prefix) + "\u00a77Started editing session with the file: \u00a7a" + config.getName() + " \u00a77from the plugin: \u00a7a" + PluginUtils.getPluginByName(args[1]).getName());
                        } else if (new File(PluginUtils.getPluginByName(args[1]).getDataFolder() + "/" + name).exists()) {
                            File config = new File(PluginUtils.getPluginByName(args[1]).getDataFolder() + "/" + name);
                            session.put(sender.getName(), config);
                            sender.sendMessage(String.valueOf(Main.prefix) + "\u00a77Started editing session with the file: \u00a7a" + config.getName() + " \u00a77from the plugin: \u00a7a" + PluginUtils.getPluginByName(args[1]).getName());
                        } else {
                            sender.sendMessage(String.valueOf(Main.errorprefix) + " file not found!");
                        }
                    } else if (new File(name).exists()) {
                        File config = new File(name);
                        session.put(sender.getName(), config);
                        sender.sendMessage(String.valueOf(Main.prefix) + "\u00a77Started editing session with the file: \u00a7a" + config.getName());
                    }
                } else if (args[0].equals("set")) {
                    if (session.containsKey(sender.getName())) {
                        if (configs.containsKey(sender.getName())) {
                            String previous = configs.get(sender.getName()).get(args[1]).toString();
                            StringBuilder builder = new StringBuilder();
                            int i = 2;
                            while (i < args.length) {
                                builder.append(" " + args[i]);
                                ++i;
                            }
                            configs.get(sender.getName()).set(args[1], (Object)builder.substring(1));
                            sender.sendMessage(String.valueOf(Main.prefix) + "\u00a77You changed the value of \u00a7a" + args[1] + " \u00a77from: '\u00a7a" + previous + "\u00a77' to '\u00a7a" + builder.substring(1) + "\u00a77'");
                        } else {
                            sender.sendMessage(String.valueOf(Main.prefix) + "\u00a77Not supported for Non-Yaml files!");
                        }
                    } else {
                        sender.sendMessage(String.valueOf(Main.prefix) + "\u00a77You dont have a editing session open!");
                    }
                } else if (args[0].equals("read")) {
                    if (session.containsKey(sender.getName())) {
                        int min = 1;
                        try {
                            min = Integer.parseInt(args[1]);
                        }
                        catch (NumberFormatException e) {
                            sender.sendMessage(String.valueOf(Main.errorprefix) + " expected number");
                            e.printStackTrace();
                            return false;
                        }
                        int max = 1;
                        try {
                            max = Integer.parseInt(args[2]);
                        }
                        catch (NumberFormatException e) {
                            sender.sendMessage(String.valueOf(Main.errorprefix) + " expected number");
                            e.printStackTrace();
                            return false;
                        }
                        try {
                            List<String> lines = Files.readAllLines(Paths.get(session.get(sender.getName()).getAbsolutePath(), new String[0]));
                            if (lines.size() >= max) {
                                if (min <= lines.size()) {
                                    if (min > 0 && max > 0) {
                                        int i = min;
                                        while (i < max + 1) {
                                            if (((Main)Main.getPlugin(Main.class)).getConfig().getBoolean("showlinenumbers")) {
                                                sender.sendMessage(String.valueOf(i) + " " + lines.get(i - 1));
                                            } else {
                                                sender.sendMessage(lines.get(i - 1));
                                            }
                                            ++i;
                                        }
                                    } else {
                                        sender.sendMessage(String.valueOf(Main.errorprefix) + " maximum and minimum need to be bigger than 0");
                                    }
                                } else {
                                    sender.sendMessage(String.valueOf(Main.errorprefix) + " the file only has " + lines.size() + " line(s)!");
                                }
                            } else {
                                sender.sendMessage(String.valueOf(Main.errorprefix) + " the file only has " + lines.size() + " line(s)!");
                            }
                        }
                        catch (IOException e) {
                            sender.sendMessage(String.valueOf(Main.errorprefix) + " while trying to save file. Is the file still there?");
                            e.printStackTrace();
                        }
                    } else {
                        sender.sendMessage(String.valueOf(Main.prefix) + "\u00a77You dont have a editing session open!");
                    }
                } else if (args[0].equals("write")) {
                    if (session.containsKey(sender.getName())) {
                        int line = Integer.parseInt(args[1]);
                        try {
                            List<String> lines = Files.readAllLines(Paths.get(session.get(sender.getName()).getAbsolutePath(), new String[0]));
                            if (line >= lines.size()) {
                                String previous = lines.get(line - 1);
                                StringBuilder builder = new StringBuilder();
                                int i = 2;
                                while (i < args.length) {
                                    builder.append(" " + args[i]);
                                    ++i;
                                }
                                lines.set(line - 1, builder.substring(1));
                                Files.write(Paths.get(session.get(sender.getName()).getAbsolutePath(), new String[0]), lines, Charset.forName("UTF-8"), new OpenOption[0]);
                                sender.sendMessage(String.valueOf(Main.prefix) + "\u00a77You changed the content of line \u00a7a" + args[1] + " \u00a77from: '\u00a7a" + previous + "\u00a77' to '\u00a7a" + builder.substring(1) + "\u00a77'");
                            }
                        }
                        catch (IOException e) {
                            sender.sendMessage(String.valueOf(Main.errorprefix) + " while trying to save file. Is the file still there?");
                            e.printStackTrace();
                        }
                    } else {
                        sender.sendMessage(String.valueOf(Main.prefix) + "\u00a77You dont have a editing session open!");
                    }
                } else {
                    this.help(sender);
                }
            }
        }
        return false;
    }

    public void help(CommandSender sender) {
        sender.sendMessage(String.valueOf(Main.prefix) + "Help");
        sender.sendMessage("\u00a7aBase Commands:");
        sender.sendMessage("\u00a7a> /edit start <plugin> \u00a77| starts a edit session with the config.yml of given plugin (aslong as it has one)");
        sender.sendMessage("\u00a7a> /edit start <plugin> <configfile> \u00a77| starts a edit session with the given Yaml file from the plugin");
        sender.sendMessage("\u00a7a> /edit start <plugin> <file> \u00a77| starts a edit session with the given file contained in that plugins folder");
        sender.sendMessage("\u00a7a> /edit start <file> \u00a77| (experimental) starts a edit session with the given file");
        sender.sendMessage("\u00a7aIn-Edit Commands");
        sender.sendMessage("\u00a7a> /edit get <section> \u00a77| gets the value from a given section (only for Yaml file editing)");
        sender.sendMessage("\u00a7a> /edit set <section> <value> \u00a77| sets the value of a given section (only for Yaml file editing)");
        sender.sendMessage("\u00a7a> /edit read <linestart> [lineend] \u00a77| reads the file from the starting line to the end or to the given end line");
        sender.sendMessage("\u00a7a> /edit write <line> <text> \u00a77| Writes text to the given line in the text");
        sender.sendMessage("\u00a7a> /edit save \u00a77| saves the config file (only for Yaml file editing)");
        sender.sendMessage("\u00a7a> /edit reload \u00a77| reloads the config file (only for Yaml file editing)");
        sender.sendMessage("\u00a7a> /edit close \u00a77| closes the edit session");
    }
}

