/*
 * Decompiled with CFR 0.152.
 */
package eu.imjustacake.ipwhitelist;

import eu.imjustacake.ipwhitelist.IP;
import eu.imjustacake.ipwhitelist.IPWhitelistZ;
import java.util.ArrayList;

public class IPConfig {
    private static String kickMessage = IPWhitelistZ.colorize(IPWhitelistZ.getInstance().getConfig().getString("kick-message"));
    private static String nullAddressMessage = IPWhitelistZ.colorize(IPWhitelistZ.getInstance().getConfig().getString("invalid-ip-message"));
    public static String localHost = "localhostx";

    public static ArrayList<IP> getAllowedIPs() {
        ArrayList<IP> allowedIps = new ArrayList<IP>();
        for (String string : IPWhitelistZ.getInstance().getConfig().getStringList("allowed-ips")) {
            allowedIps.add(new IP(string, null));
        }
        return allowedIps;
    }

    public static void whitelistIp(WhitelistAction whitelistAction, IP ip) {
        ArrayList<String> allowedIpsRaw = new ArrayList<String>();
        for (IP ipx : IPConfig.getAllowedIPs()) {
            allowedIpsRaw.add(ipx.getHostString());
        }
        switch (whitelistAction) {
            case ADD: {
                allowedIpsRaw.add(ip.getHostString());
                break;
            }
            case REMOVE: {
                allowedIpsRaw.remove(ip.getHostString());
            }
        }
        IPWhitelistZ.getInstance().getConfig().set("allowed-ips", allowedIpsRaw);
        IPConfig.reload(true);
    }

    public static boolean isIpWhitelisted(IP ip) {
        String ipraw = ip.getHostString();
        for (IP ipX : IPConfig.getAllowedIPs()) {
            if (!ipX.getHostString().equalsIgnoreCase(ip.getHostString())) continue;
            return true;
        }
        return false;
    }

    public static boolean isIpLocalHost(IP ip) {
        return ip.getHostString(true).equalsIgnoreCase(localHost);
    }

    public static String getKickMessage() {
        return kickMessage;
    }

    public static String getNullAddressMessage() {
        return nullAddressMessage;
    }

    public static void reload(boolean save) {
        if (save) {
            IPWhitelistZ.getInstance().saveConfig();
        }
        IPWhitelistZ.getInstance().reloadConfig();
    }

    public static enum WhitelistAction {
        ADD,
        REMOVE;

    }
}

