/*
 * Decompiled with CFR 0.152.
 */
package com.xniter.HungerIsStamina.Utilities;

import com.xniter.HungerIsStamina.Utilities.Utils;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public class ConsoleOutput {
    private boolean debug = false;
    private boolean colors = false;
    private ConsoleCommandSender console = null;
    @NotNull
    private String prefix = "";
    private final List<CommandSender> listeners = new ArrayList<CommandSender>();
    private final List<CommandSender> personalDebug = new ArrayList<CommandSender>();

    public ConsoleOutput(JavaPlugin plugin) {
        this.console = plugin.getServer().getConsoleSender();
    }

    public void colored(String msg) {
        if (!this.colors || this.console == null) {
            return;
        }
        this.console.sendMessage(Utils.color(msg));
    }

    public void debug(String msg) {
        if (this.debug) {
            String finalMsg = this.prefix + "&eDEBUG: " + msg;
            if (this.colors) {
                this.colored(finalMsg);
            } else {
                Bukkit.getLogger().info(Utils.stripColor(finalMsg));
            }
            this.toListeners(finalMsg);
        }
    }

    public void debug(String msg, CommandSender origin) {
        if (this.debug) {
            if (this.personalDebug.contains(origin)) {
                this.addListener(origin);
                this.debug(msg);
                this.removeListener(origin);
            } else {
                this.debug(msg);
            }
        }
    }

    public void err(String msg) {
        String finalMsg = this.prefix + "&4ERROR: " + msg;
        if (this.colors) {
            this.colored(finalMsg);
        } else {
            Bukkit.getLogger().severe(Utils.stripColor(finalMsg));
        }
        this.toListeners(finalMsg);
    }

    public void info(String msg) {
        String finalMsg = this.prefix + "&7INFO: " + msg;
        if (this.colors) {
            this.colored(finalMsg);
        } else {
            Bukkit.getLogger().info(Utils.stripColor(finalMsg));
        }
        this.toListeners(finalMsg);
    }

    public void warn(String msg) {
        String finalMsg = this.prefix + "&cWARN: " + msg;
        if (this.colors) {
            this.colored(finalMsg);
        } else {
            Bukkit.getLogger().warning(Utils.stripColor(finalMsg));
        }
        this.toListeners(finalMsg);
    }

    public void addListener(@NotNull CommandSender listener) {
        if (listener == null) {
            ConsoleOutput.$$$reportNull$$$0(0);
        }
        this.listeners.add(listener);
    }

    public void removeListener(@NotNull CommandSender listener) {
        if (listener == null) {
            ConsoleOutput.$$$reportNull$$$0(1);
        }
        this.listeners.remove(listener);
    }

    public boolean switchPersonalDebug(@NotNull CommandSender sender) {
        if (sender == null) {
            ConsoleOutput.$$$reportNull$$$0(2);
        }
        if (this.personalDebug.contains(sender)) {
            this.personalDebug.remove(sender);
        } else {
            this.personalDebug.add(sender);
        }
        return this.personalDebug.contains(sender);
    }

    public void toListeners(String message) {
        String finalMessage = Utils.color(message);
        this.listeners.forEach(c -> c.sendMessage(finalMessage));
    }

    public ConsoleOutput() {
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public boolean isColors() {
        return this.colors;
    }

    public void setColors(boolean colors) {
        this.colors = colors;
    }

    public void setConsole(ConsoleCommandSender console) {
        this.console = console;
    }

    @NotNull
    public String getPrefix() {
        String string = this.prefix;
        if (string == null) {
            ConsoleOutput.$$$reportNull$$$0(3);
        }
        return string;
    }

    public void setPrefix(@NotNull String prefix) {
        if (prefix == null) {
            ConsoleOutput.$$$reportNull$$$0(4);
        }
        if (prefix == null) {
            throw new NullPointerException("prefix is marked non-null but is null");
        }
        this.prefix = prefix;
    }

    public List<CommandSender> getListeners() {
        return this.listeners;
    }

    public List<CommandSender> getPersonalDebug() {
        return this.personalDebug;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sender";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/xniter/HungerIsStamina/Utilities/ConsoleOutput";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/xniter/HungerIsStamina/Utilities/ConsoleOutput";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getPrefix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addListener";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "removeListener";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "switchPersonalDebug";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setPrefix";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }
}

