/*
 * Decompiled with CFR 0.152.
 */
package me.pretz;

import java.util.List;
import java.util.stream.Collectors;
import me.pretz.Counters.KillCounter;
import me.pretz.Events.EnablePvPEvent;
import me.pretz.Events.PlayerAttackEvent;
import me.pretz.Events.PlayerConnectEvent;
import me.pretz.Events.PlayerDeathEvent;
import me.pretz.Handlers.ChatColorHandler;
import me.pretz.Handlers.CommandsDenyHandler;
import me.pretz.Handlers.ItemHandler;
import me.pretz.Handlers.Metrics;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class Main
extends JavaPlugin {
    public static Main plugin;

    private String color(String s) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)s);
    }

    private List<String> color(List<String> lore) {
        return lore.stream().map(this::color).collect(Collectors.toList());
    }

    public void onEnable() {
        plugin = this;
        this.saveDefaultConfig();
        Main.registerEvents((Plugin)this, new EnablePvPEvent(), new PlayerAttackEvent(), new PlayerConnectEvent(), new KillCounter(), new PlayerDeathEvent(), new CommandsDenyHandler());
        ConsoleCommandSender console = this.getServer().getConsoleSender();
        console.sendMessage("+========== HUBPVP ==========+");
        console.sendMessage("  Plugin loaded succesfully!  ");
        console.sendMessage("       Have fun pvping!       ");
        console.sendMessage("         Version: 2.0         ");
        console.sendMessage("+============================+");
        int pluginId = 15418;
        Metrics metrics = new Metrics(this, pluginId);
        metrics.addCustomChart(new Metrics.SimplePie("chart_id", () -> "My value"));
    }

    public void onDisable() {
    }

    public static void registerEvents(Plugin plugin, Listener ... listeners) {
        Listener[] var2 = listeners;
        int var3 = listeners.length;
        for (int var4 = 0; var4 < var3; ++var4) {
            Listener listener = var2[var4];
            Bukkit.getServer().getPluginManager().registerEvents(listener, plugin);
        }
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        ItemHandler giveItems = new ItemHandler();
        ItemStack sword = giveItems.getSword();
        ItemStack chest = giveItems.getChest();
        if (label.equalsIgnoreCase("hubpvp")) {
            if (!sender.hasPermission("hubpvp.admin")) {
                sender.sendMessage(ChatColor.RED + "Sorry you do not have permission to run this command!");
                return true;
            }
            if (args.length == 0) {
                sender.sendMessage(ChatColorHandler.ChatColorHandler("&a[HubPVP] Running &b2.0v &a- Made by Pretxels"));
                return true;
            }
            if (args.length > 0 && args[0].equalsIgnoreCase("reload")) {
                this.reloadConfig();
                sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)plugin.getConfig().getString("reload-message")));
                for (Player p : Bukkit.getOnlinePlayers()) {
                    if (plugin.getConfig().getBoolean("world-blocking.enable")) {
                        if (!plugin.getConfig().getBoolean("world-blocking.whitelist") && plugin.getConfig().getStringList("world-blocking.worlds").contains(p.getWorld().getName())) {
                            if (p.getInventory().getChestplate() != null && p.getInventory().getChestplate().equals((Object)chest)) {
                                p.getInventory().setHelmet(null);
                                p.getInventory().setChestplate(null);
                                p.getInventory().setLeggings(null);
                                p.getInventory().setBoots(null);
                            }
                            p.getInventory().setItem(Integer.parseInt(plugin.getConfig().getString("sword-settings.inventory-slot")), null);
                            return true;
                        }
                        if (plugin.getConfig().getBoolean("world-blocking.whitelist") && !plugin.getConfig().getStringList("world-blocking.worlds").contains(p.getWorld().getName())) {
                            if (p.getInventory().getChestplate() != null && p.getInventory().getChestplate().equals((Object)chest)) {
                                p.getInventory().setHelmet(null);
                                p.getInventory().setChestplate(null);
                                p.getInventory().setLeggings(null);
                                p.getInventory().setBoots(null);
                            }
                            p.getInventory().setItem(Integer.parseInt(plugin.getConfig().getString("sword-settings.inventory-slot")), null);
                            return true;
                        }
                    }
                    if (!p.hasPermission("hubpvp.use")) {
                        p.getPlayer().getInventory().setItem(Integer.parseInt(plugin.getConfig().getString("sword-settings.inventory-slot")), null);
                        return true;
                    }
                    p.getInventory().setItem(Integer.parseInt(plugin.getConfig().getString("sword-settings.inventory-slot")), sword);
                }
            }
        }
        return false;
    }
}

