/*
 * Decompiled with CFR 0.152.
 */
package me.pretz.Handlers;

import java.util.List;
import java.util.stream.Collectors;
import me.pretz.Handlers.ChatColorHandler;
import me.pretz.Handlers.NBTEditor;
import me.pretz.Main;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class ItemHandler {
    private ItemStack sword = new ItemStack(Material.matchMaterial((String)Main.plugin.getConfig().getString("sword-settings.sword-material")), 1);
    private ItemStack helmet = null;
    private ItemStack chest = null;
    private ItemStack legs = null;
    private ItemStack boots = null;

    private String color(String s) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)s);
    }

    private List<String> color(List<String> lore) {
        return lore.stream().map(this::color).collect(Collectors.toList());
    }

    public ItemHandler() {
        this.sword.addUnsafeEnchantment(Enchantment.DURABILITY, 1);
        this.sword = NBTEditor.set(this.sword, (byte)1, "Unbreakable");
        ItemMeta swordMeta = this.sword.getItemMeta();
        swordMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
        swordMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_UNBREAKABLE});
        swordMeta.setLore(this.color(Main.plugin.getConfig().getStringList("sword-settings.lore")));
        swordMeta.setDisplayName(ChatColorHandler.ChatColorHandler(Main.plugin.getConfig().getString("sword-settings.sword-name")));
        this.sword.setItemMeta(swordMeta);
        this.helmet = new ItemStack(Material.matchMaterial((String)Main.plugin.getConfig().getString("armor-settings.helmet-material")), 1);
        this.helmet.addUnsafeEnchantment(Enchantment.DURABILITY, 1);
        this.helmet = NBTEditor.set(this.helmet, (byte)1, "Unbreakable");
        ItemMeta helmetMeta = this.helmet.getItemMeta();
        helmetMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
        helmetMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_UNBREAKABLE});
        helmetMeta.setDisplayName(ChatColorHandler.ChatColorHandler(Main.plugin.getConfig().getString("armor-settings.helmet-name")));
        this.helmet.setItemMeta(helmetMeta);
        this.chest = new ItemStack(Material.matchMaterial((String)Main.plugin.getConfig().getString("armor-settings.chestplate-material")), 1);
        this.chest.addUnsafeEnchantment(Enchantment.DURABILITY, 1);
        this.chest = NBTEditor.set(this.chest, (byte)1, "Unbreakable");
        ItemMeta chestMeta = this.chest.getItemMeta();
        chestMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
        chestMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_UNBREAKABLE});
        chestMeta.setDisplayName(ChatColorHandler.ChatColorHandler(Main.plugin.getConfig().getString("armor-settings.chestplate-name")));
        this.chest.setItemMeta(chestMeta);
        this.legs = new ItemStack(Material.matchMaterial((String)Main.plugin.getConfig().getString("armor-settings.leggings-material")), 1);
        this.legs.addUnsafeEnchantment(Enchantment.DURABILITY, 1);
        this.legs = NBTEditor.set(this.legs, (byte)1, "Unbreakable");
        ItemMeta legsMeta = this.legs.getItemMeta();
        legsMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
        legsMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_UNBREAKABLE});
        legsMeta.setDisplayName(ChatColorHandler.ChatColorHandler(Main.plugin.getConfig().getString("armor-settings.leggings-name")));
        this.legs.setItemMeta(legsMeta);
        this.boots = new ItemStack(Material.matchMaterial((String)Main.plugin.getConfig().getString("armor-settings.boots-material")), 1);
        this.boots.addUnsafeEnchantment(Enchantment.DURABILITY, 1);
        this.boots = NBTEditor.set(this.boots, (byte)1, "Unbreakable");
        ItemMeta bootsMeta = this.boots.getItemMeta();
        bootsMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
        bootsMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_UNBREAKABLE});
        bootsMeta.setDisplayName(ChatColorHandler.ChatColorHandler(Main.plugin.getConfig().getString("armor-settings.boots-name")));
        this.boots.setItemMeta(bootsMeta);
    }

    public ItemStack getSword() {
        return this.sword;
    }

    public ItemStack getHelmet() {
        return this.helmet;
    }

    public ItemStack getChest() {
        return this.chest;
    }

    public ItemStack getLegs() {
        return this.legs;
    }

    public ItemStack getBoots() {
        return this.boots;
    }
}

