/*
 * Decompiled with CFR 0.152.
 */
package me.pretz.Events;

import java.util.HashMap;
import java.util.Map;
import me.pretz.Handlers.ChatColorHandler;
import me.pretz.Handlers.ItemHandler;
import me.pretz.Main;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitScheduler;

public class EnablePvPEvent
implements Listener {
    Map<String, Long> cooldowns = new HashMap<String, Long>();

    @EventHandler
    public void onInventoryClick(InventoryClickEvent e) {
        ItemHandler giveItems = new ItemHandler();
        ItemStack sword = giveItems.getSword();
        ItemStack helmet = giveItems.getHelmet();
        ItemStack chest = giveItems.getChest();
        ItemStack legs = giveItems.getLegs();
        ItemStack boots = giveItems.getBoots();
        if (this.areItemsSimilar(e.getCurrentItem(), helmet, chest, legs, boots, sword)) {
            e.setCancelled(true);
        }
    }

    @EventHandler
    public void onEntityDeath(EntityDeathEvent event) {
        ItemHandler giveItems = new ItemHandler();
        ItemStack sword = giveItems.getSword();
        ItemStack helmet = giveItems.getHelmet();
        ItemStack chest = giveItems.getChest();
        ItemStack legs = giveItems.getLegs();
        ItemStack boots = giveItems.getBoots();
        event.getDrops().remove(sword);
        event.getDrops().remove(helmet);
        event.getDrops().remove(chest);
        event.getDrops().remove(legs);
        event.getDrops().remove(boots);
    }

    @EventHandler
    public void OnPlayerDropItem(PlayerDropItemEvent e) {
        ItemHandler giveItems = new ItemHandler();
        ItemStack sword = giveItems.getSword();
        ItemStack helmet = giveItems.getHelmet();
        ItemStack chest = giveItems.getChest();
        ItemStack legs = giveItems.getLegs();
        ItemStack boots = giveItems.getBoots();
        if (Main.plugin.getConfig().getBoolean("world-blocking.enable")) {
            if (!Main.plugin.getConfig().getBoolean("world-blocking.whitelist") && Main.plugin.getConfig().getStringList("world-blocking.worlds").contains(e.getPlayer().getWorld().getName())) {
                return;
            }
            if (Main.plugin.getConfig().getBoolean("world-blocking.whitelist") && !Main.plugin.getConfig().getStringList("world-blocking.worlds").contains(e.getPlayer().getWorld().getName())) {
                return;
            }
        }
        if (e.getPlayer().hasPermission("hubpvp.use") && this.areItemsSimilar(e.getItemDrop().getItemStack(), helmet, chest, legs, boots, sword)) {
            e.setCancelled(true);
        }
    }

    @EventHandler
    public void onPlayerRightClick(final PlayerInteractEvent e) {
        ItemHandler giveItems = new ItemHandler();
        ItemStack sword = giveItems.getSword();
        final ItemStack helmet = giveItems.getHelmet();
        final ItemStack chest = giveItems.getChest();
        final ItemStack legs = giveItems.getLegs();
        final ItemStack boots = giveItems.getBoots();
        if (Main.plugin.getConfig().getBoolean("world-blocking.enable")) {
            if (!Main.plugin.getConfig().getBoolean("world-blocking.whitelist") && Main.plugin.getConfig().getStringList("world-blocking.worlds").contains(e.getPlayer().getWorld().getName())) {
                return;
            }
            if (Main.plugin.getConfig().getBoolean("world-blocking.whitelist") && !Main.plugin.getConfig().getStringList("world-blocking.worlds").contains(e.getPlayer().getWorld().getName())) {
                return;
            }
        }
        if (e.getPlayer().hasPermission("hubpvp.use")) {
            final ItemStack clear = new ItemStack(Material.AIR, 1);
            if ((e.getAction() == Action.RIGHT_CLICK_AIR || e.getAction() == Action.RIGHT_CLICK_BLOCK) && this.isSimilarButNotNull(sword, e.getPlayer().getInventory().getItemInHand()) && this.isSimilarButNotNull(chest, e.getPlayer().getInventory().getChestplate())) {
                BukkitScheduler scheduler = Bukkit.getServer().getScheduler();
                final Player player = e.getPlayer();
                if (this.cooldowns.containsKey(player.getName()) && this.cooldowns.get(player.getName()) > System.currentTimeMillis()) {
                    return;
                }
                this.cooldowns.put(player.getName(), System.currentTimeMillis() + 3000L);
                new BukkitRunnable(){
                    int counter = Main.plugin.getConfig().getInt("activation.time-to-activate");

                    public void run() {
                        if (this.counter == 0) {
                            e.getPlayer().sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)Main.plugin.getConfig().getString("deactivation.deactivated")));
                            this.cancel();
                            e.getPlayer().getInventory().setHelmet(clear);
                            e.getPlayer().getInventory().setChestplate(clear);
                            e.getPlayer().getInventory().setLeggings(clear);
                            e.getPlayer().getInventory().setBoots(clear);
                            player.setAllowFlight(false);
                            player.getPlayer().setFlying(false);
                            if (player.isFlying()) {
                                player.setAllowFlight(false);
                                player.getPlayer().setFlying(false);
                            }
                            if (Main.plugin.getConfig().getBoolean("deactivation.execute-console-commands")) {
                                for (String command : Main.plugin.getConfig().getStringList("deactivation.console-commands")) {
                                    command = command.replace("%player%", e.getPlayer().getName());
                                    Bukkit.getServer().dispatchCommand((CommandSender)Bukkit.getServer().getConsoleSender(), command);
                                }
                            }
                        } else {
                            player.sendMessage(ChatColorHandler.ChatColorHandler(Main.plugin.getConfig().getString("deactivation.deactivation-countdown").replace("%time%", String.valueOf(this.counter))));
                        }
                        --this.counter;
                    }
                }.runTaskTimer((Plugin)Main.plugin, 0L, 20L);
            } else if ((e.getAction() == Action.RIGHT_CLICK_AIR || e.getAction() == Action.RIGHT_CLICK_BLOCK) && this.isSimilarButNotNull(sword, e.getPlayer().getInventory().getItemInHand())) {
                final Player player = e.getPlayer();
                if (this.cooldowns.containsKey(player.getName()) && this.cooldowns.get(player.getName()) > System.currentTimeMillis()) {
                    return;
                }
                this.cooldowns.put(player.getName(), System.currentTimeMillis() + 3000L);
                new BukkitRunnable(){
                    int counter = Main.plugin.getConfig().getInt("deactivation.time-to-deactivate");

                    public void run() {
                        if (this.counter == 0) {
                            e.getPlayer().sendMessage(ChatColorHandler.ChatColorHandler(Main.plugin.getConfig().getString("activation.activated")));
                            this.cancel();
                            e.getPlayer().getInventory().setHelmet(helmet);
                            e.getPlayer().getInventory().setChestplate(chest);
                            e.getPlayer().getInventory().setLeggings(legs);
                            e.getPlayer().getInventory().setBoots(boots);
                            player.setAllowFlight(false);
                            player.getPlayer().setFlying(false);
                            if (player.isFlying()) {
                                player.setAllowFlight(false);
                                player.getPlayer().setFlying(false);
                            }
                            if (Main.plugin.getConfig().getBoolean("activation.execute-console-commands")) {
                                for (String command : Main.plugin.getConfig().getStringList("activation.console-commands")) {
                                    command = command.replace("%player%", e.getPlayer().getName());
                                    Bukkit.getServer().dispatchCommand((CommandSender)Bukkit.getServer().getConsoleSender(), command);
                                }
                            }
                        } else {
                            player.sendMessage(ChatColorHandler.ChatColorHandler(Main.plugin.getConfig().getString("activation.activation-countdown").replace("%time%", String.valueOf(this.counter))));
                        }
                        --this.counter;
                    }
                }.runTaskTimer((Plugin)Main.plugin, 0L, 20L);
            }
        }
    }

    private boolean areItemsSimilar(ItemStack reference, ItemStack ... comparisons) {
        for (ItemStack stack : comparisons) {
            if (!this.isSimilarButNotNull(reference, stack)) continue;
            return true;
        }
        return false;
    }

    private boolean isSimilarButNotNull(ItemStack one, ItemStack two) {
        if (one != null && two != null) {
            return one.getType() == two.getType() && Bukkit.getItemFactory().equals(one.getItemMeta(), two.getItemMeta());
        }
        return false;
    }
}

